module.exports = function (_opts) {
    var _icon = _opts.icon
    var _type = _opts.type
    var _table = _type + '_meta'
    var _inst = require('./db_deepFolder.js')(new basedata({
        name: _type,
        primarykey: 'id',
        icon: _icon,
        defaultList: _opts.defaultList,
        insertDefault(id) {
            return {
                id,
                meta: {},
                parent: '',
                icon: _icon,
                title: _opts.defaultTitle,
                ctime: new Date().getTime()
            }
        },
        update() {
            let list = this.folder_getChildren('', true)
            Object.values(list).forEach(item => {
                item.icon_color = item.meta.color || ''
            })
            g_category.set(_type, {
                list,
                action: 'category_' + _type,
            })
            // setTimeout(() => $(`[data-list="${_type}"]`).prop('draggable', true), 500)
        },

        init() {
            const self = this
            g_sort.set(_type + '_py', id => PinYinTranslate.sz(self.folder_getValue(id, 'title', '0').substr(0, 1)))
            g_sort.set(_type + '_group', id => self.folder_getValue(self.folder_getParent(id), 'title', '未分组'))

            let actions = ['edit', 'delete', 'new', 'newSub', 'clear', 'setItem', 'clone'].map(k => _type + '_' + k)
            g_action.
            registerAction(actions, (dom, action) => {
                let id = g_menu.key
                let data = id ? self.get(id) : {}
                g_dropdown.hide('actions_' + _type)
                g_menu.hideMenu('category_'+_type)
                g_menu.hideMenu(_type+'_item')
                switch (actions.indexOf(action[0])) {
                    case 4:
                        return self.reset()
                    case 3:
                        return self.folder_edit(-1, id)
                    case 0:
                    case 2:
                        return self.folder_edit(id || -1)
                    case 1:
                        // TODO 删除目录时更多选项(删除所有视频)
                        return confirm('确定要删除【' + self.folder_getValue(id, 'title') + '】吗？\n删除后素材不会消失', {
                            title: '删除'+_opts.title,
                            type: 'danger'
                        }).then(() => self.folder_remove(id))

                    case 5:
                        return doAction('detail_'+_type, dom) & setTimeout(() => g_menu.hideMenu('datalist_item'), 100)

                    case 6:
                        return self.folder_add(data.title+' 副本')
                }
            }).
            registerAction('detail_' + _type, (dom, action, e) => {
                if (e && getParent(e.target, '.badge').length) return
                self.showPrompt(obj => {
                    let selected = obj.getSelected()
                    let ids = selected.map((id, k) => {
                        if (obj.newst.includes(id)) { // 新目录
                            id = self.folder_add(id)
                        }
                        return id
                    })
                    g_detail.selected_keys.map(md5 => self.setItemFolder(md5, ids, false))
                }).show(dom, 'start-top')
                e && clearEventBubble(e)
            })

            g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, type }) => {
                if(type != 'sqlite') return
                
                columns[_type] = {
                    multi: true,
                    async html(items) {
                        let h = '';
                        
                        let list = await Promise.all(items.map(item => self.getItemFolder(item.id)))
                        let ids = uniqueArr(flattenArray(list))
                        let titles = ids.map(folder => {
                            let title = self.folder_getValue(folder, 'title')
                            h += `
                                <a href='#' class="badge badge-pill m-1" data-action="showFolder_${_type}" data-folder="${folder}">
                                    <i class="ti ti-${_icon} me-1"></i>
                                    <span>${title}</span>
                                </a>
                            `
                            return title
                        })
                        this.data = {ids, titles}
                        return `
                        <div class="input-group input-group-sm mb-2" data-action="detail_${_type}" >
                            <span class="input-group-text" id="inputGroup-sizing-sm">${_opts.detailPlaceholder}</span>
                            <div class="border-hover flex-fill cursor-text" style="max-height: 200px;overflow-y: auto;">${h}</div>
                        </div>`
                    }
                }
            })
        },

        showPrompt(callback) {
            var obj
            let id = _type + '_list'
            return new _DropDown(id, {
                width: '350px',
                html: `<div id="${id}" class="p-2"></div>`,
                onShow: async () => {
                    let list = await Promise.all(g_detail.selected_keys.map(async md5 => {
                        let fid = await g_data.data_getID(md5)
                        return this.getItemFolder(fid)
                    }))
                    obj = this.buildSelector(id, {
                        selected: Array.from(new Set(list.flat())),
                        container: '#' + id,
                        autoFocus: true,
                    })
                    obj.show()
                },
                onHide: () => callback(obj)
            })
        },

        buildSelector(id, opts) {
            if (!opts.sorts) opts.sorts = {}
            let sorts = opts.sorts
            if (sorts[_type + '_py'] == undefined) sorts[_type + '_py'] = { title: '拼音', icon: 'inbox' }
            if (sorts[_type + '_group'] == undefined) sorts[_type + '_group'] = { title: '群组', icon: 'folder' }
            return g_groupList.selector_build(id, Object.assign({
                defaultList: _type + '_py',
                onSelectedList: name => this.folder_sort(name),
                getName: fid => this.folder_getValue(fid, 'title', ''),
            }, opts))
        },

        async showFolder(name) {
            let h = ''
            let datas = Object.entries(this.folder_getChildren(name, true)).map(function([k, v]){
                return {
                    html: g_category.item_html(k, _type, v, 'category_' + _type),
                    group: name
                }
            })

            if (datas.length) { // 有子目录
                let id = `category_${_type}_${name}`
                let div = $("#accordion-" + id)
                if (div.length) return div.remove(); // 隐藏

                let accordion = g_tabler.build_accordion({
                    id, datas,
                    default: true,
                    parent: false,
                    header: '<span class="badge bg-primary">{i}个目录</span>',
                    onOpen: () => { },
                    collapse_start: `<div class="list-group list-group-flush">`,
                    collapse_end: `</div>`,
                })
                accordion.find(`[data-list="${_type}"]`).prop('draggable', true)
                getEle({ action: 'category_' + _type, list: _type, name }).parent('.row').append(accordion)
                
                if(await this.folder_queryItems(name, true) == 0) return // 没有项目则不打开窗口
            }
            // 新建标签页
            let tab = g_rule.getTabParams(_type, {ids: [name], type: 'sqlite'})
            tab.value = name
            
            let item = _inst.get(name)
            tab.icon = item.icon || _icon
            tab.icon_color = item.icon_color
            tab.title = item.title
            g_datalist.tab_new(tab)
        },
    }))

    g_rule.register(_type, {
        title: _type,
        sqlite(data) {
            return {
                method: 'select',
                search: 'id,md5',
                table: 'files',
                args: {
                    [_type]: `JOIN ${_table} ON files.id = ${_table}.fid`
                },
                where: {
                    [_type]: `${_table}.ids like '%${g_data.arr_join(data.ids)}%'`
                }
            }
        },
        sidebar: _opts.sidebar,
        update: false,
    })

    g_action.registerAction({
        [`category_${_type}`]: dom => _inst.showFolder(dom.dataset.name),
        [`showFolder_${_type}`]: dom => _inst.showFolder(dom.dataset.folder)
    })

    g_menu.list['datalist_item'].items.unshift({
        text: '设置'+_opts.title,
        icon: _icon,
        action: _type+'_setItem'
    })

    g_category.registerAction(_type, (dom, action) => {
        g_menu.key = action[2] // TODO 设置dropdown的key
        g_dropdown.show('actions_' + _type, dom)
    })

    g_dropdown.register('actions_' + _type, {
        position: 'top-end',
        offsetLeft: 5,
        list: {
            delete: {
                title: '删除',
                icon: 'trash',
                class: 'text-danger',
                action: _type + '_delete',
            },
        }
    })

    g_input.bind(_type+'_color', ({ val }) => {
        _inst.setMetaData(g_menu.key, {color: val})
    })

    g_menu.registerMenu({
        name: _type + '_item',
        selector: `[data-action="category_${_type}"]`,
        dataKey: 'data-name',
        items: g_menu.parseItems([
            ['edit', '编辑', 'pencil'], ['new', '新建目录', 'folder'], ['newSub', '新建子目录', 'folder-plus'],['clone', '克隆', 'folders'], 'divider', 
            ['color', g_tabler.build_colorSelect({name: _type+'_color', props: 'style="max-width: 150px;"'})]
        ], _type)
    })

    g_menu.registerMenu({
        name: 'category_'+_type,
        selector: `[data-collapse="${_type}"]`,
        dataKey: 'data-name',
        items: [{
            icon: 'plus',
            text: '新建',
            action: _type + '_new'
        }, {
            icon: 'trash',
            text: '清空',
            class: 'text-danger',
            action: _type + '_clear'
        }]
    })

    g_drag.register(_type, {
        selector: `[data-list="${_type}"]`,
        target: `[data-list="${_type}"]`,
        parentDiv: '#accordion-group-'+_type,
        board: true,
        data: {},
        badge: {
            tag: 'span',
            props: {id: 'badge_darging_'+_type, class: 'badge bg-primary position-absolute'},
        },
        onDragStart(e){
            let {name, list} = e.target.dataset
            Object.assign(this.data, {
                name,
                type: list,
            })
        },
        // TODO 支持由其他组件向该inst注册拖放协议（item的dragstart向datatransfer传输参数，contianer的dropover决定是否接受参数传递到drop
        onUpdateTarget({currentTarget, originalEvent: e}){ // 接受拖拽事件，有可能是文件
            let tip = ''
            let { type } = this.data
            let { action, list, name } = currentTarget.dataset
            let to = this.data.to = e.ctrlKey ? _inst.folder_getParent(name) : name
            if(action.startsWith('category_')){
                if(action == 'category_'+type && list == type){
                    tip = `移动到 【${to == 0 ? '顶级目录' : _inst.folder_getValue(name, 'title')}】 `
                }
            }
            return {tip , accept: true}
        },
        onDrop(e){
            let { type, name, to } = this.data
            let {target, dataTransfer} = e
            g_drag.hide(type)

            let files = target.files || dataTransfer.files
            if (files.length) { // 文件接收
                let paths = Object.values(files).map(v => v.path)
                if (arr_equal(g_cache.dragingFile, paths)) { // 从软件拖拽的文件
                    let cnt = 0
                    Promise.all(g_cache.dragingMD5s.map(async md5 => {
                        let item = await g_data.data_getData(md5)
                        let ids = e.shiftKey ? await _inst.getItemFolder(item) : []
                        if(!ids.includes(to)){
                            _inst.setItemFolder(item.id, [...ids, to])
                            cnt++
                        }
                    })).then(() => cnt && toast('成功设置 ' + cnt + ' 个文件的目录'))
                }else{
                    g_data.file_revice(paths.map(file => {
                        return {
                            file,
                            meta: {folders_ids: [to]}
                        }
                    })).then(({ added }) => toast('成功添加'+added.length+'个文件！', 'success'))
                }
                return
            }
            if (e.target.dataset.list == type && to != name) {
                if (!isEmpty(name)) { // 目录之间的层级移动
                    return _inst.folder_setValue(name, 'parent', to) // 设置父目录
                }
            }
        }
    })

    return _inst
}
