var db_list = {}
addEventListener('message', async e => {
    let { id, data: [type, {db, query, args}] } = e.data
    let _db = this.getDB(db)
    let ret
    // console.log({query, args})
    // return
    if(type == 'exec'){
        _db.exec(query) // exec无返回值
        ret = true
    }else{
        ret = await _db.prepare(query)[type](...args)
    }
    postMessage({ ret, id });
})

function getDB(file){
    return db_list[file] ??= require('better-sqlite3')(file, {})
}

