assignInstance(g_db, {

    init(){
        g_setting.tabs.library = {
            title: '素材库',
            icon: 'box',
            elements: {
                importType: {
                    title: '导入方式',
                    require: true,
                    type: 'select',
                    list: { copy: '复制', move: '移动', link: '链接' },
                    value: () => g_db.getConfig('importType', 'copy'),
                    onSave: val => g_db.setConfig('importType', val),
                },
                randomMD5: {
                    title: '随机MD5最小文件大小',
                    help: '如果想快速导入且基本上不会导入重复文件可以打开此开关(0以上)',
                    value: () => g_db.getConfig('randomMD5', -1),
                    onSave: val => g_db.setConfig('randomMD5', val),
                }
            }
        }
        g_hotkey.register('ctrl+keyl', {
            title: '切换素材库',
            content: `!g_dropdown.isShowing('db_menu') && g_dropdown.quickShow('db_menu')`,
            type: 2,
        })
    },

     table_sqlite: `
      CREATE TABLE IF NOT EXISTS files(
          id INTEGER PRIMARY KEY AUTOINCREMENT,
          title VARCHAR(256),
          size INTEGER,
          date INTEGER,
          birthtime INTEGER,
          link VARCHAR(256),
          md5 CHAR(32) NOT NULL
      );
 
      CREATE TABLE IF NOT EXISTS config(
         key   PRIMARY KEY,
         value TEXT
      );
 
      CREATE TABLE IF NOT EXISTS trash(
          id INTEGER PRIMARY KEY AUTOINCREMENT,
          title VARCHAR(256),
          size INTEGER,
          date INTEGER,
          birthtime INTEGER,
          link VARCHAR(256),
          md5 CHAR(32) NOT NULL,
          meta TEXT,
          last INTEGER
      );
      `,
     db_menu: {},
 
     getOption(opts) {
         return {
             readonly: opts.file.substring(0, 1).toLowerCase() == 'y',
             type: opts.type,
         }
     },
 
     async onFirstConnected() {
         let gid = await g_db.db_getConfig('guid')
         if (!gid){
             gid = guid()
             await g_db.db_setConfig('guid', gid)
         }
         g_db.guid = gid
     },
})
