
assignInstance(g_datalist, {
    setItemWidth(val, div){
        let inst = g_datalist.getContainer()
        g_container.runViewMethod({
            type: inst.opts.type,
            method: 'onSetWidth', args: {val, div}, inst
        })
    },
    containers: {},
    toPage(to_page){
        return this.containerMethod(null, 'loadPage', {to_page})
    },
    nextPage(){
        return this.containerMethod(null, 'nextPage')
    },
    prevPage(){
        return this.containerMethod(null, 'prevPage')
    },
    // 设置标签页物品
    tab_setItems(items, tab, load) {
        let data = this.tab_getData(undefined, tab)
        if (data.sqlite) data.sqlite.items = items
        this.containerMethod(tab, 'setItems', items, load)
    },
    // 清空标签页内容
    tab_clear(tab, load) {
        this.tab_setItems([], tab, load)
    },
    
    // 切换视图
    tab_setVal(k, v, tab) {
        tab ??= this.getCurrentTab()
        this.tabs.setValue(tab, k, v, true, false)
        if(['view', 'sort', 'reverse'].includes(k)){
            return this.tab_reopen(tab)
        }
        // this.tab_reload(tab)
    },

    // 刷新物品
    tab_refresh(tab) {
        tab ??= this.getCurrentTab()
        this.tab_setItems([], tab, true)
    },

    // 重载结构
    tab_reload(tab) {
        return this.tab_reopen(tab)
        
        tab ??= this.getCurrentTab()
        this.tab_setItems([], tab, false)
        this.tabs.generalTab(tab)
    },

    containerMethod(tab, method, ...args){
        // let container = this.tabs.getValue(tab, 'container')
        let inst = this.getContainer(tab)
        if(inst && inst[method]) return inst[method].apply(inst, args)
    },
    getContainer(id){
        return g_container.get(id ?? this.tabs.getActive())
    },
    init() {
        const self = this

        g_hotkey.register({
            'ctrl+arrowup': {
                title: '上一页',
                content: "doAction('datalist_prevPage')",
                type: 1,
            },
            'ctrl+arrowdown': {
                title: '下一页',
                content: "doAction('datalist_nextPage')",
                type: 1,
            },
        })

        g_action.registerAction({
            // 缩略图加载事件
            datalist_coverLoaded: dom => {
                let {naturalWidth, naturalHeight, src} = dom
                if(!src.startsWith('file://')){
                    // 为非本地加载的图片重新调整显示大小
                    let div = getParent(dom, '.datalist-item')
                    if(div.length){
                        g_datalist.setItemWidth(g_db.getConfig('itemWidth', 150), div.data({width: naturalWidth, height: naturalHeight}))
                    }
                }
            },

            datalist_toPage: dom => this.toPage(dom.dataset.page - 1),
            datalist_nextPage: dom => this.nextPage(),
            datalist_prevPage: dom => this.prevPage(),
            datalist_listPages: () => prompt('', {title: '输入页面(1-'+ this.containerMethod(null, 'getMaxPage') +')'}).then(page => {
                if(isNaN(page *= 1) || page <= 0) return toast('错误页面', 'danger')
                this.toPage(page - 1)
            })
        })

        g_plugin.registerEvent('db_connected', data => {
            const event_shown = async ({ tab, inst }) => {
                let { data: { sqlite, view, sort, reverse, pagePre, maxPage } } = tabData = inst.getData(tab) || {}

                const onPageChanged = ({to_page, max}) => {
                    to_page = to_page + 1
                    insertEl({ tag: 'div', text: '', props: { id: 'container_page', class: ' ', style: 'z-index:2;'} }, { target: $('#datalist_toolbar div:eq(1)'), method: 'prependTo' }).html(
                        g_tabler.build_pageination({
                            page: to_page,
                            maxPage: max,
                            maxShow: 10,
                            action: 'datalist_toPage',
                            prevAction: 'datalist_prevPage',
                            nextAction: 'datalist_nextPage',
                            moreAction: 'datalist_listPages',
                        })
                    )
                }

                g_filter.update()
                let container = self.getContainer(tab)
                if (!container) {
                    view ??= 'default'
                    if (!g_container.hasPreset(view)) return

                    const runViewMethod = (inst, method, args, type) => {
                        return g_container.runViewMethod({
                            type: type ?? inst.opts.type,
                            method, args, inst
                        })
                    }

                    let opts = {itemWidth: g_db.getConfig('itemWidth', 150)}
                    runViewMethod(container, 'onInit', opts, view)
                    let {html} = tabData.data || {}
                    container = g_container.build(tab, Object.assign(opts, {
                        type: view,
                        maxPage,
                        html,
                        style:  'height: calc(100vh - 136px)',
                        hideFooter: true,
                        hideHeader: true,
                        page_info: {
                            pagePre: pagePre || 50,
                        },
                        itemClass: 'datalist-item',
                        // itemClass: 'fade-in',
                        target: this.tabs.getContent(tab),
                        containerHTML: '<div class="{class} datalist-items" style="{style}" {props}>{html}</div>',
                        onInsertedItems(data){
                            g_plugin.callEvent('datalist_insertedItems', data)
                        },
                        onSetWidth(val, div) {
                            if(!div){ // 非个别设置
                                g_db.setConfig('itemWidth', val)
                                this.opts.itemWidth = val
                                // TODO 样式分别设置最小宽度，后续可隐藏其他元素
                            }
                            return runViewMethod(this, 'onSetWidth', {val, div})
                        },
                        onPageChanged,
                        async onInitItems(){
                            let {sqlite, sort, reverse} = self.tab_getData(undefined, this.opts.name)
                            if (sqlite && sqlite.items.length == 0) {
                                const initItems = async () => sqlite.items = await sqlite.all()
                                if(sqlite.type == 'sqlite'){
                                    // 初始化items
                                    let sorted = ['id', 'size', 'title', 'birthtime', 'date', 'random'].includes(sort)
                                    //  && !sqlite.getOption('order')
                                    if (sorted){
                                        if(sort == 'random') sort = 'RANDOM()'
                                        sqlite.setOption('order', `${sort} ${reverse ? 'DESC' : 'ASC'}`)
                                        await initItems();
                                    }else{
                                        await initItems()
                                        sqlite.items = await self.sort.do_sort(sort, sqlite.items)
                                        if (reverse) sqlite.items = sqlite.items.reverse()
                                    }
                                }else{
                                    await initItems()
                                }
                                this.setItems([...sqlite.items], true)
                                g_plugin.callEvent('datalist.tab.initItems', { tab, items: sqlite.items })
                                return true
                            }
                        },
                        onClearItems(){
                            $('#container_page').remove()
                        },
                        async before_getPage(opts){
                            let {to_page, start, end} = opts
                            let sqlite = self.tab_getData('sqlite', this.opts.name)
                            if(!sqlite) return

                           let preset = sqlite.getPreset()
                           if (preset.loadPage){  // 针对自定义视图的加载页数事件
                                this.opts.items = opts.data = await preset.loadPage.call(sqlite, to_page, sqlite.items)
                           }
                        },
                        getPage({ start, end }) {
                            let items = []
                            return new Promise(async reslove => {
                                for (let i = start; i < end; i++) {
                                    items.push(this.getItem(i))
                                }
                                reslove(items)
                            })
                        },
                        async initItemData(item, index){
                            let isData = !isEmpty(item.id) && item.md5.length == 32
                            if (isData && !item.media) {
                                Object.assign(item, await g_data.data_getFullData(item.md5))
                                Object.assign(item, await g_detail.inst.media.get(item))
                                // preset.parseItem.call(sqlite, item)
                            }
                        },
                        async parseItem({ item, type, newWidth, newHeight }, index) {
                            let isData = !isEmpty(item.id) && item.md5.length == 32
                            let r = Object.values(getConfig(replaceArr(['%name', '%duration', '%ext', '%desc'], 'detail,'), true)) // TODO 存在对象里
                            type ??= this.opts.type
                            let props = `class="${type == 'table' ? 'container-sizer' : ''}" data-mousedown="item_click" data-dbclick="item_dbclick" {md5} {dargable}`
                            let desc = r[3] && isData ? (await g_detail.getDetail(item, 'desc'))?.desc : ''
                            return self.initElementHTML(runViewMethod(this, 'parseItem', {item, props, desc, index, r, newWidth, newHeight}), item)
                        },
                        items: []
                    }))
                } else {
                    let {page, max} = container.getPageInfo()
                    onPageChanged({to_page: page, max})
                    if((tabData.lastUpdate || 0) < g_cache.lastInsertTime ){
                        tabData.lastUpdate = g_cache.lastInsertTime
                        self.tab_update(tab)
                    }
                    // g_datalist.view_getVal('onShow', item.view, item)
                }

                g_detail.selected_keys.length == 0 && g_detail.showList([]) // 如果没有选中，则更新文件侧边视图
                g_ui.show('datalistToolbars')
                g_plugin.callEvent('datalist.tabChanged', {tab, inst, data: tabData})
            }

            if (!data.first || data.opts.type !== DB_TYPE_DEFAULT) return
            let opts = {
                nowarp: true,
                name: 'tablist',
                container: '#itemlist_tabs',
                body: '{tabs}<div id="filters" class="d-flex"></div>{contents}',
                event_close({ tab, inst }) {
                    let item = inst.getData(tab)
                    item && g_datalist.view_getVal('onClose', item.view, item)
                    g_container.remove(tab)
                },
                event_shown,
                event_hide({ tab, inst }) {
                    let item = inst.getData(tab)
                    item && g_datalist.view_getVal('onHide', item.view, item)
                },
                defaultMenuItems: {
                    close: {
                        icon: 'x',
                        text: '关闭',
                    },
                    closeOther: {
                        icon: 'x',
                        text: '关闭其他',
                    },
                },
                moreItems: ['closeAll'],
                menuItems: {
                    refresh: {
                        icon: 'refresh',
                        text: '刷新',
                        callback({ key, name }) {
                            g_datalist.tab_refresh(key)
                        }
                    },
                    detail: {
                        icon: 'list',
                        text: '详细',
                        callback({ key, name }) {
                            prompt(JSON.stringify(this.data.get(key), (k, v) => {
                                return k == 'items' && Array.isArray(v) ? v.length + 'items...' : v
                            }, 4), { rows: 20, scrollable: true }, { title: '标签页信息' })
                        }
                    },
                    selectAll: {
                        icon: 'select-all',
                        text: '全选(无选中标记)',
                        callback({ key, name }) {
                            let items = Object.values(g_datalist.tab_getData('sqlite', key).items)
                            g_detail.selected_items = items
                            toast('当前选中【' + items.length + '】个项目')
                        }
                    },
                },
            }
            if (getConfig('keepTab_All')) {
                opts.onCntChanged = i => i == 0 && doAction('category,all')
            } else {
                opts.defaultTab = {
                    icon: 'house',
                    title: '主页',
                    data: {},
                    html: `
                        <div class="text-center mx-auto mt-5">
                            <i class="ti ti-box-seam" style="font-size: 4rem"></i>
                            <h4>赶快打开一个标签页吧！</h4>
                        </div>
                    `
                }
            }

            if (getConfig('tab_memory')) {
                let id = 'tab_tablist_' + g_db.current
                opts.list = () => {
                    try {
                        let data = local_readJson(id, [])
                        //.filter(item => item.data.sqlite != undefined)
                        data.forEach(item => {
                            if(item.data.sqlite){
                                item.data.sqlite = new SQL_builder(item.data.sqlite)
                                item.data.page = -1 // 重置页数
                                item.hasMore = true
                            }
                        })
                        return data
                    } catch (err) {
                        console.log(err)
                        // 已卸载的数据类型
                        return []
                    }
                }
                opts.saveData = data => local_saveJson(id, data)
            }
            self.tabs = new TabList(opts)

            $(() => {
                setTimeout(() => self.tabs.refresh(), 250)
                $(`
                    <button class="btn p-1 border-0" data-action="dropdown_show,datalist_opts">
                        <i class="ti ti-list-details"></i>
                    </button>`).prependTo(g_tabs.method('tablist', 'getItemsMenu'))
            })
        })

    }
})