g_datalist.sort = {
    list: {
        asc: {
            title: '反序',
            action: 'reverse',
        },
        id: {
            title: 'ID',
            action: 'sort,id',
        },
        name: {
            title: '名称',
            action: 'sort,title',
        },
        date: {
            title: '导入日期',
            action: 'sort,date',
        },
        birthtime: {
            title: '文件日期',
            action: 'sort,birthtime',
        },
        size: {
            title: '大小',
            action: 'sort,size',
        },
        random: {
            title: '随机',
            action: 'sort,random',
            callback: items => {
                console.log(items)
                return items
            }
        },
    },
    init() {
        const self = this
        g_dropdown.register('datalist_sort', {
            position: 'end-top',
            offsetLeft: 10,
            // alwaysHide: true,
            parent: ['datalist_opts', 'sort'],
            list() {
                let ret = {}
                for (let [k, v] of Object.entries(self.list)) {
                    ret[k] = { title: v.title, action: v.action }
                }
                return ret
            }
        }).init()
        g_hotkey.register('ctrl+keyg',  {
            title: '菜单',
            content: "g_dropdown.quickShow('datalist_opts')",
            type: 2,
        })
    },
    register(name, opts) {
        opts.action = 'sort,' + name
        this.list[name] = opts
    },
    do_sort(name, items) {
        let old = items
        let opts = this.list[name]
        if (opts && opts.callback) {
            items = opts.callback(old)
        }
        return items
    }
}
g_datalist.sort.init()

assignInstance(g_datalist, {
    init() {
        const self = this
        
        g_dropdown.register('datalist_opts', {
            position: 'start-bottom',
            offsetTop: 5,
            list: {
                detail: {
                    title: '信息',
                    icon: 'list-details',
                },
                view: {
                    title: '视图',
                    icon: 'grid-dots',
                },
                sort: {
                    title: '排序',
                    icon: 'sort-ascending-letters',
                },
            }
        })

        // TODO 注册自定义排序以及视图
        g_dropdown.register('detail', {
            position: 'end-top',
            offsetLeft: 10,
            alwaysHide: true,
            parent: ['datalist_opts', 'detail'],
            list: {
                name: {
                    title: '名称',
                    action: 'detail,name',
                },
                desc: {
                    title: '注释',
                    action: 'detail,desc',
                },
                duration: {
                    title: '时长',
                    action: 'detail,duration',
                },
                ext: {
                    title: '格式',
                    action: 'detail,ext',
                },
            }
        }).init()

        g_dropdown.register('datalist_view', {
            position: 'end-top',
            offsetLeft: 10,
            alwaysHide: true,
            parent: ['datalist_opts', 'view'],
            list: {
                default: {
                    title: '卡片视图',
                    icon: '',
                    action: 'view,default',
                },
                table: {
                    title: '表格视图',
                    icon: '',
                    action: 'view,table',
                },
                waterfall: {
                    title: '瀑布流视图',
                    icon: '',
                    action: 'view,columns',
                },
            }
        }).init()
        
        g_action.
            registerAction({
                range_view: dom => self.item_setWidth(dom.value),
                sort(dom, action) { // 排序
                    let val = action[1]
                    g_db.setConfig('sort', val),
                    g_datalist.tab_setVal('sort', val)
                },
                view(dom, action) { // 视图
                    let val = action[1]
                    g_db.setConfig('view', val)
                    g_datalist.tab_setVal('view', val)
                },
                reverse() { // 倒序
                    let val = !g_datalist.tab_getData('reverse')
                    g_db.setConfig('reverse', val),
                    g_datalist.tab_setVal('reverse', val)
                },
                detail(dom, action) {
                    console.log(action.join(','))
                    g_setting.toggleValue(action.join(','))
                    g_datalist.tab_refresh()
                },
            })

        let keys = replaceArr(['%name', '%desc', '%duration', '%ext'], 'show,')
        g_setting.
            onSetConfig(keys, (v, k) => getEle(k).toggleClass('active', v)).
            onSetConfig({
                itemWidth(v) {
                    // Object.values(g_datalist.views).forEach(preset => preset.onsetWidth && preset.onsetWidth(v))
                    getEle({ input: 'range_view' }).val(v)
                }
            })
        g_setting.apply(keys)
    },

    item_setWidth(width) {
        // TODO 最大最小值随标签
        g_pp.setTimeout('itemWidth', () => g_datalist.containerMethod(null, 'method', 'onSetWidth', width), 50)
    },

})