
assignInstance(g_datalist, {
    init() {
        const onSelectedChanged = i => {
            $('#badge_datalist_selected').toggleClass('hide', i <= 1).find('b').html(i)
        }
        g_selection.register({
            name: 'datalist',
            // container: '.overflow-container',
            container: '.datalist-items',
            selector: '.datalist-item',
            selectedClass: 'item_selected',
            html: ``,
            selected: [],
            multiSelect: true,
            addSelect: false,
            onUnset(clear){
                clear && (g_item.selected_update() & onSelectedChanged(0))
            },
            callback(selected){
                onSelectedChanged(selected.length)
                g_item.selected_update() // 跳过单击选择
            }
        })
        g_action.registerAction({
            datalist_tab_refresh: () => this.tab_refresh(),
            datalist_tab_selectAll: () => g_selection.setSelected('datalist', Array.from(this.tab_getElements())),
            datalist_tab_unsetAll: () => g_selection.clearSelected('datalist'),
            datalist_tab_selectReverse: () => g_selection.setSelected('datalist', Array.from(this.tab_getElements().filter((i, el) => !el.classList.contains('item_selected')))),
            datalist_tab_rev: () => g_selection.clearSelected('datalist'),
        })
    }
})

