
g_setting.setDefault({
    multiTab: true, // 多标签
    tab_memory: true, // 标签记忆
    keepTab_All: false, // 始终显示【全部】标签
    pagePre: 20, // 每页最大加载
})

var g_datalist = {
    tab_new(opts) {
        !getConfig('multiTab') && this.tabs.clear()

        let {sqlite, title, type, icon, sort, view, reverse, pagePre, icon_color, value, replaceTab } = opts
        if(!sqlite) return

        sqlite = new SQL_builder(sqlite) // 保证对象兼容
        let find = this.tabs.data.values().find(item => item.data.sqlite?.equal(sqlite, ['order']))
        if(find){
            if(!replaceTab) return this.tabs.setActive(find.id)
        }
        sort ??= g_db.getConfig('sort')
        view ??= g_db.getConfig('view', 'default')
        reverse ??= g_db.getConfig('reverse', false)
        pagePre ??=  parseInt(getConfig('pagePre'))
        this.tabs.add({
            icon, icon_color,
            title: toVal(title),
            data: {
                type, sqlite, sort, view, reverse, pagePre, value,
                page: -1, // 当前页数
            },
        }, true)
    },

    // 返回md5在物品列表中的下表
    findItemIndex(opts){
        if(typeof(opts) != 'object') opts = {md5: opts}
        let {md5, offset, tab, start} = opts
        let items = g_datalist.tab_getData('sqlite', tab).items
        let index = items.findIndex(item => item.md5 == md5)
        if(offset != undefined){
            let to = index + offset
            if(start){
                index += start
                return items.slice(Math.max(0, Math.min(index, to)), Math.max(index, to))
            }
            if(to >= 0 && to < items.length) return items[to]
        }
        return index
    },

    // 获取当前tab
    getCurrentTab(full) {
        return this.tabs.getActive()
    },

    // 获取当前tab标识
    getCurrentValue(){
        let {type, value} = this.tabs.getData().data
        return type + ',' + value
    },

    // 获取当前标签页内容
    getContent(tab){
        tab ??= this.getCurrentTab()
        return this.tabs.getEle(tab)
    },

    // 移除标签页
    tab_remove(tab) {
        tab ??= this.getCurrentTab()
        return this.tabs.close(tab)
    },

    // 获取标签页数据
    tab_getData(k, tab){
        tab ??= this.getCurrentTab()
        let d = this.tabs.data.get(tab).data
        return k != undefined ? d[k] : d
    },

    // 清空标签页内容
    tab_clear(tab, load){
        this.tab_setItems([], tab, load)
    },

    // 设置标签页物品
    tab_setItems(items, tab, load) {
        this.tab_getContent(tab).html('')
        let data = this.tab_getData(undefined, tab)
        if(data.sqlite){
            data.sqlite.items = items
            data.page = -1
            load && this.page_nextPage()
        }
    },

    // 搜索指定类型 type: [folders,tags] value: 对应id
    tab_search(type, value){
        return this.tabs.data.map1(([k, v]) => {
            if(v.data.type == type && (isEmpty(value) || v.data.value == value)) return v.id
        })
    },

    // 获取指定标签页物品
    item_getData(cb, tab){
        if(typeof(cb) != 'function'){
            let md5 = cb.toString()
            cb = item => item.md5 == md5
        }
        return this.tab_getData('sqlite', tab).items.find(cb)
    },

    // 更新tab.items缓存
    tab_item_update(md5, data){
        let cnt = 0
        g_datalist.tabs.data.entries((k, v) => {
            let find = v.data?.sqlite?.items?.find(item => item.md5 == md5)
            if(find){
                Object.assign(find, data) // 合并数据，因为items里有其他属性
                cnt++
            }
        })
        return cnt
    },

    // 获取标签页内容
    tab_getContent(tab) {
        return this.getContent(tab).find('.datalist-items')
    },

    // 指定tab加载items
    async tab_loadItems(items, tabs, insert = 'appendTo', source = '') {
        tabs = toArr(tabs ?? this.getCurrentTab())
        if(source != 'scroll'){ // 插入操作
            let tab_all = g_datalist.tab_search('all')
            if(tab_all.length && !tabs.includes(tab_all[0])) tabs.push(tab_all[0]) // 如果【全部】标签页存在，同样插入
        }
       tabs.forEach(tab => {
            let {sqlite, view, page} = this.tab_getData(undefined, tab)
            if(!sqlite || page == -1) return

            let target = this.tab_getContent(tab)
            let table = sqlite.getOption('table')
            Promise.all(toArr(items).map(item => {
                // 防止重复插入
                // let index = sqlite.items.find(({id}) => id == item.id)
                // if(index != -1){
                //     sqlite.items.splice(index, 1)
                //     this.tab_getElement({fid: item.id}, tab).remove()
                // }
                // sqlite.items[insert == 'appendTo' ? 'push' : 'shift'](item)
                return  this.item_parse({data: item, view, table})
            })).then(arr => {
                target.find('.nomore').remove()
                let elements = $(arr.length ? arr.join('') : this.view_getVal('noMore'))
                this.tab_updateElements(elements[insert](target))
                g_datalist.view_getVal('onLoadItems', view, tab, elements)
                debug({_: '插入物品', arr, elements, insert, target})
            })
        })
    },

    // 更新dom
    tab_updateElements(elements){
        elements.find('.lazyload').lazyload()
        g_setting.apply('itemWidth') // 更新宽度
    },
}

// view 
assignInstance(g_datalist, {
    views: {}, // 可切换的视图
    get_html(d, view) {
        view ??= this.view_getCurrentView()
        return this.views[view].item(d)
    },

    getTabData(cb){
        return this.tabs.data.list.filter(cb)
    },

    getDataByViewType(view){
        return g_datalist.getTabData(item => item.data.view == view)
    },

    view_register(view, opts) {
        this.views[view] = Object.assign({

        }, opts)
        opts.init && opts.init()
    },
    // 切换视图
    tab_setVal(k, v, tab) {
        tab ??= this.getCurrentTab()
        // 更新tab和sqlite属性（太麻烦了，把tab的属性放到sqlite里？而且这玩意不是早已经不只是sqlite。。。）
        let data = g_datalist.tab_getData(undefined, tab)
            
        data[k] = v
        Object.assign(data.sqlite.opts, {sources: false, order: undefined})
        // g_datalist.tab_setData(data, tab)
        this.tab_reload(tab) & this.tab_reload(tab)
    },

    // 刷新物品
    tab_refresh(tab){ 
        tab ??= this.getCurrentTab()
        this.tab_setItems([], tab, true)
    },

    // 重载结构
    tab_reload(tab){
        tab ??= this.getCurrentTab()
        this.tabs.generalTab(tab)
    },

    view_getCurrentView(tab){
        tab ??= this.getCurrentTab()
        return g_datalist.tab_getData('view', tab)
    },

    // 返回视图基本结构
    view_getVal(key, view, ...args) {
        view ??= this.view_getCurrentView()
        let fun = this.views?.[view]?.[key]
        if(fun) return toVal.call(undefined, fun, ...args)
    },

    async view_parseItems(view, items) {
        let opts = this.views[view]
        if (opts) {
            let html = (await Promise.all(items.map(data => this.item_parse({data, view})))).join('')
            return $(toVal(opts.container)).find('.datalist-items').html(html)
        }
    },

    tab_getElements(tab){
        return this.tab_getContent(tab).find('.datalist-item')
    },

    tab_getElement(opts, tab){
        return getEle(opts, '.datalist-item', this.tab_getContent(tab))
    },

     // 删除元素并从列表中移除
     tab_removeElement(fid, tab){
        this.tab_getElement({fid}, tab).remove()
        this.tab_spliceItem({fid, tab, remove: 1}) 
     },

      // 添加元素并添加到列表中
      async tab_appendElement(fid, tab, method = 'prependTo'){
        if(this.tab_getItemIndex({fid, tab}) != -1) return
        let data = await g_data.data_getDataByID(fid)
        data.id = fid
        this.tab_spliceItem({fid, tab, append: data, index: 0})
        this.tab_loadItems(data, tab, method)
     },

    tab_spliceItem({fid, tab, remove, append, index}){
        remove ??= 0
        let items = this.tab_getItems(tab)
        index ??= this.tab_getItemIndex({fid, tab, items})
        let found = index != -1
        if(found) append ? items.splice(index, remove, append) : items.splice(index, remove)
        return found
    },

    tab_getItems(tab){
        return g_datalist.tab_getData('sqlite', tab).items
    },

    tab_getItemIndex({fid, tab, items}){
        items ??= this.tab_getItems(tab)
        return items.findIndex(item => item.id == fid)
    },

    importActions: [], // 导入时显示的动作

})

assignInstance(g_datalist, {
    onScroll(dom) {
        let scrollTop = dom.scrollTop;
        if (scrollTop == 0) return
        if (scrollTop + dom.offsetHeight + 50 >= dom.scrollHeight && !g_pp.timerAlive('nextPage')) {
            g_pp.setTimeout('nextPage', () => g_datalist.page_nextPage(), 500)
        }
    },

    // 获取导入时的参数设置
    getImportParams(){
        let ret = {};
        [['importType', '.btn-primary'], ['importTarget', '.btn-warning'], ['importActions', '.active']].forEach(([name, classes]) =>  ret[name] = getEle({name}, classes).data('value'))
        return ret
    },

    init() {
        const self = this

        g_action.registerAction({
            datalist_tab_refresh: () => self.tab_reload(),
            datalist_tab_selectAll: () => g_selection.setSelected('datalist', Array.from(self.tab_getElements())),
            datalist_tab_unsetAll: () => g_selection.clearSelected('datalist'),
            datalist_tab_selectReverse: () => g_selection.setSelected('datalist', Array.from(self.tab_getElements().filter((i, el) => !el.classList.contains('item_selected')))),
            datalist_tab_rev: () => g_selection.clearSelected('datalist'),
        })

        g_sidebar.register('bottom', {
            html: ``,
            defaultSize: {height: 150},
            // onShow: e => setCssVar('--offset-bottom', (g_sizeable.data?.sidebarBottom?.height || 150) + 'px'),
            onHide: e => setCssVar('--offset-bottom', '0px')
        })

        g_plugin.registerEvent('onPluginsLoaded', () => {
            g_ui.register('datalistToolbars', {
                group: 'datalist_status',
                target: '#datalist_statusBar',
                html: `
                    <div id="datalist_toolbar" class="d-flex flex-nowrap w-full m-0 ps-2 pe-2">
                        <div class="me-auto d-flex">
                           
                        </div>
                        <div class="flex-fill text-end pe-2">
                            <!-- <button class="btn btn-rounded " data-action="" title="打开">
                                <i class="ti ti-player-track-prev"></i>
                            </button>
                            <button class="btn btn-rounded " data-action="" title="全选">
                                <i class="ti ti-player-pause"></i>
                            </button>
                            <button class="btn btn-rounded " data-action="" title="取消选择">
                                <i class="ti ti-player-track-next"></i>
                            </button> !-->
                        </div>
                        <div class="ms-auto border-start ps-2">
                           <div class="d-flex align-items-center" style="gap: 3px">
                                <button class="btn btn-rounded " data-action="datalist_tab_selectAll" title="全选">
                                    <i class="ti ti-select-all"></i>
                                </button>
                                <button class="btn btn-rounded " data-action="datalist_tab_unsetAll" title="取消选择">
                                    <i class="ti ti-deselect"></i>
                                </button>
                                <button class="btn btn-rounded " data-action="datalist_tab_selectReverse" title="反选">
                                    <i class="ti ti-resize"></i>
                                </button>
                                <button class="btn btn-rounded " data-action="datalist_tab_refresh" title="刷新">
                                    <i class="ti ti-reload"></i>
                                </button>
                                <span id="badge_datalist_selected" class="badge bg-azure hide">
                                    选中<b></b>
                                </span>
                           </div>
                        </div>
                    </div>
                `
            })
        })
   
        g_ui.register('datalist', {
            target: '#content',
            html: `
                <div class="position-relative w-full h-full ">
                    <div id="itemlist_tabs"  data-out="item_unpreview" data-outfor="item_preview" class="overflow-y-container"></div>
                    <div id="datalist_statusBar" class="row m-0 p-0 position-absolute align-items-center bottom-0 border-top w-full bg-auto " style="height: 43px">
                    </div>
                </div>
            `,
        }).show('datalist')

        g_sizeable.register('sidebarBottom', {
            selector: '#sidebar_bottom',
            memory: true,
            allow: ['top'],
            height_min: 50,
            height_max: 500,
            // style: {backgroundColor: 'unset'},
            change: (t, i) => {
                let ret = { resize: false }
                if (t == 'height') {
                    let {name, max} = g_ui.getGroupShown('sidebar_bottom').data() || {}
                    if(!isEmpty(name)){
                        if(max == -1 || i > max) return ret
                        g_sizeable.set(name, i)
                    }
                    setCssVar('--offset-bottom', i+ 'px')
                    return ret
                }
            }
        })

        g_style.addStyle('datalist', `
            .datalist {}
            .datalist-item {}
            .datalist-items {
                padding-bottom: var(--offset-bottom) !important;
            }
            .datalist-item.item_selected {
                border: 3px solid var(--tblr-primary) !important;
                box-sizing: content-box;
            }
            .nomore {
                margin-bottom: 100px;
            }
            .card-preview {
                position: relative;
            }
            @media screen and (max-width: 700px) {
                .btn-sm1 > small {
                    display: none;
                }
              }
        `)
        this.importActions.push(['附带目录名', 'folder-up', 'copy'], ['格式转换', 'arrows-exchange-2', 'copy'], ['视频裁剪', 'cut', 'copy'], ['字幕识别', 'text-recognition', 'copy'])
        const createGrounp = (name, items, classes, selected) => {
            if(items.length == 0) return ''
            items.at(-1)[0] != '取消' && items.push(['取消', 'x', ''])
            return `<div class="btn-group-vertical w-100" role="group">${items.map(item => {
                let [title, icon, value] = item
                let props = `data-action="activeClass,${item[3] || classes}" data-name="${item[4] || name}"`
                return `<button data-value="${value}" class="btn ${value == selected ? classes : ''}" ${props}>${!isEmpty(icon) ? `<i class="ti ti-${icon} me-2"></i>` : ''}${title}</button>`
            }).join('')}</div>`
        }
        g_fileDrop.register('datalist', {
            selector: '#content,#sidebar_right',
            layout: () => `
                <div class="w-full h-full d-flex flex-wrap align-items-center justify-content-center align-content-center" style="background-color: rgba(0, 0, 0, .4);gap: 20px">
                    <div class="card card-stacked" data-id="file">
                        <div class="card-body">
                            <h3 class="card-title"><i class="ti ti-file-import fs-2 me-2"></i>导入方式</h3>
                            ${createGrounp('importType', [['复制', 'copy', 'copy'], ['移动', 'file-arrow-right', 'move'], ['链接', 'link', 'link']], 'btn-primary', g_db.getConfig('importType', 'copy'))}
                        </div>
                    </div>
                    <div class="card card-stacked" style="max-width: 300px;" >
                        <div class="card-body">
                            <h3 class="card-title"><i class="ti ti-file-import fs-2 me-2"></i>导入位置</h3>
                            ${createGrounp('importTarget',  this.tabs.data.map1(([k, v]) => {
                                let {type, value} = v.data
                                if(['tags', 'folders'].includes(type)) return [v.title, v.icon, type+','+value]
                            }), 'btn-warning', this.getCurrentValue())}
                        </div>
                    </div>
                    
                </div>
            `,
            ingone: g_format.getCategory('ingone'),
            reviceFileObject: true,
            // acceptTypes: ['Files', 'text/plain', 'text/html', 'uri'], 
            onParse(d, target, targetCard) {
                let {importActions, importType, importTarget} = g_datalist.getImportParams()
                if(!isEmpty(importActions)) toast('导入至插件动作还在测试中...')

                let revice = items => {
                    // 应用到拖入的物品
                    items = items.map(item => {
                        if(typeof(item) == 'string') item = {file: item}
                        item.importType = importType
                        item.meta ??= []
                        let [type, name] = (importTarget || '').split(',')
                        if(['tags', 'folders'].includes(type)){
                            if(!item.meta[type]) item.meta[type] = []
                            item.meta[type].push(parseInt(name))
                        }
                        return item
                    })
                    g_data.file_revice(items)
                }
                let r
                if(d.file.data.length && (r = d.file.items)){
                    return Promise.all(r.dirs.map(dir => nodejs.files.dirFiles(dir))).then(files => {
                        r.files.push(...(flattenArray(files).filter(file => !this.ingone.includes(getExtName(file)))))
                        revice(uniqueArr(r.files))
                    })
                }
                if((r = d.html.data)){
                    let _$ = parseHtml(r)
                    let items = getElementsValues(_$.find('img'), el => {
                        el = $(el)
                        let url = (el.attr('src') || el.data('src') || '').replaceAll('file:///', '')
                        if(isEmpty(url)) return

                        let title =  el.attr('title') || el.attr('alt')
                        if(isEmpty(title) || hasSpecialChar(title) || title.length > 200) title = nguid()

                        let ext = getExtName(url)
                        if(!g_format.getCategory('image').includes(ext)) ext = 'png'
                        return {
                            file: url,
                            ext, title, meta: {url}, // 网址来源
                        }
                    })
                    return revice(items)
                }
            }
        })

        g_plugin.registerEvent('db_connected', data => {
            if (data.first && data.opts.type === DB_TYPE_DEFAULT) { 
                let opts = {
                    nowarp: true,
                    name: 'tablist',
                    container: '#itemlist_tabs',
			        body: '{tabs}<div id="filters" class="d-flex"></div>{contents}',
                    event_close({tab, inst}){
                        let item = inst.getData(tab)
                        item && g_datalist.view_getVal('onClose', item.view, item)
                    },
                    event_shown({tab, inst}){
                        let item = inst.getData(tab)
                        if(!item) return

                        let data = item.data
                        g_filter.update()
                        if (data.sqlite != undefined && !self.tab_getContent(tab).find('.datalist-item').length) { // 没有数据
                            g_datalist.view_getVal('onInit', item.view, item)
                            self.page_toPage(tab, 0)
                        }else{
                            g_datalist.view_getVal('onShow', item.view, item)
                        }

                        // 如果没有选中，则更新文件侧边视图
                        if(g_detail.selected_keys.length == 0){ 
                            g_detail.showList([])
                        }
                        g_ui.show('datalistToolbars')
                    },
                    event_hide({tab, inst}){
                        let item = inst.getData(tab)
                        item && g_datalist.view_getVal('onHide', item.view, item)
                    },
                    parseContent(k, v){
                        return self.view_getVal('container', v.data.view, v, k)
                    },
                    defaultMenuItems: {
                        close: {
                            icon: 'x',
                            text: '关闭',
                        },
                        closeOther: {
                            icon: 'x',
                            text: '关闭其他',
                        },
                    },
                    moreItems: ['closeAll'],
                    menuItems: {
                        refresh: {
                            icon: 'refresh',
                            text: '刷新',
                            callback({key, name}){
                               g_datalist.tab_reload(key)
                            }
                        },
                        detail: {
                            icon: 'list',
                            text: '详细',
                            callback({key, name}){
                                prompt(JSON.stringify(this.data.get(key), (k, v) => {
                                    return k == 'items' && Array.isArray(v) ? v.length+'items...' : v
                                }, 4), {rows: 20, scrollable: true}, {title: '标签页信息'})
                            }
                        },
                        selectAll: {
                            icon: 'select-all',
                            text: '全选(无选中标记)',
                            callback({key, name}){
                                let items = Object.values(g_datalist.tab_getData('sqlite', key).items)
                                g_detail.selected_items = items
                                toast('当前选中【'+items.length+'】个项目')
                            }
                        },
                    },
                }
                if(getConfig('keepTab_All')){
                    opts.onCntChanged = i => {
                        if(i == 0) doAction('category,all')
                    }
                }else{
                    opts.defaultTab = {
                        icon: 'house',
                        title: '主页',
                        data: {},
                        html: `
                            <div class="text-center mx-auto mt-5">
                                <i class="ti ti-box-seam" style="font-size: 4rem"></i>
                                <h4>赶快打开一个标签页吧！</h4>
                            </div>
                        `
                    }
                }

                if(getConfig('tab_memory')){
                    let id = 'tab_tablist_'+g_db.current
                    opts.list = () => {
                        try {
                            let data = local_readJson(id, []).filter(item => item.data.sqlite != undefined)
                            data.forEach(item => {
                                item.data.sqlite = new SQL_builder(item.data.sqlite)
                                item.data.page = -1 // 重置页数
                                item.hasMore = true
                            })
                            return data
                        } catch(err){
                            // 已卸载的数据类型
                            return []
                        }
                    }
                    opts.saveData = data => local_saveJson(id, data)
                }
                self.tabs = new TabList(opts)
                $(() => {
                    setTimeout(() => self.tabs.refresh(), 250) 
                    $(`
                    <button class="btn p-1 border-0" data-action="dropdown_show,datalist_opts">
                        <i class="ti ti-list-details"></i>
                    </button>`).prependTo(g_tabs.method('tablist', 'getItemsMenu'))
                })
            }
        })

        g_hotkey.register({
            'ctrl+keya': {
                title: '全选',
                content: "doAction('datalist_tab_selectAll')",
                type: 1,
            },
            'ctrl+keyw': {
                title: '关闭当前tab',
                content: "g_datalist.tabs.close(g_datalist.getCurrentTab())",
                type: 2,
            },
            'ctrl+shift+keyw': {
                title: '关闭全部tab',
                content: "g_datalist.tabs.clear()",
                type: 2,
            },
        })

        g_setting.onSetConfig({
            multiTab: () => g_datalist.tabs.clear(),
            tab_memory: b => b && toast('刷新生效!'),
            keepTab_All: () => toast('刷新生效!'),
        })
        
        g_setting.tabs.tabs = {
            title: '标签页',
            icon: 'box-multiple',
            elements: {
                keepTab_All: {
                    title: '总是显示【全部】标签页',
                    type: 'switch',
                    value: () => getConfig('keepTab_All'),
                },
                multiTab: {
                    title: '多标签',
                    type: 'switch',
                    value: () => getConfig('multiTab'),
                },
                tab_memory: {
                    title: '标签记忆',
                    help: '仅多标签模式下',
                    type: 'switch',
                    value: () => getConfig('tab_memory'),
                },
                pagePre: {
                    title: '每页展示',
                    value: () => getConfig('pagePre'),
                },
            }
        }
    },

    // 解析item结构
    async item_parse(opts) {
        let {data, view, html} = opts 
        data.cover ??= await g_item.item_getVal('cover', data)
        data.file ??= await g_item.item_getVal('file', data)

        let {file, cover, md5, id} = data
        return (html || await this.get_html(data, view)).
        replace('{dargable}', file.startsWith('http') == false ? ` data-file="${file}" draggable="true"` : '').
        replace('{preview}', (true || ['mp4', 'mp3', 'wav', 'ogg', 'm4a'].includes(getExtName(file))) ? 'data-hover="item_preview" data-out="item_unpreview" data-hoverTime="300"' : '').
        replace('{md5}', `data-md5="${md5}" data-fid="${id}"`).
        replace('{cover}', cover).
        replace('{file}', file)
    },

    // 下一页
    page_nextPage(tab) {
        return this.page_toPage(tab, parseInt(this.tab_getData('page', tab)) + 1)
    },

    // 到指定页数
    async page_toPage(tab, page = 0) {
        let data = Object.assign(this.tab_getData(undefined, tab), {page})
        var {page, pagePre, sort, reverse} = data
        let sqlite = data.sqlite
        let preset = sqlite.getPreset()
        let start = page * pagePre
        let query = sqlite.toString()
        debug({_: 'toPage', page})
        
        if (sqlite.items.length == 0 && !sqlite.sources) { // 初次加载
            let b = ['id', 'size', 'title', 'birthtime', 'random'].includes(sort)
            if(b && !sqlite.getOption('order')) sqlite.setOption('order', sort+' '+(reverse ? 'DESC' : 'ASC'))
            sqlite.items = await this.sort.do_sort(sort, await data.sqlite.all())

            if(!b && reverse) sqlite.items = sqlite.items.reverse() 
            await g_plugin.callEvent('datalist.tab.initItems', {tab, items: sqlite.items})
        }

        if(preset.loadPage) await preset.loadPage.call(sqlite, page, sqlite.items) // 针对自定义视图的加载页数事件
        
        let items = await Promise.all(sqlite.items.slice(start, data.pagePre + start).map(item => preset.parseItem.call(sqlite, item)))
        let hasMore = data.hasMore = items.length >= pagePre
        this.tab_loadItems(items, tab, 'appendTo', 'scroll')

        setTimeout(() => {
            if (hasMore && !isScroll(g_datalist.getContent().find('.overflow-y-auto')[0]).scrollY) { // 还可以加载
                this.page_nextPage();
            }
        }, 500);
    },

})