
g_setting.setDefault({
    multiTab: true, // 多标签
    tab_memory: true, // 标签记忆
    keepTab_All: false, // 始终显示【全部】标签
    pagePre: 20, // 每页最大加载
})

var g_datalist = {
    tab_reopen(tab){
        let tabData = this.tabs.getData(tab)
        if(tabData){
            let {title,icon,icon_color, data: {type, sort, reverse, pagePre, value, sqlite }} = tabData
            sqlite.items = []
            sqlite.setOption('order', '')
            this.tab_remove(tab)
            setTimeout(() => this.tab_new({
                sqlite, title, type, icon, icon_color, value
            }), 250)
        }
    },
    tab_new(opts) {
        if (!getConfig('multiTab')) this.tabs.clear()
        let { title, type, icon, sort, view, reverse, pagePre, icon_color, value, replaceTab, id } = opts
        let data
        if (opts.sqlite){
            let sqlite = new SQL_builder(opts.sqlite) // 保证对象兼容
    
            let find = this.tabs.data.values().find(item => item.data.sqlite?.equal(sqlite, ['order']))
            if (find && !replaceTab) return this.tabs.setActive(find.id) //  && find.data.sqlite.items.length > 0 
    
            sort ??= g_db.getConfig('sort')
            view ??= g_db.getConfig('view', 'default')
            reverse ??= g_db.getConfig('reverse', false)
            pagePre ??= getConfig('pagePre') * 1
            data = {type, sqlite, sort, view, reverse, pagePre, value}
        }else{
            data = opts.data
        }
        return this.tabs.add({
            id, icon, icon_color, view,
            title: toVal(title),
            data
        }, true)
    },

    // 返回md5在物品列表中的下表
    findItemIndex(opts) {
        if (typeof (opts) != 'object') opts = { md5: opts }
        let { md5, offset, tab, start } = opts
        let items = g_datalist.tab_getData('sqlite', tab).items
        let index = items.findIndex(item => item.md5 == md5)
        if (offset != undefined) {
            let to = index + offset
            if (start) {
                index += start
                return items.slice(Math.max(0, Math.min(index, to)), Math.max(index, to))
            }
            if (to >= 0 && to < items.length) return items[to]
        }
        return index
    },

    // 获取当前tab
    getCurrentTab(full) {
        return this.tabs.getActive()
    },

    // 获取当前tab标识
    getCurrentValue() {
        let { type, value } = this.tabs.getData().data
        return type + ',' + value
    },

    // 获取当前标签页内容
    getContent(tab) {
        tab ??= this.getCurrentTab()
        return this.tabs.getEle(tab)
    },

    // 移除标签页
    tab_remove(tab) {
        tab ??= this.getCurrentTab()
        return this.tabs.close(tab)
    },

    // 获取标签页数据
    tab_getData(k, tab) {
        tab ??= this.getCurrentTab()
        let d = (this.tabs.data.get(tab) || {}).data
        return k != undefined ? d[k] : d
    },

    // 搜索指定类型 type: [folders,tags] value: 对应id
    tab_search(type, value) {
        return this.tabs.data.map1(([k, v]) => {
            if (v.data.type == type && (isEmpty(value) || v.data.value == value)) return v.id
        })
    },

    // 获取指定标签页物品
    item_getData(cb, tab) {
        if (typeof (cb) != 'function') {
            let md5 = cb.toString()
            cb = item => item.md5 == md5
        }
        return this.tab_getData('sqlite', tab).items.find(cb)
    },

    // 更新tab.items缓存
    tab_item_update(md5, data) {
        let cnt = 0
        g_datalist.tabs.data.entries((k, v) => {
            let find = v.data?.sqlite?.items?.find(item => item.md5 == md5)
            if (find) {
                Object.assign(find, data) // 合并数据，因为items里有其他属性
                cnt++
            }
        })
        return cnt
    },

    // 设置更新列表倒计时
    updateTabItems(){
        g_cache.lastInsertTime = Date.now()
        g_pp.setTimeout('insertItem', () => this.tab_update(), 250)
    },

    // 获取标签页内容
    tab_getContent(tab) {
        return this.getContent(tab).find('.datalist-items')
    },

    // 指定tab加载items
    async tab_loadItems(items, tabs, insert = 'appendTo', source = '') {
        tabs = toArr(tabs ?? this.getCurrentTab())
        if (source != 'scroll') { // 插入操作
            let tab_all = g_datalist.tab_search('all')
            if (tab_all.length && !tabs.includes(tab_all[0])) tabs.push(tab_all[0]) // 如果【全部】标签页存在，同样插入
        }
        tabs.forEach(tab => {
            let { sqlite, view, page } = this.tab_getData(undefined, tab)
            if (!sqlite || page == -1) return

            let target = this.tab_getContent(tab)
            let table = sqlite.getOption('table')
            Promise.all(toArr(items).map(item => {
                // 防止重复插入
                // let index = sqlite.items.find(({id}) => id == item.id)
                // if(index != -1){
                //     sqlite.items.splice(index, 1)
                //     this.tab_getElement({fid: item.id}, tab).remove()
                // }
                // sqlite.items[insert == 'appendTo' ? 'push' : 'shift'](item)
                return this.item_parse({ data: item, view, table })
            })).then(arr => {
                target.find('.nomore').remove()
                let elements = $(arr.length ? arr.join('') : this.view_getVal('noMore'))
                this.tab_updateElements(elements[insert](target))
                g_datalist.view_getVal('onLoadItems', view, tab, elements)
                debug({ _: '插入物品', arr, elements, insert, target })
            })
        })
    },

    // 更新dom
    tab_updateElements(elements) {
        elements.find('.lazyload').lazyload()
        g_setting.apply('itemWidth') // 更新宽度
    },

    tab_getElements(tab) {
        return this.tab_getContent(tab).find('.datalist-item')
    },

    tab_getElement(opts, tab) {
        return getEle(opts, '.datalist-item', this.tab_getContent(tab))
    },

    // 删除元素并从列表中移除
    tab_removeElement(fid, tab) {
        this.tab_getElement({ fid }, tab).remove()
        this.tab_spliceItem({ fid, tab, remove: 1 })
    },

    // 添加元素并添加到列表中
    async tab_appendElement(fid, tab, method = 'prependTo') {
        if (this.tab_getItemIndex({ fid, tab }) != -1) return
        let data = await g_data.data_getDataByID(fid)
        data.id = fid
        this.tab_spliceItem({ fid, tab, append: data, index: 0 })
        this.tab_loadItems(data, tab, method)
    },

    tab_spliceItem({ fid, tab, remove, append, index }) {
        remove ??= 0
        let items = this.tab_getItems(tab)
        index ??= this.tab_getItemIndex({ fid, tab, items })
        let found = index != -1
        if (found) append ? items.splice(index, remove, append) : items.splice(index, remove)
        return found
    },

    tab_getItems(tab) {
        return g_datalist.tab_getData('sqlite', tab).items
    },

    tab_getItemIndex({ fid, tab, items }) {
        items ??= this.tab_getItems(tab)
        return items.findIndex(item => item.id == fid)
    },

    getTabData(cb) {
        return this.tabs.data.list.filter(cb)
    },

     tab_update(tab){
        tab ??= this.getCurrentTab()
        let sqlite = this.tab_getData('sqlite', tab)
        if(!sqlite) return

        sqlite.all().then(newst => {
            let last = sqlite.items.map(item => item.md5)
            let {added, removed} = arr_compare(last, newst.map(item => item.md5))
            if(added.length || removed.length){
                // 临时解决，
                // TODO 为什么在新文件夹内直接调用tab_refresh不会更新items?数量0应该会触发initItems事件才对啊
                sqlite.items = newst
                this.containerMethod(tab, 'onSetWidth', newst)
                this.tab_refresh(tab)
                // removed.forEach(md5 => this.tab_getElement({md5}).remove())
                // added.forEach(md5 => this.tab_getElement({md5}).remove())
            }
        })
    },

}

// view 
assignInstance(g_datalist, {
    view_parseItem(d, view) {
        view ??= this.view_getCurrentView()
        return this.views[view].parseItem(d)
    },

    getDataByViewType(view) {
        return g_datalist.getTabData(item => item.data.view == view)
    },
    views: {},
    view_register(view, opts) {
        this.views[view] = Object.assign({

        }, opts)
        opts.init && opts.init()
    },

    // 返回当前视图
    view_getCurrentView(tab) {
        return g_datalist.tab_getData('view', tab ?? this.getCurrentTab())
    },

    // 返回视图基本结构
    view_getVal(key, view, ...args) {
        view ??= this.view_getCurrentView()
        let fun = this.views?.[view]?.[key]
        if (fun) return toVal.call(undefined, fun, ...args)
    },

    async view_parseItems(view, items) {
        let opts = this.views[view]
        if (opts) {
            let html = (await Promise.all(items.map(data => this.item_parse({ data, view })))).join('')
            return $(toVal(opts.container)).find('.datalist-items').html(html)
        }
    },

    // 替换html的一些变量
    initElementHTML(html, {file, md5, id, cover}){
        return html
            .replace('{dargable}', !isEmpty(file) && !file.startsWith('http') ? ` data-file="${file}" draggable="true"` : '').
            //  TODO unpreview 由展现元素控制
            replace('{preview}', 'data-hover="item_preview" data-out="item_unpreview" data-hoverTime="300"').
            replace('{md5}', `data-md5="${md5}" data-fid="${id}"`).
            replace('{cover}', cover).
            replace('{file}', file)
    }

})

assignInstance(g_datalist, {
    init() {
        const self = this
        g_action.registerAction({
            datalist_tab_refresh: () => self.tab_reload(),
        })

        g_ui.register('datalist', {
            target: '#content',
            html: `
                <div class="position-relative w-full h-full ">
                    <div id="itemlist_tabs"  data-out="item_unpreview" data-outfor="item_preview" class="overflow-y-container"></div>
                    <div id="datalist_statusBar" class="row m-0 p-0 position-absolute align-items-center bottom-0 border-top w-full bg-auto " style="height: 43px">
                    </div>
                </div>
            `,
        }).show('datalist')

        g_style.addStyle('datalist', `
            .datalist {}
            .datalist-item {}
            .datalist-items {
                padding-bottom: var(--offset-bottom) !important;
            }
            .datalist-item.item_selected {
                
            }
            .datalist-item.item_selected img {
                border: 3px solid var(--tblr-primary) !important;
                box-sizing: border-box;
            }
            .nomore {
                margin-bottom: 100px;
            }
            .card-preview {
                position: relative;
            }
            @media screen and (max-width: 700px) {
                .btn-sm1 > small {
                    display: none;
                }
            }
        `)

        g_hotkey.register({
            'ctrl+keya': {
                title: '全选',
                content: "doAction('datalist_tab_selectAll')",
                type: 1,
            },
            'ctrl+keyw': {
                title: '关闭当前tab',
                content: "g_datalist.tabs.close(g_datalist.getCurrentTab())",
                type: 2,
            },
            'ctrl+shift+keyw': {
                title: '关闭全部tab',
                content: "g_datalist.tabs.clear()",
                type: 2,
            },
        })

        g_setting.onSetConfig({
            multiTab: () => g_datalist.tabs.clear(),
            tab_memory: b => b && toast('刷新生效!'),
            keepTab_All: () => toast('刷新生效!'),
        })

        g_setting.tabs.tabs = {
            title: '标签页',
            icon: 'box-multiple',
            elements: {
                keepTab_All: {
                    title: '总是显示【全部】标签页',
                    type: 'switch',
                    value: () => getConfig('keepTab_All'),
                },
                multiTab: {
                    title: '多标签',
                    type: 'switch',
                    value: () => getConfig('multiTab'),
                },
                tab_memory: {
                    title: '标签记忆',
                    help: '仅多标签模式下',
                    type: 'switch',
                    value: () => getConfig('tab_memory'),
                },
                pagePre: {
                    title: '每页展示',
                    value: () => getConfig('pagePre'),
                },
            }
        }
    },
})

assignInstance(g_datalist, {
    // 导入时显示的动作
    // 获取导入时的参数设置
    getImportParams() {
        let ret = {};
        [['importType', '.btn-primary'], ['importTarget', '.btn-warning'], ['importActions', '.active']].forEach(([name, classes]) => ret[name] = getEle({ name }, classes).data('value'))
        return ret
    },
    init(){
        this.importActions = [['附带目录名', 'folder-up', 'copy'], ['格式转换', 'arrows-exchange-2', 'copy'], ['视频裁剪', 'cut', 'copy'], ['字幕识别', 'text-recognition', 'copy']]

        const createGrounp = (name, items, classes, selected) => {
            if (items.length == 0) return ''

            items.at(-1)[0] != '取消' && items.push(['取消', 'x', ''])
            return `<div class="btn-group-vertical w-100" role="group">${items.map(item => {
                let [title, icon, value] = item
                let props = `data-action="activeClass,${item[3] || classes}" data-name="${item[4] || name}"`
                return `<button data-value="${value}" class="btn ${value == selected ? classes : ''}" ${props}>${!isEmpty(icon) ? `<i class="ti ti-${icon} me-2"></i>` : ''}${title}</button>`
            }).join('')}</div>`
        }
        g_fileDrop.register('datalist', {
            selector: '#content,#sidebar_right',
            layout: () => `
                <div class="w-full h-full d-flex flex-wrap align-items-center justify-content-center align-content-center" style="background-color: rgba(0, 0, 0, .4);gap: 20px">
                    <div class="card card-stacked" data-id="file">
                        <div class="card-body">
                            <h3 class="card-title"><i class="ti ti-file-import fs-2 me-2"></i>导入方式</h3>
                            ${createGrounp('importType', [['复制', 'copy', 'copy'], ['移动', 'file-arrow-right', 'move'], ['链接', 'link', 'link']], 'btn-primary', g_db.getConfig('importType', 'copy'))}
                        </div>
                    </div>
                    <div class="card card-stacked" style="max-width: 300px;" >
                        <div class="card-body">
                            <h3 class="card-title"><i class="ti ti-file-import fs-2 me-2"></i>导入位置</h3>
                            ${createGrounp('importTarget', this.tabs.data.map1(([k, v]) => {
                                let { type, value } = v.data
                                if (['tags', 'folders'].includes(type)) return [v.title, v.icon, type + ',' + value]
                            }), 'btn-warning', this.getCurrentValue())}
                        </div>
                    </div>
                </div>
            `,
            ingone: g_format.getCategory('ingone'),
            reviceFileObject: true,
            // acceptTypes: ['Files', 'text/plain', 'text/html', 'uri'], 
            onParse(d, target, targetCard) {
                let { importActions, importType, importTarget } = g_datalist.getImportParams()
                if (!isEmpty(importActions)) toast('导入至插件动作还在测试中...')

                let revice = items => {
                    // 应用到拖入的物品
                    items = items.map(item => {
                        if (typeof (item) == 'string') item = { file: item }
                        item.importType = importType
                        item.meta ??= []
                        let [type, name] = (importTarget || '').split(',')
                        if (['tags', 'folders'].includes(type)) {
                            if (!item.meta[type]) item.meta[type] = []
                            item.meta[type].push(parseInt(name))
                        }
                        return item
                    })
                    g_data.file_revice(items)
                }

                let r
                if (d.file.data.length && (r = d.file.items)) {
                    return Promise.all(r.dirs.map(dir => nodejs.files.dirFiles(dir))).then(files => {
                        r.files.push(...(flattenArray(files).filter(file => !this.ingone.includes(getExtName(file)))))
                        revice(uniqueArr(r.files))
                    })
                }
                if ((r = d.html.data)) {
                    let _$ = parseHtml(r)
                    let items = getElementsValues(_$.find('img'), el => {
                        el = $(el)
                        let url = (el.attr('src') || el.data('src') || '').replaceAll('file:///', '')
                        if (isEmpty(url)) return

                        let title = el.attr('title') || el.attr('alt')
                        if (isEmpty(title) || hasSpecialChar(title) || title.length > 200) title = nguid()

                        let ext = getExtName(url)
                        if (!g_format.getCategory('image').includes(ext)) ext = 'png'
                        return {
                            file: url,
                            ext, title, meta: { url }, // 网址来源
                        }
                    })
                    return revice(items)
                }
            }
        })
    }
})
