// 列表项目
var g_item = {
    init() {
        const self = this

        g_setting.tabs.sample = {
            title: '素材',
            icon: 'columns',
            elements: {
                showAlbumCover: {
                    title: '展示音频专辑图',
                    type: 'switch',
                    value: () => getConfig('showAlbumCover', false),
                },
            }
        }

        g_menu.registerMenu({
            name: 'datalist_item',
            selector: '.datalist-items [data-md5][data-fid]',
            dataKey: 'data-md5',
            items: [{
                text: '打开文件',
                icon: 'screen-share',
                action: 'item_open'
            },{
                text: '设置封面',
                icon: 'photo',
                action: 'item_cover'
            }, {
                text: '复原',
                icon: 'arrow-back-up',
                class: 'text-primary',
                action: 'item_untrash'
            }, {
                text: '输出数据',
                icon: 'list-details',
                action: 'item_print'
            }, {
                text: '定位目录',
                icon: 'current-location',
                action: 'item_location'
            }, {
                text: '移动到回收站',
                icon: 'trash',
                class: 'text-danger',
                action: 'item_trash'
            }/*, {
                text: '打包成压缩包',
                icon: '',
                action: ''
            }, {
                text: '发送到数据库',
                icon: 'box',
                action: 'dropdown_show,db_list,end-top'
            }*/],
            async onShow() {
                let trashed = await g_item.item_isTrashed(g_menu.key)
                getEle('item_untrash').toggleClass('hide', !trashed)
                getEle('item_trash').toggleClass('hide', trashed)
            },
            onHide() {
                g_preview.unpreview();
            }
        });

        g_hotkey.register('delete', { title: '删除', content: "doAction('item_trash')", type: 1 })
        g_dropdown.register('db_list', {
            position: 'end-top',
            offsetLeft: 5,
            autoClose: 'true',
            list() {
                let list = g_db.toDropdown('item_moveTo')
                delete list[g_db.current]
                return list
            },
        }).init()

        g_dropdown.register('menu_item_location', {
            offsetLeft: 5,
            position: 'end-top',
            async list() {
                // TODO 获取关联的文件列表
                let item = (await g_detail.getSelectedItems())[0]
                let ret = {
                    path: {
                        title: '素材库路径',
                        action: 'item_location,path',
                    },
                }
                if(!isEmpty(item.link)){
                    ret.file = {
                        title: '文件路径',
                        action: 'item_location,file',
                    }
                }
                return ret
            },
        })

        g_action.
            registerAction(['item_open', 'item_trash', 'item_untrash', 'item_cover', 'item_print', 'item_location', 'item_moveTo'], async (dom, action) => {
                let keys = g_detail.getSelectedKeys()
                for(let md5 of keys){
                    let data = await g_data.data_getFullData(md5, g_datalist.tab_getData('type') == 'trash' ? 'trash' : 'files')
                    let div = self.item_get(md5).parents('.datalist-item')
                    switch (action[0]) {
                        case 'item_moveTo':
                            let path = g_db.db_getVal(action[1], 'path')
                            g_data.data_setWithDB(md5, data, path + '/items.db').then(async ret => {
                                if (ret.changes) {
                                    // 移动文件并删除列表项目
                                    let from = await g_db.getSaveTo(md5)
                                    let to = await g_db.getSaveTo(md5, path)
                                    if (!nodejs.fs.moveSync(from, to, { overwrite: true })) {
                                        div.remove()
                                        g_data.data_remove(md5)
                                        return toast('移动成功', 'success')
                                    }
                                }
                                toast('移动失败', 'danger')
                            })
                            break;
                        case 'item_location':
                            let type = action[1]
                            if(type == undefined){
                                g_dropdown.show('menu_item_location', dom)
                                return false
                            }
                            let target
                            if(type == 'file'){
                                target = data.file
                            }else
                            if(type == 'path'){
                                target = g_db.getSaveTo(md5)
                            }
                            target && ipc_send('openFolder', target)
                            g_dropdown.hide('menu_item_location')
                            break;
                        case 'item_print':
                            let list = {...data, ...(await g_detail.getDetail(data))}
                            console.log(list) & prompt(JSON.stringify(list, null, 2), {title: '信息', rows: 25, scollable: true})
                            break;
                        case 'item_cover':
                            g_form.confirm1({
                                elements: {
                                    path: {
                                        title: '源文件',
                                        type: 'file_chooser',
                                        opts: { properties: ['openFile'], filters: [ { name: 'Images', extensions: ['jpg', 'jpeg', 'png', 'webp'] }]},
                                        value: data.cover,
                                    },
                                    cropper: {
                                        type: 'cropper',
                                        opts: {},
                                        value: data.cover
                                    },
                                },
                                callback({ vals }) {
                                    console.log(vals)
                                },
                                title: '设置封面',
                                buttons: [{
                                    text: '保存',
                                    class: 'btn-primary',
                                    onClick: () => {

                                    }
                                },{
                                    text: '选择文件',
                                    class: 'btn-primary',
                                    onClick: () => {

                                    }
                                }],
                                onBtnClick: btn => {

                                },
                            })
                            //g_ffmpeg.video_cover(md5, g_preview.video_get().currentTime)
                            break;
                        case 'item_open':
                            ipc_send('openFile', data.file)
                            break;
                        case 'item_untrash':
                            if (await g_item.item_toTrash(md5, false)) div.remove()
                            break;
                        case 'item_trash':
                            doAction('preview_unFullPreview')
                            if (await g_item.item_toTrash(md5)) div.remove()
                            break;
                    }
                }
                g_menu.hideMenu('datalist_item')
            })
            .registerAction({
                item_play: async (dom, action) => {
                    let {md5, start} = dom.dataset
                    g_preview.fullPreview({md5, opts: {start}})
                },
                item_previewVideo: (dom) => {
                    let par = getParent(dom, 'data-file')
                    let file = par.data('file')
                    if(nodejs.files.exists(file)){
                        g_preview.tryPause()
                        par.addClass('item_previewing')
                        $(`<video class="w-full" data-out="item_unpreviewVideo" src="${file}" autoplay loop ${dom.dataset.props || ''}></video>`).insertBefore(dom)
                    }
                },
                item_unpreviewVideo: (dom, a, ev) => {
                    if($('.item_previewing').removeClass('item_previewing')
                    .find('video').remove().length){
                        g_preview.tryPlay()
                    }
                },
                item_preview: async (dom, action, e) => {
                    // if(e.ctrlKey) return
                    let md5 = getParentAttr(dom, 'data-md5')
                    doAction('item_unpreview')
                    g_preview.preview(dom, await g_data.data_get(md5))
                },
                item_unselected: dom => {
                    // 从选中列表中移除
                    self.item_get(dom.dataset.md5).removeClass('item_selected')
                    self.selected_update()
                },
                item_dbclick: dom => { 
                    g_preview.fullPreview({dom, md5: dom.dataset.md5}) // 全屏预览文件
                },
                item_selected_clear: dom => self.selected_clear(),

            })
    },

    // 更新选中显示
    selected_update() {
        g_detail.showList(this.selected_keys())
    },

    // 返回选中
    selected_list() {
        return $('.item_selected')
    },

    // 返回选中md5
    selected_keys(tab) {
        return getElementsValues(g_datalist.tab_getContent(tab).find('.datalist-item.item_selected'), el => getChildAttr(el, 'data-md5'))
    },

    // 清除选中
    selected_clear() {
        this.selected_list().removeClass('item_selected')
        this.selected_update()
    },
    // 自定义获取文件类型
    item_types: {
        // initFile -> beforeCheck -> getFile
        file: {
            primary: 99,
            initFile: args => args.file = args.data.link || args.path + args.data.title,
            beforeCheck: () => {},
            getFile: args => {
                 // if(format == 'image' && ["jpg", "png", "jpeg", "gif", "bmp"].includes(ext) ){
                //     let cover =path+'/_preview_.png'
                //     if(nodejs.files.exists(cover)){
                //         args.cover = cover
                //         return
                //     }
                // }
                
                return args.file
            },
        },
        preview: { // 预览格式
            primary: 97,
            initFile: args => {
                return new Promise(async reslove => {
                    let {format, path, data} = args 
                    let file = args.file = await g_item.item_getVal('file', data)
                    let ext = getExtName(data.title)
    
                    if(format == 'image'){
                        if(!["jpg", "png", "jpeg", "gif", "bmp"].includes(ext)){
                            let preview = args.file = path +'_preview_.webp'
                            if(!nodejs.files.exists(preview)){
                                return g_ffmpeg.mgr.add(guid(), {
                                    // TODO 预览图压缩选项
                                    obj: nodejs.cli.imageMagick([
                                        `"${file}"`,
                                        '-define', 'webp:lossless=false',
                                        '-define', 'webp:method=4',
                                        '-define', 'webp:alpha-quality=80',
                                        '-quality', '80',
                                        `"${preview}"`
                                    ], err => reslove()),
                                    onStatusChange(status, cb) {
                                        if (status == TASK_RUNNING) {
                                            this.obj.start()
                                        }
                                    }
                                })
                            }
                        }
                    }
                    reslove()
                })
            },
            beforeCheck: () => {},
            getFile: args => args.file,
        },
        cover: {
            primary: 98,
            initFile: args => {
                let {format, path, data} = args
                
                // if(data.link && format == 'image'){
                //     args.cover = data.link
                //     return
                // }
                
                if(format == 'audio'){
                    if(!getConfig('showAlbumCover')){ // 开启封面选项
                        args.cover = path+'wave.png' //  波形图
                        return
                    }
                }
                args.cover = path+'cover.jpg' // 封面图
            },
            beforeCheck: () => {},
            getFile: async args => {
                let {format, cover, data} = args
                if (format == undefined || format == 'ingone') return './res/file.png' // 未知文件封面
                
                let input
                let getInput = async () => input ?? await g_item.getInputFile(data)
                if (!cover.startsWith('http')) {
                    let ok = true
                    let {exists, write} = nodejs.files
                    let {dir, name} = nodejs.path.parse(cover)
                    let ext = getExtName(data.title)
                    let coverFile = dir+'/'+name+'.jpg'
                    let waveFile = dir+'/wave.png' // !TODO wave单独一个项目
                    let cb = output => {
                        // if(ok && output != coverFile) return
                        // console.log({ok, output, coverFile, el: g_item.item_get(data.md5)})
                        ok && setTimeout(() => g_item.item_saveCover(data.md5, output+'?'+Date.now()), 500) // 刷新封面
                    }

                    // TODO 改为如果加载图片失败，再检查文件是否存在
                    // let isCloud = coverFile.startsWith('Y:')
                    let isCloud = false
                    // TODO 全局开关选择是否检测封面是否存在
                    if(!isCloud && !exists(coverFile)){ // 封面
                        if(g_format.isNativeThumbAllow(ext)){
                            ok = false
                            saveThumb(await getInput(), coverFile, cb).then(() => cb(coverFile))
                        }else
                        if(format == 'audio'){
                             // 检测是否有封面图
                            if(exists(dir+'/.nomedia')){ // 避免重复检测标识
                                ok = false
                            }else{
                                // TODO cli程序都加入列表
                                let streams = (await g_ffmpeg.video_meta(await getInput()))?.streams
                                ok = streams && streams.find(({ codec_name }) => ['mjpeg', 'png'].includes(codec_name))
                                if(!ok) write(dir+'/.nomedia', '')
                            }
                        }
                        ok && g_ffmpeg.markCover({data, input: await getInput(), output: coverFile}, cb)
                    }
                    if(format == 'audio'){
                        if(!isCloud && !exists(waveFile)){ // 波形图
                            g_ffmpeg.markCover({data, input: await getInput(), output: waveFile}, cb)
                        }else
                        if(!ok) return waveFile
                    }
                    if(!isCloud && !exists(cover)) return './res/loading.gif'
                }
                return cover
            }
        }
    },
    setItemType(name, cb){
        let inst = this.item_types[name]
        if(!inst) inst = this.item_types[name] = {}
        Object.assign(inst, cb)
    },
    // 获取item属性
    async item_getVal(type, md5, table, opts = {}) {
        let data = typeof (md5) == 'object' ? md5 : await g_data.data_getData(md5, table)
        if (!data) return {}

        let r = {}
        let path = await g_db.getSaveTo(data.md5)
        let format = getFileType(data.title)
        let params = {data, path, format, opts}

        await Promise.all(toArr(type).map(async n => { // TODO 优先度
            let inst = this.item_types[n]
            if(!inst || await inst.initFile(params) === false || await inst.beforeCheck(params) === false) return
            let file = await inst.getFile(params)
            if(!isEmpty(file)) r[n] = file
        }))
        return Array.isArray(type) ? r : Object.values(r)[0]
    },

    // 设置封面显示
    item_setCover(md5, img) {
       this.item_get(md5).find('.thumb').attr('src', img)
    },

    // 保存封面
    item_saveCover(md5, img) {
        // g_data.cache.update(md5, {cover: img}) // 更新缓存图片
        g_plugin.callEvent('image.saveCover', { md5, img }).then(({ md5, img }) => {
            this.item_setCover(md5, img)
        })
    },

    // 返回元素
    item_get(md5) {
        return $(`.datalist-item > [data-md5="${md5}"]`)
    },

    // 刷新dom
     item_update(md5) {
        let data = {id: 1, md5} // TODO 不用id判断
        this.item_get(data.md5).each(async (i, el) => {
            let tab = getParentData(el, 'container')
            let inst =  g_datalist.getContainer(tab)
            await inst.opts.initItemData(data)
    
            let dom = $(await inst.opts.parseItem.call(inst, {item: data, type: inst.opts.type}))
            $(el).replaceWith(dom)
            setTimeout(() => dom.find('.lazyload').lazyload() & g_datalist.setItemWidth(g_db.getConfig('itemWidth'), dom.parent('.datalist-item')), 200)
            inst.opts.onInsertedItems({list: [data], elements: dom})
        })
    },

    item_updateSize(md5, width, height) {
        let el = this.item_get(md5)
        if(el.length && el.data('width')){
            let maxHeight = g_db.getConfig('itemWidth', 200) * 1
            let newWidth = maxHeight * width / height;
            el.data({width: newWidth, height: maxHeight}).css('width', newWidth+'px')
            .find('.thumb').css({width: newWidth+'px', height: maxHeight+'px'})
        }
    },

    async getInputFile(data){
        return await (await g_plugin.callEvent('getInputFile', {
            data,
            cb: () => g_item.item_getVal('file', data)
        })).cb() // 触发事件，因为这里只是读取文件，而不是保存，允许插件选择更快的本地文件（比挂载盘快)
    },

    async getCoverSize(data, {maxHeight, maxWidth, def}){
        def ??= {width: 200, height: 200}
        let {width, height} = (await g_detail.getDetail(data, 'media')).media || def
        let r = width / height
        if(maxHeight){
            width = maxHeight * r
            height = maxHeight
        }else{
            height = maxWidth * r
            width = maxWidth
        }
        return {width, height}
    },

    // folders tag等标签的生成
    buildMetaBadges(data){
        return Object.entries(data).map(([k, v]) => {
            switch(k){
                case 'tags':
                case 'folders':
                    return v.map(folder => (k == 'tags' ? g_tags : g_folders).buildBadge({folder})).join('')
            }
        }).join('')
    }
}

function saveThumb(input, saveTo, size = {width: 225, height: 1}){
    return new Promise(reslove => {
        g_tasker.worker.send(['createThumbnailFromPath', input, size, 'toPNG'], imgData => {
            // TODO 图片转webp
            nodejs.files.write(saveTo, imgData.data) // 原生缩略图
            reslove(imgData)
        })
    })
   
}

g_item.init()