assignInstance(g_data, {

    init() {
        g_plugin.registerEvent('onPluginsLoaded', () => {
            g_db.db_switch(_GET.db ?? getConfig('db')) // 切换url指定的db
        })

        g_client.registerRevice({
            data_import({ items, id }) {
                items = items.map(item => {
                    if(!item.meta) item.meta = {}
                    if(!isEmpty(item.website)) item.meta.url = item.website
                    if(item.tags) item.meta.tags = item.tags
                    if(item.folders) item.meta.folders = item.folders
                    return item
                })
                g_data.file_revice(items).then(({ added }) => {
                    g_client.send('importResult', { id, added: added.length })
                })
            },
        });

        this.parseMgr = new Queue('parse', {
            max: 10,
            interval: 200,
            title: '素材预分析',
            autoRunning: false,
            autoClear: true,
            onAdd(){
                if(!this.inst.isRunning()){
                    this.inst.setRunning(true, true)
                    g_ui.show('importProgress')
                }
            },
            onEnded: () => false,
            onUpdate: ({ all, runnings, errors, completed, waittings }) => {
                let free = this.parseMgr.free = runnings.length == 0 && waittings.length == 0
                Progress.setMultiProgress(this.parseProgress, free ? -1 : all, completed.length, errors.length)
            },
        })

        this.importMgr = new Queue('import', {
            max: 10,
            interval: 200,
            title: '素材导入',
            autoClear: true,
            autoRunning: false,
            onAdd(){
                if(!this.inst.isRunning()){
                    this.inst.setRunning(true, true)
                    g_ui.show('importProgress')
                }
            },
            onEnded: () => false,
            onUpdate: ({ all, runnings, errors, waittings, completed }) => {
                if(this.parseMgr.free){
                    let free = this.importMgr.frimportProgressee = runnings.length == 0 && waittings.length == 0
                    Progress.setMultiProgress(this.importProgress, free ? -1 : all, completed.length, errors.length)
                }
            },
        })

        // 获取源文件执行操作时优先获取导入前的文件位置（nas）
        g_plugin.registerEvent('getInputFile', opts => {
            let cache = g_data.file_cache[opts.data.md5]
            if (cache && nodejs.files.exists(cache.file)) {
                let { birthtimeMs, size } = nodejs.files.stat(cache.file)
                if (size == cache.size && birthtimeMs == cache.birthtime) {
                    opts.cb = () => cache.file
                }
            }
        })

        // 读取媒体信息后调整插入素材的大小
        g_plugin.registerEvent('loadMetadata', ({data, json}) => {
            g_item.item_updateSize(data.md5, json.width, json.height)
        })

            g_plugin.registerEvent('ui_init', ({name}) => {
                if(name == 'datalistToolbars' && !getEle('ui,importProgress').length){
                    $(`
                    <button class="ms-2 btn btn-rounded " onclick="g_sidebar.toggle('bottom', g_ui.toggle('importProgress'))" data-target_ui="importProgress" title="导入进度">
                        <i class="ti ti-layout-list"></i>
                    </button>`).appendTo('#datalist_toolbar .me-auto')
        
                    g_ui.register('importProgress', {
                        group: 'sidebar_bottom',
                        target: '#sidebar_bottom',
                        props: 'data-max=-1',
                        html: `<h4 class="text-center">空闲中...</h4>`,
                        onShow: () => g_sidebar.show('bottom') & setCssVar('--offset-bottom', '30px'),
                        // onHide: () => g_sizeable.restore('sidebarBottom'),
                        onAppend: () => {
                            ['importProgress', 'parseProgress'].forEach((name, i) => {
                                let prefix = i == 0 ? '【导入】' : '【解析】'
                                let text = Progress.buildMultiProgress({
                                    id: name,
                                    list: {
                                        waitting: {
                                            title: prefix + '等待中...',
                                            classes: 'bg-info',
                                        },
                                        completed: {
                                            title: prefix + '已完成...',
                                            classes: 'bg-success',
                                        },
                                        error: {
                                            title: prefix + '错误(包含已存在)...',
                                            classes: 'bg-danger',
                                        },
                                    },
                                    attr: 'style="height: 30px"',
                                })
                                g_data[name] = insertEl({ tag: 'div', text, props: { id: 'mprogress_' + name, class: 'col-auto', class: 'hide1' } }, { target: g_ui.getElement('importProgress'), method: 'prependTo' })
                            })
                        }
                    });
                }
            })
    },

    // 插入数据
    data_add(data) {
        return g_data.data_set2({
            data,
            key: 'md5',
            value: data.md5,
            table: 'files',
        })
    },

    // 解析文件属性
    // TODO 只获取MD5,等要插入时在获取相关文件信息
    file_cache: {},
    file_revice(files, resloveCb) {
        console.log(files)
        return new Promise(reslove => {
            let r = {}, items = [], cnt = 0
            const next = (cb, status) => {
                cb(status)
                ++cnt >= items.length && reslove(resloveCb ? resloveCb(r) : g_data.data_import(r))
            }
            g_plugin.callEvent('file_revice', {files}).then(({files}) => {
                files.forEach(d => {
                    let isObj = typeof (d) == 'object'
                    let file = isObj ? d.file : d // 格式化file:///
    
                    if(file.startsWith('file:')) file = nodejs.url.fileURLToPath(file)
                    if(!isObj){
                        if(isEmpty(file)) return
                        d = {}
                    }
                    Object.assign(d, {file})
                    
                    if(!isEmpty(d.title)) d.title = safeFileName(d.title).substring(0, 200)
                    const getSaveTo = ext => `${nodejs.dir}/cache/${guid()}/${safeFileName(d.title)}.${ext}`
                    const addToTask = () => {
                        let file = d.file
                        if(items.find(item => item.file == file)) return // 过滤重复

                        items.push(d)
                        this.parseMgr.add(file, {
                            data: d,
                            onStatusChange(status, cb, file) {
                                if (status != TASK_RUNNING) return
                                try {
                                    // BUG 导入视频后要更改数据的file位置
                                    let { birthtimeMs: birthtime, isFile, size } = nodejs.files.stat(file)
                                    const done = md5 => {
                                        // 缓存文件md5信息供其他插件使用
                                        g_data.file_cache[md5] = r[md5] = Object.assign(this.data, { file, birthtime, size })
                                        next(cb, TASK_COMPLETED)
                                    }
                                    let maxsize = g_db.getConfig('randomMD5', -1) * 1
                                    if(maxsize > 0 && size > maxsize){ // 大于指定大小取文件路径MD5
                                        done(nodejs.files.getMd5(d.importType == 'link' ? file : guid()))
                                    }else{
                                        g_tasker.worker.send(['getMD5Hash', file], done)
                                    }
    
                                } catch (err) {
                                    //  EIO: i/o error, read？读取文件失败！？
                                    console.error(err + '->' + file)
                                    next(cb, TASK_ERROR)
                                }
                            }
                        })
                    }
    
                    if (file.startsWith('data:image/')) { // base64
                        let saveTo = getSaveTo(cutString(file, '/', ';'))
                        let err = nodejs.files.write(saveTo, Buffer.from(file.replace(/^data:image\/\w+;base64,/, ""), 'base64'))
                        if (err) return console.error(err)
    
                        d.file = saveTo
                        d.importType = 'move'
                        addToTask()
                    }else
                    if(file.startsWith('http')){
                        let saveTo = getSaveTo(d.ext || getExtName(file))
                        downloadFile({
                            url: file, saveTo,
                            complete: (err) => {
                                d.file = saveTo
                                d.importType = 'move'
                                addToTask()
                            }
                        })
                    }else{
                        addToTask()
                    }
                })

            })
        })
    },

    data_import(data) {
        for (let md5 in data) {
            let item = data[md5]
            data[md5] = Object.assign({
                md5,
                link: '',
                size: 0,
                meta: {},
                birthtime: 0,
            }, item, {
                date: new Date().getTime(),
                title: getFileName(item.file, true)
            })
        }
        return this.data_insert(data)
    },

    // 添加数据
    async data_insert(data) {
        let md5s = Object.keys(data)
        let max = md5s.length
        let ret = { added: [], exists: [], error: [] }
        return new Promise(reslove => {
            for (let md5 in data) {
                let item = data[md5]
                const onStatusChange = async (status, setStatus) => {
                    if (status != TASK_RUNNING) return

                    const cb = i => {
                        setStatus(i)
                        if (--max <= 0) { // 全部完成
                            g_plugin.callEvent('data_importedFile', ret)
                            md5s.forEach(md5 => delete g_data.file_cache[md5])
                            reslove(ret)
                        }
                    }

                    let old = await g_data.data_get(md5)
                    if (old) { // 已存在
                        ret.exists.push(item)
                        return cb(TASK_ERROR)
                    }

                    const insert = () => {
                        const finish = () => {
                            g_data.data_add(item).then(({ lastInsertRowid }) => {
                                ret.added.push(item)
                                item.id = lastInsertRowid; // 附加id
                                //  记录最后插入时间，当打开tab时检查是否旧于最后更新时间，是的话检查是否有新插入，有的话实现更新
                                g_datalist.updateTabItems()
                                // g_item.item_getVal('cover', item)
                                cb(TASK_COMPLETED)
                            })
                        }

                        // 获取媒体的信息
                        // todo 写在media里会不会比较好？
                        let { file } = item
                        if (['audio', 'video'].includes(g_format.getFileType(file))) {
                            g_ffmpeg.video_meta(file).then(meta => {
                                if (meta?.streams?.length) {
                                    let { coded_width, coded_height, avg_frame_rate } = meta.streams[0]
                                    Object.assign(item.meta, {
                                        duration: meta.format.duration * 1,
                                        width: coded_width,
                                        height: coded_height,
                                        frame: avg_frame_rate
                                    })
                                }
                                finish()
                            })
                        } else {
                            finish()
                        }
                    }

                    let file = item.file
                    let type = item.importType ?? g_db.getConfig('importType', 'copy')
                    if (type == 'link') {
                        item.link = file
                        return insert()
                    }

                    let saveTo = await g_item.item_getVal('file', item)
                    let id = 'import_' + md5
                    item.file = saveTo // 更新源文件位置

                    // 是不是放到worker里会好一点？
                    g_tasker.task_add(id, {
                        id, saveTo, file, type
                    }, {
                        onComplete: ({ err }) => {
                            if (err) {
                                ret.error.push(item)
                                return cb(TASK_ERROR)
                            }
                            insert()
                        }
                    })
                }
                this.importMgr.add(md5, { item, onStatusChange })
            }
        })
    },
})