var g_category = {
    list: {
        default: {
            title: '常用',
            list: () => g_rule.getSidebars(),
        }
    },
       
    init() {
        const self = this
        this.sidebar_init()

        g_category.
        registerAction('default', (dom, action, e) => {
            let folder = action[2]
            self.menu_folder = folder
            g_dropdown.show('actions_default', dom)
        })

        g_dropdown.register('actions_default', {
            position: 'top-end',
            offsetLeft: 5,
            onShow: function(e) {
                this.opts.list = {
                    edit: {
                        title: '编辑',
                        icon: 'pencil',
                        action: 'filter_edit',
                    },
                    delete: {
                        title: '删除',
                        icon: 'trash',
                        class: 'text-danger',
                        action: 'filter_delete',
                    }
                }
            },
        })

        g_action.
        registerAction(['filter_edit', 'filter_delete'], (dom, action) => {
            let name = g_dropdown.target.parents('[data-name]').data('name')
            switch (action[1]) {
                case 'filter_edit':
                    return;
                case 'filter_delete':
                    return;
            }
        }).
        registerAction({
            category_opts: (dom, action) => self.actions[action[1]] && self.actions[action[1]](dom, action),
            category: (dom, action) => g_datalist.tab_new(g_rule.getTabParams(action[1]))
        })

        g_style.addStyle('category', `
            #group_list .accordion-button {
                padding: 5px;
            }
            #group_list .list-group-item {
                padding: 5px;
                border: hidden;
                background: unset;
            }
            #group_list .accordion-body {
                padding: 0;
            }
            #group_list .accordion-item {
                border: hidden;
                margin-bottom: 5px;
                max-height: 300px;
                overflow: auto;
            }
            #group_list .accordion-item::-webkit-scrollbar {
                width: 13px !important;
            }
            #icons_left i:not(:last-child) {
                margin-right: 5px;
            }
        `)
        g_plugin.registerEvent('db_connected', ({db}) => this.update())
    },


    set(name, opts, update = false) {
        this.list[name] = opts
        this.update()
    },

    remove(name) {
        delete this.list[name]
    },

    sidebar_init() {

        g_sidebar.register('left', {
            html: `
                <div class="h-full">
                    <div id="icons_left" class="d-flex m-2">
                        <i class="ti ti-menu-2 fs-2" data-action="menu" title="菜单"></i>
                        <i class="ti ti-keyboard fs-2" data-action="modal_hotkey" title="快捷键"></i>
                        <i class="ti ti-plug fs-2" data-action="modal_plugin" title="插件"></i>
                        <i class="ti ti-settings fs-2" data-action="settings,general" title="设置"></i>
                    </div>
                    <div class="overflow-y hideScroll" style="height: calc(100% - 40px - 40px);">
                        <div id="group_list" class="p-2 pt-0 overflow-y-container"></div>
                    </div>
                    <div id="icons_bottom" class="d-flex m-2" height="40">
                      
                    </div>
                </div>
            `,
            onShow: e => setCssVar('--offset-left', (g_sizeable.data?.sidebarLeft?.width || 200) + 'px'),
            onHide: e => setCssVar('--offset-left', '0px')
        })

        g_sizeable.register('sidebarLeft', {
            selector: '#sidebar_left',
            memory: true,
            allow: ['right'],
            width_min: 200,
            width_max: 400,
            style: {backgroundColor: 'unset'},
            change: (t, i) => {
                if (t == 'width') {
                    setCssVar('--offset-left', (getConfig('sidebar_left') ? i : 0) + 'px')
                    return { resize: false }
                }
            }
        })
    },

    // 注册更多选项action
    actions: {},
    registerAction(action, callback) {
        this.actions[action] = callback
    },

    item_html(name, group, item, action = '') {
        let {icon, icon_color, title, editAble, menu} = item
        return `
            <div class="row align-items-center m-1">
                <a draggable="true" class="list-group-item list-group-item-action col text-nowrap" data-action="${action}" data-list="${group}" data-name="${name}">
                    ${!isEmpty(icon) ? `<i class="me-2 ti ti-${icon}" style="${!isEmpty(icon_color) ? `color: ${icon_color};` : ''}"></i>` : ''}
                    ${title}
                </a>
                ${editAble !== false ? `
                    <div class="col-auto" >
                        <a data-action="${menu || `category_opts,${group},${name}`}">
                            <i class="ti ti-dots"></i>
                        </a>
                    </div>
                ` : ''}
            </div>
        `
    },

    update(){
        let self = this
        let datas = []
        for (let [group, data] of Object.entries(this.list)) {
            let list = toVal(data.list)
            for (let [name, item] of Object.entries(list)) {
                datas.push({
                    group,
                    html: this.item_html(name, group, item, item.action || data.action || ''),
                    primary: item.primary || 0
                })
            }
        }

        $('#sidebar_left').addClass('border-end').find('#group_list')
        .html(g_tabler.build_accordion({
            // TODO 新的build_accordion方法...
            datas,
            id: 'group',
            default: true,
            parent: false,
            header: '{title}',
            collapse_start: `<div class="list-group list-group-flush">`,
            collapse_end: `</div>`,
        }))
    },
}

g_category.init()