
let queue = new Queue('test_queue', {
    max: 10,
    interval: 500,
    autoRunning: false,
    onUpdate({ waittings, runnings, errors, allow }) {
        $('#queue_status').html(`<span class="text-warning">【${waittings.length}】</span>等待中 <span class="text-success">【${runnings.length}】</span>运行中 <span class="text-info">【${allow}】</span>已添加 <span class="text-danger">【${errors.length}】</span>错误`)
    },
    onStatusChange(id, status) {
        if(status == TASK_COMPLETED){
            let div = $('#queue_log').append(`<p>【任务事件】: ${id} -> 已完成</p>`)[0]
            div.scrollTop = div.scrollHeight
        }
    }
})


g_action.registerAction({
    queue_switch: () => queue.setRunning(),
})

g_form.confirm1({
    id: 'test_queue',
    title: '队列测试',
    elements: {
        running: {
            title: '开关',
            type: 'switch',
            props: 'data-change="queue_switch"'
        }
    }
}, {
    btn_close: false,
    width: '95%',
    html: `
    <div class="row w-full">
        <div class="modal_form col-4"></div>
        <div class="col">
            <h4 id="queue_status"></h4>
            <pre>
                <code class="d-flex flex-wrap overflow-y-scroll" style="max-height:300px" id="queue_log"></code>
            </pre>
        </div>
    </div>
    `,
    buttons: [{
        text: '清空',
        onClick: () => {
            $('#queue_log').html('')
        }
    }]
})


for (let i = 0; i < 1000; i++) queue.add('task_' + i, {
    text: 'i am task ' + i,
    onStatusChange(status, cb) {
        if (status == TASK_RUNNING) {
            setTimeout(() => {
                // 自定义执行代码
                cb(TASK_COMPLETED), randNum(500, 3000)
            })
        }
    }
})
