g_form.confirm1({
    id: 'test_form',
    elements: {
        test_textarea: {
            title: '文本区域',
            type: 'textarea',
            help: '这里设置必须输入h开头',
            required: true,
            check: val => val.startsWith('h'),
            value: 'hello world!',
        },
        test_text: {
            title: '文本输入',
            type: 'text',
            value: 'hello world!',
        },
        test_checkbox: {
            title: '复选框',
            type: 'checkbox',
            value: () => false,
        },
        test_radio: {
            title: '单选框',
            type: 'radio',
            value: () => false,
        },
        test_switch: {
            title: '开关',
            type: 'switch',
            value: true,
        },
        test_range: {
            title: '滑块条',
            type: 'range',
            opts: { min: 0, max: 100, step: 1 },
            value: 20,
        },
        test_colorInputs: {
            title: '颜色选择',
            type: 'colorInputs',
            list: ['#d63939', '#206bc4'],
        },
        test_datalist: {
            title: '搜索选择',
            type: 'datalist',
            list: ['a', 'b', 'c'],
            value: 'b'
        },
        test_select: {
            title: '多选',
            type: 'select',
            list: ['a', 'b', 'c'],
            value: 'b'
        },
        // test_date: {
        //     title: '日期',
        //     type: 'date',
        //     value: ''
        // },
        test_file_chooser: {
            title: '文件选择',
            type: 'file_chooser',
            value: '',
            opts: {
                title: '选择图片',
                properties: ['openFile'],
                filters: [
                    { name: 'Images', extensions: ['jpg', 'jpeg', 'png', 'gif'] },
                ],
            }
        },
        test_html: {
            type: 'html',
            value: '自定义html'
        },
        test_image: {
            title: '图片上传',
            type: 'image',
            value: ''
        },
        test_file: {
            title: '文件选择',
            type: 'file',
        },
    }
}, {
    btn_close: false,
    buttons: [{
        text: '检查输入',
        onClick: () => {
            console.log(g_form.method('test_form', 'getVals', true))
        }
    },{
        text: '获取所有值',
        class: 'btn-primary',
        onClick: () => {
            console.table(g_form.method('test_form', 'getVals', false))
        }
    },{
        text: '获取改变值',
        class: 'btn-info',
        onClick: () => {
            console.table(g_form.method('test_form', 'getChanges', ))
        }
    },{
        text: '设置多个值',
        class: 'btn-warning',
        onClick: () => {
            let i = 0
            let form = g_form.get('test_form')
            form.entriesElement((name, item) => {
                if(['text', 'textarea'].includes(item.type)){
                    form.setElementVal(name, '【'+(++i)+'】hello!')
                }
            })
        }
    }]
})

