/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.InfoFile;
import de.quippy.sidplay.libsidplay.components.sidtune.Mus;
import de.quippy.sidplay.libsidplay.components.sidtune.P00;
import de.quippy.sidplay.libsidplay.components.sidtune.PP20;
import de.quippy.sidplay.libsidplay.components.sidtune.PSid;
import de.quippy.sidplay.libsidplay.components.sidtune.Prg;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.sidtune.SmartPtr_sidtt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class SidTune {
    private static final Logger TUNE = Logger.getLogger(SidTune.class.getName());
    public static final int SIDTUNE_MAX_SONGS = 256;
    public static final int SIDTUNE_MAX_CREDIT_STRINGS = 10;
    public static final int SIDTUNE_MAX_CREDIT_STRLEN = 81;
    public static final int SIDTUNE_MAX_MEMORY = 65536;
    public static final int SIDTUNE_MAX_FILELEN = 65662;
    public static final int SIDTUNE_SPEED_VBI = 0;
    public static final int SIDTUNE_SPEED_CIA_1A = 60;
    public static final int SIDTUNE_CLOCK_UNKNOWN = 0;
    public static final int SIDTUNE_CLOCK_PAL = 1;
    public static final int SIDTUNE_CLOCK_NTSC = 2;
    public static final int SIDTUNE_CLOCK_ANY = 3;
    public static final int SIDTUNE_SIDMODEL_UNKNOWN = 0;
    public static final int SIDTUNE_SIDMODEL_6581 = 1;
    public static final int SIDTUNE_SIDMODEL_8580 = 2;
    public static final int SIDTUNE_SIDMODEL_ANY = 3;
    public static final int SIDTUNE_COMPATIBILITY_C64 = 0;
    public static final int SIDTUNE_COMPATIBILITY_PSID = 1;
    public static final int SIDTUNE_COMPATIBILITY_R64 = 2;
    public static final int SIDTUNE_COMPATIBILITY_BASIC = 3;
    protected SidTuneInfo info = new SidTuneInfo();
    protected boolean status;
    protected short[] songSpeed = new short[256];
    protected short[] clockSpeed = new short[256];
    protected short[] songLength = new short[256];
    protected String[] infoString = new String[10];
    protected int fileOffset;
    protected int musDataLen;
    protected Buffer_sidtt cache = new Buffer_sidtt();
    private static final String[] defaultFileNameExt = new String[]{".sid", ".dat", ".inf", "", ".DAT", ".SID", ".INF", ".c64", ".prg", ".p00", ".C64", ".PRG", ".P00", ".info", ".INFO", ".data", ".DATA", ".str", ".STR", ".mus", ".MUS"};
    protected static String[] fileNameExtensions = defaultFileNameExt;
    private PSid psid = new PSid(this);
    Mus mus = new Mus(this);
    InfoFile inf = new InfoFile(this);
    Prg prg = new Prg(this);
    P00 p00 = new P00(this);
    protected static final String txt_songNumberExceed = "SIDTUNE WARNING: Selected song number was too high";
    protected static final String txt_empty = "SIDTUNE ERROR: No data to load";
    protected static final String txt_unrecognizedFormat = "SIDTUNE ERROR: Could not determine file format";
    protected static final String txt_noDataFile = "SIDTUNE ERROR: Did not find the corresponding data file";
    protected static final String txt_notEnoughMemory = "SIDTUNE ERROR: Not enough free memory";
    protected static final String txt_cantLoadFile = "SIDTUNE ERROR: Could not load input file";
    protected static final String txt_cantOpenFile = "SIDTUNE ERROR: Could not open file for binary input";
    protected static final String txt_fileTooLong = "SIDTUNE ERROR: Input data too long";
    protected static final String txt_dataTooLong = "SIDTUNE ERROR: Size of music data exceeds C64 memory";
    protected static final String txt_cantCreateFile = "SIDTUNE ERROR: Could not create output file";
    protected static final String txt_fileIoError = "SIDTUNE ERROR: File I/O error";
    protected static final String txt_VBI = "VBI";
    protected static final String txt_CIA = "CIA 1 Timer A";
    protected static final String txt_noErrors = "No errors";
    protected static final String txt_na = "N/A";
    protected static final String txt_badAddr = "SIDTUNE ERROR: Bad address data";
    protected static final String txt_badReloc = "SIDTUNE ERROR: Bad reloc data";
    protected static final String txt_corrupt = "SIDTUNE ERROR: File is incomplete or corrupt";
    private static final short[] _sidtune_CHRtab;

    static {
        short[] sArray = new short[256];
        sArray[1] = 1;
        sArray[2] = 1;
        sArray[3] = 1;
        sArray[4] = 1;
        sArray[5] = 1;
        sArray[6] = 1;
        sArray[7] = 1;
        sArray[8] = 1;
        sArray[9] = 1;
        sArray[10] = 1;
        sArray[11] = 1;
        sArray[12] = 1;
        sArray[13] = 13;
        sArray[14] = 1;
        sArray[15] = 1;
        sArray[16] = 1;
        sArray[17] = 1;
        sArray[18] = 1;
        sArray[19] = 1;
        sArray[20] = 1;
        sArray[21] = 1;
        sArray[22] = 1;
        sArray[23] = 1;
        sArray[24] = 1;
        sArray[25] = 1;
        sArray[26] = 1;
        sArray[27] = 1;
        sArray[28] = 1;
        sArray[29] = 1;
        sArray[30] = 1;
        sArray[31] = 1;
        sArray[32] = 32;
        sArray[33] = 33;
        sArray[34] = 1;
        sArray[35] = 35;
        sArray[36] = 36;
        sArray[37] = 37;
        sArray[38] = 38;
        sArray[39] = 39;
        sArray[40] = 40;
        sArray[41] = 41;
        sArray[42] = 42;
        sArray[43] = 43;
        sArray[44] = 44;
        sArray[45] = 45;
        sArray[46] = 46;
        sArray[47] = 47;
        sArray[48] = 48;
        sArray[49] = 49;
        sArray[50] = 50;
        sArray[51] = 51;
        sArray[52] = 52;
        sArray[53] = 53;
        sArray[54] = 54;
        sArray[55] = 55;
        sArray[56] = 56;
        sArray[57] = 57;
        sArray[58] = 58;
        sArray[59] = 59;
        sArray[60] = 60;
        sArray[61] = 61;
        sArray[62] = 62;
        sArray[63] = 63;
        sArray[64] = 64;
        sArray[65] = 65;
        sArray[66] = 66;
        sArray[67] = 67;
        sArray[68] = 68;
        sArray[69] = 69;
        sArray[70] = 70;
        sArray[71] = 71;
        sArray[72] = 72;
        sArray[73] = 73;
        sArray[74] = 74;
        sArray[75] = 75;
        sArray[76] = 76;
        sArray[77] = 77;
        sArray[78] = 78;
        sArray[79] = 79;
        sArray[80] = 80;
        sArray[81] = 81;
        sArray[82] = 82;
        sArray[83] = 83;
        sArray[84] = 84;
        sArray[85] = 85;
        sArray[86] = 86;
        sArray[87] = 87;
        sArray[88] = 88;
        sArray[89] = 89;
        sArray[90] = 90;
        sArray[91] = 91;
        sArray[92] = 36;
        sArray[93] = 93;
        sArray[94] = 32;
        sArray[95] = 32;
        sArray[96] = 45;
        sArray[97] = 35;
        sArray[98] = 124;
        sArray[99] = 45;
        sArray[100] = 45;
        sArray[101] = 45;
        sArray[102] = 45;
        sArray[103] = 124;
        sArray[104] = 124;
        sArray[105] = 92;
        sArray[106] = 92;
        sArray[107] = 47;
        sArray[108] = 92;
        sArray[109] = 92;
        sArray[110] = 47;
        sArray[111] = 47;
        sArray[112] = 92;
        sArray[113] = 35;
        sArray[114] = 95;
        sArray[115] = 35;
        sArray[116] = 124;
        sArray[117] = 47;
        sArray[118] = 88;
        sArray[119] = 79;
        sArray[120] = 35;
        sArray[121] = 124;
        sArray[122] = 35;
        sArray[123] = 43;
        sArray[124] = 124;
        sArray[125] = 124;
        sArray[126] = 38;
        sArray[127] = 92;
        sArray[128] = 1;
        sArray[129] = 1;
        sArray[130] = 1;
        sArray[131] = 1;
        sArray[132] = 1;
        sArray[133] = 1;
        sArray[134] = 1;
        sArray[135] = 1;
        sArray[136] = 1;
        sArray[137] = 1;
        sArray[138] = 1;
        sArray[139] = 1;
        sArray[140] = 1;
        sArray[141] = 1;
        sArray[142] = 1;
        sArray[143] = 1;
        sArray[144] = 1;
        sArray[145] = 1;
        sArray[146] = 1;
        sArray[147] = 1;
        sArray[148] = 1;
        sArray[149] = 1;
        sArray[150] = 1;
        sArray[151] = 1;
        sArray[152] = 1;
        sArray[153] = 1;
        sArray[154] = 1;
        sArray[155] = 1;
        sArray[156] = 1;
        sArray[157] = 1;
        sArray[158] = 1;
        sArray[159] = 1;
        sArray[160] = 32;
        sArray[161] = 124;
        sArray[162] = 35;
        sArray[163] = 45;
        sArray[164] = 45;
        sArray[165] = 124;
        sArray[166] = 35;
        sArray[167] = 124;
        sArray[168] = 35;
        sArray[169] = 47;
        sArray[170] = 124;
        sArray[171] = 124;
        sArray[172] = 47;
        sArray[173] = 92;
        sArray[174] = 92;
        sArray[175] = 45;
        sArray[176] = 47;
        sArray[177] = 45;
        sArray[178] = 45;
        sArray[179] = 124;
        sArray[180] = 124;
        sArray[181] = 124;
        sArray[182] = 124;
        sArray[183] = 45;
        sArray[184] = 45;
        sArray[185] = 45;
        sArray[186] = 47;
        sArray[187] = 92;
        sArray[188] = 92;
        sArray[189] = 47;
        sArray[190] = 47;
        sArray[191] = 35;
        sArray[192] = 45;
        sArray[193] = 35;
        sArray[194] = 124;
        sArray[195] = 45;
        sArray[196] = 45;
        sArray[197] = 45;
        sArray[198] = 45;
        sArray[199] = 124;
        sArray[200] = 124;
        sArray[201] = 92;
        sArray[202] = 92;
        sArray[203] = 47;
        sArray[204] = 92;
        sArray[205] = 92;
        sArray[206] = 47;
        sArray[207] = 47;
        sArray[208] = 92;
        sArray[209] = 35;
        sArray[210] = 95;
        sArray[211] = 35;
        sArray[212] = 124;
        sArray[213] = 47;
        sArray[214] = 88;
        sArray[215] = 79;
        sArray[216] = 35;
        sArray[217] = 124;
        sArray[218] = 35;
        sArray[219] = 43;
        sArray[220] = 124;
        sArray[221] = 124;
        sArray[222] = 38;
        sArray[223] = 92;
        sArray[224] = 32;
        sArray[225] = 124;
        sArray[226] = 35;
        sArray[227] = 45;
        sArray[228] = 45;
        sArray[229] = 124;
        sArray[230] = 35;
        sArray[231] = 124;
        sArray[232] = 35;
        sArray[233] = 47;
        sArray[234] = 124;
        sArray[235] = 124;
        sArray[236] = 47;
        sArray[237] = 92;
        sArray[238] = 92;
        sArray[239] = 45;
        sArray[240] = 47;
        sArray[241] = 45;
        sArray[242] = 45;
        sArray[243] = 124;
        sArray[244] = 124;
        sArray[245] = 124;
        sArray[246] = 124;
        sArray[247] = 45;
        sArray[248] = 45;
        sArray[249] = 45;
        sArray[250] = 47;
        sArray[251] = 92;
        sArray[252] = 92;
        sArray[253] = 47;
        sArray[254] = 47;
        sArray[255] = 35;
        _sidtune_CHRtab = sArray;
    }

    public SidTune(String string, String[] stringArray) {
        this.init();
        SidTune.setFileNameExtensions(stringArray);
        if (string != null && string.equals("-")) {
            this.getFromStdIn();
        } else if (string != null) {
            this.getFromFiles(string);
        }
    }

    public SidTune(short[] sArray, int n) {
        this.init();
        this.getFromBuffer(sArray, n);
    }

    public static void setFileNameExtensions(String[] stringArray) {
        fileNameExtensions = stringArray != null ? stringArray : defaultFileNameExt;
    }

    public boolean load(String string) {
        this.cleanup();
        this.init();
        if (string != null && string.equals("-")) {
            this.getFromStdIn();
        } else if (string != null) {
            this.getFromFiles(string);
        }
        return this.status;
    }

    public boolean read(short[] sArray, int n) {
        this.cleanup();
        this.init();
        this.getFromBuffer(sArray, n);
        return this.status;
    }

    public final SidTuneInfo opGet(int n) {
        this.selectSong(n);
        return this.info;
    }

    public int selectSong(int n) {
        if (!this.status) {
            return 0;
        }
        this.info.statusString = txt_noErrors;
        int n2 = n;
        if (n == 0) {
            n2 = this.info.startSong;
        }
        if (n > this.info.songs || n > 256) {
            n2 = this.info.startSong;
            this.info.statusString = txt_songNumberExceed;
        }
        this.info.currentSong = n2;
        this.info.songSpeed = this.info.compatibility == 2 ? (short)60 : this.songSpeed[n2 - 1];
        this.info.clockSpeed = this.clockSpeed[n2 - 1];
        this.info.speedString = this.info.songSpeed == 0 ? txt_VBI : txt_CIA;
        return this.info.currentSong;
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    public boolean bool() {
        return this.status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean isStereo() {
        return this.info.sidChipBase1 != 0 && this.info.sidChipBase2 != 0;
    }

    public boolean placeSidTuneInC64mem(short[] sArray) {
        if (this.status && sArray != null) {
            int n = this.info.loadAddr + this.info.c64dataLen;
            if (n <= 65536) {
                System.arraycopy(this.cache.get(), this.fileOffset, sArray, this.info.loadAddr, this.info.c64dataLen);
                this.info.statusString = txt_noErrors;
                int n2 = 0;
                while (n2 < this.info.c64dataLen) {
                    int n3 = 0;
                    while (n3 < 16 && n2 + n3 < this.info.c64dataLen) {
                        TUNE.fine(String.format("0x%02x ", sArray[this.info.loadAddr + n2 + n3]));
                        ++n3;
                    }
                    TUNE.fine("\n");
                    n2 += 16;
                }
            } else {
                System.arraycopy(this.cache.get(), this.fileOffset, sArray, this.info.loadAddr, this.info.c64dataLen - (n - 65536));
                this.info.statusString = txt_dataTooLong;
            }
            if (this.info.musPlayer) {
                this.MUS_installPlayer(sArray);
            }
        }
        return this.status && sArray != null;
    }

    public boolean saveC64dataFile(String string, boolean bl) {
        boolean bl2 = false;
        if (this.status) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, !bl);
                if (!this.info.musPlayer) {
                    short[] sArray = new short[]{(short)(this.info.loadAddr & 0xFF), (short)(this.info.loadAddr >> 8)};
                    fileOutputStream.write(sArray[0]);
                    fileOutputStream.write(sArray[1]);
                }
                if (!this.saveToOpenFile(fileOutputStream, this.cache.get(), this.fileOffset, this.info.dataFileLen - this.fileOffset)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    bl2 = true;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return bl2;
    }

    public boolean saveSIDfile(String string, boolean bl) {
        boolean bl2 = false;
        if (this.status) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, !bl);
                if (!this.SID_fileSupportSave(fileOutputStream)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    bl2 = true;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return bl2;
    }

    public boolean savePSIDfile(String string, boolean bl) {
        boolean bl2 = false;
        if (this.status) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, !bl);
                if (!this.PSID_fileSupportSave(fileOutputStream, this.cache.get())) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    bl2 = true;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return bl2;
    }

    public void fixLoadAddress(boolean bl, int n, int n2) {
        if (this.info.fixLoad || bl) {
            this.info.fixLoad = false;
            this.info.loadAddr += 2;
            this.fileOffset += 2;
            if (bl) {
                this.info.initAddr = n;
                this.info.playAddr = n2;
            }
        }
    }

    public boolean loadFile(String string, Buffer_sidtt buffer_sidtt) {
        FileInputStream fileInputStream = null;
        Buffer_sidtt buffer_sidtt2 = new Buffer_sidtt();
        int n = 0;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            this.info.statusString = txt_cantOpenFile;
            return false;
        }
        try {
            fileInputStream = new FileInputStream(file);
            n = (int)file.length();
            if (!buffer_sidtt2.assign(new short[n], n)) {
                this.info.statusString = txt_notEnoughMemory;
                return false;
            }
            try {
                int n2 = n;
                if (n2 > 0) {
                    int n3 = 0;
                    while (n3 < n) {
                        buffer_sidtt2.get()[n3] = (short)fileInputStream.read();
                        ++n3;
                    }
                }
                this.info.statusString = txt_noErrors;
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.info.statusString = txt_cantLoadFile;
                return false;
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.info.statusString = iOException.getMessage();
                }
            }
        }
        if (n == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        if (this.decompressPP20(buffer_sidtt2) < 0) {
            return false;
        }
        buffer_sidtt.assign(buffer_sidtt2.xferPtr(), buffer_sidtt2.xferLen());
        return true;
    }

    public boolean saveToOpenFile(OutputStream outputStream, short[] sArray, int n, int n2) {
        int n3 = n2;
        try {
            if (n3 > 0) {
                int n4 = n2 - n3;
                while (n4 < n3) {
                    outputStream.write(sArray[n + n4]);
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            this.info.statusString = txt_fileIoError;
            return false;
        }
        this.info.statusString = txt_noErrors;
        return true;
    }

    protected void convertOldStyleSpeedToTables(long l, short s) {
        int n = this.info.songs <= 256 ? this.info.songs : 256;
        int n2 = 0;
        while (n2 < n) {
            this.clockSpeed[n2] = s;
            this.songSpeed[n2] = (l >> (n2 & 0x1F) & 1L) == 0L ? 0 : 60;
            ++n2;
        }
    }

    protected int convertPetsciiToAscii(SmartPtr_sidtt smartPtr_sidtt, StringBuffer stringBuffer) {
        int n = 0;
        if (stringBuffer != null) {
            short s;
            do {
                if ((s = _sidtune_CHRtab[smartPtr_sidtt.operatorMal()]) >= 32 && n <= 31) {
                    stringBuffer.setLength(n + 1);
                    stringBuffer.setCharAt(n++, (char)s);
                }
                if (smartPtr_sidtt.operatorMal() == 157 && n >= 0) {
                    --n;
                }
                smartPtr_sidtt.operatorPlusPlus();
            } while (s != 13 && s != 0 && !smartPtr_sidtt.fail());
        } else {
            short s;
            do {
                s = _sidtune_CHRtab[smartPtr_sidtt.operatorMal()];
                smartPtr_sidtt.operatorPlusPlus();
            } while (s != 13 && s != 0 && !smartPtr_sidtt.fail());
        }
        return n;
    }

    protected boolean checkCompatibility() {
        switch (this.info.compatibility) {
            case 2: {
                switch (this.info.initAddr >> 12) {
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.info.statusString = txt_badAddr;
                        return false;
                    }
                }
                if (this.info.initAddr < this.info.loadAddr || this.info.initAddr > this.info.loadAddr + this.info.c64dataLen - 1) {
                    this.info.statusString = txt_badAddr;
                    return false;
                }
            }
            case 3: {
                if (this.info.loadAddr >= 2024) break;
                this.info.statusString = txt_badAddr;
                return false;
            }
        }
        return true;
    }

    protected boolean checkRelocInfo() {
        short s;
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
            return true;
        }
        if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
            return true;
        }
        short s2 = this.info.relocStartPage;
        short s3 = (short)(s2 + this.info.relocPages - 1 & 0xFF);
        if (s3 < s2) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        short s4 = s = (short)(this.info.loadAddr >> 8);
        s4 = (short)(s4 + (short)(this.info.c64dataLen - 1 >> 8));
        if (s2 <= s && s3 >= s || s2 <= s4 && s3 >= s4) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        if (s2 < 4 || 160 <= s2 && s2 <= 191 || s2 >= 208 || 160 <= s3 && s3 <= 191 || s3 >= 208) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        return true;
    }

    protected boolean resolveAddrs(short[] sArray, int n) {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                this.info.statusString = txt_corrupt;
                return false;
            }
            this.info.loadAddr = SIDEndian.endian_16(sArray[this.fileOffset + 1], sArray[this.fileOffset + 0]);
            this.fileOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == 3) {
            if (this.info.initAddr != 0) {
                this.info.statusString = txt_badAddr;
                return false;
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
        return true;
    }

    protected LoadStatus PSID_fileSupport(Buffer_sidtt buffer_sidtt) {
        return this.psid.PSID_fileSupport(buffer_sidtt);
    }

    protected boolean PSID_fileSupportSave(OutputStream outputStream, short[] sArray) {
        return this.psid.PSID_fileSupportSave(outputStream, sArray);
    }

    protected LoadStatus SID_fileSupport(Buffer_sidtt buffer_sidtt, Buffer_sidtt buffer_sidtt2) {
        return LoadStatus.LOAD_NOT_MINE;
    }

    protected boolean SID_fileSupportSave(OutputStream outputStream) {
        return true;
    }

    protected LoadStatus MUS_fileSupport(Buffer_sidtt buffer_sidtt, Buffer_sidtt buffer_sidtt2) {
        return this.mus.MUS_fileSupport(buffer_sidtt, buffer_sidtt2);
    }

    protected LoadStatus MUS_load(Buffer_sidtt buffer_sidtt, boolean bl) {
        return this.mus.MUS_load(buffer_sidtt, bl);
    }

    protected LoadStatus MUS_load(Buffer_sidtt buffer_sidtt, Buffer_sidtt buffer_sidtt2, boolean bl) {
        return this.mus.MUS_load(buffer_sidtt, buffer_sidtt2, bl);
    }

    protected boolean MUS_detect(short[] sArray, int n, Mus.Voice3Index voice3Index) {
        return this.mus.MUS_detect(sArray, n, voice3Index);
    }

    protected boolean MUS_mergeParts(Buffer_sidtt buffer_sidtt, Buffer_sidtt buffer_sidtt2) {
        return this.mus.MUS_mergeParts(buffer_sidtt, buffer_sidtt2);
    }

    protected void MUS_setPlayerAddress() {
        this.mus.MUS_setPlayerAddress();
    }

    protected void MUS_installPlayer(short[] sArray) {
        this.mus.MUS_installPlayer(sArray);
    }

    protected LoadStatus INFO_fileSupport(Buffer_sidtt buffer_sidtt, Buffer_sidtt buffer_sidtt2) {
        return this.inf.INFO_fileSupport(buffer_sidtt, buffer_sidtt2);
    }

    protected LoadStatus PRG_fileSupport(String string, Buffer_sidtt buffer_sidtt) {
        return this.prg.PRG_fileSupport(string, buffer_sidtt);
    }

    protected LoadStatus X00_fileSupport(String string, Buffer_sidtt buffer_sidtt) {
        return this.p00.X00_fileSupport(string, buffer_sidtt);
    }

    private void init() {
        this.status = false;
        this.info.statusString = txt_na;
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
        this.info.c64dataLen = 0;
        this.info.dataFileLen = 0;
        this.info.formatString = txt_na;
        this.info.speedString = txt_na;
        this.info.playAddr = 0;
        this.info.initAddr = 0;
        this.info.loadAddr = 0;
        this.info.currentSong = 0;
        this.info.startSong = 0;
        this.info.songs = 0;
        this.info.sidChipBase1 = 54272;
        this.info.sidChipBase2 = 0;
        this.info.musPlayer = false;
        this.info.fixLoad = false;
        this.info.songSpeed = 0;
        this.info.clockSpeed = 0;
        this.info.sidModel = 0;
        this.info.compatibility = 0;
        this.info.relocStartPage = 0;
        this.info.relocPages = 0;
        int n = 0;
        while (n < 256) {
            this.songSpeed[n] = this.info.songSpeed;
            this.clockSpeed[n] = this.info.clockSpeed;
            this.songLength[n] = 0;
            ++n;
        }
        this.fileOffset = 0;
        this.musDataLen = 0;
        n = 0;
        while (n < 10) {
            this.infoString[n] = null;
            ++n;
        }
        this.info.numberOfInfoStrings = 0;
        this.info.numberOfCommentStrings = 1;
        this.info.commentString = new String[this.info.numberOfCommentStrings];
        this.info.commentString[0] = this.info.commentString != null ? "--- SAVED WITH SIDPLAY ---" : null;
    }

    private void cleanup() {
        this.info.commentString = null;
        this.deleteFileNameCopies();
        this.status = false;
    }

    private void getFromStdIn() {
        this.status = false;
        this.info.statusString = txt_notEnoughMemory;
        short[] sArray = new short[65662];
        int n = 0;
        try {
            int n2;
            while ((n2 = System.in.read()) != -1 && n < 65662) {
                sArray[n++] = (short)n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.info.dataFileLen = n;
        this.getFromBuffer(sArray, this.info.dataFileLen);
    }

    private void getFromFiles(String string) {
        this.status = false;
        Buffer_sidtt buffer_sidtt = new Buffer_sidtt();
        Buffer_sidtt buffer_sidtt2 = new Buffer_sidtt();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.loadFile(string, buffer_sidtt)) {
            LoadStatus loadStatus = this.PSID_fileSupport(buffer_sidtt);
            if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
                if (loadStatus == LoadStatus.LOAD_OK) {
                    this.status = this.acceptSidTune(string, null, buffer_sidtt);
                }
                return;
            }
            loadStatus = this.orStatus(this.SID_fileSupport(buffer_sidtt2, buffer_sidtt), this.INFO_fileSupport(buffer_sidtt2, buffer_sidtt));
            if (loadStatus == LoadStatus.LOAD_NOT_MINE) {
                int n = 0;
                while (n < fileNameExtensions.length) {
                    if (!this.createNewFileName(stringBuffer, string, fileNameExtensions[n])) {
                        return;
                    }
                    if (!string.equalsIgnoreCase(stringBuffer.toString()) && this.loadFile(stringBuffer.toString(), buffer_sidtt2) && (this.SID_fileSupport(buffer_sidtt, buffer_sidtt2) == LoadStatus.LOAD_OK || this.INFO_fileSupport(buffer_sidtt, buffer_sidtt2) == LoadStatus.LOAD_OK)) {
                        this.status = this.acceptSidTune(string, stringBuffer.toString(), buffer_sidtt);
                        return;
                    }
                    ++n;
                }
                loadStatus = this.MUS_fileSupport(buffer_sidtt, buffer_sidtt2);
                if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
                    if (loadStatus == LoadStatus.LOAD_ERROR) {
                        return;
                    }
                    n = 0;
                    while (n < fileNameExtensions.length) {
                        if (!this.createNewFileName(stringBuffer, string, fileNameExtensions[n])) {
                            return;
                        }
                        if (!string.equalsIgnoreCase(stringBuffer.toString()) && this.loadFile(stringBuffer.toString(), buffer_sidtt2)) {
                            if (fileNameExtensions[n].equalsIgnoreCase(".mus")) {
                                if (this.MUS_fileSupport(buffer_sidtt2, buffer_sidtt) == LoadStatus.LOAD_OK) {
                                    if (this.MUS_mergeParts(buffer_sidtt2, buffer_sidtt)) {
                                        this.status = this.acceptSidTune(stringBuffer.toString(), string, buffer_sidtt2);
                                    }
                                    return;
                                }
                            } else if (this.MUS_fileSupport(buffer_sidtt, buffer_sidtt2) == LoadStatus.LOAD_OK) {
                                if (this.MUS_mergeParts(buffer_sidtt, buffer_sidtt2)) {
                                    this.status = this.acceptSidTune(string, stringBuffer.toString(), buffer_sidtt);
                                }
                                return;
                            }
                        }
                        ++n;
                    }
                    buffer_sidtt2.erase();
                    this.MUS_fileSupport(buffer_sidtt, buffer_sidtt2);
                    this.status = this.acceptSidTune(string, null, buffer_sidtt);
                    return;
                }
                loadStatus = this.X00_fileSupport(string, buffer_sidtt);
                if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
                    if (loadStatus == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(string, null, buffer_sidtt);
                    }
                    return;
                }
                loadStatus = this.PRG_fileSupport(string, buffer_sidtt);
                if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
                    if (loadStatus == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(string, null, buffer_sidtt);
                    }
                    return;
                }
                this.info.statusString = txt_unrecognizedFormat;
                return;
            }
            if (loadStatus == LoadStatus.LOAD_OK) {
                int n = 0;
                while (n < fileNameExtensions.length) {
                    if (!this.createNewFileName(stringBuffer, string, fileNameExtensions[n])) {
                        return;
                    }
                    if (!string.equalsIgnoreCase(stringBuffer.toString()) && this.loadFile(stringBuffer.toString(), buffer_sidtt2) && (this.SID_fileSupport(buffer_sidtt2, buffer_sidtt) == LoadStatus.LOAD_OK || this.INFO_fileSupport(buffer_sidtt2, buffer_sidtt) == LoadStatus.LOAD_OK)) {
                        this.status = this.acceptSidTune(stringBuffer.toString(), string, buffer_sidtt2);
                        return;
                    }
                    ++n;
                }
                this.info.statusString = txt_noDataFile;
                return;
            }
        } else {
            return;
        }
    }

    private LoadStatus orStatus(LoadStatus loadStatus, LoadStatus loadStatus2) {
        int n;
        int n2 = loadStatus == LoadStatus.LOAD_NOT_MINE ? 0 : (n = loadStatus == LoadStatus.LOAD_OK ? 1 : 2);
        int n3 = loadStatus2 == LoadStatus.LOAD_NOT_MINE ? 0 : (loadStatus2 == LoadStatus.LOAD_OK ? 1 : 2);
        int n4 = n | n3;
        return n4 == 0 ? LoadStatus.LOAD_NOT_MINE : (n4 == 1 ? LoadStatus.LOAD_OK : LoadStatus.LOAD_ERROR);
    }

    private void deleteFileNameCopies() {
        if (this.info.dataFileName != null) {
            this.info.dataFileName = null;
        }
        if (this.info.infoFileName != null) {
            this.info.infoFileName = null;
        }
        if (this.info.path != null) {
            this.info.path = null;
        }
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
    }

    private void getFromBuffer(short[] sArray, int n) {
        this.status = false;
        if (sArray == null || n == 0) {
            this.info.statusString = txt_empty;
            return;
        }
        if (n > 65662) {
            this.info.statusString = txt_fileTooLong;
            return;
        }
        short[] sArray2 = new short[n];
        System.arraycopy(sArray, 0, sArray2, 0, n);
        Buffer_sidtt buffer_sidtt = new Buffer_sidtt(sArray2, n);
        Buffer_sidtt buffer_sidtt2 = new Buffer_sidtt();
        if (this.decompressPP20(buffer_sidtt) < 0) {
            return;
        }
        boolean bl = false;
        LoadStatus loadStatus = this.PSID_fileSupport(buffer_sidtt);
        if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
            if (loadStatus == LoadStatus.LOAD_ERROR) {
                return;
            }
            bl = true;
        } else {
            loadStatus = this.MUS_fileSupport(buffer_sidtt, buffer_sidtt2);
            if (loadStatus != LoadStatus.LOAD_NOT_MINE) {
                if (loadStatus == LoadStatus.LOAD_ERROR) {
                    return;
                }
                bl = this.MUS_mergeParts(buffer_sidtt, buffer_sidtt2);
            } else {
                this.info.statusString = txt_unrecognizedFormat;
            }
        }
        if (bl) {
            this.status = this.acceptSidTune("-", "-", buffer_sidtt);
        }
    }

    private boolean acceptSidTune(String string, String string2, Buffer_sidtt buffer_sidtt) {
        if (this.info.numberOfInfoStrings == 3) {
            int n = 0;
            while (n < 3) {
                if (this.infoString[n].length() == 0) {
                    this.infoString[n] = "<?>";
                    this.info.infoString[n] = this.infoString[n];
                }
                ++n;
            }
        }
        this.deleteFileNameCopies();
        if (string != null) {
            this.info.path = string;
            File file = new File(this.info.path);
            this.info.dataFileName = file.getName();
            String string3 = this.info.path = file.getParentFile() != null ? file.getParentFile().getPath() : "";
            if (this.info.path == null || this.info.dataFileName == null) {
                this.info.statusString = txt_notEnoughMemory;
                return false;
            }
        } else {
            this.info.path = "";
            this.info.dataFileName = "";
        }
        this.info.infoFileName = string2 != null ? new File(string2).getName() : "";
        if (this.info.songs > 256) {
            this.info.songs = 256;
        } else if (this.info.songs == 0) {
            ++this.info.songs;
        }
        if (this.info.startSong > this.info.songs) {
            this.info.startSong = 1;
        } else if (this.info.startSong == 0) {
            ++this.info.startSong;
        }
        if (this.info.musPlayer) {
            this.MUS_setPlayerAddress();
        }
        this.info.dataFileLen = buffer_sidtt.len();
        this.info.c64dataLen = buffer_sidtt.len() - this.fileOffset;
        if (!this.resolveAddrs(buffer_sidtt.get(), this.fileOffset)) {
            return false;
        }
        if (!this.checkRelocInfo()) {
            return false;
        }
        if (!this.checkCompatibility()) {
            return false;
        }
        if (this.info.dataFileLen >= 2) {
            boolean bl = this.info.fixLoad = SIDEndian.endian_little16(buffer_sidtt.get(), this.fileOffset) == this.info.loadAddr + 2;
        }
        if (this.info.c64dataLen > 65536) {
            this.info.statusString = txt_dataTooLong;
            return false;
        }
        if (this.info.c64dataLen == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        this.cache.assign(buffer_sidtt.xferPtr(), buffer_sidtt.xferLen());
        this.info.statusString = txt_noErrors;
        return true;
    }

    private boolean createNewFileName(StringBuffer stringBuffer, String string, String string2) {
        int n;
        if (stringBuffer.length() > 0) {
            stringBuffer.delete(0, stringBuffer.length() - 1);
        }
        if ((n = string.lastIndexOf(".")) != -1) {
            stringBuffer.append(string.substring(0, n)).append(string2);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        return true;
    }

    private int decompressPP20(Buffer_sidtt buffer_sidtt) {
        PP20 pP20 = new PP20();
        if (pP20.isCompressed(buffer_sidtt.get(), buffer_sidtt.len())) {
            Decompressed decompressed = new Decompressed();
            int n = pP20.decompress(buffer_sidtt.get(), buffer_sidtt.len(), decompressed);
            if (n == 0) {
                this.info.statusString = pP20.getStatusString();
                return -1;
            }
            this.info.statusString = pP20.getStatusString();
            buffer_sidtt.assign(decompressed.destBufRef, n);
            return 1;
        }
        return 0;
    }

    public static class Decompressed {
        short[] destBufRef;
    }

    public static enum LoadStatus {
        LOAD_NOT_MINE,
        LOAD_OK,
        LOAD_ERROR;

    }
}

