/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.mos656x;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IComponent;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEndian;

public abstract class MOS656X
extends Event
implements IComponent {
    public static final int MOS6567R56A_SCREEN_HEIGHT = 262;
    public static final int MOS6567R56A_SCREEN_WIDTH = 64;
    public static final int MOS6567R56A_FIRST_DMA_LINE = 48;
    public static final int MOS6567R56A_LAST_DMA_LINE = 247;
    public static final int MOS6567R8_SCREEN_HEIGHT = 263;
    public static final int MOS6567R8_SCREEN_WIDTH = 65;
    public static final int MOS6567R8_FIRST_DMA_LINE = 48;
    public static final int MOS6567R8_LAST_DMA_LINE = 247;
    public static final int MOS6569_SCREEN_HEIGHT = 312;
    public static final int MOS6569_SCREEN_WIDTH = 63;
    public static final int MOS6569_FIRST_DMA_LINE = 48;
    public static final int MOS6569_LAST_DMA_LINE = 247;
    private static final String credit = "*MOS656X (VICII) Emulation:\tCopyright (C) 2001 Simon White <sidplay2@yahoo.com>";
    protected short[] regs = new short[64];
    protected short icr;
    protected short idr;
    protected short ctrl1;
    protected int yrasters;
    protected int xrasters;
    protected int raster_irq;
    protected int raster_x;
    protected int raster_y;
    protected int first_dma_line;
    protected int last_dma_line;
    protected int y_scroll;
    protected boolean bad_lines_enabled;
    protected boolean bad_line;
    protected boolean vblanking;
    protected boolean lp_triggered;
    protected short lpx;
    protected short lpy;
    protected short sprite_dma;
    protected short sprite_expand_y;
    protected short[] sprite_mc_base = new short[8];
    protected long m_rasterClk;
    protected IEventContext event_context;
    protected Event.event_phase_t m_phase;
    public static final int MOS656X_INTERRUPT_RST = 1;
    public static final int MOS656X_INTERRUPT_LP = 8;
    public static final int MOS656X_INTERRUPT_REQUEST = 128;

    protected MOS656X(IEventContext iEventContext) {
        super("VIC Raster");
        this.event_context = iEventContext;
        this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
        this.chip(mos656x_model_t.MOS6569);
    }

    @Override
    public void event() {
        long l = this.event_context.getTime(this.m_rasterClk, this.event_context.phase());
        if (l == 0L) {
            return;
        }
        long l2 = 1L;
        this.m_rasterClk += l;
        this.raster_x = (int)((long)this.raster_x + l);
        int n = (this.raster_x + 9) % this.xrasters;
        this.raster_x %= this.xrasters;
        switch (n) {
            case 0: {
                short s = (short)(this.raster_y & 0xFF);
                short s2 = 1;
                this.sprite_expand_y = (short)(this.sprite_expand_y ^ this.regs[23]);
                int n2 = 1;
                while (n2 < 16) {
                    if ((this.regs[21] & s2) != 0 && s == this.regs[n2]) {
                        this.sprite_dma = (short)(this.sprite_dma | s2);
                        this.sprite_mc_base[n2 >> 1] = 0;
                        this.sprite_expand_y = (short)(this.sprite_expand_y & (~(this.regs[23] & s2) & 0xFF));
                    }
                    n2 += 2;
                    s2 = (short)(s2 << 1);
                }
                l2 = 2L;
                if ((this.sprite_dma & 1) != 0) {
                    this.addrctrl(false);
                    break;
                }
                this.addrctrl(true);
                if ((this.sprite_dma & 0x1F) != 0) break;
                l2 = 9L;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if ((this.sprite_dma & 2) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 3: {
                if ((this.sprite_dma & 3) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 4: {
                if ((this.sprite_dma & 4) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 5: {
                if ((this.sprite_dma & 6) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 6: {
                if ((this.sprite_dma & 8) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 7: {
                if ((this.sprite_dma & 0xC) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 8: {
                if ((this.sprite_dma & 0x10) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 9: {
                if (this.raster_y == this.yrasters - 1) {
                    this.vblanking = true;
                } else {
                    ++this.raster_y;
                    if (this.raster_y == this.raster_irq) {
                        this.trigger(1);
                    }
                }
                if ((this.sprite_dma & 0x18) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 10: {
                if (this.vblanking) {
                    this.lp_triggered = false;
                    this.vblanking = false;
                    this.raster_y = 0;
                    if (this.raster_irq == 0) {
                        this.trigger(1);
                    }
                }
                if ((this.sprite_dma & 0x20) != 0) {
                    this.addrctrl(false);
                    break;
                }
                if ((this.sprite_dma & 0xF8) != 0) break;
                l2 = 10L;
                break;
            }
            case 11: {
                if ((this.sprite_dma & 0x30) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 12: {
                if ((this.sprite_dma & 0x40) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 13: {
                if ((this.sprite_dma & 0x60) != 0) break;
                this.addrctrl(true);
                break;
            }
            case 14: {
                if ((this.sprite_dma & 0x80) == 0) break;
                this.addrctrl(false);
                break;
            }
            case 15: {
                l2 = 2L;
                if ((this.sprite_dma & 0xC0) != 0) break;
                this.addrctrl(true);
                l2 = 5L;
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                l2 = 2L;
                if ((this.sprite_dma & 0x80) != 0) break;
                this.addrctrl(true);
                l2 = 3L;
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                this.addrctrl(true);
                break;
            }
            case 20: {
                if (this.raster_y == this.first_dma_line) {
                    this.bad_lines_enabled = (this.ctrl1 & 0x10) != 0;
                }
                boolean bl = this.bad_line = this.raster_y >= this.first_dma_line && this.raster_y <= this.last_dma_line && (this.raster_y & 7) == this.y_scroll && this.bad_lines_enabled;
                if (this.bad_line) {
                    this.addrctrl(false);
                }
                l2 = 3L;
                break;
            }
            case 23: {
                int n3 = 0;
                while (n3 < 8) {
                    if ((this.sprite_expand_y & 1 << n3) != 0) {
                        int n4 = n3;
                        this.sprite_mc_base[n4] = (short)(this.sprite_mc_base[n4] + 2);
                    }
                    ++n3;
                }
                break;
            }
            case 24: {
                short s = 1;
                int n5 = 0;
                while (n5 < 8) {
                    if ((this.sprite_expand_y & s) != 0) {
                        int n6 = n5;
                        this.sprite_mc_base[n6] = (short)(this.sprite_mc_base[n6] + 1);
                    }
                    if ((this.sprite_mc_base[n5] & 0x3F) == 63) {
                        this.sprite_dma = (short)(this.sprite_dma & (~s & 0xFF));
                    }
                    ++n5;
                    s = (short)(s << 1);
                }
                l2 = 39L;
                break;
            }
            case 63: {
                this.addrctrl(true);
                l2 = this.xrasters - n;
                break;
            }
            default: {
                l2 = n < 23 ? (long)(23 - n) : (n < 63 ? (long)(63 - n) : (long)(this.xrasters - n));
            }
        }
        this.event_context.schedule(this, l2 - (long)(this.event_context.phase() == Event.event_phase_t.EVENT_CLOCK_PHI1 ? 0 : 1), this.m_phase);
    }

    protected void trigger(int n) {
        if (n == 0) {
            if ((this.idr & 0x80) != 0) {
                this.interrupt(false);
            }
            this.idr = 0;
            return;
        }
        this.idr = (short)(this.idr | n);
        if ((this.icr & this.idr) != 0 && (this.idr & 0x80) == 0) {
            this.idr = (short)(this.idr | 0x80);
            this.interrupt(true);
        }
    }

    protected abstract void interrupt(boolean var1);

    protected abstract void addrctrl(boolean var1);

    public void chip(mos656x_model_t mos656x_model_t2) {
        switch (mos656x_model_t2) {
            case MOS6567R56A: {
                this.yrasters = 262;
                this.xrasters = 64;
                this.first_dma_line = 48;
                this.last_dma_line = 247;
                break;
            }
            case MOS6567R8: {
                this.yrasters = 263;
                this.xrasters = 65;
                this.first_dma_line = 48;
                this.last_dma_line = 247;
                break;
            }
            case MOS6569: {
                this.yrasters = 312;
                this.xrasters = 63;
                this.first_dma_line = 48;
                this.last_dma_line = 247;
            }
        }
        this.reset();
    }

    public void lightpen() {
        this.event();
        if (!this.lp_triggered) {
            this.lpx = (short)(this.raster_x << 2);
            this.lpy = (short)(this.raster_y & 0xFF);
            this.trigger(8);
        }
    }

    @Override
    public void reset() {
        this.ctrl1 = 0;
        this.idr = 0;
        this.icr = 0;
        this.raster_irq = 0;
        this.y_scroll = 0;
        this.raster_y = this.yrasters - 1;
        this.raster_x = 0;
        this.bad_lines_enabled = false;
        this.m_rasterClk = 0L;
        this.lp_triggered = false;
        this.vblanking = false;
        this.lpy = 0;
        this.lpx = 0;
        this.sprite_dma = 0;
        this.sprite_expand_y = (short)255;
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.sprite_mc_base.length) {
            this.sprite_mc_base[n] = 0;
            ++n;
        }
        this.event_context.schedule(this, 0L, this.m_phase);
    }

    @Override
    public short read(short s) {
        if (s > 63) {
            return 0;
        }
        if (s > 46) {
            return 255;
        }
        this.event();
        switch (s) {
            case 17: {
                return (short)(this.ctrl1 & 0x7F | (this.raster_y & 0x100) >> 1);
            }
            case 18: {
                return (short)(this.raster_y & 0xFF);
            }
            case 19: {
                return this.lpx;
            }
            case 20: {
                return this.lpy;
            }
            case 25: {
                return this.idr;
            }
            case 26: {
                return (short)(this.icr | 0xF0);
            }
        }
        return this.regs[s];
    }

    @Override
    public void write(short s, short s2) {
        if (s > 63) {
            return;
        }
        this.regs[s] = s2;
        this.event();
        switch (s) {
            case 17: {
                this.raster_irq = SIDEndian.endian_16hi8(this.raster_irq, (short)(s2 >> 7));
                this.ctrl1 = s2;
                this.y_scroll = s2 & 7;
                if (this.raster_x < 11) break;
                if (this.raster_y == this.first_dma_line && (s2 & 0x10) != 0) {
                    this.bad_lines_enabled = true;
                }
                boolean bl = this.bad_line = this.raster_y >= this.first_dma_line && this.raster_y <= this.last_dma_line && (this.raster_y & 7) == this.y_scroll && this.bad_lines_enabled;
                if (!this.bad_line || this.raster_x >= 53) break;
                this.addrctrl(false);
                break;
            }
            case 18: {
                this.raster_irq = SIDEndian.endian_16lo8(this.raster_irq, s2);
                break;
            }
            case 23: {
                this.sprite_expand_y = (short)(this.sprite_expand_y | ~s2 & 0xFF);
                break;
            }
            case 25: {
                this.idr = (short)(this.idr & (~s2 & 0xF | 0x80));
                if (this.idr != 128) break;
                this.trigger(0);
                break;
            }
            case 26: {
                this.icr = (short)(s2 & 0xF);
                this.trigger(this.icr & this.idr);
            }
        }
    }

    @Override
    public String credits() {
        return credit;
    }

    public static enum mos656x_model_t {
        MOS6567R56A,
        MOS6567R8,
        MOS6569;

    }
}

