/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.CueIndex;
import java.io.IOException;

public class CueTrack {
    private static final int CUESHEET_TRACK_OFFSET_LEN = 64;
    private static final int CUESHEET_TRACK_NUMBER_LEN = 8;
    private static final int CUESHEET_TRACK_ISRC_LEN = 96;
    private static final int CUESHEET_TRACK_TYPE_LEN = 1;
    private static final int CUESHEET_TRACK_PRE_EMPHASIS_LEN = 1;
    private static final int CUESHEET_TRACK_RESERVED_LEN = 110;
    private static final int CUESHEET_TRACK_NUM_INDICES_LEN = 8;
    protected long offset;
    protected int number;
    protected byte[] isrc = new byte[13];
    protected int type;
    protected int preEmphasis;
    protected byte numIndices;
    protected CueIndex[] indices;

    public CueTrack(BitInputStream bitInputStream) throws IOException {
        this.offset = bitInputStream.readRawULong(64);
        this.number = bitInputStream.readRawUInt(8);
        bitInputStream.readByteBlockAlignedNoCRC(this.isrc, 12);
        this.type = bitInputStream.readRawUInt(1);
        this.preEmphasis = bitInputStream.readRawUInt(1);
        bitInputStream.skipBitsNoCRC(110);
        this.numIndices = (byte)bitInputStream.readRawUInt(8);
        if (this.numIndices > 0) {
            this.indices = new CueIndex[this.numIndices];
            int n = 0;
            while (n < this.numIndices) {
                this.indices[n] = new CueIndex(bitInputStream);
                ++n;
            }
        }
    }
}

