/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.io;

import de.quippy.jflac.util.CRC16;
import de.quippy.jflac.util.CRC8;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private static final int BITS_PER_BLURB = 8;
    private static final long[] MASK32;
    private byte[] buffer = new byte[0];
    private int outCapacity = 0;
    private int outBlurbs = 0;
    private int outBits = 0;
    private int totalBits = 0;
    private int consumedBlurbs = 0;
    private int consumedBits = 0;
    private int totalConsumedBits = 0;
    private short readCRC16 = 0;
    private OutputStream os;

    static {
        long[] lArray = new long[65];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        lArray[32] = -1L;
        lArray[33] = 0x1FFFFFFFFL;
        lArray[34] = 0x3FFFFFFFFL;
        lArray[35] = 0x7FFFFFFFFL;
        lArray[36] = 0xFFFFFFFFFL;
        lArray[37] = 0x1FFFFFFFFFL;
        lArray[38] = 0x3FFFFFFFFFL;
        lArray[39] = 0x7FFFFFFFFFL;
        lArray[40] = 0xFFFFFFFFFFL;
        lArray[41] = 0x1FFFFFFFFFFL;
        lArray[42] = 0x3FFFFFFFFFFL;
        lArray[43] = 0x7FFFFFFFFFFL;
        lArray[44] = 0xFFFFFFFFFFFL;
        lArray[45] = 0x1FFFFFFFFFFFL;
        lArray[46] = 0x3FFFFFFFFFFFL;
        lArray[47] = 0x7FFFFFFFFFFFL;
        lArray[48] = 0xFFFFFFFFFFFFL;
        lArray[49] = 0x1FFFFFFFFFFFFL;
        lArray[50] = 0x3FFFFFFFFFFFFL;
        lArray[51] = 0x7FFFFFFFFFFFFL;
        lArray[52] = 0xFFFFFFFFFFFFFL;
        lArray[53] = 0x1FFFFFFFFFFFFFL;
        lArray[54] = 0x3FFFFFFFFFFFFFL;
        lArray[55] = 0x7FFFFFFFFFFFFFL;
        lArray[56] = 0xFFFFFFFFFFFFFFL;
        lArray[57] = 0x1FFFFFFFFFFFFFFL;
        lArray[58] = 0x3FFFFFFFFFFFFFFL;
        lArray[59] = 0x7FFFFFFFFFFFFFFL;
        lArray[60] = 0xFFFFFFFFFFFFFFFL;
        lArray[61] = 0x1FFFFFFFFFFFFFFFL;
        lArray[62] = 0x3FFFFFFFFFFFFFFFL;
        lArray[63] = Long.MAX_VALUE;
        lArray[64] = -1L;
        MASK32 = lArray;
    }

    private boolean resize(int n) {
        if (this.outCapacity >= n) {
            return true;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, 0, byArray, 0, Math.min(this.outBlurbs + (this.outBits != 0 ? 1 : 0), n));
        if (n < this.outBlurbs + (this.outBits != 0 ? 1 : 0)) {
            this.outBlurbs = n;
            this.outBits = 0;
            this.totalBits = n << 3;
        }
        if (n < this.consumedBlurbs + (this.consumedBits != 0 ? 1 : 0)) {
            this.consumedBlurbs = n;
            this.consumedBits = 0;
            this.totalConsumedBits = n << 3;
        }
        this.buffer = byArray;
        this.outCapacity = n;
        return true;
    }

    private boolean grow(int n) {
        int n2 = Math.max(this.outCapacity * 2, this.outCapacity + n);
        return this.resize(n2);
    }

    private boolean ensureSize(int n) {
        if (this.outCapacity << 3 < this.totalBits + n) {
            return this.grow((n >> 3) + 2);
        }
        return true;
    }

    public BitOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public BitOutputStream() {
    }

    public boolean concatenateAligned(BitOutputStream bitOutputStream) {
        int n = bitOutputStream.totalBits - bitOutputStream.totalConsumedBits;
        if (n == 0) {
            return true;
        }
        if (this.outBits != bitOutputStream.consumedBits) {
            return false;
        }
        if (!this.ensureSize(n)) {
            return false;
        }
        if (this.outBits == 0) {
            System.arraycopy(bitOutputStream.buffer, bitOutputStream.consumedBlurbs, this.buffer, this.outBlurbs, bitOutputStream.outBlurbs - bitOutputStream.consumedBlurbs + (bitOutputStream.outBits != 0 ? 1 : 0));
        } else if (this.outBits + n > 8) {
            int n2 = this.outBlurbs;
            this.buffer[n2] = (byte)(this.buffer[n2] << 8 - this.outBits);
            int n3 = this.outBlurbs;
            this.buffer[n3] = (byte)(this.buffer[n3] | bitOutputStream.buffer[bitOutputStream.consumedBlurbs] & (1 << 8 - this.outBits) - 1);
            System.arraycopy(bitOutputStream.buffer, bitOutputStream.consumedBlurbs + 1, this.buffer, this.outBlurbs + 11, bitOutputStream.outBlurbs - bitOutputStream.consumedBlurbs - 1 + (bitOutputStream.outBits != 0 ? 1 : 0));
        } else {
            int n4 = this.outBlurbs;
            this.buffer[n4] = (byte)(this.buffer[n4] << n);
            int n5 = this.outBlurbs;
            this.buffer[n5] = (byte)(this.buffer[n5] | bitOutputStream.buffer[bitOutputStream.consumedBlurbs] & (1 << n) - 1);
        }
        this.outBits = bitOutputStream.outBits;
        this.totalBits += n;
        this.outBlurbs = this.totalBits / 8;
        return true;
    }

    public void resetReadCRC16(short s) {
        this.readCRC16 = s;
    }

    public short getReadCRC16() {
        return this.readCRC16;
    }

    public short getWriteCRC16() {
        return CRC16.calc(this.buffer, this.outBlurbs);
    }

    public byte getWriteCRC8() {
        return CRC8.calc(this.buffer, this.outBlurbs);
    }

    public boolean isByteAligned() {
        return (this.outBits & 7) == 0;
    }

    public boolean isConsumedByteAligned() {
        return (this.consumedBits & 7) == 0;
    }

    public int bitsLeftForByteAlignment() {
        return 8 - (this.consumedBits & 7);
    }

    public int getInputBytesUnconsumed() {
        return this.totalBits - this.totalConsumedBits >> 3;
    }

    public void writeZeroes(int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (!this.ensureSize(n)) {
            throw new IOException("Memory Allocation Error");
        }
        this.totalBits += n;
        while (n > 0) {
            int n2 = Math.min(8 - this.outBits, n);
            int n3 = this.outBlurbs++;
            this.buffer[n3] = (byte)(this.buffer[n3] << n2);
            n -= n2;
            this.outBits += n2;
            if (this.outBits != 8) continue;
            this.outBits = 0;
        }
    }

    public void writeRawUInt(boolean bl, int n) throws IOException {
        this.writeRawUInt(bl ? 1 : 0, n);
    }

    public void writeRawUInt(int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.outCapacity << 3 < this.totalBits + n2 && !this.ensureSize(n2)) {
            throw new IOException("Memory allocation error");
        }
        if (n2 < 32) {
            n &= ~(-1 << n2);
        }
        this.totalBits += n2;
        while (n2 > 0) {
            int n3;
            int n4 = 8 - this.outBits;
            if (n4 == 8) {
                if (n2 < 8) {
                    this.buffer[this.outBlurbs] = (byte)n;
                    this.outBits = n2;
                    break;
                }
                if (n2 == 8) {
                    this.buffer[this.outBlurbs++] = (byte)n;
                    break;
                }
                n3 = n2 - 8;
                this.buffer[this.outBlurbs++] = (byte)(n >> n3);
                n &= ~(-1 << n3);
                n2 -= 8;
                continue;
            }
            if (n2 <= n4) {
                int n5 = this.outBlurbs;
                this.buffer[n5] = (byte)(this.buffer[n5] << n2);
                int n6 = this.outBlurbs++;
                this.buffer[n6] = (byte)(this.buffer[n6] | n);
                if (n2 == n4) {
                    this.outBits = 0;
                    break;
                }
                this.outBits += n2;
                break;
            }
            n3 = n2 - n4;
            int n7 = this.outBlurbs;
            this.buffer[n7] = (byte)(this.buffer[n7] << n4);
            int n8 = this.outBlurbs++;
            this.buffer[n8] = (byte)(this.buffer[n8] | n >> n3);
            n &= ~(-1 << n3);
            n2 -= n4;
            this.outBits = 0;
        }
    }

    public void writeRawInt(int n, int n2) throws IOException {
        this.writeRawUInt(n, n2);
    }

    public void writeRawULong(long l, int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (!this.ensureSize(n)) {
            throw new IOException("Memory Allocate Error");
        }
        l &= MASK32[n];
        this.totalBits += n;
        while (n > 0) {
            int n2;
            if (this.outBits == 0) {
                if (n < 8) {
                    this.buffer[this.outBlurbs] = (byte)l;
                    this.outBits = n;
                    break;
                }
                if (n == 8) {
                    this.buffer[this.outBlurbs++] = (byte)l;
                    break;
                }
                n2 = n - 8;
                this.buffer[this.outBlurbs++] = (byte)(l >> n2);
                l &= -1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
                n -= 8;
                continue;
            }
            n2 = Math.min(8 - this.outBits, n);
            int n3 = n - n2;
            int n4 = this.outBlurbs;
            this.buffer[n4] = (byte)(this.buffer[n4] << n2);
            int n5 = this.outBlurbs++;
            this.buffer[n5] = (byte)((long)this.buffer[n5] | l >> n3);
            l &= -1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
            n -= n2;
            this.outBits += n2;
            if (this.outBits != 8) continue;
            this.outBits = 0;
        }
    }

    public void writeRawUIntLittleEndian(int n) throws IOException {
        this.writeRawUInt(n, 8);
        this.writeRawUInt(n >> 8, 8);
        this.writeRawUInt(n >> 16, 8);
        this.writeRawUInt(n >> 24, 8);
    }

    public void writeByteBlock(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.writeRawUInt(byArray[n2], 8);
            ++n2;
        }
    }

    public void writeUnaryUnsigned(int n) throws IOException {
        if (n < 32) {
            this.writeRawUInt(1, ++n);
        } else if (n < 64) {
            this.writeRawULong(1L, ++n);
        } else {
            this.writeZeroes(n);
            this.writeRawUInt(1, 1);
        }
    }

    public int riceBits(int n, int n2) {
        int n3 = n < 0 ? (-(++n) << 1) + 1 : n << 1;
        int n4 = n3 >> n2;
        return 1 + n2 + n4;
    }

    public void writeRiceSigned(int n, int n2) throws IOException {
        int n3 = n < 0 ? (-(++n) << 1) + 1 : n << 1;
        int n4 = n3 >> n2;
        int n5 = 1 + n2;
        int n6 = n5 + n4;
        int n7 = 1 << n2;
        n7 |= n3 & (1 << n2) - 1;
        if (n6 <= 32) {
            this.writeRawUInt(n7, n6);
        } else {
            this.writeZeroes(n4);
            this.writeRawUInt(n7, n5);
        }
    }

    public void writeUTF8UInt(int n) throws IOException {
        if (n < 128) {
            this.writeRawUInt(n, 8);
        } else if (n < 2048) {
            this.writeRawUInt(0xC0 | n >> 6, 8);
            this.writeRawUInt(0x80 | n & 0x3F, 8);
        } else if (n < 65536) {
            this.writeRawUInt(0xE0 | n >> 12, 8);
            this.writeRawUInt(0x80 | n >> 6 & 0x3F, 8);
            this.writeRawUInt(0x80 | n & 0x3F, 8);
        } else if (n < 0x200000) {
            this.writeRawUInt(0xF0 | n >> 18, 8);
            this.writeRawUInt(0x80 | n >> 12 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 6 & 0x3F, 8);
            this.writeRawUInt(0x80 | n & 0x3F, 8);
        } else if (n < 0x4000000) {
            this.writeRawUInt(0xF8 | n >> 24, 8);
            this.writeRawUInt(0x80 | n >> 18 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 12 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 6 & 0x3F, 8);
            this.writeRawUInt(0x80 | n & 0x3F, 8);
        } else {
            this.writeRawUInt(0xFC | n >> 30, 8);
            this.writeRawUInt(0x80 | n >> 24 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 18 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 12 & 0x3F, 8);
            this.writeRawUInt(0x80 | n >> 6 & 0x3F, 8);
            this.writeRawUInt(0x80 | n & 0x3F, 8);
        }
    }

    public void writeUTF8ULong(long l) throws IOException {
        if (l < 128L) {
            this.writeRawUInt((int)l, 8);
        } else if (l < 2048L) {
            this.writeRawUInt(0xC0 | (int)(l >> 6), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        } else if (l < 65536L) {
            this.writeRawUInt(0xE0 | (int)(l >> 12), 8);
            this.writeRawUInt(0x80 | (int)(l >> 6 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        } else if (l < 0x200000L) {
            this.writeRawUInt(0xF0 | (int)(l >> 18), 8);
            this.writeRawUInt(0x80 | (int)(l >> 12 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 6 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        } else if (l < 0x4000000L) {
            this.writeRawUInt(0xF8 | (int)(l >> 24), 8);
            this.writeRawUInt(0x80 | (int)(l >> 18 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 12 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 6 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        } else if (l < Integer.MIN_VALUE) {
            this.writeRawUInt(0xFC | (int)(l >> 30), 8);
            this.writeRawUInt(0x80 | (int)(l >> 24 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 18 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 12 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 6 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        } else {
            this.writeRawUInt(254, 8);
            this.writeRawUInt(0x80 | (int)(l >> 30 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 24 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 18 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 12 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l >> 6 & 0x3FL), 8);
            this.writeRawUInt(0x80 | (int)(l & 0x3FL), 8);
        }
    }

    public void zeroPadToByteBoundary() throws IOException {
        if ((this.outBits & 7) != 0) {
            this.writeZeroes(8 - (this.outBits & 7));
        }
    }

    public void flushByteAligned() throws IOException {
        this.zeroPadToByteBoundary();
        if (this.outBlurbs == 0) {
            return;
        }
        this.os.write(this.buffer, 0, this.outBlurbs);
        this.outBlurbs = 0;
    }

    public int getTotalBits() {
        return this.totalBits;
    }

    public int getTotalBlurbs() {
        return (this.totalBits + 7) / 8;
    }
}

