/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2ExtendedHeader;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Footer;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Frame;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Frames;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Header;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3v2Tag {
    private static final String ENC_TYPE = "ISO-8859-1";
    private ID3v2Header head = null;
    private ID3v2ExtendedHeader ext_head = null;
    private ID3v2Frames<String, ID3v2Frame> frames = new ID3v2Frames();
    private ID3v2Footer foot = null;
    private int padding;
    private int origSize;
    private int origPadding;
    private boolean exists;

    public ID3v2Tag(RandomAccessInputStream randomAccessInputStream) throws FileNotFoundException, IOException, ID3v2FormatException {
        this.head = new ID3v2Header(randomAccessInputStream);
        this.padding = 0;
        this.exists = this.head.headerExists();
        if (this.exists) {
            if (this.head.getExtendedHeader()) {
                this.ext_head = new ID3v2ExtendedHeader(randomAccessInputStream);
            }
            if (this.head.getFooter()) {
                this.foot = new ID3v2Footer(randomAccessInputStream, this.head.getTagSize() + this.head.getHeaderSize());
            }
            if (this.head.getMajorVersion() >= 3) {
                this.parseFrames(randomAccessInputStream);
            }
            this.origSize = this.getSize();
            this.origPadding = this.getPadding();
        }
    }

    private void parseFrames(RandomAccessInputStream randomAccessInputStream) throws FileNotFoundException, IOException, ID3v2FormatException {
        int n = this.head.getHeaderSize();
        int n2 = this.head.getTagSize();
        if (this.head.getExtendedHeader()) {
            n2 -= this.ext_head.getSize();
            n += this.ext_head.getSize();
        }
        randomAccessInputStream.seek(n);
        int n3 = 0;
        boolean bl = false;
        while (n3 < n2 && !bl) {
            byte[] byArray = new byte[4];
            n3 += randomAccessInputStream.read(byArray);
            if (byArray[0] != 0) {
                String string = new String(byArray);
                n3 += randomAccessInputStream.read(byArray);
                int n4 = Helpers.convertDWordToInt(byArray, 0);
                byte[] byArray2 = new byte[2];
                n3 += randomAccessInputStream.read(byArray2);
                byte[] byArray3 = new byte[n4];
                n3 += randomAccessInputStream.read(byArray3);
                ID3v2Frame iD3v2Frame = new ID3v2Frame(string, byArray2, byArray3);
                this.frames.put(string, iD3v2Frame);
                continue;
            }
            bl = true;
            this.padding = n2 - n3 - byArray.length;
        }
    }

    public void writeTag(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        int n = this.getSize();
        this.origPadding = this.padding;
        this.padding = this.getUpdatedPadding();
        if (this.padding > this.origPadding || this.padding == this.origPadding && n == this.origSize) {
            byte[] byArray = this.getBytes();
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
        } else {
            int n2 = (int)(randomAccessFile.length() + (long)n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.getBytes(), 0, byArray, 0, n);
            int n3 = (int)(randomAccessFile.length() - (long)this.origSize);
            byte[] byArray2 = new byte[n3];
            randomAccessFile.seek(this.origSize);
            if (randomAccessFile.read(byArray2) != byArray2.length) {
                throw new IOException("Error reading mp3 file before writing");
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            randomAccessFile.setLength(n3);
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
        }
        this.origSize = n;
        this.exists = true;
    }

    public void removeTag(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException {
        if (this.exists) {
            int n = (int)(randomAccessFile.length() - (long)this.origSize);
            byte[] byArray = new byte[n];
            randomAccessFile.seek(this.origSize);
            if (randomAccessFile.read(byArray) != byArray.length) {
                throw new IOException("Error encountered while removing id3v2 tag.");
            }
            randomAccessFile.setLength(n);
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
            this.exists = false;
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.getSize() + this.padding];
        int n = 0;
        int n2 = 0;
        n2 = this.head.getHeaderSize();
        System.arraycopy(this.head.getBytes(), 0, byArray, n, n2);
        n += n2;
        if (this.head.getExtendedHeader()) {
            n2 = this.ext_head.getSize();
            System.arraycopy(this.ext_head.getBytes(), 0, byArray, n, n2);
            n += n2;
        }
        n2 = this.frames.getLength();
        System.arraycopy(this.frames.getBytes(), 0, byArray, n, n2);
        System.arraycopy(new byte[this.padding], 0, byArray, n += n2, this.padding);
        n += this.padding;
        if (this.head.getFooter()) {
            n2 = this.foot.getFooterSize();
            System.arraycopy(this.foot.getBytes(), 0, byArray, n, n2);
            n += n2;
        }
        return byArray;
    }

    private int getUpdatedPadding() {
        int n = this.getSize();
        int n2 = 0;
        if (this.origPadding == this.padding && n > this.origSize && this.padding >= n - this.origSize) {
            n2 = this.padding - (n - this.origSize);
        } else if (n < this.origSize) {
            n2 = this.origSize - n + this.padding;
        }
        return n2;
    }

    public void setTextFrame(String string, String string2) {
        if (string.charAt(0) == 'T' && !string.equals("TXXX")) {
            try {
                byte[] byArray = new byte[string2.length() + 1];
                byArray[0] = 0;
                System.arraycopy(string2.getBytes(ENC_TYPE), 0, byArray, 1, string2.length());
                this.updateFrameData(string, byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void setURLFrame(String string, String string2) {
        if (string.charAt(0) == 'W' && !string.equals("WXXX")) {
            this.updateFrameData(string, string2.getBytes());
        }
    }

    public void setUserDefinedTextFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 2];
            int n = 0;
            byArray[n++] = 0;
            System.arraycopy(string.getBytes(ENC_TYPE), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes(ENC_TYPE), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData("TXXX", byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void setUserDefinedURLFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 2];
            int n = 0;
            byArray[n++] = 0;
            System.arraycopy(string.getBytes(ENC_TYPE), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes(), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData("WXXX", byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void setCommentFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 5];
            int n = 0;
            byArray[n++] = 0;
            byArray[n++] = 101;
            byArray[n++] = 110;
            byArray[n++] = 103;
            System.arraycopy(string.getBytes(ENC_TYPE), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes(ENC_TYPE), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData("COMM", byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void removeFrame(String string) {
        this.frames.remove(string);
        this.updateSize();
    }

    public void updateFrameData(String string, byte[] byArray) {
        if (this.frames.containsKey(string)) {
            ((ID3v2Frame)this.frames.get(string)).setFrameData(byArray);
        } else {
            ID3v2Frame iD3v2Frame = new ID3v2Frame(string, byArray);
            this.frames.put(string, iD3v2Frame);
        }
        this.updateSize();
    }

    public String getFrameDataString(String string) {
        try {
            if (this.frames.containsKey(string)) {
                return ((ID3v2Frame)this.frames.get(string)).getDataString();
            }
        }
        catch (ID3v2FormatException iD3v2FormatException) {
            Log.error("ID3v2Tag:", iD3v2FormatException);
        }
        return null;
    }

    public byte[] getFrameData(String string) {
        if (this.frames.containsKey(string)) {
            return ((ID3v2Frame)this.frames.get(string)).getFrameData();
        }
        return null;
    }

    private void updateSize() {
        int n = this.frames.getLength();
        if (this.head.getExtendedHeader()) {
            n += this.ext_head.getSize();
        }
        this.head.setTagSize(n);
        if (this.head.getFooter()) {
            this.foot.setTagSize(n);
        }
    }

    public boolean tagExists() {
        return this.exists;
    }

    public int getSize() {
        int n = this.head.getTagSize() + this.head.getHeaderSize();
        if (this.head.getFooter()) {
            n += this.foot.getFooterSize();
        }
        return n;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        if (!this.head.getFooter() && n >= 0) {
            this.padding = n;
        }
    }

    public String toString() {
        String string = this.head.toString();
        string = String.valueOf(string) + "\nPadding:\t\t\t" + this.getPadding() + " bytes";
        if (this.head.getExtendedHeader()) {
            string = String.valueOf(string) + "\n" + this.ext_head.toString();
        }
        string = String.valueOf(string) + "\n" + this.frames.toString();
        if (this.head.getFooter()) {
            string = String.valueOf(string) + this.foot.toString();
        }
        return string;
    }
}

