/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.mp3.streaming.IcyInputStream;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import de.quippy.javamod.system.Log;
import de.quippy.mp3.decoder.Bitstream;
import de.quippy.mp3.decoder.BitstreamException;
import de.quippy.mp3.decoder.Decoder;
import de.quippy.mp3.decoder.Header;
import de.quippy.mp3.decoder.SampleBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;

public class MP3Mixer
extends BasicMixer {
    private byte[] output;
    private InputStream inputStream;
    private Bitstream bitStream;
    private Decoder decoder;
    private URL mp3FileUrl;
    private TagParseListener tagParseListener;
    private int played_ms;
    private Boolean isStreaming;

    public MP3Mixer(URL uRL) {
        this.mp3FileUrl = uRL;
    }

    public void setTagParserListener(TagParseListener tagParseListener) {
        this.tagParseListener = tagParseListener;
    }

    private void initialize() {
        try {
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException bitstreamException) {
                    Log.error("IGNORED", bitstreamException);
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            if (!this.isStreaming()) {
                this.inputStream = new FileOrPackedInputStream(this.mp3FileUrl);
            } else {
                URLConnection uRLConnection = this.mp3FileUrl.openConnection();
                uRLConnection.setRequestProperty("Icy-Metadata", "1");
                this.inputStream = new IcyInputStream((InputStream)new BufferedInputStream(uRLConnection.getInputStream()), this.tagParseListener);
            }
            this.bitStream = new Bitstream(this.inputStream);
            this.decoder = new Decoder();
            this.played_ms = 0;
        }
        catch (Exception exception) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            Log.error("[MP3Mixer]", exception);
        }
    }

    private boolean isStreaming() {
        if (this.isStreaming == null) {
            if (this.mp3FileUrl.getProtocol().equalsIgnoreCase("file")) {
                this.isStreaming = Boolean.FALSE;
            } else {
                try {
                    URLConnection uRLConnection = this.mp3FileUrl.openConnection();
                    int n = uRLConnection.getContentLength();
                    this.isStreaming = n == -1 ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable throwable) {
                    Log.error("[MP3Mixer::isStreamaing]", throwable);
                }
            }
        }
        return this.isStreaming;
    }

    @Override
    public boolean isSeekSupported() {
        return !this.isStreaming();
    }

    @Override
    public long getMillisecondPosition() {
        if (!this.isStreaming()) {
            return this.played_ms;
        }
        return 0L;
    }

    @Override
    public long getLengthInMilliseconds() {
        if (!this.isStreaming()) {
            try {
                this.initialize();
                Header header = this.bitStream.readFrame();
                if (header != null) {
                    return (long)((double)header.total_ms(this.inputStream.available()) + 0.5);
                }
            }
            catch (Throwable throwable) {
                Log.error("IGNORED", throwable);
            }
        }
        return 0L;
    }

    @Override
    protected void seek(long l) {
        block10: {
            try {
                if (this.isStreaming()) break block10;
                if ((long)this.played_ms > l) {
                    if (this.bitStream != null) {
                        try {
                            this.bitStream.close();
                            this.bitStream = null;
                        }
                        catch (BitstreamException bitstreamException) {
                            Log.error("IGNORED", bitstreamException);
                        }
                    }
                    if (this.inputStream != null) {
                        try {
                            this.inputStream.close();
                            this.inputStream = null;
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                    this.inputStream = this.mp3FileUrl.openStream();
                    this.bitStream = new Bitstream(this.inputStream);
                    this.decoder = new Decoder();
                    this.played_ms = 0;
                }
                float f = this.played_ms;
                while (f < (float)l) {
                    Header header = this.bitStream.readFrame();
                    if (header == null) break;
                    f += header.ms_per_frame();
                    this.bitStream.closeFrame();
                }
                this.played_ms = (int)((double)f + 0.5);
            }
            catch (Throwable throwable) {
                Log.error("[MP3Mixer]", throwable);
            }
        }
    }

    @Override
    public int getChannelCount() {
        if (this.decoder != null) {
            return this.decoder.getOutputChannels();
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        Header header;
        if (this.bitStream != null && (header = this.bitStream.getHeader()) != null) {
            return header.bitrate_instant() / 1000;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.decoder != null) {
            return this.decoder.getOutputFrequency() / 1000;
        }
        return 0;
    }

    private byte[] getOutputBuffer(int n) {
        if (this.output == null || this.output.length < n) {
            this.output = new byte[n];
        }
        return this.output;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            Header header = this.bitStream.readFrame();
            if (header == null) {
                return;
            }
            SampleBuffer sampleBuffer = (SampleBuffer)this.decoder.decodeFrame(header, this.bitStream);
            this.setAudioFormat(new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                do {
                    short[] sArray = sampleBuffer.getBuffer();
                    this.played_ms += sArray.length / this.decoder.getOutputChannels() * 1000 / this.decoder.getOutputFrequency();
                    int n = sampleBuffer.getBufferLength();
                    int n2 = n << 1;
                    byte[] byArray = this.getOutputBuffer(n2);
                    int n3 = 0;
                    int n4 = 0;
                    while (n-- > 0) {
                        short s = sArray[n4++];
                        byArray[n3++] = (byte)s;
                        byArray[n3++] = (byte)(s >>> 8);
                    }
                    this.writeSampleDataToLine(byArray, 0, n2);
                    this.bitStream.closeFrame();
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.isInSeeking()) {
                        this.setIsSeeking();
                        while (this.isInSeeking()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if ((header = this.bitStream.readFrame()) == null) continue;
                    sampleBuffer = (SampleBuffer)this.decoder.decodeFrame(header, this.bitStream);
                } while (header != null);
                if (header == null) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException bitstreamException) {
                    Log.error("IGNORED", bitstreamException);
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }
}

