/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer.interpolation;

public class CubicSpline {
    public static final int SPLINE_QUANTBITS = 14;
    private static final int SPLINE_QUANTSCALE = 16384;
    private static final int SPLINE_FRACBITS = 10;
    private static final int SPLINE_LUTLEN = 1024;
    public static final int SPLINE_FRACSHIFT = 4;
    public static final int SPLINE_FRACMASK = 4092;
    public static final int[] lut = new int[4096];

    static {
        CubicSpline.initialize();
    }

    private CubicSpline() {
    }

    private static void initialize() {
        double d = 9.765625E-4;
        double d2 = 16384.0;
        int n = 0;
        while (n < 1024) {
            double d3 = (double)n * d;
            int n2 = n << 2;
            double d4 = Math.floor(0.5 + d2 * (-0.5 * d3 * d3 * d3 + 1.0 * d3 * d3 - 0.5 * d3));
            double d5 = Math.floor(0.5 + d2 * (1.5 * d3 * d3 * d3 - 2.5 * d3 * d3 + 1.0));
            double d6 = Math.floor(0.5 + d2 * (-1.5 * d3 * d3 * d3 + 2.0 * d3 * d3 + 0.5 * d3));
            double d7 = Math.floor(0.5 + d2 * (0.5 * d3 * d3 * d3 - 0.5 * d3 * d3));
            CubicSpline.lut[n2 + 0] = (int)(d4 < -d2 ? -d2 : (d4 > d2 ? d2 : d4));
            CubicSpline.lut[n2 + 1] = (int)(d5 < -d2 ? -d2 : (d5 > d2 ? d2 : d5));
            CubicSpline.lut[n2 + 2] = (int)(d6 < -d2 ? -d2 : (d6 > d2 ? d2 : d6));
            CubicSpline.lut[n2 + 3] = (int)(d7 < -d2 ? -d2 : (d7 > d2 ? d2 : d7));
            int n3 = lut[n2 + 0] + lut[n2 + 1] + lut[n2 + 2] + lut[n2 + 3];
            if (n3 != 16384) {
                int n4 = n2;
                if (lut[n2 + 1] > lut[n4]) {
                    n4 = n2 + 1;
                }
                if (lut[n2 + 2] > lut[n4]) {
                    n4 = n2 + 2;
                }
                if (lut[n2 + 3] > lut[n4]) {
                    n4 = n2 + 3;
                }
                int n5 = n4;
                lut[n5] = lut[n5] + (16384 - n3);
            }
            ++n;
        }
    }
}

