/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.system.Helpers;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class BasicModMixer {
    protected ChannelMemory[] channelMemory;
    protected int maxChannels;
    protected static final int MAX_NNA_CHANNELS = 200;
    protected int currentTempo;
    protected int currentBPM;
    protected int globalTuning;
    protected int globalVolume;
    protected int globalVolumSlideValue;
    protected boolean useFastSlides;
    protected int frequencyTableType;
    protected int currentTick;
    protected int currentRow;
    protected int currentArrangement;
    protected int currentPatternIndex;
    protected int samplePerTicks;
    protected int patternDelayCount;
    protected int patternTicksDelayCount;
    protected Pattern currentPattern;
    protected int volRampLen;
    protected int patternBreakRowIndex;
    protected int patternPosJumpPatternIndex;
    protected boolean jumpLoopPositionSet;
    protected int jumpLoopPatternIndex;
    protected int jumpLoopPatternRow;
    protected int jumpLoopRepeatCount;
    protected final Module mod;
    protected int sampleRate;
    protected int doISP;
    protected int doNoLoops;
    protected boolean doFastForward;
    protected boolean modFinished;
    protected boolean doFadeOut;
    protected int fadeOutValue;
    protected int fadeOutFac;
    protected int fadeOutSub;
    protected int[] vRampL;
    protected int[] vRampR;
    protected int[] nvRampL;
    protected int[] nvRampR;

    public BasicModMixer(Module module, int n, int n2, int n3) {
        this.mod = module;
        this.sampleRate = n;
        this.doISP = n2;
        this.doNoLoops = n3;
        this.maxChannels = module.getNChannels();
        if (module.getModType() == 8) {
            this.maxChannels += 200;
        }
        this.channelMemory = new ChannelMemory[this.maxChannels];
        this.vRampL = new int[16];
        this.vRampR = new int[16];
        this.nvRampL = new int[16];
        this.nvRampR = new int[16];
        this.initializeMixer();
    }

    public void changeSampleRate(int n) {
        this.sampleRate = n;
        this.samplePerTicks = this.calculateSamplesPerTick();
        this.calculateGlobalTuning();
        this.calculateVolRampLen();
        int n2 = 0;
        while (n2 < this.maxChannels) {
            ChannelMemory channelMemory = this.channelMemory[n2];
            this.setNewPlayerTuningFor(channelMemory);
            ++n2;
        }
    }

    public void changeISP(int n) {
        this.doISP = n;
    }

    public void changeDoNoLoops(int n) {
        this.doNoLoops = n;
    }

    public void setIsFastForward(boolean bl) {
        this.doFastForward = bl;
    }

    protected abstract void initializeMixer(int var1, ChannelMemory var2);

    public void initializeMixer() {
        this.calculateGlobalTuning();
        this.frequencyTableType = this.mod.getFrequencyTable();
        this.currentTempo = this.mod.getTempo();
        this.currentBPM = this.mod.getBPMSpeed();
        this.globalVolume = this.mod.getBaseVolume();
        this.globalVolumSlideValue = 0;
        this.useFastSlides = this.mod.doFastSlides();
        this.samplePerTicks = this.calculateSamplesPerTick();
        this.patternTicksDelayCount = 0;
        this.patternDelayCount = 0;
        this.currentRow = 0;
        this.currentArrangement = 0;
        this.currentTick = 0;
        this.currentArrangement = 0;
        this.currentPatternIndex = this.mod.getArrangement()[this.currentArrangement];
        this.currentPattern = this.mod.getPatternContainer().getPattern(this.currentPatternIndex);
        this.patternPosJumpPatternIndex = -1;
        this.patternBreakRowIndex = -1;
        this.jumpLoopPositionSet = false;
        this.jumpLoopRepeatCount = -1;
        this.jumpLoopPatternRow = -1;
        this.jumpLoopPatternIndex = -1;
        this.modFinished = false;
        this.calculateVolRampLen();
        this.mod.resetLoopRecognition();
        this.doFadeOut = false;
        this.fadeOutFac = 8;
        this.fadeOutValue = 1 << this.fadeOutFac;
        this.fadeOutSub = 1;
        int n = this.mod.getNChannels();
        int n2 = 0;
        while (n2 < this.maxChannels) {
            this.channelMemory[n2] = new ChannelMemory();
            if (n2 < n) {
                ChannelMemory channelMemory = this.channelMemory[n2];
                channelMemory.panning = this.mod.getPanningValue(n2);
                channelMemory.channelVolume = this.mod.getChannelVolume(n2);
                this.initializeMixer(n2, channelMemory);
            }
            ++n2;
        }
    }

    protected int calculateSamplesPerTick() {
        return ((this.sampleRate << 1) + (this.sampleRate >> 1)) / this.currentBPM;
    }

    private void calculateGlobalTuning() {
        this.globalTuning = (int)(3753235185664L / (long)this.sampleRate);
    }

    private void calculateVolRampLen() {
        this.volRampLen = this.sampleRate * 146 / 100000;
        if (this.volRampLen < 8) {
            this.volRampLen = 8;
        }
    }

    protected int getFineTunePeriod(ChannelMemory channelMemory, int n) {
        int n2 = n - 1;
        switch (this.frequencyTableType) {
            case 0: 
            case 1: {
                int n3 = Helpers.FreqS3MTable[n2 % 12];
                int n4 = n2 / 12;
                if (channelMemory.currentFinetuneFrequency <= 0) {
                    channelMemory.currentFinetuneFrequency = 8363;
                }
                return (int)(8363L * ((long)n3 << 7) / ((long)channelMemory.currentFinetuneFrequency << n4));
            }
            case 2: {
                return Helpers.protracker_fineTunedPeriods[(channelMemory.currentFineTune >> 4) + 8][n - 25];
            }
            case 16: {
                if ((n2 -= 12) < 0) {
                    n2 = 0;
                }
            }
            case 4: {
                int n5 = channelMemory.currentFineTune;
                int n6 = n5 >> 4;
                int n7 = (n2 % 12 << 3) + 8;
                int n8 = n2 / 12;
                int n9 = n7 + n6;
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 103) {
                    n9 = 103;
                }
                int n10 = Helpers.logtab[n9];
                if (n5 < 0) {
                    --n6;
                    n5 = -n5;
                } else {
                    ++n6;
                }
                n9 = n7 + n6;
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 103) {
                    n9 = 103;
                }
                int n11 = Helpers.logtab[n9];
                n6 = n5 & 0xF;
                return n10 * (16 - n6) + n11 * n6 >> n8 + 4;
            }
            case 8: {
                int n12 = 7680 - (n2 << 6) - (channelMemory.currentFineTune >> 1);
                if (n12 < 1) {
                    return 4;
                }
                return n12 << 2;
            }
        }
        return (int)(8363L * (long)n / (long)channelMemory.currentFinetuneFrequency);
    }

    protected int getFineTunePeriod(ChannelMemory channelMemory) {
        if (this.frequencyTableType >= 2) {
            return channelMemory.assignedNoteIndex == 0 ? 0 : this.getFineTunePeriod(channelMemory, channelMemory.assignedNoteIndex + channelMemory.currentTranspose);
        }
        if (this.frequencyTableType == 1 || this.frequencyTableType == 0) {
            return channelMemory.assignedNoteIndex == 0 ? 0 : this.getFineTunePeriod(channelMemory, channelMemory.assignedNoteIndex);
        }
        return channelMemory.assignedNotePeriod == 0 ? 0 : this.getFineTunePeriod(channelMemory, channelMemory.assignedNotePeriod << 4);
    }

    protected void setNewPlayerTuningFor(ChannelMemory channelMemory, int n) {
        if (n <= 0) {
            channelMemory.currentTuning = 0;
        } else if (this.frequencyTableType == 8) {
            int n2 = Helpers.lintab[(n >>= 2) % 768] >> n / 768;
            channelMemory.currentTuning = (int)(((long)n2 << 16) / (long)this.sampleRate);
        } else {
            channelMemory.currentTuning = this.globalTuning / n;
        }
    }

    protected void setNewPlayerTuningFor(ChannelMemory channelMemory) {
        this.setNewPlayerTuningFor(channelMemory, channelMemory.currentNotePeriod);
    }

    protected long cutOffToFrequency(long l, int n, boolean bl) {
        double d = bl ? 10240.0 : 12288.0;
        double d2 = 110.0 * Math.pow(2.0, 0.25 + (double)(l * (long)(n + 256)) / d);
        long l2 = (long)d2;
        if (l2 < 120L) {
            return 120L;
        }
        if (l2 > 20000L) {
            return 20000L;
        }
        if (l2 << 1 > (long)this.sampleRate) {
            return (long)this.sampleRate >> 1;
        }
        return l2;
    }

    protected void setupChannelFilter(ChannelMemory channelMemory, boolean bl, int n) {
        double d = channelMemory.nCutOff + channelMemory.nCutSwing & 0x7F;
        double d2 = channelMemory.nResonance + channelMemory.nResSwing & 0x7F;
        double d3 = this.cutOffToFrequency((long)d, n, (this.mod.getSongFlags() & 0x8000) != 0);
        double d4 = Math.pow(10.0, -(0.1875 * d2) / 20.0);
        double d5 = (1.0 - 2.0 * d4) * (d3 *= 6.28318530716 / (double)this.sampleRate);
        if (d5 > 2.0) {
            d5 = 2.0;
        }
        d5 = (2.0 * d4 - d5) / d3;
        double d6 = Math.pow(1.0 / d3, 2.0);
        double d7 = 1.0 / (1.0 + d5 + d6);
        double d8 = -d6 * d7;
        double d9 = 1.0 - d7 - d8;
        switch (channelMemory.nFilterMode) {
            case 1: {
                channelMemory.nFilter_A0 = (long)((1.0 - d7) * 4.294967296E9);
                channelMemory.nFilter_B0 = (long)(d9 * 4.294967296E9);
                channelMemory.nFilter_B1 = (long)(d8 * 4.294967296E9);
                channelMemory.nFilter_HP = -1L;
                break;
            }
            default: {
                channelMemory.nFilter_A0 = (long)(d7 * 4.294967296E9);
                channelMemory.nFilter_B0 = (long)(d9 * 4.294967296E9);
                channelMemory.nFilter_B1 = (long)(d8 * 4.294967296E9);
                channelMemory.nFilter_HP = 0L;
            }
        }
        if (bl) {
            channelMemory.nFilter_Y2 = 0L;
            channelMemory.nFilter_Y1 = 0L;
        }
        channelMemory.filterOn = true;
    }

    private long doResonance(ChannelMemory channelMemory, long l) {
        long l2 = l * channelMemory.nFilter_A0 + channelMemory.nFilter_Y1 * channelMemory.nFilter_B0 + channelMemory.nFilter_Y2 * channelMemory.nFilter_B1 + 4096L >> 32;
        channelMemory.nFilter_Y2 = channelMemory.nFilter_Y1;
        channelMemory.nFilter_Y1 = l2 - (l & channelMemory.nFilter_HP);
        return l2;
    }

    protected abstract void doRowEffects(ChannelMemory var1);

    protected abstract void doTickEffekts(ChannelMemory var1);

    protected abstract void doVolumeColumnRowEffekt(ChannelMemory var1);

    protected abstract void doVolumeColumnTickEffekt(ChannelMemory var1);

    protected abstract void resetAllEffects(ChannelMemory var1, PatternElement var2, boolean var3);

    protected abstract boolean isNoteDelayEffekt(ChannelMemory var1);

    protected abstract boolean isPortaToNoteEffekt(ChannelMemory var1);

    protected abstract boolean isSampleOffsetEffekt(ChannelMemory var1);

    protected void processEnvelopes(ChannelMemory channelMemory) {
        Object object;
        int n = channelMemory.currentVolume << 8;
        int n2 = channelMemory.panning;
        Instrument instrument = channelMemory.assignedInstrument;
        if (instrument != null) {
            Envelope envelope;
            Envelope envelope2;
            object = instrument.volumeEnvelope;
            if (object != null && ((Envelope)object).on) {
                channelMemory.volEnvPos = ((Envelope)object).updatePosition(channelMemory.volEnvPos, channelMemory.keyOff);
                int n3 = ((Envelope)object).getValueForPosition(channelMemory.volEnvPos);
                n = n * n3 >> 9;
            }
            if ((envelope2 = instrument.panningEnvelope) != null && envelope2.on) {
                channelMemory.panEnvPos = envelope2.updatePosition(channelMemory.panEnvPos, channelMemory.keyOff);
                n2 += envelope2.getValueForPosition(channelMemory.panEnvPos) - 256;
            }
            if (channelMemory.keyOff) {
                if (object != null && ((Envelope)object).on) {
                    channelMemory.fadeOutVolume -= instrument.volumeFadeOut << 1;
                    if (channelMemory.fadeOutVolume < 0) {
                        channelMemory.fadeOutVolume = 0;
                    }
                } else {
                    channelMemory.fadeOutVolume = 0;
                }
                n = n * channelMemory.fadeOutVolume >> 16;
            }
            if ((envelope = instrument.pitchEnvelope) != null && envelope.on) {
                channelMemory.pitchEnvPos = envelope.updatePosition(channelMemory.pitchEnvPos, channelMemory.keyOff);
                int n4 = envelope.getValueForPosition(channelMemory.pitchEnvPos) - 256;
                if (envelope.filter) {
                    this.setupChannelFilter(channelMemory, !channelMemory.filterOn, n4);
                } else {
                    long l = channelMemory.currentNotePeriod;
                    long l2 = 0L;
                    if (n4 < 0) {
                        if ((n4 = -n4) > 255) {
                            n4 = 255;
                        }
                        l2 = Helpers.LinearSlideUpTable[n4];
                    } else {
                        if (n4 > 255) {
                            n4 = 255;
                        }
                        l2 = Helpers.LinearSlideDownTable[n4];
                    }
                    this.setNewPlayerTuningFor(channelMemory, (int)(l * l2 >> 16));
                }
            }
        }
        if (channelMemory.panbrelloOn) {
            int n5;
            int n6 = channelMemory.panbrelloTablePos >> 2 & 0x3F;
            switch (channelMemory.panbrelloType & 3) {
                case 1: {
                    n5 = Helpers.ModRampDownTable[n6];
                    break;
                }
                case 2: {
                    n5 = Helpers.ModSquareTable[n6];
                    break;
                }
                case 3: {
                    n5 = Helpers.ModRandomTable[n6];
                    break;
                }
                default: {
                    n5 = Helpers.ModSinusTable[n6];
                }
            }
            channelMemory.panbrelloTablePos += channelMemory.panbrelloStep;
            n5 = n5 * channelMemory.panbrelloAmplitude + 2 >> 3;
            n2 = (n5 += n2) < 0 ? 0 : (n5 > 255 ? 255 : n5);
        }
        n = n * channelMemory.channelVolume >> 6;
        n = n * this.globalVolume >> 7;
        if ((n = n * this.fadeOutValue >> this.fadeOutFac) < 0) {
            n = 0;
        } else if (n > 16384) {
            n = 16384;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 256) {
            n2 = 256;
        }
        channelMemory.actRampVolLeft = channelMemory.actVolumeLeft;
        channelMemory.actRampVolRight = channelMemory.actVolumeRight;
        channelMemory.actVolumeLeft = n * (256 - n2 << 8);
        channelMemory.actVolumeRight = n * (n2 << 8);
        if (channelMemory.doSurround) {
            channelMemory.actVolumeLeft = -channelMemory.actVolumeLeft;
        }
        if (channelMemory.actVolumeLeft != channelMemory.actRampVolLeft) {
            channelMemory.deltaVolLeft = channelMemory.actVolumeLeft - channelMemory.actRampVolLeft;
            if (channelMemory.deltaVolLeft > this.volRampLen) {
                channelMemory.deltaVolLeft /= this.volRampLen;
            } else if (channelMemory.deltaVolLeft != 0) {
                channelMemory.deltaVolLeft /= channelMemory.deltaVolLeft;
            }
        } else {
            channelMemory.deltaVolLeft = 0;
        }
        if (channelMemory.actVolumeRight != channelMemory.actRampVolRight) {
            channelMemory.deltaVolRight = channelMemory.actVolumeRight - channelMemory.actRampVolRight;
            if (channelMemory.deltaVolRight > this.volRampLen) {
                channelMemory.deltaVolRight /= this.volRampLen;
            } else if (channelMemory.deltaVolRight != 0) {
                channelMemory.deltaVolRight /= channelMemory.deltaVolRight;
            }
        } else {
            channelMemory.deltaVolRight = 0;
        }
        object = channelMemory.currentSample;
        if (object != null && ((Sample)object).vibratoDepth > 0 && channelMemory.currentNotePeriod > 0) {
            int n7;
            if (((Sample)object).vibratoSweep == 0) {
                channelMemory.autoVibratoAmplitude = ((Sample)object).vibratoDepth << 8;
            } else if (!channelMemory.keyOff) {
                channelMemory.autoVibratoAmplitude += (((Sample)object).vibratoDepth << 8) / ((Sample)object).vibratoSweep;
                if (channelMemory.autoVibratoAmplitude >> 8 > ((Sample)object).vibratoDepth) {
                    channelMemory.autoVibratoAmplitude = ((Sample)object).vibratoDepth << 8;
                }
            }
            channelMemory.autoVibratoTablePos += ((Sample)object).vibratoRate;
            switch (((Sample)object).vibratoType & 7) {
                default: {
                    n7 = Helpers.ft2VibratoTable[channelMemory.autoVibratoTablePos & 0xFF];
                    break;
                }
                case 1: {
                    n7 = (channelMemory.autoVibratoTablePos & 0x80) == 128 ? 64 : -64;
                    break;
                }
                case 2: {
                    n7 = (64 + (channelMemory.autoVibratoTablePos >> 1) & 0x7F) - 64;
                    break;
                }
                case 3: {
                    n7 = (64 - (channelMemory.autoVibratoTablePos >> 1) & 0x7F) - 64;
                    break;
                }
                case 4: {
                    n7 = Helpers.ModRandomTable[channelMemory.autoVibratoTablePos & 0x3F];
                }
            }
            n7 = n7 * channelMemory.autoVibratoAmplitude >> 8;
            this.setNewPlayerTuningFor(channelMemory, channelMemory.currentNotePeriod + (n7 >> 4));
        }
    }

    protected void resetInstrument(ChannelMemory channelMemory) {
        channelMemory.currentSamplePos = 0;
        channelMemory.currentTuningPos = 0;
        channelMemory.currentDirection = 0;
        channelMemory.autoVibratoAmplitude = 0;
        channelMemory.autoVibratoTablePos = 0;
        channelMemory.pitchEnvPos = -1;
        channelMemory.panEnvPos = -1;
        channelMemory.volEnvPos = -1;
        channelMemory.instrumentFinished = false;
        channelMemory.filterOn = false;
    }

    public int getCurrentUsedChannels() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxChannels) {
            if (this.isChannelActive(this.channelMemory[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private boolean isChannelActive(ChannelMemory channelMemory) {
        return channelMemory.currentSample != null && channelMemory.currentSample.sample != null && channelMemory.currentTuning != 0 && !channelMemory.instrumentFinished;
    }

    protected void setNewInstrumentAndPeriod(ChannelMemory channelMemory) {
        Instrument instrument;
        PatternElement patternElement = channelMemory.currentElement;
        Sample sample = null;
        if (patternElement.getInstrument() > 0) {
            if (channelMemory.assignedInstrument != null) {
                instrument = channelMemory.assignedInstrument;
                sample = this.mod.getInstrumentContainer().getSample(instrument.getSampleIndex(channelMemory.assignedNoteIndex - 1));
                channelMemory.assignedNoteIndex = instrument.getNoteIndex(channelMemory.assignedNoteIndex - 1) + 1;
                if ((instrument.initialFilterCutoff & 0x80) != 0) {
                    channelMemory.nCutOff = instrument.initialFilterCutoff & 0x7F;
                }
                if ((instrument.initialFilterResonance & 0x80) != 0) {
                    channelMemory.nResonance = instrument.initialFilterResonance & 0x7F;
                }
            } else {
                sample = this.mod.getInstrumentContainer().getSample(channelMemory.assignedInstrumentIndex - 1);
            }
            if (sample != null) {
                int n = sample.panning;
                if (n != -1) {
                    channelMemory.doSurround = false;
                    channelMemory.panning = n;
                }
                channelMemory.fadeOutVolume = 65536;
                channelMemory.currentSetVolume = channelMemory.currentVolume = sample.volume;
            }
        }
        if (patternElement.getPeriod() > 0 || patternElement.getNoteIndex() > 0) {
            this.resetAllEffects(channelMemory, patternElement, true);
            channelMemory.keyOff = false;
            if (channelMemory.assignedInstrument != null || channelMemory.assignedInstrumentIndex > 0) {
                if (sample == null) {
                    if (channelMemory.assignedInstrument != null) {
                        instrument = channelMemory.assignedInstrument;
                        sample = this.mod.getInstrumentContainer().getSample(instrument.getSampleIndex(channelMemory.assignedNoteIndex - 1));
                        channelMemory.assignedNoteIndex = instrument.getNoteIndex(channelMemory.assignedNoteIndex - 1) + 1;
                        if ((instrument.initialFilterCutoff & 0x80) != 0) {
                            channelMemory.nCutOff = instrument.initialFilterCutoff & 0x7F;
                        }
                        if ((instrument.initialFilterResonance & 0x80) != 0) {
                            channelMemory.nResonance = instrument.initialFilterResonance & 0x7F;
                        }
                    } else {
                        sample = this.mod.getInstrumentContainer().getSample(channelMemory.assignedInstrumentIndex - 1);
                    }
                }
                if (channelMemory.currentSample != sample) {
                    channelMemory.currentSample = sample;
                    if (sample != null) {
                        this.resetInstrument(channelMemory);
                        channelMemory.currentFinetuneFrequency = sample.baseFrequency;
                        channelMemory.currentFineTune = sample.fineTune;
                        channelMemory.currentTranspose = sample.transpose;
                    }
                }
            }
            if (channelMemory.currentSample != null && !this.isPortaToNoteEffekt(channelMemory)) {
                this.resetInstrument(channelMemory);
                channelMemory.portaTargetNotePeriod = channelMemory.currentNotePeriod = this.getFineTunePeriod(channelMemory);
                this.setNewPlayerTuningFor(channelMemory, channelMemory.currentNotePeriod);
                instrument = channelMemory.assignedInstrument;
                if (instrument != null) {
                    boolean bl = false;
                    if ((instrument.initialFilterCutoff & 0x80) != 0) {
                        channelMemory.nCutOff = instrument.initialFilterCutoff & 0x7F;
                        bl = true;
                    }
                    if ((instrument.initialFilterResonance & 0x80) != 0) {
                        channelMemory.nResonance = instrument.initialFilterResonance & 0x7F;
                        bl = true;
                    }
                    if (channelMemory.nCutOff < 127 && bl) {
                        this.setupChannelFilter(channelMemory, true, 256);
                    }
                }
            }
        }
    }

    protected void processEffekts(boolean bl, ChannelMemory channelMemory) {
        if (bl) {
            this.doVolumeColumnTickEffekt(channelMemory);
            this.doTickEffekts(channelMemory);
        } else {
            this.doVolumeColumnRowEffekt(channelMemory);
            this.doRowEffects(channelMemory);
        }
        this.processEnvelopes(channelMemory);
    }

    private boolean isInfinitLoop(int n, PatternRow patternRow) {
        return this.mod.isArrangementPositionPlayed(n) && patternRow.isRowPlayed() && !this.jumpLoopPositionSet;
    }

    private boolean isInfinitLoop(int n, int n2) {
        return this.isInfinitLoop(n, this.currentPattern.getPatternRow(n2));
    }

    protected void doRowEvent() {
        PatternRow patternRow = this.currentPattern.getPatternRow(this.currentRow);
        if (patternRow == null) {
            return;
        }
        if (this.isInfinitLoop(this.currentArrangement, this.currentRow) && this.doNoLoops == 1) {
            this.doFadeOut = true;
        }
        patternRow.setRowPlayed();
        int n = this.mod.getNChannels();
        int n2 = 0;
        while (n2 < n) {
            PatternElement patternElement = patternRow.getPatternElement(n2);
            ChannelMemory channelMemory = this.channelMemory[n2];
            this.resetAllEffects(channelMemory, patternElement, false);
            channelMemory.currentElement = patternElement;
            if (patternElement.getPeriod() > 0) {
                channelMemory.assignedNotePeriod = patternElement.getPeriod();
            }
            if (patternElement.getNoteIndex() > 0) {
                channelMemory.assignedNoteIndex = patternElement.getNoteIndex();
            }
            if (patternElement.getInstrument() > 0) {
                channelMemory.assignedInstrumentIndex = patternElement.getInstrument();
                channelMemory.assignedInstrument = this.mod.getInstrumentContainer().getInstrument(patternElement.getInstrument() - 1);
            }
            channelMemory.effekt = patternElement.getEffekt();
            channelMemory.effektParam = patternElement.getEffektOp();
            channelMemory.volumeEffekt = patternElement.getVolumeEffekt();
            channelMemory.volumeEffektOp = patternElement.getVolumeEffektOp();
            if (patternElement.getPeriod() == -1 || patternElement.getNoteIndex() == -1) {
                channelMemory.keyOff = true;
            } else if (patternElement.getPeriod() == -2 || patternElement.getNoteIndex() == -2) {
                channelMemory.fadeOutVolume = 0;
            } else if (!this.isNoteDelayEffekt(channelMemory)) {
                this.setNewInstrumentAndPeriod(channelMemory);
            }
            this.processEffekts(false, channelMemory);
            ++n2;
        }
    }

    protected boolean doTickEvents() {
        block15: {
            int n;
            block16: {
                block17: {
                    block14: {
                        if (this.doFadeOut) {
                            this.fadeOutValue -= this.fadeOutSub;
                            if (this.fadeOutValue <= 0) {
                                return true;
                            }
                        }
                        n = this.maxChannels;
                        if (this.patternTicksDelayCount <= 0) break block14;
                        int n2 = 0;
                        while (n2 < n) {
                            ChannelMemory channelMemory = this.channelMemory[n2];
                            this.processEffekts(true, channelMemory);
                            ++n2;
                        }
                        --this.patternTicksDelayCount;
                        break block15;
                    }
                    --this.currentTick;
                    if (this.currentTick > 0) break block16;
                    this.currentTick = this.currentTempo;
                    if (this.patternDelayCount <= 0) break block17;
                    int n3 = 0;
                    while (n3 < n) {
                        ChannelMemory channelMemory = this.channelMemory[n3];
                        this.processEffekts(false, channelMemory);
                        ++n3;
                    }
                    --this.patternDelayCount;
                    break block15;
                }
                if (this.currentArrangement >= this.mod.getSongLength()) {
                    return true;
                }
                this.doRowEvent();
                ++this.currentRow;
                if (this.currentRow < this.currentPattern.getRowCount() && this.patternBreakRowIndex == -1 && this.patternPosJumpPatternIndex == -1) break block15;
                this.mod.setArrangementPositionPlayed(this.currentArrangement);
                if (this.patternPosJumpPatternIndex != -1) {
                    int n4;
                    int n5 = n4 = this.patternBreakRowIndex != -1 ? this.patternBreakRowIndex : this.currentRow - 1;
                    if (this.isInfinitLoop(this.patternPosJumpPatternIndex, n4) && this.doNoLoops == 2) {
                        this.patternPosJumpPatternIndex = -1;
                        this.patternBreakRowIndex = -1;
                        this.jumpLoopPositionSet = false;
                        ++this.currentArrangement;
                    } else {
                        this.currentArrangement = this.patternPosJumpPatternIndex;
                    }
                    this.patternPosJumpPatternIndex = -1;
                } else {
                    this.jumpLoopPositionSet = false;
                    ++this.currentArrangement;
                }
                if (this.patternBreakRowIndex != -1) {
                    this.currentRow = this.patternBreakRowIndex;
                    this.patternBreakRowIndex = -1;
                } else {
                    this.currentRow = 0;
                }
                if (this.currentArrangement < this.mod.getSongLength()) {
                    this.currentPatternIndex = this.mod.getArrangement()[this.currentArrangement];
                    this.currentPattern = this.mod.getPatternContainer().getPattern(this.currentPatternIndex);
                } else {
                    this.currentPatternIndex = -1;
                    this.currentPattern = null;
                }
                break block15;
            }
            int n6 = 0;
            while (n6 < n) {
                ChannelMemory channelMemory = this.channelMemory[n6];
                this.processEffekts(true, channelMemory);
                ++n6;
            }
        }
        return false;
    }

    protected void fitIntoLoops(ChannelMemory channelMemory) {
        Sample sample = channelMemory.currentSample;
        if (channelMemory.currentDirection >= 0) {
            channelMemory.currentTuningPos += channelMemory.currentTuning;
            if (channelMemory.currentTuningPos >= 65536) {
                channelMemory.currentSamplePos += channelMemory.currentTuningPos >> 16;
                channelMemory.currentTuningPos &= 0xFFFF;
                if ((sample.loopType & 1) == 0) {
                    channelMemory.instrumentFinished = channelMemory.currentSamplePos >= sample.length;
                } else if ((sample.loopType & 4) == 0) {
                    if (channelMemory.currentSamplePos >= sample.repeatStop) {
                        channelMemory.currentSamplePos = sample.repeatStart + (channelMemory.currentSamplePos - sample.repeatStart) % sample.repeatLength;
                    }
                } else if (channelMemory.currentSamplePos >= sample.repeatStop) {
                    channelMemory.currentDirection = -1;
                    channelMemory.currentSamplePos = sample.repeatStop - (channelMemory.currentSamplePos - sample.repeatStart) % sample.repeatLength - 1;
                }
            }
        } else {
            channelMemory.currentTuningPos -= channelMemory.currentTuning;
            if (channelMemory.currentTuningPos <= 0) {
                int n = (-channelMemory.currentTuningPos >> 16) + 1;
                channelMemory.currentSamplePos -= n;
                channelMemory.currentTuningPos += n << 16;
                if (channelMemory.currentSamplePos <= sample.repeatStart) {
                    channelMemory.currentDirection = 1;
                    channelMemory.currentSamplePos = sample.repeatStart + (sample.repeatStart - channelMemory.currentSamplePos) % sample.repeatLength;
                }
            }
        }
    }

    private void mixChannelIntoBuffers(int[] nArray, int[] nArray2, int n, int n2, ChannelMemory channelMemory) {
        int n3 = n;
        while (n3 < n2) {
            long l = channelMemory.currentSample.getInterpolatedSample(this.doISP, channelMemory.currentSamplePos, channelMemory.currentTuningPos);
            if (channelMemory.filterOn) {
                l = this.doResonance(channelMemory, l);
            }
            long l2 = channelMemory.actRampVolLeft;
            if (channelMemory.deltaVolLeft > 0 && l2 > (long)channelMemory.actVolumeLeft || channelMemory.deltaVolLeft < 0 && l2 < (long)channelMemory.actVolumeLeft) {
                channelMemory.actRampVolLeft = channelMemory.actVolumeLeft;
                l2 = channelMemory.actRampVolLeft;
                channelMemory.deltaVolLeft = 0;
            } else {
                channelMemory.actRampVolLeft += channelMemory.deltaVolLeft;
            }
            long l3 = channelMemory.actRampVolRight;
            if (channelMemory.deltaVolRight > 0 && l3 > (long)channelMemory.actVolumeRight || channelMemory.deltaVolRight < 0 && l3 < (long)channelMemory.actVolumeRight) {
                channelMemory.actRampVolRight = channelMemory.actVolumeRight;
                l3 = channelMemory.actRampVolRight;
                channelMemory.deltaVolRight = 0;
            } else {
                channelMemory.actRampVolRight += channelMemory.deltaVolRight;
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] + (int)(l * l2 >> 32);
            int n5 = n3++;
            nArray2[n5] = nArray2[n5] + (int)(l * l3 >> 32);
            this.fitIntoLoops(channelMemory);
            if (channelMemory.instrumentFinished) break;
        }
    }

    private void fillRampDataIntoBuffers(int[] nArray, int[] nArray2, ChannelMemory channelMemory) {
        int n = channelMemory.currentTuningPos;
        int n2 = channelMemory.currentSamplePos;
        int n3 = channelMemory.currentDirection;
        boolean bl = channelMemory.instrumentFinished;
        int n4 = channelMemory.actRampVolLeft;
        int n5 = channelMemory.actRampVolRight;
        this.mixChannelIntoBuffers(nArray, nArray2, 0, 16, channelMemory);
        channelMemory.currentTuningPos = n;
        channelMemory.currentSamplePos = n2;
        channelMemory.instrumentFinished = bl;
        channelMemory.currentDirection = n3;
        channelMemory.actRampVolLeft = n4;
        channelMemory.actRampVolRight = n5;
    }

    public int mixIntoBuffer(int[] nArray, int[] nArray2, int n) {
        if (this.modFinished) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.samplePerTicks;
        int n4 = n - 16;
        while (n3 < n4 && !this.modFinished) {
            int n5 = 0;
            while (n5 < this.maxChannels) {
                ChannelMemory channelMemory = this.channelMemory[n5];
                if (!channelMemory.muted && this.isChannelActive(channelMemory)) {
                    this.mixChannelIntoBuffers(nArray, nArray2, n2, n3, channelMemory);
                    if (!channelMemory.instrumentFinished) {
                        this.fillRampDataIntoBuffers(this.nvRampL, this.nvRampR, channelMemory);
                    }
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < 16) {
                int n6 = 16 - n5;
                nArray[n2 + n5] = nArray[n2 + n5] * n5 + this.vRampL[n5] * n6 >> 4;
                nArray2[n2 + n5] = nArray2[n2 + n5] * n5 + this.vRampR[n5] * n6 >> 4;
                this.vRampL[n5] = this.nvRampL[n5];
                this.vRampR[n5] = this.nvRampR[n5];
                this.nvRampR[n5] = 0;
                this.nvRampL[n5] = 0;
                ++n5;
            }
            n2 += this.samplePerTicks;
            this.modFinished = this.doTickEvents();
            n3 += this.samplePerTicks;
        }
        return n2;
    }

    protected class ChannelMemory {
        public PatternElement currentElement;
        public boolean muted = false;
        public int assignedNotePeriod = 0;
        public int currentNotePeriod = 0;
        public int currentFinetuneFrequency = 0;
        public int assignedNoteIndex;
        public int currentFineTune = 0;
        public int currentTranspose;
        public int currentVolume = 0;
        public int currentSetVolume = 0;
        public int channelVolume = 0;
        public int fadeOutVolume = 65536;
        public int panning = 128;
        public int actVolumeLeft;
        public int actVolumeRight;
        public int actRampVolLeft = 0;
        public int actRampVolRight = 0;
        public int deltaVolLeft = 0;
        public int deltaVolRight = 0;
        public int noteDelayCount = -1;
        public int noteCutCount = -1;
        public Instrument assignedInstrument;
        public int assignedInstrumentIndex;
        public Sample currentSample;
        public int currentTuning = 0;
        public int currentTuningPos = 0;
        public int currentSamplePos = 0;
        public int currentDirection = 0;
        public int volEnvPos = -1;
        public int panEnvPos = -1;
        public int pitchEnvPos = -1;
        public boolean instrumentFinished = true;
        public boolean keyOff = false;
        public int keyOffCounter = -1;
        public int effekt;
        public int effektParam;
        public int volumeEffekt;
        public int volumeEffektOp;
        public int channelVolumSlideValue = 0;
        public boolean glissando = false;
        public int arpegioIndex = -1;
        public int[] arpegioNote = new int[3];
        public int portaStepUp = 0;
        public int portaStepUpEnd = 0;
        public int portaStepDown = 0;
        public int portaStepDownEnd = 0;
        public int finePortaUp = 0;
        public int finePortaDown = 0;
        public int finePortaUpEx = 0;
        public int finePortaDownEx = 0;
        public int portaNoteStep = 0;
        public int portaTargetNotePeriod = 0;
        public int volumSlideValue = 0;
        public int panningSlideValue;
        public int vibratoTablePos = 0;
        public int vibratoStep = 0;
        public int vibratoAmplitude = 0;
        public int vibratoType = 0;
        public boolean vibratoOn = false;
        public boolean vibratoNoRetrig = false;
        public int autoVibratoTablePos = 0;
        public int autoVibratoAmplitude = 0;
        public int tremoloTablePos = 0;
        public int tremoloStep = 0;
        public int tremoloAmplitude = 0;
        public int tremoloType = 0;
        public boolean tremoloOn = false;
        public boolean tremoloNoRetrig = false;
        public int panbrelloTablePos = 0;
        public int panbrelloStep = 0;
        public int panbrelloAmplitude = 0;
        public int panbrelloType = 0;
        public boolean panbrelloOn = false;
        public boolean panbrelloNoRetrig = false;
        public int tremorCount = 0;
        public int tremorOntime = 0;
        public int tremorOfftime = 0;
        public int retrigCount = 0;
        public int retrigMemo = 0;
        public int retrigVolSlide = 0;
        public int sampleOffset = 0;
        public int highSampleOffset = 0;
        public boolean doSurround = false;
        public boolean filterOn = false;
        public int nFilterMode = 0;
        public int nResonance = 0;
        public int nCutOff = 0;
        public int nCutSwing = 0;
        public int nResSwing = 0;
        public long nFilter_A0 = 0L;
        public long nFilter_B0 = 0L;
        public long nFilter_B1 = 0L;
        public long nFilter_HP = 0L;
        public long nFilter_Y1 = 0L;
        public long nFilter_Y2 = 0L;

        public void deepCopy(ChannelMemory channelMemory) {
            try {
                Field[] fieldArray = ChannelMemory.class.getDeclaredFields();
                int n = 0;
                while (n < fieldArray.length) {
                    Field field = fieldArray[n];
                    if (!Modifier.isFinal(field.getModifiers())) {
                        field.set(this, field.get(channelMemory));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

