/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod;

import de.quippy.javamod.multimedia.mod.ModContainer;
import de.quippy.javamod.multimedia.mod.ModMixer;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModConfigPanel
extends JPanel {
    private static final long serialVersionUID = -3417460833901933361L;
    private ModContainer parentContainer;
    private JCheckBox playerSetUp_WideStereoMix = null;
    private JCheckBox playerSetUp_NoiseReduction = null;
    private JCheckBox playerSetUp_MegaBass = null;
    private JCheckBox playerSetUp_fadeOutLoops = null;
    private JCheckBox playerSetUp_ignoreLoops = null;
    private JLabel playerSetUp_L_Channels = null;
    private JComboBox playerSetUp_Channels = null;
    private JLabel playerSetUp_L_BitsPerSample = null;
    private JComboBox playerSetUp_BitsPerSample = null;
    private JLabel playerSetUp_L_SampleRate = null;
    private JComboBox playerSetUp_SampleRate = null;
    private JLabel playerSetUp_L_Interpolation = null;
    private JComboBox playerSetUp_Interpolation = null;

    public ModConfigPanel() {
        this.initialize();
    }

    public ModConfigPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.initialize();
    }

    public ModConfigPanel(boolean bl) {
        super(bl);
        this.initialize();
    }

    public ModConfigPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.initialize();
    }

    public ModContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(ModContainer modContainer) {
        this.parentContainer = modContainer;
    }

    private void initialize() {
        this.setName("ModConfigPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPlayerSetUp_WideStereoMix(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_NoiseReduction(), Helpers.getGridBagConstraint(1, 0, 1, 2, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_MegaBass(), Helpers.getGridBagConstraint(3, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_fadeOutLoops(), Helpers.getGridBagConstraint(4, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_SampleRate(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_Channels(), Helpers.getGridBagConstraint(1, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_BitsPerSample(), Helpers.getGridBagConstraint(2, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_Interpolation(), Helpers.getGridBagConstraint(3, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_ignoreLoops(), Helpers.getGridBagConstraint(4, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_SampleRate(), Helpers.getGridBagConstraint(0, 2, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_Channels(), Helpers.getGridBagConstraint(1, 2, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_BitsPerSample(), Helpers.getGridBagConstraint(2, 2, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_Interpolation(), Helpers.getGridBagConstraint(3, 2, 1, 2, 2, 17, 1.0, 0.0));
    }

    public JCheckBox getPlayerSetUp_WideStereoMix() {
        if (this.playerSetUp_WideStereoMix == null) {
            this.playerSetUp_WideStereoMix = new JCheckBox();
            this.playerSetUp_WideStereoMix.setName("playerSetUp_WideStereoMix");
            this.playerSetUp_WideStereoMix.setText("Wide Stereo Mix");
            this.playerSetUp_WideStereoMix.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_WideStereoMix.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if ((itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setDoWideStereoMix(ModConfigPanel.this.getPlayerSetUp_WideStereoMix().isSelected());
                    }
                }
            });
        }
        return this.playerSetUp_WideStereoMix;
    }

    public JCheckBox getPlayerSetUp_NoiseReduction() {
        if (this.playerSetUp_NoiseReduction == null) {
            this.playerSetUp_NoiseReduction = new JCheckBox();
            this.playerSetUp_NoiseReduction.setName("playerSetUp_NoiseReduction");
            this.playerSetUp_NoiseReduction.setText("Noise Reduction");
            this.playerSetUp_NoiseReduction.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_NoiseReduction.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if ((itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setDoNoiseReduction(ModConfigPanel.this.getPlayerSetUp_NoiseReduction().isSelected());
                    }
                }
            });
        }
        return this.playerSetUp_NoiseReduction;
    }

    public JCheckBox getPlayerSetUp_MegaBass() {
        if (this.playerSetUp_MegaBass == null) {
            this.playerSetUp_MegaBass = new JCheckBox();
            this.playerSetUp_MegaBass.setName("playerSetUp_MegaBass");
            this.playerSetUp_MegaBass.setText("Bass Boost");
            this.playerSetUp_MegaBass.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_MegaBass.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if ((itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setDoMegaBass(ModConfigPanel.this.getPlayerSetUp_MegaBass().isSelected());
                    }
                }
            });
        }
        return this.playerSetUp_MegaBass;
    }

    public int getLoopValue() {
        return this.getPlayerSetUp_fadeOutLoops().isSelected() ? 1 : (this.getPlayerSetUp_ignoreLoops().isSelected() ? 2 : 0);
    }

    public void setLoopValue(int n) {
        if (n == 0) {
            this.getPlayerSetUp_fadeOutLoops().setSelected(false);
            this.getPlayerSetUp_ignoreLoops().setSelected(false);
        } else if (n == 1) {
            this.getPlayerSetUp_fadeOutLoops().setSelected(true);
            this.getPlayerSetUp_ignoreLoops().setSelected(false);
        } else if (n == 2) {
            this.getPlayerSetUp_fadeOutLoops().setSelected(false);
            this.getPlayerSetUp_ignoreLoops().setSelected(true);
        }
    }

    private void configMixerWithLoopValue() {
        ModMixer modMixer;
        ModContainer modContainer = this.getParentContainer();
        if (modContainer != null && (modMixer = modContainer.getCurrentMixer()) != null) {
            modMixer.setDoNoLoops(this.getLoopValue());
        }
    }

    public JCheckBox getPlayerSetUp_fadeOutLoops() {
        if (this.playerSetUp_fadeOutLoops == null) {
            this.playerSetUp_fadeOutLoops = new JCheckBox();
            this.playerSetUp_fadeOutLoops.setName("playerSetUp_fadeOutLoops");
            this.playerSetUp_fadeOutLoops.setText("Fade out infinit loops");
            this.playerSetUp_fadeOutLoops.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_fadeOutLoops.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                        if (ModConfigPanel.this.getPlayerSetUp_fadeOutLoops().isSelected()) {
                            ModConfigPanel.this.getPlayerSetUp_ignoreLoops().setSelected(false);
                        }
                        ModConfigPanel.this.configMixerWithLoopValue();
                    }
                }
            });
        }
        return this.playerSetUp_fadeOutLoops;
    }

    public JCheckBox getPlayerSetUp_ignoreLoops() {
        if (this.playerSetUp_ignoreLoops == null) {
            this.playerSetUp_ignoreLoops = new JCheckBox();
            this.playerSetUp_ignoreLoops.setName("playerSetUp_ignoreLoops");
            this.playerSetUp_ignoreLoops.setText("Ignore infinit loops");
            this.playerSetUp_ignoreLoops.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_ignoreLoops.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                        if (ModConfigPanel.this.getPlayerSetUp_ignoreLoops().isSelected()) {
                            ModConfigPanel.this.getPlayerSetUp_fadeOutLoops().setSelected(false);
                        }
                        ModConfigPanel.this.configMixerWithLoopValue();
                    }
                }
            });
        }
        return this.playerSetUp_ignoreLoops;
    }

    public JLabel getPlayerSetUp_L_BitsPerSample() {
        if (this.playerSetUp_L_BitsPerSample == null) {
            this.playerSetUp_L_BitsPerSample = new JLabel();
            this.playerSetUp_L_BitsPerSample.setName("playerSetUp_L_BitsPerSample");
            this.playerSetUp_L_BitsPerSample.setText("Resolution");
            this.playerSetUp_L_BitsPerSample.setFont(Helpers.DIALOG_FONT);
        }
        return this.playerSetUp_L_BitsPerSample;
    }

    public JComboBox getPlayerSetUp_BitsPerSample() {
        if (this.playerSetUp_BitsPerSample == null) {
            this.playerSetUp_BitsPerSample = new JComboBox();
            this.playerSetUp_BitsPerSample.setName("playerSetUp_BitsPerSample");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(ModContainer.BITSPERSAMPLE);
            this.playerSetUp_BitsPerSample.setModel(defaultComboBoxModel);
            this.playerSetUp_BitsPerSample.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_BitsPerSample.setEnabled(true);
            this.playerSetUp_BitsPerSample.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if (itemEvent.getStateChange() == 1 && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setSampleSizeInBits(Integer.parseInt(ModConfigPanel.this.getPlayerSetUp_BitsPerSample().getSelectedItem().toString()));
                    }
                }
            });
        }
        return this.playerSetUp_BitsPerSample;
    }

    public JLabel getPlayerSetUp_L_Channels() {
        if (this.playerSetUp_L_Channels == null) {
            this.playerSetUp_L_Channels = new JLabel();
            this.playerSetUp_L_Channels.setName("playerSetUp_L_Channels");
            this.playerSetUp_L_Channels.setText("Channels");
            this.playerSetUp_L_Channels.setFont(Helpers.DIALOG_FONT);
        }
        return this.playerSetUp_L_Channels;
    }

    public JComboBox getPlayerSetUp_Channels() {
        if (this.playerSetUp_Channels == null) {
            this.playerSetUp_Channels = new JComboBox();
            this.playerSetUp_Channels.setName("playerSetUp_Channels");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(ModContainer.CHANNELS);
            this.playerSetUp_Channels.setModel(defaultComboBoxModel);
            this.playerSetUp_Channels.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_Channels.setEnabled(true);
            this.playerSetUp_Channels.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if (itemEvent.getStateChange() == 1 && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setChannels(Integer.parseInt(ModConfigPanel.this.getPlayerSetUp_Channels().getSelectedItem().toString()));
                    }
                }
            });
        }
        return this.playerSetUp_Channels;
    }

    public JLabel getPlayerSetUp_L_SampleRate() {
        if (this.playerSetUp_L_SampleRate == null) {
            this.playerSetUp_L_SampleRate = new JLabel();
            this.playerSetUp_L_SampleRate.setName("playerSetUp_L_SampleRate");
            this.playerSetUp_L_SampleRate.setText("Frequency");
            this.playerSetUp_L_SampleRate.setFont(Helpers.DIALOG_FONT);
        }
        return this.playerSetUp_L_SampleRate;
    }

    public JComboBox getPlayerSetUp_SampleRate() {
        if (this.playerSetUp_SampleRate == null) {
            this.playerSetUp_SampleRate = new JComboBox();
            this.playerSetUp_SampleRate.setName("playerSetUp_SampleRate");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(ModContainer.SAMPLERATE);
            this.playerSetUp_SampleRate.setModel(defaultComboBoxModel);
            this.playerSetUp_SampleRate.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_SampleRate.setEnabled(true);
            this.playerSetUp_SampleRate.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if (itemEvent.getStateChange() == 1 && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setSampleRate(Integer.parseInt(ModConfigPanel.this.getPlayerSetUp_SampleRate().getSelectedItem().toString()));
                    }
                }
            });
        }
        return this.playerSetUp_SampleRate;
    }

    public JLabel getPlayerSetUp_L_Interpolation() {
        if (this.playerSetUp_L_Interpolation == null) {
            this.playerSetUp_L_Interpolation = new JLabel();
            this.playerSetUp_L_Interpolation.setName("playerSetUp_L_Interpolation");
            this.playerSetUp_L_Interpolation.setText("Interpolation");
            this.playerSetUp_L_Interpolation.setFont(Helpers.DIALOG_FONT);
        }
        return this.playerSetUp_L_Interpolation;
    }

    public JComboBox getPlayerSetUp_Interpolation() {
        if (this.playerSetUp_Interpolation == null) {
            this.playerSetUp_Interpolation = new JComboBox();
            this.playerSetUp_Interpolation.setName("playerSetUp_Interpolation");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(ModContainer.INTERPOLATION);
            this.playerSetUp_Interpolation.setModel(defaultComboBoxModel);
            this.playerSetUp_Interpolation.setFont(Helpers.DIALOG_FONT);
            this.playerSetUp_Interpolation.setEnabled(true);
            this.playerSetUp_Interpolation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ModMixer modMixer;
                    ModContainer modContainer;
                    if (itemEvent.getStateChange() == 1 && (modContainer = ModConfigPanel.this.getParentContainer()) != null && (modMixer = modContainer.getCurrentMixer()) != null) {
                        modMixer.setDoISP(ModConfigPanel.this.getPlayerSetUp_Interpolation().getSelectedIndex());
                    }
                }
            });
        }
        return this.playerSetUp_Interpolation;
    }
}

