/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.flac;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jflac.FLACDecoder;
import de.quippy.jflac.FrameDecodeException;
import de.quippy.jflac.frame.Frame;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.util.ByteData;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class FLACMixer
extends BasicMixer {
    private InputStream inputStream;
    private FLACDecoder decoder;
    private URL flacFileUrl;
    private int channels;
    private int sampleRate;
    private int lengthInMilliseconds;

    public FLACMixer(URL uRL) {
        this.flacFileUrl = uRL;
        this.initialize();
    }

    private void initialize() {
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            this.inputStream = new FileOrPackedInputStream(this.flacFileUrl);
            this.decoder = new FLACDecoder(this.inputStream);
            this.decoder.readMetadata();
            AudioFormat audioFormat = this.decoder.getStreamInfo().getAudioFormat();
            this.setAudioFormat(audioFormat);
            this.channels = audioFormat.getChannels();
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.lengthInMilliseconds = (int)(this.decoder.getStreamInfo().getTotalSamples() * 1000L / (long)this.sampleRate);
        }
        catch (Exception exception) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            Log.error("[FLACMixer]", exception);
        }
    }

    @Override
    public int getChannelCount() {
        return this.channels;
    }

    @Override
    public int getCurrentKBperSecond() {
        Header header;
        Frame frame;
        if (this.decoder != null && (frame = this.decoder.getCurrentFrame()) != null && (header = frame.getHeader()) != null) {
            return header.blockSize * header.bitsPerSample * header.channels * 1000 / header.sampleRate;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.decoder != null) {
            Header header;
            Frame frame = this.decoder.getCurrentFrame();
            if (frame != null && (header = frame.getHeader()) != null) {
                return header.sampleNumber * 1000L / (long)this.sampleRate;
            }
            return this.decoder.getSamplesDecoded() * 1000L / (long)this.sampleRate;
        }
        return 0L;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long l) {
        try {
            long l2 = l * (long)this.sampleRate / 1000L;
            long l3 = this.getMillisecondPosition() * (long)this.sampleRate / 1000L;
            if (l3 > l2 || this.decoder.getSeekTable() != null) {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
                this.inputStream = this.flacFileUrl.openStream();
                this.decoder = new FLACDecoder(this.inputStream);
                this.decoder.readMetadata();
            }
            this.decoder.seekTo(l2);
        }
        catch (Throwable throwable) {
            Log.error("[FLACMixer::seek]", throwable);
        }
    }

    private ByteData decode() throws IOException {
        try {
            this.decoder.findFrameSync();
            Frame frame = this.decoder.readFrame();
            return this.decoder.decodeFrame(frame, null);
        }
        catch (FrameDecodeException frameDecodeException) {
            return null;
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                boolean bl = false;
                do {
                    try {
                        ByteData byteData = this.decode();
                        if (byteData != null) {
                            byte[] byArray = byteData.getData();
                            int n = byteData.getLen();
                            this.writeSampleDataToLine(byArray, 0, n);
                        }
                    }
                    catch (EOFException eOFException) {
                        bl = true;
                    }
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.isInSeeking()) continue;
                    this.setIsSeeking();
                    while (this.isInSeeking()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (!bl);
                if (bl) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }
}

