/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

public abstract class IIRFilterBase {
    protected int frequency;
    protected int sampleRate;
    protected static final int HISTORYSIZE = 3;
    protected float[][] inArray;
    protected float[][] outArray;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected float amplitudeAdj;

    public void initialize(int n, int n2, int n3, float f) {
        this.frequency = n3;
        this.sampleRate = n;
        this.inArray = new float[n2][3];
        this.outArray = new float[n2][3];
        this.clearHistory();
    }

    public void clearHistory() {
        int n = this.inArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 3) {
                this.outArray[n2][n3] = 0.0f;
                this.inArray[n2][n3] = 0.0f;
                ++n3;
            }
            ++n2;
        }
    }

    public static float getIIRDecimalValueFrom(float f) {
        double d = Math.pow(10.0, (double)f / 20.0);
        return (float)(d < 1.0 ? -d : d);
    }

    public static float getIIRDBValueFrom(float f) {
        return (float)Math.log10(f < 0.0f ? -f : f) * 20.0f;
    }

    protected float calcRadiansPerSample(float f) {
        return (float)(Math.PI * 2 * (double)f / (double)this.sampleRate);
    }

    protected float getThetaZero() {
        return this.calcRadiansPerSample(this.frequency);
    }

    public void setAmplitudeAdj(float f) {
        this.amplitudeAdj = f;
    }

    public float getAmplitudeAdj() {
        return this.amplitudeAdj;
    }

    public void setGain(float f) {
        this.setAmplitudeAdj(IIRFilterBase.getIIRDecimalValueFrom(f));
    }

    public float getGain() {
        return IIRFilterBase.getIIRDBValueFrom(this.getAmplitudeAdj());
    }

    protected abstract float performFilterCalculation(float var1, int var2, int var3, int var4, int var5);
}

