/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRBandpassFilter;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilter;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;
import javax.sound.sampled.AudioFormat;

public class GraphicEQ
implements DSPEffekt {
    private static final float Q = 1.4f;
    private static final int[] CENTER_FREQUENCIES = new int[]{60, 170, 310, 600, 1000, 3000, 6000, 12000, 14000, 16000};
    private int usedBands;
    private IIRFilter theFilter;
    private boolean isActive;

    public GraphicEQ() {
        IIRFilterBase[] iIRFilterBaseArray = new IIRBandpassFilter[CENTER_FREQUENCIES.length];
        int n = 0;
        while (n < CENTER_FREQUENCIES.length) {
            iIRFilterBaseArray[n] = new IIRBandpassFilter();
            ++n;
        }
        this.theFilter = new IIRFilter(iIRFilterBaseArray);
        this.isActive = false;
    }

    @Override
    public void initialize(AudioFormat audioFormat, int n) {
        int n2 = (int)audioFormat.getSampleRate();
        int n3 = n2 >> 1;
        IIRFilterBase[] iIRFilterBaseArray = this.theFilter.getFilters();
        int n4 = 0;
        while (n4 < CENTER_FREQUENCIES.length) {
            iIRFilterBaseArray[n4].initialize(n2, audioFormat.getChannels(), CENTER_FREQUENCIES[n4], 1.4f);
            ++n4;
        }
        this.theFilter.initialize(audioFormat.getChannels(), n);
        n4 = 0;
        while (n4 < CENTER_FREQUENCIES.length) {
            if (CENTER_FREQUENCIES[n4] > n3) break;
            ++n4;
        }
        this.usedBands = n4;
    }

    @Override
    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public int getBandCount() {
        return CENTER_FREQUENCIES.length;
    }

    public int getCenterFreq(int n) {
        return CENTER_FREQUENCIES[n];
    }

    public void setBand(int n, float f) {
        this.theFilter.setBand(n, f);
    }

    public float getBand(int n) {
        return this.theFilter.getBand(n);
    }

    public void setPreAmp(float f) {
        this.theFilter.setPreAmp(f);
    }

    public float getPreAmpDB() {
        return this.theFilter.getPreAmp();
    }

    @Override
    public int doEffekt(float[] fArray, int n, int n2) {
        if (!this.isActive) {
            return n2;
        }
        return this.theFilter.doFilter(fArray, n, n2, this.usedBands);
    }
}

