/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoundSlider
extends JComponent {
    private static final long serialVersionUID = 7401158894851891182L;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final double PI_2 = Math.PI * 2;
    private static final double START_ANG = 5.497787143782138;
    private static final double LENGTH_ANG = 4.71238898038469;
    private ChangeEvent changeEvent = null;
    private double lastAngle;
    private double currentAngle;
    private float currentValue;

    public RoundSlider() {
        this.initialize();
    }

    private void initialize() {
        this.setValue(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RoundSlider.this.lastAngle = RoundSlider.this.getAngle(mouseEvent);
                RoundSlider.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                double d = RoundSlider.this.getAngle(mouseEvent);
                RoundSlider.this.setValue((float)((5.497787143782138 - d) / 4.71238898038469));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                double d = RoundSlider.this.getAngle(mouseEvent);
                double d2 = d - RoundSlider.this.lastAngle;
                RoundSlider.this.lastAngle = d;
                float f = (float)((double)RoundSlider.this.getValue() - d2 / 4.71238898038469);
                if ((double)Math.abs(f - RoundSlider.this.getValue()) < 0.5) {
                    RoundSlider.this.setValue(f);
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
    }

    public float getValue() {
        return this.currentValue;
    }

    public void setValue(float f) {
        this.currentValue = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.currentAngle = 5.497787143782138 - 4.71238898038469 * (double)this.currentValue;
        this.repaint();
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    private int getMaxSize() {
        int n;
        int n2 = this.getWidth();
        return n2 < (n = this.getHeight()) ? n2 : n;
    }

    private double getAngle(MouseEvent mouseEvent) {
        int n = this.getMaxSize() >> 1;
        int n2 = mouseEvent.getX() - n;
        int n3 = mouseEvent.getY() - n;
        double d = Math.atan2(n2, n3);
        if (n2 < 0) {
            d += Math.PI * 2;
        }
        return d;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getMaxSize();
        int n2 = n >> 1;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(this.getParent().getBackground());
            graphics2D.setRenderingHints(AALIAS);
        }
        --n2;
        int n3 = 64;
        int n4 = (255 - n3) / (n -= 2);
        int n5 = n;
        while (n5 >= 0) {
            graphics.setColor(new Color(n3, n3, n3));
            int n6 = 1 + n2 - (n5 >> 1);
            graphics.fillOval(n6, n6, n5, n5);
            n3 += n4;
            --n5;
        }
        graphics.setColor(Color.RED);
        double d = Math.sin(this.currentAngle);
        double d2 = Math.cos(this.currentAngle);
        int n7 = n2 + (int)((double)n2 * d);
        int n8 = n2 + (int)((double)n2 * d2);
        graphics.drawLine(n2, n2, n7, n8);
    }
}

