//保存并添加时传递的数据格式：
//单选题    {"titile":"无题","questions":[{"body":"111","type":"singleOption","id":"61844191-ed22-42a5-0223-8f60dbd62165","answer":{"comment":"222","content":[0]},"options":[]}]}
//多选题    {"titile":"无题","questions":[{"body":"111","type":"multiOption","id":"2a1cf31b-e32f-bb13-d2aa-34839c3f6b84","answer":{"comment":"222","content":[0,1]},"options":[]}]}
//问答题    {"titile":"无题","questions":[{"body":"111","type":"free","id":"a569fb01-4def-1bc0-81f1-c330225ff485","answer":{"comment":"222","content":"123"}}]}

//编辑状态的数据格式
//编辑多选题；
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"题干","type":"multiOption","answer":{"comment":"题目解析","content":[0,1]},"options":["选项内容","选项内容","选项内容","选项内容"]}]}}')
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"sssss","type":"multiOption","id":"aceea866-6f67-3696-971a-1830ae328c23","answer":{"comment":"ddddddddddddddd","content":[0,1,2,3]},"options":["1<br>","2<br>","23<br>","4<br>"]}]}}')
//编辑单选题；
//msg:{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"11111","type":"singleOption","id":"2344059f-ee06-ec1f-30cd-470cdc959991","answer":{"comment":"111111","content":[2]},"options":[null,"11<br>","士大夫似的<br>"]}]}}
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"题干","type":"singleOption","answer":{"comment":"题目解析","content":[0]},"options":["选项内容","选项内容","选项内容","选项内容"]}]}}')
//编辑填空题
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"s","type":"fillBlank","id":"9dbb2885-f28b-44df-d48c-af1a93a5bf12","answer":{"comment":"ddddd","content":["1<br>","2<br>","3<br>","4<br>"]}}]}}')
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"题干","type":"fillBlank","answer":{"comment":"题目解析","content":["空位","空位","空位","空位"]}}]}}')
//编辑主观题
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"1111231","type":"free","id":"11505ed4-bbdb-b430-c04e-2716045c1249","answer":{"comment":"22223","content":"2222312"}}]}}')
//onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"题干","type":"free","answer":{"comment":"题目解析","content":"参考答案"}}]}}')
//{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"11111","type":"singleOption","id":"2344059f-ee06-ec1f-30cd-470cdc959991","answer":{"comment":"111111","content":[2]},"options":[null,"11<br>","士大夫似的<br>"]}]}}
$(function () {
    var saveURI = '/saveQuizSheet';
    var getURI = '/quizSheet';
    var CONSTANT_IMG_SERVER = "";
    var options = {
        iconsPath: 'javascripts/nicEdit/nicEditorIcons.gif', //相对引用的html文件即可
        uploadURI: '/uploadImage',
        // buttonList : [ 'fontSize', 'bold', 'italic', 'subscript',
        // 'superscript', 'image', 'upload' ]
        // ['fontSize','bold','italic','underline','strikeThrough','subscript','superscript','html','image']}).panelInstance('area4');
        fullPanel: true
    };
    var myNicEditor = new nicEditor(options); // 一个编辑器实例可用于多个编辑区
    var localQid = 0; // 试题的本地id，自增。与服务器端的试题id无关。服务器端的试题的id，是 .question 的属性
    // data-qid。

    var url;
    //mode 可以是 new （新建），demo（演示，默认），remote（从服务器加载）
    //如果是remote，应给出quizSheetId参数。
    //如果是new，应给出quizSheetTitile。
    var mode;
    var quizSheetId;
    var quizSheetTitile;

    var sampleEditorPaneId = "sampleEditorPane";
    var realEditorPaneId = "editorPane";
    //var currentEditorPaneId = sampleEditorPaneId;
    var classForEdit = [".questionBody", ".optionBody", ".blankBody", ".answerBody", ".questionComment"];
    var questionTypeMap = { singleOption: "单选", multiOption: "多选", bool: "判断", fillBlank: "填空", free: "主观" };
    var selectedQuesId = null;

    var quizSheet = null; //JSON

    function initParam() {
        url = $.url();
        console.log("url:" + url);
        mode = url.fparam('mode');
        quizSheetId = url.fparam('quizSheetId');
        quizSheetTitile = url.fparam('quizSheetTitile') || quizSheetTitile;
    }

    function enableEditorPane() {
        var questions = $("#editorPane  .question");
        questions.each(function (i) {
            enableEditQuestion(this);
        });
    }

    function enableEditQuestion(quesElem) {
        if (!quesElem.id)
            quesElem.id = localQid + "-question";
        for (var k = 0; k < classForEdit.length; k++) {
            var clazz = classForEdit[k];
            $(quesElem).find(clazz).each(function (j) {
                if (this.id && myNicEditor.instanceById(this.id))
                    return;
                // question 元素的 id 的结构是 localQid-clazz-n
                var eid = localQid + "-" + clazz.slice(1) + "-" + j;
                this.id = eid;
                myNicEditor.addInstance(eid);
            });
        }
        localQid++;
        return quesElem;
    }

    function createQuestionList() {
        var ql = $("#questionList .main");
        var templ = $('#sampleQuestionListItem');
        ql.empty();
        questions = $("#editorPane  .question");
        questions.each(function (i) {
            var thiz = $(this);
            var li = templ.clone();
            li.removeAttr("id");
            li[0].setAttribute("data-refId", this.id);
            li.find(".listType")[0].innerHTML = thiz.attr("bussTypeName"); //questionTypeMap[this.getAttribute("data-questionType")] || "未知";
            li.find(".listTitile")[0].innerHTML = thiz.find(".questionBody").text(); //innerText 支持不广泛，用text()代替
            li.appendTo(ql);
            li[0].onclick = function () { selectQuestionListItem(this.getAttribute("data-refId")) };
        });
        selectQuestionListItem(selectedQuesId);
    }

    function updateQuestionList() {
        $("#questionList li").each(function (i) {
            var qbody = $("#" + this.getAttribute("data-refId") + "  .questionBody");
            var title = $(this).find(".listTitile");
            var strBody = qbody.text();
            if (title.text() !== strBody)
                title[0].innerHTML = strBody;
        });
    }

    function addQuestion(type, position, id, bussTypeName, dicId) {
        if (!isFinite(position))
            position = -1;
        var templType = type;
        /*var templType = (type === 'singleOption') ? 'multiOption' : type;
        if(type === "free"){
        templType = "free";
        }
        if(type === "fillBlank"){
        templType = "fillBlank";
        }*/
        var ques = $(
                '#sampleEditorPane  .question[data-questionType="' + templType
                + '"]').clone();
        //alert(ques.attr("data-questiontype"))
        // ques[0].id = (localQid++) + "-question";
        ques.attr('data-questionType', type);
        var tid = id || guid();
        ques.attr('data-questionId', tid);
        ques.attr("bussTypeName", bussTypeName);
        ques.attr("dicid", dicId);
        //ques.find('.questionType').html(questionTypeMap[type]);
        ques.find('.questionType').html(bussTypeName);
        ques.find(classForEdit.join(',')).empty();
        ques.find("ol input").attr("name", tid);
        if (selectedQuesId && position < 0) {
            ques.insertAfter(document.getElementById(selectedQuesId));
        } else {
            questions = $("#editorPane  .question");
            if (questions[position])
                ques.insertBefore(questions[position]);
            else {
                ques.appendTo($("#editorPane"));
            }
        }
        // alert(ques[0])
        enableEditQuestion(ques[0]);
        return ques[0];
    }

    function deleteQuestion(id) {
        var ques = $('#' + id + ".question");
        ques.find("div[id]").each(function () {
            if (myNicEditor.instanceById(this.id))
                myNicEditor.removeInstance(this.id);
        });
        ques.remove();
        createQuestionList();
    }

    function deleteAllQuestion() {
        $(".question[data-questionid]").each(function () {
            var ques = $(this);
            ques.find("div[id]").each(function () {
                if (myNicEditor.instanceById(this.id))
                    myNicEditor.removeInstance(this.id);
            });
            ques.remove();
            createQuestionList();
        })
    }
    function moveQuestion(id, direction) {
        var ques = $('#' + id + ".question")[0];
        if (!ques)
            return false;
        var target = ques;
        if (direction === 'up') {
            while ((target = target.previousSibling) && !$(target).hasClass('question'));
            if (target && target !== ques) {
                ques.parentNode.insertBefore(ques, target);
                return true;
            }
        } else if (direction === 'down') {
            while ((target = target.nextSibling) && !$(target).hasClass('question'));
            if (target && target !== ques) {
                $(ques).insertAfter(target);
                return true;
            }
        }
        return false;
    }

    function selectQuestionListItem(id) {
        $('#questionList [data-refId="' + selectedQuesId + '"]').removeClass("selected");
        var li = $('#questionList [data-refId="' + id + '"]').addClass("selected");
        if (li.length == 0) {
            selectedQuesId = null;
            return;
        }
        selectedQuesId = id;
        var ques = document.getElementById(id);
        if (ques)
            ques.scrollIntoView();
    }

    /**
    * 让#questionList, .editorPane 占据余下的高度，并可以滚动。CSS很难单独做到。
    * 参考：http://stackoverflow.com/questions/90178/make-a-div-fill-the-remaining-screen-space
    */
    function layout() {
        $("#questionList, .editorPane").each(function () {
            var height = window.innerHeight - this.offsetTop;
            if (height < 10) height = 10;
            this.style.height = height + "px";
        });
    }

    //去除注释， 把图片的地址转化为cdn地址
    function cleanTagAndReplaceImgUrl(str) {
        var el = $("<div>").html(str);
        //清除注释节点;
        el.find("*").each(function () {
            if (this.nodeType === 8 || this.nodeType === 4) {
                $(this).remove();
            };
        });
        str = el.html();

        var p;
        //这个常量是一个单独的JS;
        for (p in CONSTANT_FILEDOMAIN_MAP) {
            var reg = new RegExp(CONSTANT_FILEDOMAIN_MAP[p], "gi");
            str = str.replace(reg, p);
        };
        return str;
    }

    function guid() {
        function S4() {
            return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
        }
        return (S4() + S4() + S4() + +S4() + S4() + S4() + S4() + S4());
    }

    function isNull(str) {
        if (typeof str === "string") {
            if (!str || str && $.trim(str.replace(/&nbsp;| |<br>/gi, "")) === "" || str && (str === "<br>")) {
                return true;
            };
            if (str) {

            };
            return false;
        };
    };

    function quizSheetToJS() {
        var canExportToJS = true;
        var alertMessages = ["题目信息和正确答案不能为空，请返回填写"];
        var zs = {};
        zs.title = quizSheetTitile || "无题";
        if (quizSheetId)
            zs.id = quizSheetId;
        var ques = zs.questions = [];
        $("#editorPane  .question").each(function (i) {

            var q = ques[i] = {};
            var thiz = $(this);
            q.body = $.trim(cleanTagAndReplaceImgUrl(thiz.find(".questionBody").html()));
            if (isNull(q.body)) {
                canExportToJS = false;
            };
            q.bussTypeName = thiz.attr("bussTypeName");
            q.bussType = thiz.attr("dicid");
            q.type = thiz.attr('data-questionType');
            var qid = thiz.attr('data-questionId');
            var aid = thiz.attr('data-answerId');
            var comment = cleanTagAndReplaceImgUrl(thiz.find(".questionComment").html());
            if (qid)
                q.id = qid;
            q.answer = {};
            if (aid)
                q.answer.id = aid;
            if (comment)
                q.answer.comment = comment;
            switch (q.type) {
                case "singleOption":
                case "multiOption":
                    q.options = [];
                    thiz.find(".optionBody").each(function (j) {
                        var body = $.trim(cleanTagAndReplaceImgUrl($(this).html()));
                        if (isNull(body)) {
                            canExportToJS = false;
                        };
                        if (body)
                            q.options[j] = body;
                    });
                    thiz.find(".questionOptions input").each(function (j) {
                        //this.getAttribute('checked') === 'checked' 是不合适的，因为它不会因为用户的选择而改变。
                        if (this.checked) {
                            if (!q.answer.content)
                                q.answer.content = [];
                            q.answer.content.push(j);
                        }
                    });
                    if (!q.answer.content || ($.trim(q.answer.content.join()) == "")) {
                        canExportToJS = false;
                    }
                    break;
                case "fillBlank":
                    thiz.find(".blankBody").each(function (j) {
                        var body = cleanTagAndReplaceImgUrl($(this).html());
                        if (isNull(body)) {
                            canExportToJS = false;
                        };
                        if (body) {
                            if (!q.answer.content)
                                q.answer.content = [];
                            q.answer.content[j] = body;
                        }
                    });
                    break;
                case "bool":
                    var checkBoxes = thiz.find(".questionOptions input");
                    if (checkBoxes[0].checked)
                        q.answer.content = true;
                    else if (checkBoxes[1].checked)
                        q.answer.content = false;
                    break;
                case "free":
                    var body = cleanTagAndReplaceImgUrl(thiz.find(".answerBody").html());
                    if (isNull(body)) {
                        canExportToJS = false;
                    };
                    if (body)
                        q.answer.content = body;
                    break;
            } //end switch
            //重新处理已经生成的内容;
            //如果题目类型为多选，但是用户只勾选一个选项， 那么我们把题目类型设置为单选;
            if (q.type === "multiOption" && q.answer.content && q.answer.content.length == 1) {
                q.type = "singleOption";
            };
            if (!('content' in q.answer || 'comment' in q.answer))
                delete q.answer;
        }); //end each
        if (!canExportToJS) {
            alert(alertMessages);
            return
        };
        return zs;
    }

    /**
    * @param funcSuccess(data) 保存后执行的函数，参数为响应体。
    */
    function saveQuizSheet(funcSuccess) {
        var zs = quizSheetToJS();
        if (mode == "new")
            ucbook.postWebPageMessage(JSON.stringify({ action: "saveTopicData", arguments: zs }));
        else
            ucbook.postWebPageMessage(JSON.stringify({ action: "updateTopicData", arguments: zs }));
    }

    function replaceImgsDomain(str) {
        for (p in CONSTANT_FILEDOMAIN_MAP) {
            var reg = new RegExp(p, "gi");
            str = str.replace(reg, CONSTANT_FILEDOMAIN_MAP[p]);
        };
        return str;
    };

    function editQuizSheet(data) {
        quizSheet = data;
        quizSheetTitile = quizSheet.titile;
        var ques = quizSheet.questions;
        for (var i = 0; i < ques.length; i++) {
            var qElem = addQuestion(ques[i].type, null, ques[i].id);
            var questionId = $(qElem).attr("data-questionid");
            $(qElem).attr("bussTypeName", ques[i].bussTypeName);
            $(qElem).attr("dicid", ques[i].bussType);
            qElem = $(qElem);
            qElem.find(".questionBody").html(replaceImgsDomain(ques[i].body));
            if (ques[i].answer && ques[i].answer.comment)
                qElem.find(".questionComment").html(replaceImgsDomain(ques[i].answer.comment));

            var ans = ques[i].answer && ques[i].answer.content;

            switch (ques[i].type) {
                case "singleOption":
                    qElem.find("ol").html("");
                    for (var j = 0; j < ques[i].options.length; j++) {
                        var li = $('<li><span> <input type="radio" name="' + questionId + '" /> </td><td> <div class="optionBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
                        li.appendTo(qElem.find("ol"));
                    }
                    qElem.find(".optionBody").each(function (j) {
                        if (j < ques[i].options.length)
                            this.innerHTML = replaceImgsDomain(ques[i].options[j]);
                    });
                    var checkBoxes = qElem.find(".questionOptions input");
                    if (ans) {
                        for (var k = 0; k < ans.length; k++) {
                            if (ans[k] < checkBoxes.length)
                                checkBoxes[ans[k]].checked = true;
                        }
                    }
                    break;
                case "multiOption":
                    qElem.find("ol").html("");
                    for (var j = 0; j < ques[i].options.length; j++) {
                        var li = $('<li><span> <input type="checkbox" /> </td><td> <div class="optionBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
                        li.appendTo(qElem.find("ol"));
                    }
                    qElem.find(".optionBody").each(function (j) {
                        if (j < ques[i].options.length)
                            this.innerHTML = replaceImgsDomain(ques[i].options[j]);
                    });
                    var checkBoxes = qElem.find(".questionOptions input");
                    if (ans) {
                        for (var k = 0; k < ans.length; k++) {
                            if (ans[k] < checkBoxes.length)
                                checkBoxes[ans[k]].checked = true;
                        }
                    }
                    break;
                case "fillBlank":
                    qElem.find("ol").html("");
                    for (var j = 0; j < ans.length; j++) {
                        var li = $('<li> <span><div class="blankBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
                        li.appendTo(qElem.find("ol"));
                    }
                    qElem.find(".blankBody").each(function (j) {
                        if (ans && j < ans.length)
                            this.innerHTML = replaceImgsDomain(ans[j]);
                    });
                    break;
                case "bool":
                    if (typeof ans === 'boolean') {
                        var checkBoxes = qElem.find(".questionOptions input");
                        var idx = ans ? 0 : 1;
                        checkBoxes[idx].checked = true;
                    }
                    break;
                case "free":
                    if (ans) {
                        qElem.find(".answerBody").html(replaceImgsDomain(ans));
                    }
                    break;
            } //end switch
        } //end for
        //createQuestionList();
    };

    function loadQuizSheet() {
        var url = "/quizSheet/" + quizSheetId;
    }

    function renderSelect(data) {
        $("#selectQuestionType").html(function () {
            var _this = $(this);
            var html = "";
            $.each(data, function (i, e) {
                if (!e.dicName) return;
                var type = "";
                if (e.dicName === "选择题") {
                    type = "multiOption";
                } else if (e.dicName === "多选题") {
                    type = "multiOption";
                } else if (e.dicName === "单选题") {
                    type = "singleOption";
                } else {
                    type = "free";
                };
                /*
                * <option value="singleOption">单选</option>
                <option value="multiOption">多选</option>
                <option value="free">主观</option>
                <option value="fillBlank">填空</option>
                * */
                html += ('<option value="' + type + "____" + e.dicID + '"  >' + e.dicName + '</option>');
            });
            return html;
        });

        //模拟下拉框；
        $("select").EmulateSelect({
            emitChange: function () {
            }
        });
    };

    $("#commandNewQuestion").click(function () {
        var type = $("#selectQuestionType").val().split("____")[0];
        var bussTypeName = $(".select-name").text();
        var dicId = $("#selectQuestionType").val().split("____")[1];
        var ques = addQuestion(type, -1, undefined, bussTypeName, dicId);

        createQuestionList();
        selectQuestionListItem(ques.id);
    });

    $('#commandDeleteQuestion').click(function () {
        if (selectedQuesId)
            deleteQuestion(selectedQuesId);
        else {
            alert("请先选择题目，再进行删除操作");
        }
    });

    $('#commandUp, #commandDown').click(function () {
        if (selectedQuesId) {
            var dir = this.id === 'commandUp' ? 'up' : 'down';
            if (moveQuestion(selectedQuesId, dir))
                createQuestionList();
        } else {
            this.id === 'commandUp' ? alert("请先选择题目，再进行上移/操作") : alert("请先选择题目，再进行下移操作");
        }
    });

    function postToClient(data) {
        ucbook & ucbook.postWebPageMessage(JSON.stringify({ action: "postTopic", arguments: [encodeURIComponent(JSON.stringify(data)), CONSTANT_IMG_SERVER] }));
    };

    $('#commandSave').click(function () {
        saveQuizSheet(function (data) {
            window.location = '/quiz-sheet-edit.html#mode=remote&quizSheetId=' + data;
            //因为页面相同，'#'表示页面内跳转，onload 事件不会触发，所以需要强制重新加载。
            window.location.reload();
        });
    });

    $('#commandEditSave').click(function () {
        saveQuizSheet(function (data) {
            window.location = '/quiz-sheet-edit.html#mode=remote&quizSheetId=' + data;
            //因为页面相同，'#'表示页面内跳转，onload 事件不会触发，所以需要强制重新加载。
            window.location.reload();
        });
    });

    function testJSON(json, struct) {
        if (!struct) {
            throw new Error("argument Error");
        };
        if (typeof json !== "object") {
            l("ajax的返回数据不是json");
            if (json.toString() === struct) return true;
            return false;
        };
        for (var prop in json) {
            //如果规定的结构下面没有这个属性，直接返回false；
            if (undefined === struct[prop]) {
                return false;
            };
            //如果这个属性是json
            if (typeof json[prop] === "object") {
                //深度对比;
                if (!arguments.callee(json[prop], struct[prop])) return false;
            } else {
                //如果这个有值不相等的;
                if (json[prop] != struct[prop]) {
                    return false;
                };
            };
        };
        //所有的检测完毕就返回真;
        return true;
    };

    window.confirmToSaveTopics = function () {
        var zs = quizSheetToJS();
        var boolean = testJSON(zs, JSON.parse(orginalData));
        if (boolean) {
            ucbook & ucbook.postWebPageMessage(JSON.stringify({ action: "sendDataWithoutTopicsChange", arguments: [boolean] }));
        } else {
            ucbook & ucbook.postWebPageMessage(JSON.stringify({ action: "sendDataWithoutTopicsChange", arguments: [encodeURIComponent(JSON.stringify(zs))] }));
        };
    };

    $(document).bind("paste", function (ev) {
        //把剪贴板中的img变为base64格式;
        var canvas = document.createElement("canvas");
        var context = canvas.getContext("2d");
        var html = $(ev.originalEvent.clipboardData.getData("text/html"));
        html.find("img").each(function () {
            var img = document.createElement("img");
            var src = $(this).attr("src"); //.replace(/\\/gi,"\/");
            var _this = this;
            //img.crossOrigin = "Anonymous";
            img.src = src;
            img.onload = function () {
                canvas.width = img.width;
                canvas.height = img.height;
                context.drawImage(img, 0, 0, img.width, img.height);
                var dataBase64 = canvas.toDataURL("image/png").replace("image/png", "image/octet-stream");
                $("img").each(function (index, el) {
                    //匹配图片;
                    if ($(this).attr("src").replace(/[\/\\]/g, "") === src.replace(/[\/\\]/g, "")) {
                        //如果图片超过5M的话;
                        if (dataBase64 && dataBase64.length > 5249917) {
                            el.src = "./images/b34c240d02ca4722b2712d85249b7d7b_0.jpg";
                            el.width = "400";
                            el.height = "200";
                            return;
                        } else {
                            el.src = dataBase64;
                            if (img.width > 600) {
                                el.width = 600;
                                el.height = parseInt(img.height * 500 / img.width);
                            }
                        };
                    };
                });

                img.onload = null;
            };
        });
        //如果是单图的话，我们可以通过item这个属性获取到图片
        var target = ev.target;
        var ele = ev.originalEvent.clipboardData.items;
        for (var i = 0; i < ele.length; ++i) {
            if (ele[i].kind == 'file' && ele[i].type.indexOf('image/') !== -1) {

                var blob = ele[i].getAsFile();
                readBlobAsDataURL(blob, function (base64) {

                    var img = document.createElement('img');
                    img.setAttribute('src', base64);

                    if (img.width > 600) {
                        img.width = 600;
                        img.height = parseInt(img.height * 500 / img.width);
                    };

                    img.onload = function () {

                        if (img.width > 600) {
                            img.width = 600;
                            img.height = parseInt(img.height * 500 / img.width);
                        };
                    };

                    if (target.tagName.toLocaleLowerCase() === "div") {
                        $(target).append(img);
                    } else {
                        $(target).after(img); ;
                    }
                });
                //阻止默认事件, 避免重复添加;
                ev.originalEvent.preventDefault();
            };
        };
    });

    function readBlobAsDataURL(blob, callback) {
        var a = new FileReader();
        a.onload = function (e) { callback(e.target.result); };
        a.readAsDataURL(blob);
    };

    $('#commandBack').click(function () {
        //window.location = '/quiz-sheet-manage.html';
    });

    $('#commandStartQuiz').click(function () {
        saveQuizSheet(function (data) {
            //window.location = '/quiz-start.html#quizSheetId=' + data;
        });
    });

    $(".delBtn").live("click", function () {
        $(this).parent().remove();

    })

    function addLi(li, that) {
        var ol = that.prev();
        li.appendTo(ol);
    }
    $(".addBtn1").live("click", function () {

        var li = $('<li><span> <input type="checkbox" /> </td><td> <div class="optionBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
        var that = $(this);
        addLi(li, that);
        enableEditQuestion($(this).closest(".question")[0]);
    })
    $(".addBtn3").live("click", function () {

        var li = $('<li><span> <input type="radio" name="' + $(this).closest(".question").attr("data-questionid") + '" /> </td><td> <div class="optionBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
        var that = $(this);
        addLi(li, that);
        enableEditQuestion($(this).closest(".question")[0]);
    })

    $(".addBtn2").live("click", function () {

        var li = $('<li> <span><div class="blankBody theme-rich-text-edit" contenteditable="true"><br></div></span> <span class="delBtn">删除</span></li>');
        var that = $(this);
        addLi(li, that);
        enableEditQuestion($(this).closest(".question")[0]);
    })

    //单选按钮选中
    /*
    $("#editorPane").delegate("input[type=radio]","click",function(){
    $(this).attr("checked",true);
    $(this).parents("li").siblings().find("input[type=radio]").removeAttr("checked");
    })
    */



    var iconButtonWrappers = $('.iconButtonWrapper');

    iconButtonWrappers.mousedown(function () {
        this.classList.add('down');
    }).click(function () {
        iconButtonWrappers.removeClass('down');
    });

    function editModel() {
        $("#questionList").addClass("hidden");
        $("#newbar").addClass("hidden");
        $("#editbar").removeClass("hidden");
    };

    function forbidenDeleteKeyDown() {
        $(document).keydown(function (ev) {
            if (ev.keyCode == 8 && ev.target === document.body) {
                ev.preventDefault();
            };
        });
    };

    function forbiddenDrag() {
        window.addEventListener("dragover", function (e) {
            e = e || event;
            e.preventDefault();
        }, false);
        window.addEventListener("drop", function (e) {
            e = e || event;
            e.preventDefault();
        }, false);
    }

    var orginalData = '{"title":"无题","questions":[]}';
    //交互代码
    window.onMessage = function (message) {
        //ucbook的message;
        try {
            console.log("msg:" + message);
            var msg = JSON.parse(message);
        } catch (e) {
            //走的是跨域message;
            try {
                msg = JSON.parse(JSON.parase(message.data));
            } catch (e) {
                console.log(e + ":" + message);
                return;
            }
        }
        switch (msg.action) {
            case "editTopic":
                //                editModel();
                //                editQuizSheet(msg.arguments);
                //                break;
                //var result = JSON.parse(msg.arguments);
                editModel();
                editQuizSheet(msg.arguments);
                //CONSTANT_IMG_SERVER = result.CONSTANT_IMG_SERVER;
                orginalData = msg.arguments;
                break;
            case "setUserHomeworkAnswer":
                break;
            case "deleteAllQuestion":
                deleteAllQuestion();
                break;
            case "addTopic":
                var result = JSON.parse(msg.arguments);
                renderSelect(result.types);
                CONSTANT_IMG_SERVER = result.CONSTANT_IMG_SERVER;
                break;
            case "confirmToSaveTopics":
                confirmToSaveTopics();
                break;
            default:
                break;
        }
    };
    //以下为页面加载时执行代码

    initParam();

    myNicEditor.setPanel('nicEditPanel'); // 用于放置工具条的元素，一般是div，最好设置宽度
    // style="width: 525px;"
    window.ucbook && (ucbook.onWebPageMessage = onMessage);
    window.ucbook && ucbook.postWebPageMessage("ready");
    window.onmessage = onMessage;
    if (mode === 'edit') {
        //loadQuizSheet();
        //currentEditorPaneId = realEditorPaneId;
        //$("#"+sampleEditorPaneId).addClass("hidden");
        // do quiz sheet loading
    } else if (mode === 'new') {
        //TODO: 新建一些空试题
    } else { //demo
        //$("#"+realEditorPaneId).addClass("hidden");
        //var ques = $("#sampleEditorPane  .question");
        //ques.clone().appendTo($("#editorPane"));
    }
    enableEditorPane();
    createQuestionList();
    setInterval(updateQuestionList, 1500);

    layout();
    window.onresize = layout;
    document.oncontextmenu = new Function("return false;");
    forbiddenDrag();
    forbidenDeleteKeyDown();
    //onMessage('{"action":"editTopic","arguments":{"titile":"无题","questions":[{"body":"<br>","type":"fillBlank","id":"2e9c27ec-a16b-e1ac-632d-4df9b6000bbd","answer":{"content":["1<br>","2<br>","3<br>","4<br>","5<br>","6<br>","7<br>","8<br>"]}}]}}');

});
              