$(function() {
	
    var url = $.url();
    var zsid = url.fparam('quizSheetId');
    var classes = null;
    var classArray = null;
    
    function bindClasses() {
    	var sel = $('#selectClass')[0];
    	for (var i=0; i<classArray.length; i++) {
    		var opt = document.createElement('option');
    		opt.value = classArray[i].id;
    		opt.innerHTML=classArray[i].displayName;
    		sel.appendChild(opt);
    	} 
    }
    
	function mapToArray(map) {
		var result = [];
		for (id in map) {
			var value = map[id];
			value.id = id;
			result.push(value);
		}
		return result;
	}
    
    function loadClasses() {
    	$.getJSON('/groups', function(data) {
    		classes = data;
    		classArray = mapToArray(classes);
			bindClasses();
		}).error(function() {
			alert('获取班级列表失败了！');
		});
    }
    
    function startQuiz() {
    	var quiz = {};
    	quiz.quizSheet = zsid;
    	quiz.group = $('#selectClass').val();
    	$.ajax({
    	    contentType: 'application/json', //mime type of request
    	    data: JSON.stringify(quiz),
    	    success: function(data){
    	    	alert("测验已开始。");
    	    	window.location = '/quiz-monitor.html#quizId='+data;
    	    },
    	    error: function(){
    	    	alert("创建测验失败！");
    	    },
    	    processData: false,
    	    type: 'POST',
    	    url: '/newQuiz'
    	});
    }

    $('#commandCancel').click(function(){
    		window.history.back();
    });
    
    $('#commandNext').click(function(){
    		startQuiz();
    }); 
    
    loadClasses();    
});
