$(function() {

    var url = $.url();
    var quizSheets = null; //map
    var quizSheetList = null; //array
    var uid = url.fparam('uid');
    
    function bindQuizSheetList() {
    	if (!quizSheetList || quizSheetList.length == 0) {
    		return false;
    	}
    	var temp = $('#quizSheetPanel .quizSheet');
    	$('#quizSheetPanel .placeholder').addClass('hidden');
    	temp.removeClass('hidden');
    	var parent = temp[0].parentNode;
    	for(var i=1; i < quizSheetList.length; i++) {
    		temp.clone().appendTo(parent);
    	}
    	$('#quizSheetPanel .quizSheetTitile').each(function(j){
    		var titile = quizSheetList[j].titile || "无题"+new Date(quizSheetList[j].mtime).toString();
    		this.innerHTML= titile +'（' + new Date(quizSheetList[j].mtime).toLocaleString() +'）'; 
    	});
    	$('#quizSheetPanel input').each(function(k){
    		//this.value = quizSheetList[k].id;
    		$(this).attr('data-qsid', quizSheetList[k].id);
    	});
    }
    

	function mapToArray(map) {
		var result = [];
		for (id in map) {
			var value = map[id];
			value.id = id;
			result.push(value);
		}
		return result;
	}
	
	function loadQuizSheetList() {
		$.getJSON('/quizSheets', function(data) {
			quizSheets = data;
			quizSheetList = mapToArray(data);
			bindQuizSheetList();
		}).error(function() {
			alert('获取试卷列表失败了！');
		});
	}

	function loadQuizSheetListByLogin() {
		if (uid) {
		    login(loadQuizSheetList, function() {
				alert('用户' + uid + '登录失败了！');
			});
		} else
			loadQuizSheetList();
	}
	
	function getSelectedQuizSheetId() {
		var zsea = document.selectQuizSheet.quizSheet;
		if (zsea && !zsea.length && zsea.checked)
			return $(zsea).attr('data-qsid');
    	for (var i=0; i < zsea.length; i++) {
    		if (zsea[i].checked)
    			return $(zsea[i]).attr('data-qsid');
    	}
	}
    
    $('#commandEdit').click(function(){
    	var zsid = getSelectedQuizSheetId();
    	if (zsid)
    		window.location = '/quiz-sheet-edit.html#quizSheetId='+zsid+'&mode=remote';
    });
    
    $('#commandRemove').click(function(){
        var zsid = getSelectedQuizSheetId();
        if (zsid) {
            $.get('/deleteQuizSheet/'+zsid, function(data){
                window.location.reload();
            }).error(function(){
                alert('删除失败！');
            });
        }
    });
    
    $('#commandRename').click(function(){
        var zsid = getSelectedQuizSheetId();
        if (zsid) {
        	var zs = quizSheets[zsid];
        	$.prompt('输入试卷标题', zs.titile, function(title) {
    			if (typeof title === 'string') {
    				if (!title)
    					$.alert('试卷标题不能为空！');
    				else {
    					zs.titile = title;
    					$.ajax({
    			    	    contentType: 'application/json', //mime type of request
    			    	    data: JSON.stringify(zs),
    			    	    //dataType: 'json', //expected type of response
    			    	    success:function() {
    			    	    	window.location.reload();
    			    	    },
    			    	    error: function(){
    			    	    	$.alert("重命名失败！");
    			    	    },
    			    	    processData: false,
    			    	    type: 'POST',
    			    	    url: '/saveQuizSheet'
    			    	});    					
    				}
    			}
    		}); 
        }
    });
    
    $('#commandNew').click(function(){
    	//CEF 暂不支持 window.prompt()
//    	var titile = window.prompt('请输入试卷标题', '无题');
//    	if (titile)
//    		window.location = '/quiz-sheet-edit.html#quizSheetTitile='+titile+'&mode=new';
    	$.prompt('输入试卷标题', '新试卷', function(title) {
			if (typeof title === 'string') {
				if (!title)
					$.alert('试卷标题不能为空！'); //TODO prevent dialog disappearing
				else {
					window.location = '/quiz-sheet-edit.html#quizSheetTitile='+title+'&mode=new';
				}
			}
		});    	
    	//window.location = '/quiz-sheet-new.html'
    });
    
    $('#commandStartQuiz').click(function(){
    	var zsid = getSelectedQuizSheetId();
    	if (zsid)
    		window.location = '/quiz-start.html#quizSheetId='+zsid;
    });
    
    $.initDialog();
    
    loadQuizSheetListByLogin();
});
