$(function() {

	var url = $.url();
	var uid = url.fparam('uid');
	var quizzes = null;
	var teacher = {};
	var quiz = null;

	function displayState(id) {
		$('.state').addClass('hidden');
		$('#' + id).removeClass('hidden');
	}

	function bindQuiz() {
		if (quiz) {
			$('#quiz a').html(
					(teacher && teacher.displayName || '?') + "发布了测试："
							+ quiz.titile + "("
							+ new Date(quiz.startTime).toLocaleString() + ")")
					.attr('href', 'answer-sheet-edit.html#quizId=' + quiz.id);
			displayState('quiz');
		} else {
			displayState('noQuiz');
		}
	}

	function loadQuizFailed() {
		displayState('networkFailed');
	}

	function loginFailed() {
		displayState('networkFailed');
	}

	function mapToArray(map) {
		var result = [];
		for (id in map) {
			var value = map[id];
			value.id = id;
			result.push(value);
		}
		return result;
	}
	
	function getNewestQuiz() {
		if (quizzes.length <= 1)
			return quizzes[0];
		var ret = quizzes[0];
		for (var i=1; i<quizzes.length; i++) {
			if (new Date(ret.startTime) < new Date(quizzes[i].startTime))
				ret = quizzes[i];
		}
		return ret;
	}

	function loadQuizzes() {
		quizzes = quiz = teacher = null;
		$.getJSON('/liveQuizzes', function(data) {
			quizzes = mapToArray(data);
			quiz = getNewestQuiz();
			if (!quiz) {
				bindQuiz();
				return;
			}
			$.getJSON('/user/' + quiz.teacher, function(data) {
				teacher = data;
				bindQuiz();
			}).error(function() {
				bindQuiz();
			});
		}).error(function() {
			loadQuizFailed();
		});
	}

	function loadQuizzesByLogin() {
		if (uid) {
		    login(loadQuizzes, loginFailed);
		} else
			loadQuizzes();
	}

	$('#reload').click(function() {
		window.location.reload();
	});
	
	$('#host').text(url.attr().host || 'localhost');
	
	$('#edit-settings').click(function(){
		if (typeof ucbook != 'object'){
			alert("error: ucbook not exits!");
			return;
		}
		ucbook.loadLocal('tool/ClassRoom/settings.html');
	});

	loadQuizzesByLogin();

	setInterval(loadQuizzes, 2000);
});
