$(function() {

    var url = $.url();
    var questionId = url.fparam('questionId');
    if (!questionId)
        return;
    var parentLib = opener ? opener.exports : parent.exports;
    //Map<qid, {question:Qestion, answers:Map<uid, Answer>, 
	// hasScore:boolean, refAnswerHtml:string, commitedUids:[int],  correctUids:int}    
    var indexByQuestion = parentLib.indexByQuestion; 
    var questionItem = indexByQuestion[questionId];
    var students = parentLib.students; //[User]
    var commitedUserMap = {};
    var unCommitedUserMap = {};
    var allUserMap = {};
    var correctUserMap = {};
    
    var optionAnswerToString = parentLib.optionAnswerToString;
    var fillBlankAnswerToString = parentLib.fillBlankAnswerToString;
    
    function buildUserMap() {
    	for (var i in students) {
    		var user = students[i];
    		allUserMap[user.id] = user;
    	}
    	var cus = questionItem.commitedUids;
    	for (var i=0; i<cus.length; i++) {
    		var uid = cus[i];
    		commitedUserMap[uid] = allUserMap[uid];    		
    	}
    	for(var i in students) {
    		var user = students[i];
    		var uid = user.id;
    		if (!commitedUserMap[uid]) {
    			unCommitedUserMap[uid] = user;
    		}
    	}
    	var rus = questionItem.correctUids;
    	for (var i=0; i<rus.length; i++) {
    		correctUserMap[rus[i]] = true;
    	}
    }
    
    function bindUsers(userMap, listSelector) {
    	var templ = $('#sampleUserList .userItem');
    	var list = $(listSelector);
    	for (var uid in userMap) {
    		var user = userMap[uid];
    		if(!user)
    		    continue;
    		var item = templ.clone();    		
    		item.find('.name').html(user.displayName);
    		if (user.sex === 'f') {
    			var icon = item.find('.icon');
    			icon.attr('src', icon.attr('data-female-icon'));
    		}
    		item.attr('data-uid', uid);
    		item.appendTo(list);
    	}
    }
    
    function answerToString(quesType, answer) {
    	if (! ('content' in answer))
    		return '';
    	var content = answer.content;
    	switch(quesType) {
		case "singleOption":
		case "multiOption":			
			return optionAnswerToString(answer.content);
		case "fillBlank":
			return fillBlankAnswerToString(answer.content);
		case "bool":
			if (typeof answer.content === 'boolean') {
				return answer.content? "正确":"错误";
			}
			return '';
		case "free":
			return answer.content;
			break;
		} //end switch
    }
    
    function bindAnswers() {
    	if (!questionItem)
    		return;
    	var ques = questionItem.question;
    	$('#titile .type').html(parentLib.questionTypeMap[ques.type]);
    	
    	//部分复用bindAnswerSheets()
    	var status = $('#status');
    	status.find('.commitCount').html(questionItem.commitedUids.length);
    	status.find('.unCommitCount').html(Object.keys(students).length - questionItem.commitedUids.length)
        if (questionItem.hasScore) {
            status.find('.correctCount').html(questionItem.correctUids.length);
            status.find('.wrongCount').html(questionItem.commitedUids.length - questionItem.correctUids.length);
            if (questionItem.commitedUids.length > 0)
              status.find('.correctRatio').html(Math.round(100 * questionItem.correctUids.length / questionItem.commitedUids.length));
        } else {
            status.find('.scoreCount').addClass('hidden');
        }
    	
    	$('#commitUserList .userItem').each(function(){
    		var userItem = $(this);
    		var uid = userItem.attr('data-uid');
    		var ans = questionItem.answers[uid];    		
    		userItem.find('.answer').html(answerToString(ques.type, ans))
    		    .removeClass('hidden');
    		if (questionItem.hasScore) {
    			var imgSel = correctUserMap[uid] ?  '.wrong' : '.correct';
    			userItem.find('.score').removeClass('hidden')
    			  .find(imgSel).addClass('hidden');
    		}
    	});
    }
    
   //复用
    function layout() {
        $(".userList").each(function(){
            var height = window.innerHeight - this.offsetTop;
            if (height < 10) height = 10;
            this.style.height=height+"px";
        });
    }
    
    $('.tab').click(function() {
    	var tab = $(this);
    	$('.tab').removeClass('selected');
    	tab.addClass('selected');
    	var id = tab.attr('id');
    	var contentId = tab.attr('data-content');
    	$('.userList').addClass('hidden');
    	$('#'+contentId).removeClass('hidden');
    	layout();
    });
    
    $('#commandClose').click(function() {
        $(parent.document).find('#questionView').addClass('hidden');
    });
    
    buildUserMap();
    bindUsers(commitedUserMap, '#commitUserList');
    bindUsers(unCommitedUserMap, '#unCommitUserList');
    bindAnswers();    
    

    layout();
    window.onresize = layout;
});
