$(function() {
    var saveURI = '/postAnswerSheet'; //暂存、提交答卷。根据答卷中的commit=true标志决定。
    //var commitURI = '/commitAnswerSheet'; //提交答卷。
    var options = {
            iconsPath : 'javascripts/nicEdit/nicEditorIcons.gif', //相对引用的html文件即可
            uploadURI : '/uploadImage',
            // buttonList : [ 'fontSize', 'bold', 'italic', 'subscript',
            // 'superscript', 'image', 'upload' ]
            // ['fontSize','bold','italic','underline','strikeThrough','subscript','superscript','html','image']}).panelInstance('area4');
            fullPanel : true
    };
    var myNicEditor = new nicEditor(options); // 一个编辑器实例可用于多个编辑区
    var localQid = 0; // 试题的本地id，自增。与服务器端的试题id无关。服务器端的试题的id，是 .question 的属性
    var url = $.url();
    
    //quizSheetId 指出测试的id。
    var quizId = url.fparam('quizId');
    var quizSheetId = null;

    var sampleEditorPaneId = "sampleEditorPane";
    var realEditorPaneId = "editorPane";

    var classForEdit = [".blankBody", ".answerBody"];
    var questionTypeMap = { singleOption: "单选", multiOption:"多选", bool:"判断", fillBlank:"填空", free:"问答"};
    var selectedQuesId = null;
    
    var quiz = null;
    var quizSheet = null; //JSON
    var answerSheet = {};

    //复用
    function enableEditQuestion(quesElem) {
        if (!quesElem.id)
            quesElem.id = localQid + "-question";
        for (var k = 0; k < classForEdit.length; k++) {
            var clazz = classForEdit[k];
            $(quesElem).find(clazz).each(function(j) {
                if (this.id && myNicEditor.instanceById(this.id))
                    return;
                // question 元素的 id 的结构是 localQid-clazz-n
                var eid = localQid + "-" + clazz.slice(1) + "-" + j;
                this.id = eid;
                myNicEditor.addInstance(eid);
            });
        }
        localQid++;
        return quesElem;
    }

    //复用
    function addQuestion(type, position) {
        if (!isFinite(position))
            position = -1;
        var templType = (type === 'singleOption') ? 'multiOption' : type;
        var ques = $(
                '#sampleEditorPane  .question[data-questionType="' + templType
                + '"]').clone();
        // ques[0].id = (localQid++) + "-question";
        ques.attr('data-questionType', type);
        ques.find('.questionType').html(questionTypeMap[type]);
        ques.find(classForEdit.join(',')).empty();

        if (selectedQuesId && position < 0) {
            ques.insertAfter(document.getElementById(selectedQuesId));
        } else {
            questions = $("#editorPane  .question");
            if (questions[position])
                ques.insertBefore(questions[position]);
            else {
                ques.appendTo($("#editorPane"));
            }
        }
        if (!answerSheet.commit)
        	enableEditQuestion(ques[0]);
        return ques[0];
    }

    /**
     * 让#questionList, .editorPane 占据余下的高度，并可以滚动。CSS很难单独做到。
     * 参考：http://stackoverflow.com/questions/90178/make-a-div-fill-the-remaining-screen-space
     */
    //部分复用
    function layout() {
        $("#mainPane").each(function(){
            var height = window.innerHeight - this.offsetTop;
            if (height < 10) height = 10;
            this.style.height=height+"px";
        });
    }
    
    //复用
    function innerHtmlIfNotEmpty(elem) {
    	elem = $(elem);
    	if (elem.find('img, embeded, object').length === 0) {
    		var txt = $.trim(elem.text());
    		if (!txt)
    			return txt;
    	}
    	return elem.html();
    }

    function answerSheetToJS() {
        var as = {};
        as.quiz = quizId;
        as.answers = [];
        $("#editorPane  .question").each(function(i){
        	var thiz = $(this);
        	var ans = as.answers[i] = {};
        	var qtype = thiz.attr('data-questionType');
        	var qid = thiz.attr('data-questionId');
        	ans.question = qid;

        	switch(qtype) {
			case "singleOption":
			case "multiOption":
				thiz.find(".questionOptions input").each(function(j){
					//this.getAttribute('checked') === 'checked' 是不合适的，因为它不会因为用户的选择而改变。
					if (this.checked){
						if (!ans.content)
							ans.content = [];
						ans.content.push(j); 
					}						
				});
				break;
			case "fillBlank":
				thiz.find(".blankBody").each(function(j){
					var body = innerHtmlIfNotEmpty(this);
					if (body) {
						if (!ans.content)
							ans.content = [];
						ans.content[j] = body;
					}
				});
				break;
			case "bool":
				var checkBoxes = thiz.find(".questionOptions input");
				if (checkBoxes[0].checked)
					ans.content = true;
				else if (checkBoxes[1].checked)
					ans.content = false;
				break;
			case "free":
				var body = innerHtmlIfNotEmpty(thiz.find(".answerBody")[0]);
				if (body)
					ans.content = body;
				break;
        	} //end switch
        }); //end each
        return as;
    }

    /**
     * @param commit 是否提交，否则只保存。
     */
    function postAnswerSheet(commit) {
    	if (answerSheet && answerSheet.commit) {
    		alert("试卷已提交，无法再次提交"); //TODO: 不提供提交按钮
    		return;
    	}    		
    	var answerSheet = answerSheetToJS();
    	if (commit)
    		answerSheet.commit = true;
    	$.ajax({
    	    contentType: 'application/json', //mime type of request
    	    data: JSON.stringify(answerSheet),
    	    //dataType: 'json', //expected type of response
    	    success: function(data){
    	    	if (!commit) {
    	    		alert("保存成功！");
    	    	} else
    	    		alert("提交成功！");
    	    	window.location.reload();
//    	    	var newPage =  '/answer-sheet-edit.html#quizSheetId='+quizSheetId;
//    	    	if (window.location.href === newPage)
//    	    		window.reload();
//    	    	else
//    	    		window.location == newPage;
    	    },
    	    error: function(){
    	    	alert("保存失败！");
    	    },
    	    processData: false,
    	    type: 'POST',
    	    url: saveURI
    	});
    	//alert(JSON.stringify(zs));
//    	$.post(saveURI, zs, function(data){
//    		window.location = '/quiz-sheet-edit.html#mode=remote&quizSheetId='+data;
//    	}).error(function(){
//    		alert("保存失败！");
//    	});
    }
    
    
    function optionAnswerToString(answerArray) {
    	if (!answerArray)
    		return '';
    	var optionNames="ABCDEF";
    	var result = '';
    	for (var i=0; i<answerArray.length; i++) {
    		result+=optionNames[answerArray[i]];
    	}
    	return result;
    }
    
    function fillBlankAnswerToString(answerArray) {
    	if (!answerArray)
    		return '';
    	return answerArray.length > 0 ? answerArray.join('、') : '';
    }
    
    /**
     * 把我的答案附加到试卷问题上的myAnswer字段。
     */
    function attachMyAnswer() {
    	if (!quizSheet || !answerSheet.answers)
    		return false;
    	var ans = answerSheet.answers;
    	var ques = quizSheet.questions;
    	for (var i = 0; i < ques.length; i++) {
    		var q = ques[i];
    		for (var j=0; j < ans.length; j++) {
    			var a = ans[j];
    			if(a.question === q.id)
    				q.myAnswer = a;
    		}
    	}
    	return true;
    }
    
    function generateScore() {
    	$('#editorPane .question').each(function(i) {
    		var scoreElem = $(this).find(".score");
    		if (scoreElem.length === 0)
    			return;
    		if(!quizSheet.questions[i].answer)
    			return;
			var refAnswer = quizSheet.questions[i].answer && quizSheet.questions[i].answer.content;
			var myAnswer = quizSheet.questions[i].myAnswer && quizSheet.questions[i].myAnswer.content;			
			if (typeof refAnswer === 'object') {
				refAnswer = JSON.stringify(refAnswer);
				myAnswer = JSON.stringify(myAnswer);
			}
			var correct = (refAnswer === myAnswer); //TODO 精确化
			if (correct)
				scoreElem.find('.wrong').addClass('hidden');
			else
				scoreElem.find('.correct').addClass('hidden');
			scoreElem.removeClass('hidden');
    	});
    }
    
    //部分复用 loadQuizSheet()
    function bindQuizSheetAndAnswerSheet() {
        $("#quizTitle").html(quizSheet.titile);
        
    	//只有未提交的答卷才可以编辑、提交
    	if (!answerSheet.commit)
    		myNicEditor.setPanel('nicEditPanel'); 
    	else {
    		$('#commandCommit').remove();
    		$('#commandSave').remove();
    	}
    	
    	attachMyAnswer();
		var ques = quizSheet.questions;
		for (var i=0; i<ques.length; i++) {
			var qElem = addQuestion(ques[i].type);
			qElem=$(qElem);
			qElem.find(".questionBody").html(ques[i].body);
			if (ques[i].answer && ques[i].answer.comment)
				qElem.find(".questionComment").html(ques[i].answer.comment);
			qElem.attr("data-questionId", ques[i].id);
			qElem.find(".questionNumber").html(i + 1 + '. ');
			var refAnswer = ques[i].answer && ques[i].answer.content;
			var refAnswerBody = qElem.find(".refAnswerBody").empty();
			var myAnswer = ques[i].myAnswer && ques[i].myAnswer.content;
//			if (ques[i].answer)
//				qElem.attr("data-answerId", ques[i].answer.id);
			var nRemoveRows = 0;
			switch(ques[i].type) {
			case "singleOption":
			case "multiOption":
				qElem.find(".optionBody").each(function(j){
					if (j < ques[i].options.length)
					this.innerHTML = ques[i].options[j];
				});
				var checkBoxes = qElem.find(".questionOptions input");
				if (myAnswer) {
					for (var k = 0; k < myAnswer.length; k++) {
						if (myAnswer[k] < checkBoxes.length)
							checkBoxes[myAnswer[k]].checked = true;
					}
				}
				nRemoveRows = ques[i].options.length;
				refAnswerBody.html(optionAnswerToString(refAnswer));
				break;
			case "fillBlank":
				var blankBodys = qElem.find(".blankBody").each(function(j){
					if (myAnswer && j < myAnswer.length)
    					this.innerHTML = myAnswer[j];
				});
				if (refAnswer && refAnswer.length > 0)
					nRemoveRows = refAnswer.length;
				refAnswerBody.html(fillBlankAnswerToString(refAnswer));
				break;
			case "bool":
				if (typeof myAnswer === 'boolean') {
					var checkBoxes = qElem.find(".questionOptions input");
					var idx = myAnswer? 0 : 1;
					checkBoxes[idx].checked = true;
				}
				if (typeof refAnswer === 'boolean') {
					refAnswerBody.html(refAnswer? "正确":"错误");
				}
				break;
			case "free":
				if (myAnswer) {
					qElem.find(".answerBody").html(myAnswer);
				}
				refAnswerBody.html(refAnswer);
				break;
			} //end switch
			//删除多余的选择支和空位
			if (nRemoveRows > 0) {
				qElem.find(".questionOptions tbody>tr:gt(" + (nRemoveRows - 1) +")").remove();				
			}
		} //end for
		
		if (answerSheet.commit) {
			generateScore();
			$('#editorPane .refAnswer').removeClass('hidden');
			$('#editorPane input').each(function(){
				this.disabled = true;
			});
		}
		attachEventHandler();
    }
    
    //部分复用 loadQuizSheet()
	function loadQuizSheetAndAnswerSheet() {
		var urlQuiz = '/quiz/' + quizId;
		$.getJSON(urlQuiz, function(data) {
			quiz = data;
			quizSheetId = quiz.quizSheet;
			var urlQuizSheet = "/quizSheet/" + quizSheetId;
			$.getJSON(urlQuizSheet, function(data) {
				quizSheet = data;
				quizSheetTitile = quizSheet.titile;
				var urlAnswerSheet = "/answerSheet/viaQuiz/" + quizId;
				$.getJSON(urlAnswerSheet, function(data) {
					answerSheet = data || {};
					bindQuizSheetAndAnswerSheet();
					layout();
				}).error(function() {
					alert("从 " + urlAnswerSheet + " 获取答卷失败了!"); // TODO: 显示响应
				});
			}).error(function() {
				alert("从 " + urlQuizSheet + " 获取试卷失败了!"); // TODO: 显示响应
			});
		}).error(function() {
			alert("从 " + urlQuiz + " 获取测试失败了!"); // TODO: 显示响应
		});
	}
	
	function attachEventHandler() {
		if (!answerSheet || answerSheet.commit) {
			$('.touchArea').removeClass('touchArea');
			return;
		}
		$('.touchArea input').click(function (ev) {
			//ev.preventDefault(); //取消缺省行为，即选中/反选。但是这与 touchArea 上的处理器结合的话，input还是无法选中，所以不用。
			ev.stopPropagation(); //阻止事件传播。因为input会在其父元素之前得到click事件，所以调用后touchArea不会再处理。
			//return false; //jQuery 中 return false 等效于preventDefault() + stopPropagation()。
		});

		$('.touchArea').click(function _touchArea_clicked(ev){
			var input = $(this).find('input')[0];
			if (input && !input.disabled)
				input.checked = !input.checked;
			ev.stopPropagation();
		});
	}

    $('#commandSave').click(function() {
    	postAnswerSheet(false);
    });
    
    $('#commandCommit').click(function() {
    	postAnswerSheet(true);
    });
    
    $('#commandBack').click(function() {
    	window.location = '/quiz-receiver.html';
    });

    loadQuizSheetAndAnswerSheet();

    layout();
    window.onresize = layout;
});
