﻿///单击，双击处理
var resolveClickAndDblClick = null;
///当前选中的元素;
var nowEl = null;
///资源根目录
var _resRootDir;
///上下文件菜单位置
var contextMenuPosition = {
    x: 0,
    y: 0
};
var mysign = true;
var mysign2 = true;


var _idex = 0;
var common = {
    show: function (el, p) {
        var id = $(nowEl).attr("data-id");
        if (id.startsWith('0_')) {
            $(".fl").css("color", "#AAAAAA");
        }
        else {
            $(".fl").css("color", "#0099cc");
        }

        var left = $(nowEl).offset().left - 22;
        var top = $(nowEl).offset().top + 50;

        if (p) {
            el.css({ left: left, top: top });
        };
        el.show();
    },
    hide: function (el) {
        el.hide();
    },
    showOrHide: function (el, p) {
        if (window.getComputedStyle($("#contextMenu")[0], null).display === "block") {
            common.hide(el);
        } else {
            common.show(el, p);
        }
    },
    showTab: function ($e, $arr, cl) {
        $arr.removeClass();
        $e.addClass(cl);
    }
};

function showHideMenu(ev, flag) {
    if (ev.target.tagName.toLowerCase() === "a") {
        contextMenuPosition.x = ev.clientX;
        contextMenuPosition.y = ev.clientY + (document.body.scrollTop || document.documentElement.scrollTop); //Chrom FF兼容
        if ((contextMenuPosition.x + $("#contextMenu").width()) > document.body.clientWidth) {
            contextMenuPosition.x = document.body.clientWidth - $("#contextMenu").width()
        };
        if ((contextMenuPosition.y + $("#contextMenu").height()) > document.body.clientHeight) {
            contextMenuPosition.y = document.body.clientHeight - $("#contextMenu").height()
        }
        contextMenuPosition.x += 1;
        contextMenuPosition.y += 1;
        var nametemp = $(ev.target).attr("data-name");
        if (!nametemp.startsWith('导入书籍')) {
            var id = $(nowEl).attr("data-id");
            if (id != undefined && id != null && id != "") {
                if (flag) {
                    common.showOrHide($("#contextMenu"), contextMenuPosition);
                } else {
                    common.show($("#contextMenu"), contextMenuPosition);
                };
            }
            else {
                DownLoadBookFromClient($(nowEl).attr("data-platformid"));
            }
        }
        else {
            ImportBook();
        }

        $("#contextMenu dt").html($(ev.target).attr("data-name"))
        $("#contextMenu dd").html($(ev.target).attr("data-Publish"))
        return false;
    }
    common.hide($("#contextMenu"));
    return false;
}

function events() {
    $("body").bind("contextmenu", function (ev) {
        var flag = (nowEl == ev.target);
        nowEl = ev.target;
        showHideMenu(ev, flag);
        return false;
    });

    $(document).bind("click", function (ev) {
        clearTimeout(resolveClickAndDblClick);
        if (mysign) {
            resolveClickAndDblClick = setTimeout(function () {
                var flag = (nowEl == ev.target);
                nowEl = ev.target;
                showHideMenu(ev, flag);
            }, 300);
        }
    });
    $(document).bind("touchstart", function (ev) {
        mysign = false;
        clearTimeout(resolveClickAndDblClick);
        resolveClickAndDblClick = setTimeout(function () {
            var flag = (nowEl == ev.target);
            nowEl = ev.target;
            showHideMenu(ev, flag);
        }, 300);
        setTimeout(function () {
            mysign = true;
        }, 800);
    });
    $(document).bind("click", function (ev) {
        clearTimeout(resolveClickAndDblClick);
        if (mysign) {
            resolveClickAndDblClick = setTimeout(function () {
                var flag = (nowEl == ev.target);
                nowEl = ev.target;
                showHideMenu(ev, flag);
            }, 300);
        }
    });
    //touchstart
    $(document).delegate(".bookSync", "touchstart", function (ev) {

        console.log($(this));
        console.log(ev.target)
        var platformId = $(this).attr("platformId");
        DownLoadBookFromClient(platformId);
        setTimeout(function () {
            mysign2 = true;
        }, 800);
    });
    function mytouch(mytouch) {
        mysign2 = false;
        DownLoadBookFromClient(mytouch);
    }
    $(document).bind("dblclick", function (ev) {
        clearTimeout(resolveClickAndDblClick);
        if (ev.target.tagName.toLowerCase() === "a") {
            common.hide($("#contextMenu"));
            nowEl = ev.target;
            var nametemp = $(ev.target).attr("data-name");
            if (!nametemp.startsWith('导入书籍')) {
                //OpenBook( $(nowEl).attr("data-id") );
                var id = $(nowEl).attr("data-id");
                if (id == "" || id == undefined || id == null) {
                    DownLoadBookFromClient($(nowEl).attr("data-platformid"));
                }
                else {
                    OpenBook($(nowEl).attr("data-id"));
                }
            }
            else {
                ImportBook();
            }

        };
    });



    $("#contextMenu ol").click(function (ev) {
        var id = $(nowEl).attr("data-id");

        if (ev.target.dataset.open) {
            if (id == "" || id == undefined || id == null) {
                DownLoadBookFromClient($(nowEl).attr("data-platformid"));
            }
            else {
                OpenBook(id);
            }
        }
        //OpenBook(id);
        if (ev.target.dataset.delete) {
            if (!id.startsWith('0_')) {
                DeleteBook(id);
            }
        }
        $("#contextMenu").hide();
    });

    $(window).bind("resize", layout);

    function layout() {
        $("#book-items").css("minHeight", document.documentElement.offsetHeight - $("#book-items")[0].offsetTop)
    };
    layout();

    //GetBookListByType(1);
    getBookListType();
    ucbook.onWebPageMessage = onMessage;
}

function getBookListType() {
    ucbook.invokeCsFunction("getBookType");
}
function DeleteBook(bookId) {
    ucbook.invokeCsFunction("DeleteBook", bookId);
}

function OpenBook(bookId) {
    ucbook.invokeCsFunction("OpenBook", bookId);
}
function ImportBook() {
    ucbook.invokeCsFunction("ImportBook");
}
function DownLoadBook(bookId) {
    ucbook.invokeCsFunction("DownLoadBook", bookId);
}

function DownLoadBookFromClient(platformId) {
    if (mysign2) {
        mysign2 = false;
        ucbook.invokeCsFunction("DownLoadBookFromClient", platformId);
    }
    setTimeout(function () {
        mysign2 = true;
    }, 800);
}

function GotoShowByType(type) {
    return ucbook.invokeCsFunction("GotoShowByType", parseInt(type));
}

function GetBookListByType(type) {
    return ucbook.invokeCsResultFunction("GetBookListByType", type);
}

function GetBookListByType_result(books) {
    UpdateBookShelf(books);
}

function RefreshBookShelf() {
    var newArray = []
    for (var key in arguments) {
        newArray.push(arguments[key]);
    }
    var jsId = newArray.pop();

    UpdateBookShelf(newArray);
}
function SetMyActionMsg(msg) {
    $("#MyActionContent").text(msg);

}
function SetMyActionMsgView(msg) {
    $("#MyAction").css("display", msg);

}
function UpdateBookShelf(books) {
    $.each(books, function (i, e) {
        e.CoverPath = _resRootDir + e.CoverPath;
    });
    list.items = books;
    list.update();

}

function SetMBook(istrue) {
    if (!istrue) {
        $("#header ul>li").each(function () {
            if ($(this).attr("data-list") == "2") {
                $(this).hide();
            }
        });
    }
}

function BookDownLoadingProgress(p) {
    for (var i = 0; i < list.items.length; i++) {
        var b = list.items[i];
        if (b.Id == p.Id) {
            b.Progress = p.Progress;
            b.State = p.State;
            break;
        }
    }
    list.update();
}

function onMessage(message) {
    var msg;
    try {
        msg = JSON.parse(message);
    } catch (e) {
        console.log(e + ":" + message);
        return;
    }

    switch (msg.action) {
        case "updateProgress":
            BookDownLoadingProgress(msg.arguments);
            break
    }
}

function setBookListType(obj) {
    ucbook.invokeCsFunction("SetMBook");
    GetBookListByType(obj);
    var index = 0;
    switch (obj) {
        case 1:
            index = 0;
            break;
        case 24:
            index = 1;
            break;
        case 3:
            index = 2;
            break;
        case 2:
            index = 3;
            break;
    }
    book.selectedIndex = index;
    book.update();
}
function SetAssetsPath(dir) {
    _resRootDir = "file:///" + dir;
}

function page_deactivate() {
    common.hide($("#contextMenu"));
}

function book_mouseout(bookDiv) {
    if (bookDiv != null) {
        var tooltip = $("#tooltip");
        tooltip.text('');
        tooltip.css("visibility", "hidden");
    }
}

function book_mouseover(bookDiv, e) {
    if (bookDiv != null) {
        var tooltip = $("#tooltip");
        var publish = $(bookDiv).attr("data-name");
        if (publish && publish != '') {
            tooltip.text(publish);

            var clientWidth = document.body.clientWidth;
            var clientHeight = document.body.clientHeight;

            var left = e.clientX;
            var top = e.clientY + (document.body.scrollTop || document.documentElement.scrollTop);

            if (left + tooltip[0].offsetWidth > clientWidth)
                left = clientWidth - tooltip[0].offsetWidth - 5;
            if (top + tooltip[0].offsetHeight > clientHeight)
                top = clientHeight - tooltip[0].offsetHeight - 5;

            tooltip.offset(function (n, c) {
                newPos = new Object();
                newPos.left = left;
                newPos.top = top;
                return newPos;
            });

            tooltip.css("visibility", "visible");
        }
    }
}

if (!String.prototype.startsWith) {
    Object.defineProperty(String.prototype, 'startsWith', {
        enumerable: false,
        configurable: false,
        writable: false,
        value: function (searchString, position) {
            position = position || 0;
            return this.indexOf(searchString, position) === position;
        }
    });
}

var app = angular.module("App", []);
app.factory("list", function () {
    return {
        items: null,
        update: function () {
            $("#main").scope().items = this.items;
            $("#main").scope().$apply();
        }
    }
});


app.factory("booktype", function () {
    return {
        selectedIndex: -1,
        update: function () {
            $("#header").scope().selected = this.selectedIndex;
            $("#header").scope().$apply();
        }
    }
});

var list = angular.injector(["App"]).get("list");
var book = angular.injector(["App"]).get("booktype");


app.controller("book.ctr", ["$scope", "list", function ($scope, list) {
    $scope._resRootDir = _resRootDir;
    $scope.items = list.items;
    $scope.deleteBook = function (bookId) {
        DeleteBook(bookId)
    };
    $scope.goByType = function () {
        GotoShowByType($(".activeLi").attr("data-list"))
    };

    $scope.showResString = getResString;
}]);

app.controller("book.type", ["$scope", "list", function ($scope, list) {
    $scope.items = [
		{ name: ucbook.constant.bookself.ElectronicCourse, listType: 1 },
		{ name: ucbook.constant.bookself.ElectronicTeaching, listType: 24 },
		{ name: ucbook.constant.bookself.VideoClassRoom, listType: 3 },
		{ name: ucbook.constant.bookself.MultimediaBook, listType: 2 }
    ];

    $scope.selected = 0;

    $scope.showByType = function (index, showType) {
        $scope.selected = index;
        var get = GetBookListByType(showType);
    };
    $scope.myres_click = function () {
        ucbook.invokeCsFunction("MyDownLoadRecords");
    };

    $scope.MyAction_click = function () {
    };
    $scope.showResString = getResString;
}]);

app.controller("book.context", ["$scope", "list", function ($scope, list) {
    $scope.showResString = getResString;
}]);

window.onload = events;

function getResString(name) {
    return ucbook.constant.bookself[name];
}