/**
 * 更新用户组（班级）信息到服务器。
 * 用户组将从 ucbook.getProperty('classList') 中获得，ucbook 可以用 CEF 绑定。
 * @param fSuccess 成功时执行的回调
 * @param fFailed 失败时执行的回调
 */
function updateGroups(fSuccess, fFailed) {
		if (typeof ucbook !== 'object') {
			//alert("error: ucbook not exits!");
			if (fFailed)
				fFailed();
			return;
		}
		ucbook.getProperty('classList', function(classList) {
			if (!classList) {
				//alert("error: ucbook.getProperty('classList') is empty!");
				if (fFailed)
					fFailed();
				return;
			}
			$.ajax({
				contentType: 'application/json', //mime type of request
				data: classList,
				success: fSuccess,
				error: fFailed,
				processData: false,
				type: 'POST',
				url: '/updateGroups'
			});
		});
}