$(function() {

    var url = $.url();
    var quizSheetList = null; //JSON
    var uid = url.fparam('uid');
    var paramGid = url.fparam('gid');
    
    function bindQuizSheetList() {
    	if (!quizSheetList || quizSheetList.length == 0) {
    		return false;
    	}
    	var temp = $('#quizSheetPanel .quizSheet');
    	$('#quizSheetPanel .placeholder').addClass('hidden');
    	temp.removeClass('hidden');
    	var parent = temp[0].parentNode;
    	for(var i=1; i < quizSheetList.length; i++) {
    		temp.clone().appendTo(parent);
    	}
    	$('#quizSheetPanel .quizSheetTitile').each(function(j){
    		var titile = quizSheetList[j].titile || "无题"+new Date(quizSheetList[j].mtime).toString();
    		this.innerHTML= titile +'（' + new Date(quizSheetList[j].mtime).toLocaleString() +'）'; 
    	});
    	$('#quizSheetPanel input').each(function(k){
    		$(this).attr('data-qsid', quizSheetList[k].id);
    	});
    }
    

	function mapToArray(map) {
		var result = [];
		for (id in map) {
			var value = map[id];
			value.id = id;
			result.push(value);
		}
		return result;
	}
	
	function loadQuizSheetList() {
		$.getJSON('/quizSheets', function(data) {
			quizSheetList = mapToArray(data);
			bindQuizSheetList();
		}).error(function() {
			alert('获取试卷列表失败了！');
		});
	}

	function loadQuizSheetListByLogin() {
		if (uid) {
		    login(
		    		function () {
		    			updateGroups(); //update-groups.js
		    			loadQuizSheetList();
		    		}
		    		, function() {
		    			alert('用户' + uid + '登录失败了！');
		    		}
		    );
		} else
			loadQuizSheetList();
	}
	
	function getSelectedQuizSheetId() {
		var zsea = document.selectQuizSheet.quizSheet;
		if (zsea && !zsea.length && zsea.checked)
			return $(zsea).attr('data-qsid');
    	for (var i=0; i < zsea.length; i++) {
    		if (zsea[i].checked)
    			return $(zsea[i]).attr('data-qsid');
    	}
	}
	
	function startQuiz(zsid) {
		if (paramGid)
			return doStartQuiz(zsid, paramGid);

		$.getJSON('/groups', function(data) {
    		var classes = data;
    		var options = [];
    		for (var gid in classes) {
    			options.push({ value: gid, text: classes[gid].displayName });
    		}
    		$.option('选择班级', options, function(gid) {
    			if (gid) {
    				doStartQuiz(zsid, gid);
    			}
    		})
		}).error(function() {
			$.alert('获取班级列表失败了！');
		});
		
		function doStartQuiz(zsid, gid) {
			var quiz = {};
			quiz.quizSheet = zsid;
			quiz.group = gid;
			$.ajax({
				contentType: 'application/json', //mime type of request
				data: JSON.stringify(quiz),
				success: function(data){
					//alert("测验已开始。");
					window.location = '/quiz-monitor.html#quizId='+data;
				},
				error: function(){
					$.alert("创建测验失败！");
				},
				processData: false,
				type: 'POST',
				url: '/newQuiz'
			});
		}
	}
    
    $('#commandStartQuiz').click(function(){
    	var zsid = getSelectedQuizSheetId();
    	if (zsid)
    		startQuiz(zsid);
    		//window.location = '/quiz-start.html#quizSheetId='+zsid;
    });
    
    $.initDialog();
    
    loadQuizSheetListByLogin();
});
