$(function() {
    var saveURI = '/saveQuizSheet';
    var getURI = '/quizSheet';
    var options = {
            iconsPath : 'javascripts/nicEdit/nicEditorIcons.gif', //相对引用的html文件即可
            uploadURI : '/uploadImage',
            // buttonList : [ 'fontSize', 'bold', 'italic', 'subscript',
            // 'superscript', 'image', 'upload' ]
            // ['fontSize','bold','italic','underline','strikeThrough','subscript','superscript','html','image']}).panelInstance('area4');
            fullPanel : true
    };
    var myNicEditor = new nicEditor(options); // 一个编辑器实例可用于多个编辑区
    var localQid = 0; // 试题的本地id，自增。与服务器端的试题id无关。服务器端的试题的id，是 .question 的属性
    // data-qid。
    
    var url; 
  //mode 可以是 new （新建），demo（演示，默认），remote（从服务器加载）
    //如果是remote，应给出quizSheetId参数。
    //如果是new，应给出quizSheetTitile。
    var mode;
    var quizSheetId;
    var quizSheetTitile;
    
    var sampleEditorPaneId = "sampleEditorPane";
    var realEditorPaneId = "editorPane";
    //var currentEditorPaneId = sampleEditorPaneId;
    var classForEdit = [".questionBody", ".optionBody", ".blankBody", ".answerBody",".questionComment"];
    var questionTypeMap = { singleOption: "单选", multiOption:"多选", bool:"判断", fillBlank:"填空", free:"问答"};
    var selectedQuesId = null;
    
    var quizSheet = null; //JSON
    
    function initParam() {
    	url = $.url();
        mode = url.fparam('mode');
        quizSheetId = url.fparam('quizSheetId');
        quizSheetTitile = url.fparam('quizSheetTitile') || quizSheetTitile;
    }

    function enableEditorPane() {
        var questions = $("#editorPane  .question");
        questions.each(function(i) {
            enableEditQuestion(this);
        });
    }

    function enableEditQuestion(quesElem) {
        if (!quesElem.id)
            quesElem.id = localQid + "-question";
        for (var k = 0; k < classForEdit.length; k++) {
            var clazz = classForEdit[k];
            $(quesElem).find(clazz).each(function(j) {
                if (this.id && myNicEditor.instanceById(this.id))
                    return;
                // question 元素的 id 的结构是 localQid-clazz-n
                var eid = localQid + "-" + clazz.slice(1) + "-" + j;
                this.id = eid;
                myNicEditor.addInstance(eid);
            });
        }
        localQid++;
        return quesElem;
    }

    function createQuestionList() {
        var ql = $("#questionList .main");
        var templ = $('#sampleQuestionListItem'); 
        ql.empty();
        questions = $("#editorPane  .question");
        questions.each(function(i) {
            var thiz = $(this);
            var li = templ.clone();
            li.removeAttr("id");
            li[0].setAttribute("data-refId", this.id);
            li.find(".listType")[0].innerHTML= questionTypeMap[this.getAttribute("data-questionType")] || "未知";
            li.find(".listTitile")[0].innerHTML = thiz.find(".questionBody").text(); //innerText 支持不广泛，用text()代替
            li.appendTo(ql);
            li[0].onclick = function() { selectQuestionListItem(this.getAttribute("data-refId")) };
        });
        selectQuestionListItem(selectedQuesId);
    }

    function updateQuestionList() {
        $("#questionList li").each(function(i){
            var qbody = $("#"+this.getAttribute("data-refId")+"  .questionBody");
            var title = $(this).find(".listTitile");
            var strBody = qbody.text();
            if (title.text() !== strBody)
                title[0].innerHTML = strBody;
        });
    }	

    function addQuestion(type, position) {
        if (!isFinite(position))
            position = -1;
        var templType = (type === 'singleOption') ? 'multiOption' : type;
        var ques = $(
                '#sampleEditorPane  .question[data-questionType="' + templType
                + '"]').clone();
        // ques[0].id = (localQid++) + "-question";
        ques.attr('data-questionType', type);
        ques.find('.questionType').html(questionTypeMap[type]);
        ques.find(classForEdit.join(',')).empty();

        if (selectedQuesId && position < 0) {
            ques.insertAfter(document.getElementById(selectedQuesId));
        } else {
            questions = $("#editorPane  .question");
            if (questions[position])
                ques.insertBefore(questions[position]);
            else {
                ques.appendTo($("#editorPane"));
            }
        }
        enableEditQuestion(ques[0]);
        return ques[0];
    }

    function deleteQuestion(id) {
        var ques = $('#'+id+".question");
        ques.find("div[id]").each(function(){
            if (myNicEditor.instanceById(this.id))
                myNicEditor.removeInstance(this.id);
        });
        ques.remove();
        createQuestionList();
    }

    function moveQuestion(id, direction) {
        var ques = $('#'+id+".question")[0];
        if (!ques)
            return false;
        var target = ques;
        if (direction === 'up') {
            while ((target = target.previousSibling) && !$(target).hasClass('question')) ;
            if (target && target !== ques) {
                ques.parentNode.insertBefore(ques, target);
                return true;
            }
        } else if (direction === 'down') {
            while ((target = target.nextSibling) && !$(target).hasClass('question')) ;
            if (target && target !== ques) {
                $(ques).insertAfter(target);
                return true;
            }
        }
        return false;
    }

    function selectQuestionListItem(id) {
        $('#questionList [data-refId="'+selectedQuesId+'"]').removeClass("selected");
        var li = $('#questionList [data-refId="'+id+'"]').addClass("selected");
        if (li.length == 0) {
            selectedQuesId = null;
            return;
        }			
        selectedQuesId = id;
        var ques =document.getElementById(id);
        if (ques)
            ques.scrollIntoView();
    }

    /**
     * 让#questionList, .editorPane 占据余下的高度，并可以滚动。CSS很难单独做到。
     * 参考：http://stackoverflow.com/questions/90178/make-a-div-fill-the-remaining-screen-space
     */
    function layout() {
        $("#questionList, .editorPane").each(function(){
            var height = window.innerHeight - this.offsetTop;
            if (height < 10) height = 10;
            this.style.height=height+"px";
        });
    }
    
    function innerHtmlIfNotEmpty(elem) {
    	elem = $(elem);
    	if (elem.find('img, embeded, object').length === 0) {
    		var txt = $.trim(elem.text());
    		if (!txt)
    			return txt;
    	}
    	return elem.html();
    }

    function quizSheetToJS() {
        var zs = {};
        zs.titile = quizSheetTitile || "无题";
        if (quizSheetId) 
        	zs.id = quizSheetId;
        var ques = zs.questions = [];
        $("#editorPane  .question").each(function(i){
        	var q = ques[i] = {};
        	var thiz = $(this);
        	q.body = thiz.find(".questionBody").html();
        	q.type = thiz.attr('data-questionType');
        	var qid = thiz.attr('data-questionId');
        	var aid = thiz.attr('data-answerId');
        	var comment = innerHtmlIfNotEmpty(thiz.find(".questionComment"));
        	if (qid)
        		q.id = qid;
        	q.answer = {};
        	if (aid)
        		q.answer.id = aid;
        	if (comment)
        		q.answer.comment = comment;
        	switch(q.type) {
			case "singleOption":
			case "multiOption":
				q.options = [];
				thiz.find(".optionBody").each(function(j){
					var body = innerHtmlIfNotEmpty(this);
					if (body)
						q.options[j] = body;
				});				
				thiz.find(".questionOptions input").each(function(j){
					//this.getAttribute('checked') === 'checked' 是不合适的，因为它不会因为用户的选择而改变。
					if (this.checked){
						if (!q.answer.content)
							q.answer.content = [];
						q.answer.content.push(j); 
					}						
				});
				break;
			case "fillBlank":
				thiz.find(".blankBody").each(function(j){
					var body = innerHtmlIfNotEmpty(this);
					if (body) {
						if (!q.answer.content)
							q.answer.content = [];
						q.answer.content[j] = body;
					}
				});
				break;
			case "bool":
				var checkBoxes = thiz.find(".questionOptions input");
				if (checkBoxes[0].checked)
					q.answer.content = true;
				else if (checkBoxes[1].checked)
					q.answer.content = false;
				break;
			case "free":
				var body = innerHtmlIfNotEmpty(thiz.find(".answerBody")[0]);
				if (body)
					q.answer.content = body;
				break;
        	} //end switch
        	if (! ('content' in q.answer || 'comment' in q.answer))
        			delete q.answer;
        }); //end each
        return zs;
    }

    /**
     * @param funcSuccess(data) 保存后执行的函数，参数为响应体。
     */
    function saveQuizSheet(funcSuccess) {
    	var zs = quizSheetToJS();
    	$.ajax({
    	    contentType: 'application/json', //mime type of request
    	    data: JSON.stringify(zs),
    	    //dataType: 'json', //expected type of response
    	    success:funcSuccess,
    	    error: function(){
    	    	alert("保存失败！");
    	    },
    	    processData: false,
    	    type: 'POST',
    	    url: saveURI
    	});
    	//alert(JSON.stringify(zs));
//    	$.post(saveURI, zs, function(data){
//    		window.location = '/quiz-sheet-edit.html#mode=remote&quizSheetId='+data;
//    	}).error(function(){
//    		alert("保存失败！");
//    	});
    }
    
    function loadQuizSheet() {
    	var url = "/quizSheet/" + quizSheetId;
    	$.getJSON(url, function(data){
    		quizSheet = data;
    		quizSheetTitile = quizSheet.titile;
    		var ques = quizSheet.questions;
    		for (var i=0; i<ques.length; i++) {
    			var qElem = addQuestion(ques[i].type);
    			qElem=$(qElem);
    			qElem.find(".questionBody").html(ques[i].body);
    			if (ques[i].answer && ques[i].answer.comment)
    				qElem.find(".questionComment").html(ques[i].answer.comment);
    			qElem.attr("data-questionId", ques[i].id);
    			var ans = ques[i].answer && ques[i].answer.content;
    			if (ques[i].answer)
    				qElem.attr("data-answerId", ques[i].answer.id);
    			switch(ques[i].type) {
    			case "singleOption":
    			case "multiOption":
    				qElem.find(".optionBody").each(function(j){
    					if (j < ques[i].options.length)
    					this.innerHTML = ques[i].options[j];
    				});
    				var checkBoxes = qElem.find(".questionOptions input");
    				if (ans) {
    					for (var k = 0; k < ans.length; k++) {
    						if (ans[k] < checkBoxes.length)
    							checkBoxes[ans[k]].checked = true;
    					}
    				}
    				break;
    			case "fillBlank":
    				qElem.find(".blankBody").each(function(j){
    					if (ans && j < ans.length)
        					this.innerHTML = ans[j];
    				});
    				break;
    			case "bool":
    				if (typeof ans === 'boolean') {
    					var checkBoxes = qElem.find(".questionOptions input");
    					var idx = ans? 0 : 1;
    					checkBoxes[idx].checked = true;
    				}
    				break;
    			case "free":
    				if (ans) {
    					qElem.find(".answerBody").html(ans);
    				}
    				break;
    			} //end switch
    		} //end for
    		createQuestionList();
    	}).error(function(data){
    		alert("从 "+url +" 获取试卷失败了!"); //TODO: 显示响应
    	});
    }

    $("#commandNewQuestion").click(function(){
        var type = $("#selectQuestionType").val();
        var ques = addQuestion(type);
        createQuestionList();
        selectQuestionListItem(ques.id);
    });

    $('#commandDeleteQuestion').click(function() {
        if (selectedQuesId)
            deleteQuestion(selectedQuesId);
    });

    $('#commandUp, #commandDown').click(function() {
        if (selectedQuesId) {
            var dir = this.id === 'commandUp' ? 'up' : 'down';
            if (moveQuestion(selectedQuesId, dir))
                createQuestionList();
        }
    });

    $('#commandSave').click(function() {
    	saveQuizSheet(function(data){
    		window.location = '/quiz-sheet-edit.html#mode=remote&quizSheetId='+data;
    		//因为页面相同，'#'表示页面内跳转，onload 事件不会触发，所以需要强制重新加载。
    		window.location.reload();
    	});
    });
    
    $('#commandBack').click(function() {
    	window.location = '/quiz-sheet-manage.html';
    });
    
    $('#commandStartQuiz').click(function() {
    	saveQuizSheet(function(data){
    		window.location = '/quiz-start.html#quizSheetId='+data;
    	});    	
    });
    
    var iconButtonWrappers = $('.iconButtonWrapper');
    
    iconButtonWrappers.mousedown(function() {
    	this.classList.add('down');
    }).click(function(){    	
    	iconButtonWrappers.removeClass('down');
    });
    
    //以下为页面加载时执行代码
    
    initParam();

    myNicEditor.setPanel('nicEditPanel'); // 用于放置工具条的元素，一般是div，最好设置宽度
    // style="width: 525px;"

    if (mode === 'remote' ) {
    	loadQuizSheet();
        //currentEditorPaneId = realEditorPaneId;
        //$("#"+sampleEditorPaneId).addClass("hidden");
        // do quiz sheet loading
    } else if (mode === 'new') {
        //TODO: 新建一些空试题
    } else { //demo
        //$("#"+realEditorPaneId).addClass("hidden");
        var ques = $("#sampleEditorPane  .question");
        ques.clone().appendTo($("#editorPane"));
    }
    enableEditorPane();
    createQuestionList();
    setInterval(updateQuestionList, 1500);

    layout();
    window.onresize = layout;
});
