var exports = {};

$(function() {

    var url = $.url();

    var quizId = url.fparam('quizId');
    var quizSheetId = null;
    var sampleEditorPaneId = "sampleEditorPane";
    var realEditorPaneId = "editorPane";
    var classForEdit = [".questionBody", ".optionBody", ".blankBody", ".answerBody",".questionComment"];
    var questionTypeMap = { singleOption: "单选", multiOption:"多选", bool:"判断", fillBlank:"填空", free:"问答"};
    exports.questionTypeMap = questionTypeMap;
    
    var quiz = null; //{students[User]}
    var quizSheet = null; //{questions:[{body:string, type:string, answer:Answer}]
    var answerSheets = null; //Map<aid, AnswerSheet>
    var indexByQuestion = null; //Map<qid, {question:Qestion, answers:Map<uid, Answer>, 
    		// hasScore:boolean, refAnswerHtml:string, commitedUids:[int],  correctUids:int}

    //部分复用 addQuestion(type, position)
    function addQuestion(type) {
        var ques = $('#sampleEditorPane  .question').clone();
        ques.attr('data-questionType', type);
        ques.find('.questionType').html(questionTypeMap[type]);
        //ques.find(classForEdit.join(',')).empty();
        ques.appendTo($("#editorPane"));
        return ques[0];
    }
    
    //复用
    function isObjective(question) {
    	var type = question.type;
    	return type === 'bool' || type === 'singleOption' || type === 'multiOption';
    }
    
    function buildIndexByQuestion() {
    	if (!quizSheet)
    		return;
    	indexByQuestion = {};
    	var quess = quizSheet.questions;
    	for(var i=0; i<quess.length; i++) {
    		var ques = quess[i];
    		var item = { question: ques, answers: {}, commitedUids: [], correctUids: [] }
    		item.hasScore = !!(ques.answer && isObjective(ques)); //是否可以评分
    		indexByQuestion[ques.id] = item;
    	}

    	for (var asid in answerSheets) {
    		var answerSheet = answerSheets[asid];
    		var uid = answerSheet.uid;
    		var answers = answerSheet.answers;
    		for (var i=0; i<answers.length; i++) {
    			var ans = answers[i];
    			var qid = ans.question;
    			var item = indexByQuestion[qid];
    			var ques = item.question;
    			
    			item.answers[uid] = ans;
    			item.commitedUids.push(uid);    			
    			if (item.hasScore) {
    				var refAns = ques.answer.content;
    				ans = ans.content;
    				if (typeof refAns === 'object') { //TODO: 用更稳定的比较法
    					refAns = JSON.stringify(refAns);
    					ans = JSON.stringify(ans);
    				}
    				if (ans === refAns)
    					item.correctUids.push(uid);
    			}
    		}
    	}
    }

    /**
     * 让#questionList, .editorPane 占据余下的高度，并可以滚动。CSS很难单独做到。
     * 参考：http://stackoverflow.com/questions/90178/make-a-div-fill-the-remaining-screen-space
     */
    function layout() {
        $("#questionList, .editorPane").each(function(){
            var height = window.innerHeight - this.offsetTop;
            if (height < 10) height = 10;
            this.style.height=height+"px";
        });
        if (typeof quizMonitorQuestionLayout === 'function')
            quizMonitorQuestionLayout();
    }
    
    //复用
    function optionAnswerToString(answerArray) {
    	if (!answerArray)
    		return '';
    	var optionNames="ABCDEF";
    	var result = '';
    	for (var i=0; i<answerArray.length; i++) {
    		result+=optionNames[answerArray[i]];
    	}
    	return result;
    }
    
    exports.optionAnswerToString = optionAnswerToString;
    
    //复用
    function fillBlankAnswerToString(answerArray) {
    	if (!answerArray)
    		return '';
    	return answerArray.length > 0 ? answerArray.join('、') : '';
    }
    exports.fillBlankAnswerToString = fillBlankAnswerToString;
    
    //部分复用 loadQuizSheet()
    function bindQuizSheet() {
        $("#quizTitle").html(quizSheet.titile);
		var ques = quizSheet.questions;
		for (var i=0; i<ques.length; i++) {
			var qElem = addQuestion(ques[i].type);
			qElem=$(qElem);
			qElem.find(".questionBody").html(ques[i].body);
			//if (ques[i].answer && ques[i].answer.comment) //暂时不显示comment
			//	qElem.find(".questionComment").html(ques[i].answer.comment);
			qElem.attr("data-questionId", ques[i].id);
			qElem.find(".questionNumber").html(i + 1 + '. ');
			var refAnswer = ques[i].answer && ques[i].answer.content;
			var refAnswerBody = qElem.find(".refAnswerBody").empty();
			switch(ques[i].type) {
			case "singleOption":
			case "multiOption":
				var option = qElem.find(".option")[0];
				var parent = option.parentNode;
				$(parent).removeClass('hidden');
				for (var j=1; j<ques[i].options.length; j++) {
					$(option).clone().appendTo(parent);
				}
				qElem.find(".option").each(function(j){
					this.innerHTML = "ABCDEF"[j] +'. '+ ques[i].options[j];
				});
				refAnswerBody.html(optionAnswerToString(refAnswer));
				break;
			case "fillBlank":
				refAnswerBody.html(fillBlankAnswerToString(refAnswer));
				break;
			case "bool":
				if (typeof refAnswer === 'boolean') {
					refAnswerBody.html(refAnswer? "正确":"错误");
				}
				break;
			case "free":
				refAnswerBody.html(refAnswer);
				break;
			} //end switch
			ques[i].refAnswerHtml = refAnswerBody.html();
		} //end for
    }    

    function updateAnswerSheets()
	{
		var urlAnswerSheet = "/answerSheet/allViaQuiz/" + quizId;
		$.getJSON(urlAnswerSheet, function(data) {
			answerSheets = data;
			bindAnswerSheets();
			layout();
		}).error(function() {
			console.log("从 " + urlAnswerSheet + " 获取答卷失败了!"); // TODO: 显示响应
		});
	}
    
    function bindAnswerSheets() {
    	buildIndexByQuestion();
    	exports.indexByQuestion = indexByQuestion;
    	$('#editorPane .question').each(function() {
    		var qElem = $(this);
    		var qid = qElem.attr("data-questionId");
    		var item = indexByQuestion[qid];
    		qElem.find('.commitCount').html(item.commitedUids.length);
    		if (item.hasScore) {
    			qElem.find('.correctCount').html(item.correctUids.length);
    			qElem.find('.wrongCount').html(item.commitedUids.length - item.correctUids.length);
    		} else {
    			qElem.find('.score').addClass('hidden');
    		}
    	});
    }
    
    function loadQuiz(fSuccess, fError) {
        var urlQuiz = '/quiz/' + quizId;
        $.getJSON(urlQuiz, function(data) {
            quiz = data;
            exports.students = quiz.students = quiz.students || {};
            if (fSuccess)
                fSuccess(data);
        }).error(function() {            
            if (fError)
                fError();
        });
    }
    
    function loadQuizSheet(fSuccess, fError) {
        quizSheetId = quiz.quizSheet;
        var urlQuizSheet = "/quizSheet/" + quizSheetId;
        $.getJSON(urlQuizSheet, function(data) {
            quizSheet = data;
            if (fSuccess)
                fSuccess(data);
        }).error(function() {
            if (fError)
                fError();
        });
    }
    
    //部分复用 loadQuizSheet()
	function loadQuizSheetAndAnswerSheet() {
	    loadQuiz(
	       function ok(){
	           loadQuizSheet(
	                   function ok() {
	                       bindQuizSheet();
	                       attachEventHandler();
	                       updateAnswerSheets();
	                   },
	                   function fail() {
	                       alert("获取试卷失败了!"); 
	                   }
	           );
	       },
	       function fail(){
	           alert("获取测验失败了!");
	       }
	    );
//		var urlQuiz = '/quiz/' + quizId;
//		$.getJSON(urlQuiz, function(data) {
//			quiz = data;
//			exports.students = quiz.students;
//			quizSheetId = quiz.quizSheet;
//			var urlQuizSheet = "/quizSheet/" + quizSheetId;
//			$.getJSON(urlQuizSheet, function(data) {
//				quizSheet = data;
//				bindQuizSheet();
//				attachEventHandler();
//				updateAnswerSheets();		
//			}).error(function() {
//				alert("从 " + urlQuizSheet + " 获取试卷失败了!"); // TODO: 显示响应
//			});
//		}).error(function() {
//			alert("从 " + urlQuiz + " 获取测验失败了!"); // TODO: 显示响应
//		});
	}
	
	function endQuiz() {
		$.get('/endQuiz/'+quizId, function(data) {
			alert("测验已结束。");
			//window.location = '/quiz-sheet-manage.html';
			window.location = '/quiz-sheet-publish.html';
		}).error(function() {
			alert("结束测验失败了!"); 
		});
	}
	
	//必须在 bindQuizSheet()之后。
	function attachEventHandler() {
	    $('.commandStatus').click(function(){	        
	        var qid = $(this).closest('.question').attr('data-questionId');
	        if (qid) {
	            quizMonitorQuestionShow(qid);
	        }	       
	    });
	    
	    $('.commandShowAnswer, .refAnswer').click(function(){
	        var ans = $(this).closest('.question').find('.refAnswerBody');
	        if (ans.hasClass('hidden'))
	        	ans.removeClass('hidden');
	        else
	        	ans.addClass('hidden');	        
	    });
	}

    $("#commandBack").click(function(){
        var ok = confirm("是否确定？退出课堂将不能再查看作答情况！");
        if (ok)
        	endQuiz();
    });
    

    loadQuizSheetAndAnswerSheet();
    
    quizMonitorQuestionInit();
    
    setInterval(loadQuiz, 5000); //目的是刷新班级数据
    setInterval(updateAnswerSheets, 5000);

    //layout();
    window.onresize = layout;
});
