/**
 * 登录函数。url 中的 fparam 参数是uid、role、displayName、sex（'m'|'f'）、
 * gids（用户组的数组，逗号分隔）。
 * 如果用户id不存在而role存在，将新建用户并登录；如果用户id存在，且role存在则更新用户信息。
 * 依赖 purl 和 jquery。
 * @param loginSuccess 成功时执行的回调
 * @param loginFailed 失败时执行的回调
 */
function login(loginSuccess, loginFailed) {

    var url = $.url();
    var uid = url.fparam('uid');
    var params = {
        displayName : url.fparam('displayName'),
        role : url.fparam('role'),
        sex: url.fparam('sex'),
        gids: url.fparam('gids'),
    }

    if (uid) {
        var loginUrl = '/login/' + uid;
        var count = 0;
        for ( var key in params) {
            if (params[key]) {
                if (count == 0)
                    loginUrl += '?';
                else
                    loginUrl += '&';
                loginUrl += key + '=' + params[key];
                count++;
            }
        }
        
        loginUrl = encodeURI(loginUrl); //不做encodeURI，中文部分 chrome 正确，但 firefox 错误
        $.get(loginUrl, function(data) {
            if(loginSuccess)
                loginSuccess(data);
        }).error(function() {
            if(loginFailed)
                loginFailed();
        });
    }
}
