/**
* borrow from svg-edit/svg-editor.js
* This sets up alternative dialog boxes. They mostly work the same way as
* their UI counterparts, expect instead of returning the result, a callback
* needs to be included that returns the result as its first parameter.
* In the future we may want to add additional types of dialog boxes, since 
* they should be easy to handle this way.
* $.initDialog() should be called after doc loaded.
*/
$.initDialog = function() {
	
	$('body').append(
			'<div id="dialog_box">\
			<div id="dialog_box_overlay"></div>\
			<div id="dialog_container">\
				<div id="dialog_content"></div>\
				<div id="dialog_buttons"></div>\
			</div>\
		</div>'
	);
	
	var uiStrings = {ok:'确定', cancel:'取消', yes:'是', no:'否'};
	
	var input;
	
	//如果需要可移动的对话框，则反注释这一行，并引入jquery-ui-xxx.js。
	//$('#dialog_container').draggable({cancel:'#dialog_content, #dialog_buttons *'});
	
	var box = $('#dialog_box'), btn_holder = $('#dialog_buttons');
	
	var dbox = function(type, msg, callback, defText) {
		$('#dialog_content').html('<p>'+msg.replace(/\n/g,'</p><p>')+'</p>')
			.toggleClass('prompt',(type=='prompt' || type=='option'));
		btn_holder.empty();
		
		var okText = type == 'confirm' ? uiStrings.yes : uiStrings.ok;
		var cancelText = type == 'confirm' ? uiStrings.no : uiStrings.cancel;
		
		var ok = $('<input type="button" value="' + okText + '">').appendTo(btn_holder);
	
		if(type != 'alert') {
			$('<input type="button" value="' + cancelText + '">')
				.appendTo(btn_holder)
				.click(function() { box.hide();callback(false)});
		}
		
		if(type == 'prompt') {
			var input = $('<input type="text">').prependTo(btn_holder);
			input.val(defText || '');
			//TODO: 似乎有问题，任意按键都可触发
			//input.bind('keydown', 'return', function() {ok.click();});
		}
		
		if(type == 'process') {
			ok.hide();
		}
		
		if(type == 'option') {
			var input = $('<select></select>').prependTo(btn_holder);
			var arrayOptions = defText;
			for (var i=0; i<arrayOptions.length; i++) {
	    		var opt = document.createElement('option');
	    		opt.value = arrayOptions[i].value;
	    		$(opt).text(arrayOptions[i].text);
	    		input.append(opt);
	    	}
		}

		box.show();
		
		ok.click(function() { 
			box.hide();
			var resp = (type == 'prompt' || type == 'option')?input.val():true;
			if(callback) callback(resp);
		}).focus();
		
		if(type == 'prompt' || type == 'option') input.focus();
	}
	
	$.alert = function(msg, cb) { dbox('alert', msg, cb);};
	$.confirm = function(msg, cb) {	dbox('confirm', msg, cb);};
	$.process_cancel = function(msg, cb) {	dbox('process', msg, cb);};
	$.prompt = function(msg, txt, cb) { dbox('prompt', msg, cb, txt);};
	$.option = function(msg, arrayOptions, cb) { dbox('option', msg, cb, arrayOptions);};
};
