$(	main);

var teacherUid;
var classes;
var gid;
var locked = false;

function main() {
	$('#select-class').change(function () {
		selectClass(this.value);
	});
	
	$('#publish').click(function() {
		if (!gid) {
			alert('必须先选择班级');
			return;
		}
		//window.location = 'quiz-sheet-publish.html#gid='+gid;	
		window.open('quiz-sheet-publish.html#gid='+gid, '课堂测试');
	});
	
	$('#lock').click(function () {
		toggleLock();
	});
	
    layout();
    window.onresize = layout;
    
	var url = $.url();
	teacherUid = url.fparam('uid');
	if (teacherUid) {
	    login( function() {
	    	updateGroups(getClasses, getClasses); //update-groups.js
	    } /*getClasses*/, 
	    loginFailed);
	} else
		getClasses();
}

function layout() {
    $("#panel-3, #student-list").each(function(){
        var height = window.innerHeight - this.offsetTop;
        if (height < 10) height = 10;
        this.style.height=height+"px";
    });
    var ll = $('#lock-label')[0];
    var sl = $('#student-list')[0];
    //ll.offsetTop= sl.offsetTop;
    ll.style.top= sl.offsetTop + (sl.offsetHeight - ll.offsetHeight)/2 + "px";
    ll.style.left= sl.offsetLeft + (sl.offsetWidth - ll.offsetWidth)/2 + "px";
    //ll.style.height = sl.style.height;
    //ll.style.lineHeight = sl.style.height;
}

//function loginOk() {
//	getClasses
//}

function toggleLock() {
	postJSON('/lockClass', {'locked':!locked}, 
			(function(data){
				locked = !locked;
				var ll = $('#lock-label');
				var lb = $('#lock');
				if (locked) {
					ll.removeClass('hidden');
					lb.addClass('unlock');
				} else {
					ll.addClass('hidden');
					lb.removeClass('unlock');
				}
				layout();
			}),
			(function(){
				alert("锁屏失败！");
			})
	);
}

function getClasses(/*fOk, fError */) {
	$.getJSON('/groups', function(data) {
		classes = data;
		var options = [];
		options.push('<option value="">无</option>');
		for (var gid in classes) {
			options.push('<option value="' + gid +'">' + classes[gid].displayName + '</option>');
		}
		$('#select-class').html(options.join());	
		setInterval(buildStudentList, 2800);
	}).error(function(err) {
		alert('获取班级列表失败了！');
		showStudentListText('获取班级列表失败了！');
	});
}

function postJSON(url, data, fOk, fError) {	
	data = JSON.stringify(data);
	$.ajax({
		contentType: 'application/json', //mime type of request
		'data': data,
		success: fOk,
		error: fError,
		processData: false,
		type: 'POST',
		'url': url
	});
}

function selectClass(gid) {
	clearSelectedClass();	
	postJSON('/selectClass', {'gid':gid}, 
	(function(data){
		window.gid = gid;
		if (gid)
		  $('#class-name').html(classes[gid].displayName);
		buildStudentList();
	}),
	(function() {
		alert('选择班级失败了！');
		showStudentListText('选择班级失败了！');
	})
	);
}

function clearSelectedClass() {
	window.gid = null;
	if (locked) {
		locked = false;
		var ll = $('#lock-label');
		var lb = $('#lock');
		ll.addClass('hidden');
		lb.removeClass('unlock');
	}
	$('#class-name').html('无班级');
	$('#attendance-count').html('0');
	$('#student-count').html('0');
}

function buildStudentList() {
	if (!gid) {
		showStudentListText('');
		return;
	}
	$.getJSON('/studentsOfGroup/' + window.gid, function(students) {
		if (!students) {
			showStudentListText('');
			return;
		}
		var studentCount = Object.keys(students).length;
		$('#student-count').html(studentCount);
		var studentElems = $('#student-list .user');
		var list = $('#student-list');
		var reLayout = false;
		var i = 0;
		if (studentElems.length == 0 || studentElems.length != studentCount) {
			reLayout = true;
			list.empty();
			var templ = $('#student-list-sample .user');
			for (i = 0; i < studentCount; i++)
				templ.clone().appendTo(list);
		}
		studentElems = $('#student-list .user');
		var i = 0;
		for (var uid in students) {
			var item = $(studentElems[i++]);
			var user = students[uid];				
    		if(!user)
    		    continue;    		
    		item.find('.name').html(user.displayName);
    		var icon = item.find('.icon');
    		var sexIcon = user.sex === 'f' ? icon.attr('data-female-icon') : icon.attr('data-male-icon');    		
    		if (icon.attr('src') !== sexIcon)
    			icon.attr('src', sexIcon);
    		item.attr('data-uid', uid);
		}
		
		$.getJSON('/activeUsers', function(activeUsers){
			var activeCount = 0;
			var i = 0;
			for (var uid in students) {
	    		var item = $(studentElems[i++]);
	    		if (activeUsers.indexOf(uid) == -1) {
	    			item.addClass('deactived');
	    		} else {
	    			item.removeClass('deactived');
	    			activeCount++;
	    		}
			}
			$('#attendance-count').html(activeCount);
			if (reLayout)
				layout();
		}).error(function(){
			showStudentListText('获取在线学生列表失败了！');
		});
	}).error(function(){
		showStudentListText('获取学生信息失败了！');
	});
}

function showStudentListText(msg) {
	$('#student-list').html(msg);
	layout();
}

function loginFailed() {
	alert('登录失败！');
}
