
var equationXml = null,
	results = {},
	Back_prev;

function loadEquationXml(callback) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', './equations.xml');
    xhr.onreadystatechange = function () {
        if (xhr.readyState == 4) {
            if (xhr.status == 0 && !equationXml) {
                var parser = new DOMParser();
                equationXml = parser.parseFromString(xhr.response, "application/xml");
                callback();
            }
        }
    }
    xhr.send(null);
}

function addEquation(equationName) {
    if (!equationXml) {
        loadEquationXml(function () {
            addEquation(equationName);
        });
    } else {
        var node = equationXml.querySelector("div[id=" + equationName + "]");
        if (!node) return;
        var miNodes = document.querySelectorAll('mi');
        if (miNodes.length == 1 && miNodes[0].textContent == "") {
            var mathContainer = document.querySelector('math').parentElement;
            mathContainer.parentElement.removeChild(mathContainer);
        }

        var equation = document.createElement('div');
        equation.appendChild(node.firstChild.cloneNode(true));
        document.body.appendChild(equation);
    }
}

function setMathContent(mathContent) {
    document.body.innerHTML = mathContent;
}

function getMathContent() {
    return document.body.innerHTML;
}

var equationElementHandlers = {
    //frac,root,abs
    'frac': function () { insertElement('mfrac', 2); },
    'sqrt': function () { insertElement('msqrt', 1); },
    'root': function () { insertElement('mroot', 2); },
    'abs': function () { insertrc(); },
    //sum log lim product
    'sum1': function () { doSum1(); },
    'sum2': function () { insertElement1('\u2211', 0); },
    'sum3': function () { insertElement1('\u2211', 1); },
    'log': function () { insertElement1('log', 0); },
    'lg': function () { insertlg(); },
    'ln': function () { insertln(); },
    'lim': function () { doLimCmd(); },
    'prod1': function () { insertElement1('\u220F', 0); },
    'prod2': function () { insertElement1('\u220F', 1); },
    //trigonometric function
    'sin': function () { insertsin(); },
    'cos': function () { insertcos(); },
    'tan': function () { inserttan(); },
    'cot': function () { insertcot(); },
    'sec': function () { insertsec(); },
    'csc': function () { insertcsc(); },
    'arcsin': function () { insertarcsin(); },
    'arccos': function () { insertarccos(); },
    'arctan': function () { insertarctan(); },
    'arccot': function () { insertarccot(); },
    'arcsec': function () { insertarcsec(); },
    'arccsc': function () { insertarccsc(); },
    //integral
    'int1': function () { doInt(); },
    'int2': function () { insertElement1('\u222B', 1); },
    'int3': function () { insertElement1('\u222B', 2); },
    'int4': function () { insertElement1('\u222C', 0); },
    'int5': function () { insertElement1('\u222d', 0); },
    'int6': function () { insertElement1('\u222e', 0); },
    //layout
    'sub': function () { doSubCmd(); },
    'sup': function () { doSupCmd(); },
    'subsup': function () { doSubSupCmd(); },
    'under': function () { doBelowCmd(); },
    'over': function () { doAboveCmd(); },
    'underover': function () { doAboveBelowCmd(); },
    'multiscripts': function () { doTensorCmd(); },
    'matrix21': function (row, col) { doMatrixCmd(2, 1); },
    'matrix22': function (row, col) { doMatrixCmd(2, 2); },
    'matrix23': function (row, col) { doMatrixCmd(2, 3); },
    'matrix31': function (row, col) { doMatrixCmd(3, 1); },
    'matrix32': function (row, col) { doMatrixCmd(3, 2); },
    'matrix33': function (row, col) { doMatrixCmd(3, 3); }
}

function onMessage(message) {
    try {
        var msg = JSON.parse(message);
    } catch (e) {
        console.log(e + ":" + message);
        return;
    }
    switch (msg.action) {
        case 'setMathContent':
            setMathContent(msg.arguments[0]);
            break;
        case 'getMathContent':
            var content = getMathContent();
            ucbook.postWebPageMessage(content);
            break;
        case 'addEquation':
            addEquation(msg.arguments[0]);
            break;
        case 'insertMathSymbol':
            var str = msg.arguments[0];
            str = str.replace('u', '0x');
            var symbol = String.fromCharCode(Number(str));
            inserttag("mo", symbol);
            break;
        case 'insertEquationElement':
            equationElementHandlers[msg.arguments[0]]();
            break;
        default:
            break;
    }
}

/*
*/
//ɾԱ༭mimnԪ
function removeCanSelectFn() {
    var aCanSelect = document.querySelectorAll('.canSelect'), len = aCanSelect.length;
    while (len >= 1) {
        len--;
        aCanSelect[len].classList.toggle('canSelect');
    };
};

//ǵǰûѡֵĹ겻ûûѡֹ  ʱרҵ
var setBorderOrNone = {
    bar: function () {
        var cs = document.querySelector("#cursor") && document.querySelector("#cursor").classList;
        if (false /*document.getSelection().type.toLowerCase() === "range" && cs*/) {
            cs.add('noBorder');
        } else if (cs) {
            cs.remove('noBorder');
        };
        setTimeout(arguments.callee, 500)
    }
};
/*
var cs = document.querySelector("#cursor").classList;	 if( document.getSelection().type.toLowerCase() === "range" ){	 cs.contains('noBorder') ? cs.remove('noBorder') : cs.add('noBorder');	 }else{	 cs.remove('noBorder'); }
*/
//趨borderΪNoneǰָ
setBorderOrNone.bar();



(function () {
    //ǻ  CTRL+Z ; CTRL+Y
    function Back_prev() {
        this.arr = [];
    };
    Back_prev.prototype = {
        push: function (html) {
            //if( this.arr.length > 4 )this.arr.shift();
            this.arr.push(html);
            this.i = 0;
        },
        prev: function () {
            this.i++;
            if (this.i >= this.arr.length) this.i = this.arr.length;
            return this.arr[this.arr.length - this.i];
        },
        next: function () {
            this.i--;
            if (this.i < 1) this.i = 1;
            return this.arr[this.arr.length - this.i]
        },
        i: 0
    };

    back_prev = new Back_prev();
    back_prev.put = function () {
        back_prev.push(document.getElementsByTagName('body')[0].innerHTML);
    };
    //btnΪtrueǳ btnΪfalseΪ //Ϊʱڰ¼ӳһʱ ŽµַԳûһεļ¼
    back_prev.importToBody = function (btn) {
        var data;
        if (!btn) {
            data = back_prev.prev();
            if (!data) return
        } else {
            data = back_prev.next();
        };
        document.getElementsByTagName('body')[0].innerHTML = data;
        return;
    };
})();

//ƶûѡsigleton ,window.onloadʱʼ
var ev = {
    blur: function () {
        try {
            delcursor()
        } catch (e) { }
    },
    focus: function () {
        var eMi = document.getElementsByTagName('mi')[0];
        setFocusColor(eMi);
    },
    mousedown: function (ev) {
        removeCanSelectFn();
        var target = ev.target;
        if (target.tagName.toLowerCase() === 'mi' || target.tagName.toLowerCase() === 'mn') {
            target.classList.add('canSelect');
        };

    },
    mouseup: function (ev) {
        //var aCan = Array.prototype.slice.call(document.querySelectorAll('canSelect'),null);
    },
    selectstart: function () {
        removeCanSelectFn();
    }
};

window.onload = function () {
    var parameter = unescape(window.location.href).split('?')[1];
    if (!!parameter) {
        var parts = unescape(parameter).split('=');
        if (!!parts[1]) {
            switch (parts[0].toLowerCase()) {
                case "addequation":
                    addEquation(parts[1]);
                    break;
                case "insertmathsymbol":
                    inserttag("mo", String.fromCharCode(Number(parts[1].replace('u', '0x'))));
                    break;
                case "insertequationelement":
                    equationElementHandlers[parts[1]]();
                    break;
                default:
                    break;
            }
        }
    };
    ucbook.onWebPageMessage = onMessage;
    ucbook.postWebPageMessage("ready");

    window.addEventListener('blur', ev.blur, false);
    window.addEventListener('focus', ev.focus, false);
    document.addEventListener('mousedown', ev.mousedown, false);
    document.addEventListener('mouseup', ev.mouseup, false)
    document.addEventListener('selectstart ', ev.selectstart, false)
    document.oncontextmenu = function () { return false; }
};
