// MathML editing functions
var mmlns = "http://www.w3.org/1998/Math/MathML";
var htmlns = "http://www.w3.org/1999/xhtml";
var designWin = window; //design_frame;
var designDoc = document; //designWin.document;
var su1 = "b5";
var editStyle;
var gPrefsService;
var gPrefs;
var caretState;
var designview = 1; //1:Design; 0:Presentation
var charcur = 0;
var histmath = new Array();
var histp = 0;
var histr = 0;
var copymath;

designDoc.onkeypress = doKeypress;
designDoc.onkeydown = doKeydown;
designWin.focus();
designDoc.onclick = domouseclick;

var bcolor = "#fff"; //efefef
var fcolor = "#000000";
var oe = 1;
function getService(s, i) {
	return (Components.classes[s].getService(i));
}

function createInstance(s, i) {
	return (Components.classes[s].createInstance(i));
}

function exit() {
	// restore caret (this doesn't seem to work)
	gPrefs.setBoolPref("accessibility.browsewithcaret", caretState);
	gPrefsService.savePrefFile(null);

	window.close();
}

function doNewCmd() {
	window.location.reload();
	designWin.focus();
}

function doOpenCmd() {
	try {
		var dlg = window.open("dialog/openfile.html", "hadialog", "toolbar=no,menubar=no,personalbar=no,width=400,height=400," + "scrollbars=no,resizable=yes");
		dlg.focus();
	} catch(ex) {
		alert("Not Open Successfully");
		designWin.focus();
	}
}

function doOpenLocCmd() {

	var o = new Object();
	o.val = "";
	designWin.openDialog("", "_blank", "", o);
	if (o.val.length > 0) {
		try {
			var n = designDoc.getElementById("mml-frame");
			var loadFlags = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE;
			n.webNavigation.loadURI(o.val, loadFlags, null, null, null);
		} catch(ex) {}
	}

	designWin.focus();
}

function doSaveCmd() {
	try {
		try {
			netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		} catch(e) {
			alert("Permission to save file was denied.");
		}
		const nsIFilePicker = Components.interfaces.nsIFilePicker;
		var fp = createInstance("@mozilla.org/filepicker;1", nsIFilePicker);
		fp.init(window, "", nsIFilePicker.modeSave);
		fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterXML);

		var res = fp.show();
		if (res == nsIFilePicker.returnOK || res == nsIFilePicker.returnReplace) {
			var tempLocalFile = null;
			var docURI = createInstance("@mozilla.org/network/standard-url;1", Components.interfaces.nsIURI);
			docURI.spec = fp.fileURL.spec;

			if (docURI.schemeIs("file")) {
				var ioService = getService("@mozilla.org/network/io-service;1", Components.interfaces.nsIIOService);
				var gFileHandler = ioService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
				localFile = gFileHandler.getFileFromURLSpec(fp.fileURL.spec);
			}
			var os = createInstance("@mozilla.org/network/file-output-stream;1", Components.interfaces.nsIFileOutputStream);
			os.init(localFile, 0x2A, 0644, 0); // write, create, truncate
			var tmp = '<?xml version="1.0"?>\n';
			os.write(tmp, tmp.length);
			tmp = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN" "http://www.w3.org/TR/MathML2/dtd/xhtml-math11-f.dtd">\n';
			os.write(tmp, tmp.length);

			var source;
			var sourceStr;
			if (designview == 0) {
				source = designDoc.createRange();
				source.selectNodeContents(designDoc.body);
				sourceStr = source.toString();
			}
			if (designview == 1) {
				sourceStr = designDoc.body.innerHTML;
			}
			os.write(sourceStr, sourceStr.length);
			os.close();
		}
	} catch(ex) {
		alert("Bad save: " + ex);
	}
}

function doCut() {

}

function doCopy() {
	var n = designDoc.getElementById("cursor");
	copymath = n.cloneNode(true);
}
function doPaste() {
	if (designview == 0) {

		alert("This function can not be used in MathML code mode");
		return;
	}
	if (copymath == null) {
		return;
	}
	var d = designDoc.createDocumentFragment();
	d.appendChild(copymath);
	insertfragment(d);
	//	alert(copymath);
	// savehist();
}
function doDeleteCmd() {
	var n = designDoc.getElementById("cursor").nextElementSibling;
	if (n) n.parentNode.removeChild(n);
}

function doBackSpaceCmd(evt) {
	//deleteleft();
	/*
	var sel=document.getSelection();
	var ranges=selectRange();
	for(i=0;i<ranges.length;i++)
	{
		var range = ranges[i];
		alert(range);
		if (range!='') {
			range.deleteContents();
			return;
		}
	}
	*/
	
	deleteselection();

	//ıǩ
	var aM = document.querySelectorAll('mstyle');
	var len = aM.length;
	do{
		len--;
		if(aM[len] && aM[len].childNodes[0].textContent === '\u0000'){
			var oDiv = findtagparent(aM[len],'div');
			oDiv.parentNode.removeChild( oDiv );
		};
	}while(len);
	/*(
	if(document.querySelectorAll('div').length === 0){
		window.open('','_self','');
		window.close();
	}
	*/
}

function selectRange()
{
	var ranges = [];
	var sel =document.getSelection();

	for(var i = 0; i < sel.rangeCount; i++) {
		ranges[i] = sel.getRangeAt(i);
	}

	return ranges;
}


function doSpaceCmd() {
	movespace();
}

function doTabCmd() {
	tabobject();
}

function doEnterCmd() {
	dosplit();
}

function notImplemented() {
	alert("not implemented");
}

function doHelpCmd() {
	designWin.open('', 'mathmled_about', 'scrollbars=1,resizable=1,width=500,height=300');
}

function doSelectAllCmd() {
	var s = designWin.getSelection();
	var bodyNode = designDoc.getElementsByTagName("body").item(0);
	s.selectAllChildren(bodyNode);
}

function dofont() {
	var f = document.getElementById("font").selectedIndex;
	var fv = document.getElementById("font").options[f].value;
	var s = designWin.getSelection();
	var n = getselectednode(s);
	if (findmathparent(n)) n.setAttribute("fontfamily", fv);
	document.getElementById("font").selectedIndex = 0;
}
function doSmallCmd() {

	sizesmall();
}

function dofontsize() {
	var f = document.getElementById("fontsize").selectedIndex;
	var fv = document.getElementById("fontsize").options[f].value;
	if (fv == "big") doBigCmd();
	if (fv == "small") doSmallCmd();
	if (fv == "normal") doNormalSizeCmd();
}
function doSmallCmd() {

	sizesmall();
}

function doBigCmd() {
	sizebig();
}

function doNormalSizeCmd() {
	sizenormal();
}

function doNormalCmd() {
	var s = designWin.getSelection();
	if (s) {
		stylebold(false);
		styleitalic(false);
	}
}

function doBoldCmd() {
	var s = designWin.getSelection();
	if (s) {
		stylebold(true);
		styleitalic(false);
	}
}

function doBoldCmd1() {
	var s = designWin.getSelection();
	var n = getselectednode(s);
	if (findmathparent(n)) {
		if (n.getAttribute("fontweight") != "bold") n.setAttribute("fontweight", "bold");
		else n.removeAttribute("fontweight");
	}
}

function doItalicCmd() {
	var s = designWin.getSelection();
	if (s) {
		stylebold(false);
		styleitalic(true);
	}
}

function doItalicCmd1() {
	var s = designWin.getSelection();
	var n = getselectednode(s);
	if (findmathparent(n)) {
		if (n.getAttribute("fontstyle") != "italic") n.setAttribute("fontstyle", "italic");
		else n.removeAttribute("fontstyle");
	}
}

function doBoldItalicCmd() {
	var s = designWin.getSelection();
	if (s) {
		stylebold(true);
		styleitalic(true);
	}
}

function doToggleBold() {
	var s = designWin.getSelection();
	if (s) togglebold();
}

function doToggleItalic() {
	var s = designWin.getSelection();
	if (s) toggleitalic();
}

// For talking with the ColorPicker
var gColorObj = new Object();

gColorObj.LastTextColor = "";
gColorObj.LastBackgroundColor = "";
gColorObj.LastHighlightColor = "";
gColorObj.Type = "";
gColorObj.PageColor = "";
gColorObj.TableColor = "";
gColorObj.CellColor = "";
gColorObj.BackgroundColor = "";

var gLastTextColor = "#000000";
var gLastBackgroundColor = "#ffffff";

function getOffsetTop(elm) {

	var mOffsetTop = elm.offsetTop;
	var mOffsetParent = elm.offsetParent;

	while (mOffsetParent) {
		mOffsetTop += mOffsetParent.offsetTop;
		mOffsetParent = mOffsetParent.offsetParent;
	}

	return mOffsetTop;
}

function getOffsetLeft(elm) {

	var mOffsetLeft = elm.offsetLeft;
	var mOffsetParent = elm.offsetParent;

	while (mOffsetParent) {
		mOffsetLeft += mOffsetParent.offsetLeft;
		mOffsetParent = mOffsetParent.offsetParent;
	}

	return mOffsetLeft;
}

function doColorCmd() {
	var s = designWin.getSelection();
	if (!s) return;
	var colorwin = window.open("textcolor.htm", "", "toolbar=no,menubar=no,personalbar=no,width=250,height=190,scrollbars=no,resizable=no");
	colorwin.focus();

}

function doBackgroundColorCmd() {
	var s = designWin.getSelection();
	if (!s) return;
	var backcolorwin = window.open("backcolor.htm", "", "toolbar=no,menubar=no,personalbar=no,width=250,height=190,scrollbars=no,resizable=no");
	backcolorwin.focus();
}

// Doing the right thing - having the controls track the caret - is hard.
function updateColorControls() {
	var button = designDoc.getElementById("TextColorButton");
	if (button) button.setAttribute("style", "background-color:" + gLastTextColor);
	button = designDoc.getElementById("BackgroundColorButton");
	if (button) button.setAttribute("style", "background-color:" + gLastBackgroundColor);
}

function doMathCmd() {
	var s = designWin.getSelection();
	if (s) insertmath();
}

function doTextCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mtext", o.val);
	}
}

function doFractionCmd() {
	var curnode = designDoc.getElementById("cursor");
	var d = designDoc.createDocumentFragment();
	var mf = designDoc.createElementNS(mmlns, "mfrac");
	var rb = newrowbox();
	if (curnode.tagName == "mo") {
		mf.appendChild(rb);
		mf.appendChild(newrowbox());
		d.appendChild(mf);
		insertfragment(d);
	} else {
		var c1 = curnode.cloneNode(true);
		mf.appendChild(c1);
		mf.appendChild(rb);
		d.appendChild(mf);
		replacebox(curnode, mf);
	}

	setFocus(rb);
}

function doSubCmd() {
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "msub");
	var n = designDoc.getElementById("cursor");
	var ismo = (n.localName == "mo");
	var rb = newrowbox(); // new empty subscript
	var mr = useEnclosingmrow(n);
	if (isFirstChildOf(mr, "msup")) {
		n = mr;
		var msup = n.parentNode;
		var base = n.cloneNode(true);
		var sup = n.nextSibling.cloneNode(true);
		ms = designDoc.createElementNS(mmlns, "msubsup");
		ms.appendChild(base);
		ms.appendChild(rb);
		ms.appendChild(sup);
		d.appendChild(ms);
		//  d.appendChild(doplaceholder());
		msup.parentNode.replaceChild(d, msup);
	} else if (!ismo && !findmathparent(n)) {
		ms.appendChild(newrowbox());
		ms.appendChild(rb);
		d.appendChild(ms);
		//  d.appendChild(doplaceholder());
		insertfragment(d);
	} else {
		var old = n.cloneNode(true);
		ms.appendChild(nestinmrow(old));
		ms.appendChild(rb);
		d.appendChild(ms);
		//  d.appendChild(doplaceholder());
		n.parentNode.replaceChild(d, n);
	}
	setFocus(rb);
}

function doSupCmd() {
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "msup");
	var n = designDoc.getElementById("cursor");
	var ismo = (n.localName == "mo");
	var rb = newrowbox(); // new empty superscript
	var mr = useEnclosingmrow(n);
	if (isFirstChildOf(mr, "msub")) { // msubsup looks better than nested msub/msup
		n = mr;
		var msub = n.parentNode;
		var base = n.cloneNode(true);
		var sub = n.nextSibling.cloneNode(true);
		ms = designDoc.createElementNS(mmlns, "msubsup");
		ms.appendChild(base);
		ms.appendChild(sub);
		ms.appendChild(rb);
		d.appendChild(ms);
		//   d.appendChild(doplaceholder());
		msub.parentNode.replaceChild(d, msub);
	} else if (!ismo && (!findmathparent(n))) {
		ms.appendChild(newrowbox());
		ms.appendChild(rb);
		d.appendChild(ms);
		//  d.appendChild(doplaceholder());
		insertfragment(d);
	} else {
		var old = n.cloneNode(true);
		ms.appendChild(nestinmrow(old));
		ms.appendChild(rb);
		d.appendChild(ms);
		//  d.appendChild(doplaceholder());
		n.parentNode.replaceChild(d, n);
	}
	setFocus(rb);
}

function doSubSupCmd() {
	insertsubsup();
}

function doTensorCmd() {

	inserttensor();
}

function insertElement(em, v) {
	var curNode = designDoc.getElementById("cursor");
	var d = designDoc.createDocumentFragment();
	var emNode = designDoc.createElementNS(mmlns, em);
	var rb = newrowbox();
	var cb = newcolorbox();
	var c1 = nestinmrow(curNode.cloneNode(true));
	var b;
	if (v == 1) {
		if (curNode.tagName == "mo") {
			delcursor();
			emNode.appendChild(cb);
			curNode.parentNode.appendChild(emNode);
		} else {
			emNode.appendChild(c1);
			curNode.parentNode.replaceChild(emNode, curNode);
		}
	} else if (v == 2) {
		if (curNode.tagName == "mo") {
			delcursor();
			emNode.appendChild(cb);
			emNode.appendChild(newrowbox());
			curNode.parentNode.appendChild(emNode);
		} else {
			emNode.appendChild(c1);
			emNode.appendChild(rb);
			curNode.parentNode.replaceChild(emNode, curNode);
		}
	};
}
function doRadicalCmd() {
	var curnode = designDoc.getElementById("cursor");
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "msqrt");
	var rb = newrowbox();
	var c1 = curnode.cloneNode(true);
	if (curnode.tagName == "mo") {
		ms.appendChild(rb);
		d.appendChild(mf);
		insertfragment(d);
	} else {
		var c1 = curnode.cloneNode(true);
		mf.appendChild(c1);
		mf.appendChild(rb);
		d.appendChild(mf);
		replacebox(curnode, mf);
	}
	ms.appendChild(rb);
	d.appendChild(ms);
	insertfragment(d);
	setFocus(rb);
}

function doRootCmd() {
	insertroot();
}

function doDisplayCmd() {
	insertdisplay();
}

function doInt() {
	inserttag("mo", "\u222B");
}

function doSum() {
	inserttag("mo", "\u2211");
}

function doSum1() {
	inserttag("mo", "\u2211");
	//inserttag("mi", "");
	insertmath()
}

function insertElement1(node, m) {
	var d = designDoc.createDocumentFragment();
	var node1 = designDoc.createElementNS(mmlns, "mo");
	var box1 = designDoc.createTextNode(node);
	var curNode = designDoc.getElementById("cursor");
	node1.appendChild(box1);
	var node2 = designDoc.createElementNS(mmlns, "mrow");
	node2.appendChild(node1);
	var nb = newrowbox();
	if (m == 0) //m=0:munder; m=1:munderover;m=2:msubsup;
	{
		var ms = designDoc.createElementNS(mmlns, "munder");
		ms.appendChild(node2);
		ms.appendChild(nb);
		d.appendChild(ms);
	} else if (m == 1) {
		var ms1 = designDoc.createElementNS(mmlns, "munderover");
		ms1.appendChild(node2);
		var nb1 = newrowbox();
		ms1.appendChild(nb);
		ms1.appendChild(nb1);
		d.appendChild(ms1);
	} else if (m == 2) {
		var ms1 = designDoc.createElementNS(mmlns, "msubsup");
		ms1.appendChild(node2);
		var nb1 = newrowbox();
		ms1.appendChild(nb);
		ms1.appendChild(nb1);
		d.appendChild(ms1);
	}

	if (curNode && curNode.tagName == "mo") {
		d.appendChild(newcolorbox());

	} else {
		var c = curNode.cloneNode(true);
		d.appendChild(c);
	}
	insertfragment(d);
	delcursor();
}

function domatrix() {
	var r = prompt("please input the number of rows:", "");
	var s = prompt("please input the number of cols:", "");
	doMatrixCmd(r, s);
}

function doOperatorCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mo", o.val);
	}
}

function doBinOperatorCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mo", o.val);
	}
}

function doElementCmd() {
	inserttag("mo", "\u2208");
}

function doParensCmd() {
	insertfence("(", ")");
}

function doBracketsCmd() {
	var s = designWin.getSelection();
	if (s) insertbrackets();
}

function doBracesCmd() {
	var s = designWin.getSelection();
	if (s) insertbraces();
}

function doMatrixCmd(r, c) {
	insertmatrix(r, c);
}

function doLimCmd() {
	insertname("lim");
	insertmunder();
	curnode = designDoc.getElementById("cursor");
	rb = newbox();
	delcursor();
	setFocusColor(rb);
	curnode.parentNode.parentNode.parentNode.appendChild(rb);
}

function doMathNameCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) insertname(o.val);
	}
}

function doAboveCmd() {
	insertmover();
}

function doBelowCmd() {
	insertmunder();
}

function doAboveBelowCmd() {
	insertmunderover();
}

function doGreekCmd(val) {
	var s = designWin.getSelection();
	if (s) {
		if (val.length > 0) inserttag("mi", val);
	}
}

function doSpacingCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mspace", o.val);
	}
}

function doInvisibleCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mo", o.val);
	}
}

function domiCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mi", o.val);
	}
}

function domoCmd() {
	var s = designWin.getSelection();
	if (s) {
		var o = new Object();
		o.val = "";
		designWin.openDialog("", "_blank", "", o);
		if (o.val.length > 0) inserttag("mo", o.val);
	}
}

function doViewSourceCmd() {
	var s = designWin.getSelection();
	if (s) {
		viewmathnode(s.focusNode);
	}
}

function doAttributesCmd() {
	var s = designWin.getSelection();
	if (s) {
		viewattributes(s.focusNode);
	}
}
function doKeydown(evt) {
	//removeCanSelectFn();
	// console.log("dokeydwon");
	if (designview == 0) {
		return;
	};
	if( evt.keyCode === 17 && evt.ctrlKey )return;
	if( evt.ctrlKey ){
		if( evt.keyCode ===90 ){  //ˣݵ뵽html棬
			back_prev.importToBody();
		}else if( evt.keyCode ===89 ){ // 
			back_prev.importToBody(1);
		}else if( evt.keyCode ===67 ){ //
			back_prev.cache = document.getSelection().type.toLowerCase() === 'range' && document.getSelection().focusNode.nodeValue;
		}else if( evt.keyCode ===86 ){ //
			back_prev.cache && inserttag('mi', back_prev.cache);
			back_prev.put();
		}else if( evt.keyCode ===88){ //
			back_prev.cache = document.getSelection().type.toLowerCase() === 'range' && document.getSelection().focusNode.nodeValue;
			var cur = document.getElementById('cursor');
			back_prev.put();
			cur.parentNode.removeChild( cur );
		};
		evt.stopPropagation();
		evt.preventDefault();
		return;
	};
	var stopBubble = true;
	switch (evt.keyCode) {
		case 8:
			doBackSpaceCmd(evt);
			break;
		case 32:
			//stopPropagation
			//alert("spddace");
			dospace();
			break;
		case 46:
			//alert("del");
			doDeleteCmd();
			break;
		case 37:
		case 38:
		case 39:
		case 40:
			doNavigate(evt.keyCode);
			break;
		default:
			stopBubble = false;
			break;
	}
	if (stopBubble) {
		evt.stopPropagation();
		evt.preventDefault();
	};
	//removeCanSelectFn();

}

function doKeypress(evt) {
	// alert("dokey1");
	if (/*(document.getSelection().type).toLowerCase() == 'range'*/false) {
		var range = document.getSelection(),
			range = range.getRangeAt();
			//alert(1);
			//console.log( range )
			range.deleteContents();
	};
	insertchar(evt.charCode);
	charcur = 1;
	evt.stopPropagation();
	back_prev.put();
}

function doNavigate(kc) {
	delmstyle();
	var curNode = designDoc.getElementById("cursor");
	var p = curNode;
	if (kc == 38) {
		while (1) {
			if (p.tagName === 'mtd') {
				p = findtagparent(curNode, "mtr");
				p = p.previousElementSibling.childNodes[0];
				break;
			};
			if (p.parentNode.tagName == "mstyle" && p.parentNode.getAttribute("mid") == "tempstyle") {
				return;
			};
			while (p) {
				if (p.tagName === 'mrow' && p.previousElementSibling && p.previousSibling.tagName === 'mrow') {
					p = p.previousElementSibling;
					if (p.childNodes[0].childElementCount > 1) p = p.childNodes[0].childNodes[0];
					break;
				};
				if (p.parentNode.tagName == "mstyle" && p.parentNode.getAttribute("mid") == "tempstyle") {
					return;
				};
				p = p.parentNode
			};
			break;
			/*else if(p.previousSibling || p.nextSibling || p.parentNode.tagName!="mrow")
			 {
			 rn=p.parentNode;
			 break;
			 }else
			 {
			 p=p.parentNode;
			 }
			 */
		}
		delcursor();
		setFocusColor(p);
	}
	if (kc == 37) {
		while (1) {
			if (p.tagName == "mstyle" && p.getAttribute("mid") == "tempstyle") {
				return;
			};
			if (p.onece && p.childElementCount > 0) {
				p.onece = false;
				while (p.childElementCount > 0) {
					p = p.childNodes[p.childElementCount - 1];
				}
				break;
			};
			if (p.previousElementSibling) {
				p = p.previousElementSibling;
				if (!p.onece && (p.childElementCount > 1)) {
					p.onece = true;
					break;
				}
				while (p.childElementCount > 0) {
					p = p.childNodes[p.childElementCount - 1];
				}
				break;
			}
			p = p.parentNode;

		}
		delcursor();
		setFocusColor(p);
	}
	if (kc == 39) {
		while (1) {
			if (p.tagName == "mstyle" && p.getAttribute("mid") == "tempstyle") {
				return;
			}
			/*
			 //׼  Ҳǽͳ nextSiblingҪֶmiĹ
			 while(p.tagName === 'mi'){
			 p = p.parentNode;
			 }
			 */
			if (p.nextElementSibling) {
				p = p.nextElementSibling;
				while (p.childElementCount > 0) {
					p = p.childNodes[0];
				}
				break;
			};
			p = p.parentNode;
			console.log(p.tagName)
			if(p.tagName=='mfrac' || !p.tagName ==='mrow')break;
			/*
			 while( p.nextElementSibling == null){
			 p = p.parentNode;
			 }
			 break;
			 */
		}
		delcursor();
		setFocusColor(p);
	}
	if (kc == 40) {
		/*
		 if(curNode.childElementCount > 0) {
		 delcursor();
		 setFocusColor(curNode.childNodes[0]);
		 }
		 */
		while (1) {
			if (p.parentNode.tagName == "mstyle" && p.parentNode.getAttribute("mid") == "tempstyle") {
				return
			};
			while (p) {
				if (p.tagName === 'mtr') {
					p = p.nextElementSibling.childNodes[0];
					break;
				};
				if (p.tagName === 'mrow' && p.nextElementSibling && p.nextElementSibling.tagName === 'mrow') {
					p = p.nextElementSibling;
					if (p.childNodes[0].childElementCount > 1) p = p.childNodes[0].childNodes[0];
					break;
				};
				if (p.parentNode.tagName == "mstyle" && p.parentNode.getAttribute("mid") == "tempstyle") {
					return
				};
				p = p.parentNode;
			};
			break;
		}
		delcursor();
		setFocusColor(p);
	}
}

function doCode() {
	if (designview == 0) {
		alert("already in code mode");
		return;
	}
	var h = designDoc.body.innerHTML;
	designDoc.body.innerHTML = "";
	designDoc.body.innerHTML = "<form name='f2'><textarea name='mathcode' cols=70 rows=15 style='border:0'>" + h + "</textarea></form>";
	designview = 0;
	document.getElementById("mathsign").style.display = "none";
}
function doDesign() {
	if (designview == 1) {
		alert("already in design mode");
		return;
	}
	var s = designDoc.f2.mathcode.value;
	designDoc.body.innerHTML = "";
	s = s.toString();
	var myDocument;
	var parser = new DOMParser();
	myDocument = parser.parseFromString(s.toString(), "text/xml");
	var root = myDocument.documentElement;
	var d = designDoc.createDocumentFragment();
	d.appendChild(root);
	designDoc.body.appendChild(d);
	designWin.focus();
	//designDoc.body.innerHTML=s;
	designview = 1;
	document.getElementById("mathsign").style.display = "";
}
function doPreview() {
	var source;
	var sourceStr;
	if (designview == 0) {
		source = designDoc.createRange();
		source.selectNodeContents(designDoc.body);
		sourceStr = source.toString();
	}
	if (designview == 1) {
		sourceStr = designDoc.body.innerHTML;
	}
	var dlg;
	dlg = window.open("", "preview", "toolbar=no,menubar=no,personalbar=no,width=400,height=300," + "scrollbars=no,resizable=yes");
	dlg.document.body.innerHTML = "";
	dlg.document.title = "Preview Your Mathematical Expression";
	var myDocument;
	var parser = new DOMParser();
	myDocument = parser.parseFromString(sourceStr, "text/xml");

	var del1 = myDocument.getElementById("tempstyle");
	del1.removeAttribute("mathsize");
	del1.removeAttribute("mathcolor");
	var del2 = myDocument.getElementById("cursor");
	del2.removeAttribute("id");
	del2.removeAttribute("mathcolor");
	//06-0905
	var root = myDocument.documentElement;
	var d = dlg.document.createDocumentFragment();
	d.appendChild(root);
	dlg.document.body.appendChild(d);
	if (dlg && !dlg.closed) {
		dlg.focus();
	}
}

function getEvent(evt)
{
	var targ;//defeat Safari bug
	if(!e){
		var e=evt;//firefoxûwindow.event
		targ=e.srcElement ? e.srcElement:e.target;
	};
	if(targ.nodeType==3){
		targ=targ.parentNode
	};
    return targ;
}

function domouseclick(evt) {
	var targ=getEvent(evt);

	delcursor();
	evt.stopPropagation();
	if(targ.tagName.toLowerCase() == 'body' || targ.tagName.toLowerCase() == 'html' || targ.tagName.toLowerCase() == 'div'){
		var eMi = document.getElementsByTagName('mi')[0];
		delcursor();
		setFocusColor( eMi );
		return
	};
	if (designview == 0) return;

	if (designview == 1) {
		var curnode = designDoc.getElementById("cursor");
		delcursor();
		if(targ.tagName === 'mo' || targ.tagName === 'mi' || targ.tagName === 'mn' ){
			setFocusColor(targ);
			//setBorderOrNone.bar(); //趨borderǰָ
			return
		};
		var s = designWin.getSelection();
		var loc = !s.focusNode ? targ: s.focusNode.parentNode;
		if (loc == curnode) {
			var nloc = loc.parentNode;
			if (nloc.tagName == "mrow" && loc.nextSibling == null && loc.previousSibling == null) {
				nloc = nloc.parentNode;
			}
			if ( nloc.tagName == 'msup' && nloc.parentNode.parentNode.tagName == 'mfrac'){
				nloc = nloc.parentNode.parentNode;
			}
			if (nloc.tagName === 'mtd') {
				nloc = loc.firstChild;
			};
			var nlocA = nloc.getAttribute("mid");
			if (nlocA == "tempstyle") {
				return;
			} else {
				nloc.setAttribute("mathbackground", bcolor);
				nloc.setAttribute("mathcolor", fcolor);
				nloc.setAttribute("id", "cursor");
			}
		} else {
			loc.setAttribute("mathbackground", bcolor);
			loc.setAttribute("mathcolor", fcolor);
			loc.setAttribute("id", "cursor");
		}

		// flashcursor();
	};
}

function doplaceholder() {
	var mp = designDoc.createElementNS(mmlns, "mphantom");
	var mph = designDoc.createElementNS(mmlns, "mi");
	var t = designDoc.createTextNode("|");
	mph.setAttribute("id", "placeholder");
	mph.appendChild(t);
	mp.appendChild(mph);
	return (mp);

}

function delcursor() {
	var curnode = designDoc.getElementById("cursor");
	if (!curnode) {
		return;
	} else {
		curnode.removeAttribute("mathbackground");
		curnode.removeAttribute("mathcolor");
		curnode.removeAttribute("id");
	};
	delmstyle();
}
function delmstyle() {
	var mstys = designDoc.getElementsByTagName("mstyle");
	for (var i = 0; i < mstys.length; i++) {
		if (mstys[i].getAttribute("mid") == "tempstyle") {
			continue;
		} else {
			mstys[i].parentNode.replaceChild(mstys[i].firstChild, mstys[i]);
		}
	}
}

//editing
function newbox() {
	var box = designDoc.createElementNS(mmlns, "mi");
	box.appendChild(designDoc.createTextNode("\u0000"));
	box.className = 'null';
	return box;
}

function newrowbox() {
	var row = designDoc.createElementNS(mmlns, "mrow");
	row.appendChild(newbox());
	return row;
}

function newcolorbox() {
	var row = designDoc.createElementNS(mmlns, "mrow");
	var n = newbox();
	setFocusColor(n);
	row.appendChild(n);
	return row;
}

function zerowidthspace() {
	var mi = designDoc.createElementNS(mmlns, "mi");
	mi.appendChild(designDoc.createTextNode("\u200B"));
	return mi;
}

function newnone() {
	var none = designDoc.createElementNS(mmlns, "none");
	return none;
}

function findtagparent(node, tag) {
	if (!node || node.localName == tag) return node;
	else return findtagparent(node.parentNode, tag);
}

function findmathparent(node) {
	return findtagparent(node, "math");
}

function getselectednode(s) {
	var r = s.getRangeAt(0);
	var n = r.commonAncestorContainer; // get selection node
	if (n.nodeType == Node.TEXT_NODE) n = n.parentNode;
	return n;
}

function cant_nest_here(node) {
	if (findtagparent(node, "mi") || findtagparent(node, "mn") || findtagparent(node, "mo")) return true;
	else return false;
}

function nestinmath(node) {
	var d = designDoc.createDocumentFragment();
	var m = designDoc.createElementNS(mmlns, "math");
	m.setAttribute("xmlns", mmlns);
	var r = designDoc.createElementNS(mmlns, "mrow");
	r.appendChild(node);
	m.appendChild(r);
	d.appendChild(m);
	return d;
}

function nestinmrow(old) {
	if (old.localName == "mrow" || old.localName == "mo") {
		return old;
	} else {
		var row = designDoc.createElementNS(mmlns, "mrow");
		row.appendChild(old);
		return row;
	}
}

function insertbefore(loc, node) {
	var n = findmathparent(loc);
	var p = loc.parentNode;
	if (!n) {
		p.insertBefore(nestinmath(node), loc);
	} else {
		if (cant_nest_here(p)) {
			loc = p;
			p = loc.parentNode;
		}
		p.insertBefore(node, loc);
	}
}

function insertafter(loc, node) {
	var sib = loc.nextSibling;
	if (sib) loc.parentNode.insertBefore(node, sib);
	else loc.parentNode.appendChild(node);
}

function appendhere(loc, node) {
	var n = findmathparent(loc);
	if (!n) {
		var d = nestinmath(node);
		insertafter(loc, d);
		return;
	} else {
		var p = loc.parentNode;
		if (cant_nest_here(p)) loc = p;
		insertafter(loc, node);
	}
}

function replacebox(loc, node) {
	loc.parentNode.replaceChild(node, loc);
}

function inputboxselected(node) {
	if(node && node.textContent == "" && (node.tagName == "mi" || node.tagName == "MI") && node.className === 'null'){
		return true;
	};
	if ( node && node.textContent == "" || node.data == "\u0000"  ){
		return true
	}else if ( node && node.localName == "mi" || node.localName == "MI") return inputboxselected(node.firstChild);
	/*
	if ((  node.textContent == "" || node.data == "\u0000" ) && node.length == 1 && (node.parentNode.localName == "mi" || node.parentNode.localName == "MI")){
		return true
	}
	*/
	else return false;
}

function insertfragment(node) {
	var curnode = designDoc.getElementById("cursor");
	delcursor();
	if (inputboxselected(curnode)) {
		replacebox(curnode, node);
	} else if (judgep(curnode.parentNode) == 1) {
		var b = designDoc.createElementNS(mmlns, "mrow");
		var c = curnode.cloneNode(true);
		b.appendChild(c);
		b.appendChild(node);
		replacebox(curnode, b);
	} else {
		appendhere(curnode, node);
	}
	//savehist();
}
function judgep(node1) {
	tagname1 = node1.tagName;
	var ne = new Array();
	ne[0] = "mroot";
	ne[1] = "mfrac";
	ne[2] = "msup";
	ne[3] = "msub";
	ne[4] = "msubsup";
	ne[5] = "munder";
	ne[6] = "mover";
	ne[7] = "munderover"; //nesting element
	var r = 0;
	for (var i = 0; i <= ne.length; i++) {
		if (tagname1 == ne[i]) r = 1;
	}
	return (r);
}
function insertmath() {
	var d = designDoc.createDocumentFragment();
	var b = newbox();
	d.appendChild(b);
	insertfragment(d);
	setFocus(b);
}

function insertdisplay() {
	var math = designDoc.createElementNS(mmlns, "math");
	math.setAttribute("xmlns", mmlns);
	math.setAttribute("mode", "display");
	var style = designDoc.createElementNS(mmlns, "mstyle");
	style.setAttribute("displaystyle", "true");
	var rb = newrowbox();
	style.appendChild(rb);
	math.appendChild(style);
	var s = designWin.getSelection();
	if (s) {
		var end = s.focusNode;
		var off = s.focusOffset;
		var p = end.parentNode;
		var n = findmathparent(end);
		if (n) { // don't nest display inside math
			insertafter(n, math);
		} else if (end.nodeType == Node.TEXT_NODE && off > 0) {
			if (off == end.length) {
				insertafter(end, math);
			} else {
				p.insertBefore(math, end.splitText(off));
			}
		} else {
			p.insertBefore(math, end);
		}
	}
	setFocus(rb);
}

function inserttag(tagname, op) {
	var d = designDoc.createDocumentFragment();
	var tag = designDoc.createElementNS(mmlns, tagname);
	var t = designDoc.createTextNode(op);
	tag.appendChild(t);
	setFocusColor(tag);
	d.appendChild(tag);
	insertfragment(d);
}

function insertbox() {
	inserttag("mi", "\u0000");
}
function inserteq() {
	inserttag("mo", "\u003d");
}
function insertgt() {
	inserttag("mo", "\u003e");
}
function insertlt() {
	inserttag("mo", "\u003c");
}
function insertpercent() {
	inserttag("mo", "\u0025");
}
function insertdirectprod() {
	inserttag("mo", "\u2297");
}
function inserttimes() {
	inserttag("mo", "\u00D7");
}
function insertplus() {
	inserttag("mo", "\u002B");
}
function insertminus() {
	inserttag("mo", "\u2212");
}
function insertdivide() {
	inserttag("mo", "\u00F7");
}
function insertplusminus() {
	inserttag("mo", "\u00B1");
}

function insertsubset() {
	inserttag("mo", "\u2282");
}
function insertnsub() {
	inserttag("mo", "\u2284");
}
function insertnsubseteq() {
	inserttag("mo", "\u2288");
}
function insertpi() {
	inserttag("mi", "\u03C0");
}
function inserttheta() {
	inserttag("mi", "\u03B8");
}
function insertinfinity() {
	inserttag("mi", "\u221E");
}
function insertnot() {
	inserttag("mi", "\u2309");
}
function insertarrow() {
	inserttag("mo", "\u2192");
}
function insertleftrightarrow() {
	inserttag("mo", "\u2194");
}
function insertRightarrow() {
	inserttag("mo", "\u21d2");
}
function insertLeftrightarrow() {
	inserttag("mo", "\u21d4");
}
function insertCirclePlus() {
	inserttag("mo", "\u2295");
}
function insertle() {
	inserttag("mo", "\u2264");
}
function insertne() {
	inserttag("mo", "\u2260");
}
function insertge() {
	inserttag("mo", "\u2265");
}
function insertcaps() {
	inserttag("mo", "\u2229");
	}
function insertcaps() {
	inserttag("mo", "\u2229");
	}
function insertcups() {
	inserttag("mo", "\u222a");
	}
function insertemptyset() {
	inserttag("mo", "\u2205");
	}
function insertxodot() {
	inserttag("mo", "\u2299");
	}
function insertpart() {
	inserttag("mo", "\u2202");
	}
function insertwedge() {
	inserttag("mo", "\u2227");
	}
function insertvee() {
	inserttag("mo", "\u2228");
	}
function insertbullet() {
	inserttag("mo", "\u2022");
	}
function insertmp() {
	inserttag("mo", "\u2213");
	}
function insertlowast() {
	inserttag("mo", "\u2217");
	}
function insertforall() {
	inserttag("mo", "\u2200");
	}
function insertexist() {
	inserttag("mo", "\u2203");
	}
function insertnexists() {
	inserttag("mo", "\u2204");
	}
function insertleftg() {
	inserttag("mo", "\u2571");
	}
function insertrightg() {
	inserttag("mo", "\u2572");
	}
function insertsubseteqq() {
	inserttag("mo", "\u2286");
	}
function insertsupseteqq() {
	inserttag("mo", "\u2287");
	}
function insertsupset() {
	inserttag("mo", "\u2283");
	}
function insertnelement() {
	inserttag("mo", "\u2209");
	}
function insertoneflag() {
	inserttag("mo", "\u223c");
	}
function inserttwoflag() {
	inserttag("mo", "\u2248");
	}
function insertequiv() {
	inserttag("mo", "\u2261");
	}

function insertfence(left, right) {
	var d = designDoc.createDocumentFragment();
	var ml = designDoc.createElementNS(mmlns, "mo");
	var mr = designDoc.createElementNS(mmlns, "mo");
	ml.appendChild(designDoc.createTextNode(left));
	mr.appendChild(designDoc.createTextNode(right));
	curNode = designDoc.getElementById("cursor");
	if (curNode.tagName == "mo") {
	d.appendChild(ml);
	var rb = newrowbox();
	d.appendChild(rb);
	d.appendChild(mr);
	insertfragment(d);
	setFocus(rb);
	} else {
	var old = curNode.cloneNode(true);
	d.appendChild(ml);
	d.appendChild(nestinmrow(old));
	d.appendChild(mr);
	curNode.parentNode.replaceChild(d, curNode);
	}
}

function insertbrackets() {
	insertfence("[", "]");
	}

function insertbraces() {
	insertfence("{", "}");
}
function insertrc() {
	insertfence("|", "|");
	}
function insertceiling() {
	insertfence("\u2308", "\u2309");
	}
function insertfloor() {
	insertfence("\u230A", "\u230B");
	}

function setFocus(node1) {
	delcursor();
	mis = node1.getElementsByTagName("mi");
	for (var i = 0; i < mis.length; i++) {
		mi = mis[i];
		v = mi.firstChild.nodeValue;
		asc1 = v.charCodeAt();
		if (asc1 == 9633) {
		setFocusColor(mi);
		return;
	}
}
}

function setFocusColor(node1) {
	if(!node1)return
	node1.setAttribute("mathbackground", bcolor);
	node1.setAttribute("mathcolor", fcolor);
	node1.setAttribute("id", "cursor");
	//node1.parentNode.replaceChild(d,n);
}

// Actually, put caret at end of last leaf under node
function caret_on_node(node) {
	var c = node;
	setFocus(node);
	while (c && c.nodeType != Node.TEXT_NODE) {
	c = c.lastChild;
	}
var s = designWin.getSelection();
s.collapse(c, c.length);
}

function insertroot() {
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "mroot");
	var s = designWin.getSelection();
	if (s.isCollapsed || !findmathparent(s.focusNode)) {
	var rb = newrowbox();
	ms.appendChild(rb);
	ms.appendChild(newrowbox());
	d.appendChild(ms);
	//  d.appendChild(doplaceholder());
	insertfragment(d);
	setFocus(rb);
	} else {
	var n = getselectednode(s);
	var old = n.cloneNode(true);
	ms.appendChild(nestinmrow(old));
	ms.appendChild(newrowbox());
	d.appendChild(ms);
	//  d.appendChild(doplaceholder());
	n.parentNode.replaceChild(d, n);
	}
}

function insertname(n) {
	var d = designDoc.createDocumentFragment();
	var mi = designDoc.createElementNS(mmlns, "mi");
	var t = designDoc.createTextNode(n);
	mi.appendChild(t);
	//mi.setAttribute("mathcolor","black");
	setFocusColor(mi);
	d.appendChild(mi);
	insertfragment(d);
	}

function insertsin() {
	insertname("sin");
	//inserttag("mi", "");
	insertmath();
}
function insertcos() {
	insertname("cos");
	//inserttag("mi", "");
	insertmath();
	}
function inserttan() {
	insertname("tan");
	//inserttag("mi", "");
	insertmath();
	}
function insertcot() {
	insertname("cot");
	//inserttag("mi", "");
	insertmath();
	}
function insertarcsin() {
	insertname("arcsin");
	//inserttag("mi", "");
	insertmath();
	}
function insertarccos() {
	insertname("arccos");
	//inserttag("mi", "");
	insertmath();
	}
function insertarctan() {
	insertname("arctan");
	//inserttag("mi", "");
	insertmath();
	}
function insertarccot() {
	insertname("arccot");
	//inserttag("mi", "");
	insertmath();
	}
function insertsec() {
	insertname("sec");
	//inserttag("mi", "");
	insertmath();
	}
function insertarcsec() {
	insertname("arcsec");
	//inserttag("mi", "");
	insertmath();
	}
function insertcsc() {
	insertname("csc");
	//inserttag("mi", "");
	insertmath();
	}
function insertarccsc() {
	insertname("arccsc");
	//inserttag("mi", "");
	insertmath();
	}

function insertln() {
	insertname("ln");
	//inserttag("mi", "");
	insertmath();
	}
function insertlg() {
	insertname("lg");
	//inserttag("mi", "");
	insertmath();
	}

function isFirstChildOf(node, tag) {
	if (node.parentNode.localName != tag) return false;
	else if (node.previousSibling) return false;
	else return true;
	}

// if we're the only child of an mrow, use that instead.
function useEnclosingmrow(node) {
	if (node.previousSibling || node.nextSibling || node.parentNode.localName != "mrow") return node;
	else return node.parentNode;
	}

function insertsubsup() {
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "msubsup");
	var n = designDoc.getElementById("cursor");
	var rb = newrowbox(); // new empty superscript
	var ismo = (n.localName == "mo");
	if (!ismo && !findmathparent(n)) {
	ms.appendChild(newrowbox());
	ms.appendChild(newrowbox());
	ms.appendChild(rb);
	d.appendChild(ms);
	//  d.appendChild(doplaceholder());
	insertfragment(d);
	} else {
		var old = n.cloneNode(true);
		ms.appendChild(nestinmrow(old));
		ms.appendChild(newrowbox());
		ms.appendChild(rb);
		d.appendChild(ms);
		// d.appendChild(doplaceholder());
		n.parentNode.replaceChild(d, n);
	}
setFocus(rb);
}

function inserttensor() {
	var d = designDoc.createDocumentFragment();
	var ms = designDoc.createElementNS(mmlns, "mmultiscripts");
	var mp = designDoc.createElementNS(mmlns, "mprescripts");
	var n = designDoc.getElementById("cursor");
	var rb = newrowbox(); // new empty subscript
	if (!findmathparent(n)) {
	ms.appendChild(newrowbox());
	ms.appendChild(newrowbox());
	ms.appendChild(rb);
	ms.appendChild(mp);
	ms.appendChild(newrowbox());
	ms.appendChild(newrowbox());
	d.appendChild(ms);
	insertfragment(d);
	} else {
	var old = n.cloneNode(true);
	ms.appendChild(nestinmrow(old));
	ms.appendChild(newrowbox());
	ms.appendChild(rb);
	ms.appendChild(mp);
	ms.appendChild(newrowbox());
	ms.appendChild(newrowbox());
	d.appendChild(ms);
	n.parentNode.replaceChild(d, n);
	}
setFocus(rb);
}

function insertmover() {
	var d = designDoc.createDocumentFragment();
	var mover = designDoc.createElementNS(mmlns, "mover");
	var n = designDoc.getElementById("cursor");
	var rb = newrowbox(); // new empty overscript
	var mr = useEnclosingmrow(n);
	if (isFirstChildOf(mr, "munder")) {
	n = mr;
	var munder = n.parentNode;
	var base = n.cloneNode(true);
	var under = n.nextSibling.cloneNode(true);
	ms = designDoc.createElementNS(mmlns, "munderover");
	ms.appendChild(base);
	ms.appendChild(under);
	ms.appendChild(rb);
	d.appendChild(ms);
	munder.parentNode.replaceChild(d, munder);
	} else if (!findmathparent(n)) {
	mover.appendChild(newrowbox());
	mover.appendChild(rb);
	d.appendChild(mover);
	insertfragment(d);
	} else {
	var old = n.cloneNode(true);
	mover.appendChild(nestinmrow(old));
	mover.appendChild(rb);
	d.appendChild(mover);
	n.parentNode.replaceChild(d, n);
	}
setFocus(rb);
}

function insertmunder() {
	var d = designDoc.createDocumentFragment();
	var munder = designDoc.createElementNS(mmlns, "munder");
	var n = designDoc.getElementById("cursor");
	var rb = newrowbox(); // new empty underscript
	var mr = useEnclosingmrow(n);
	if (isFirstChildOf(mr, "mover")) {
	n = mr;
	var mover = n.parentNode;
	var base = n.cloneNode(true);
	var over = n.nextSibling.cloneNode(true);
	ms = designDoc.createElementNS(mmlns, "munderover");
	ms.appendChild(base);
	ms.appendChild(rb);
	ms.appendChild(over);
	d.appendChild(ms);
	mover.parentNode.replaceChild(d, mover);
	} else if (!findmathparent(n)) {
	munder.appendChild(newrowbox());
	munder.appendChild(rb);
	d.appendChild(munder);
	insertfragment(d);
	} else {
	n = designDoc.getElementById("cursor");
	var old = n.cloneNode(true);
	munder.appendChild(nestinmrow(old));
	munder.appendChild(rb);
	d.appendChild(munder);
	n.parentNode.replaceChild(d, n);
	}
setFocus(rb);
}

function insertmunderover() {
	var d = designDoc.createDocumentFragment();
	var muo = designDoc.createElementNS(mmlns, "munderover");
	var rb = newrowbox(); // new empty overscript
	var s = designWin.getSelection();
	if (s.isCollapsed || !findmathparent(s.focusNode)) {
	muo.appendChild(newrowbox());
	muo.appendChild(newrowbox());
	muo.appendChild(rb);
	d.appendChild(muo);
	insertfragment(d);
	} else {
	var n = designDoc.getElementById("cursor");
	var old = n.cloneNode(true);
	muo.appendChild(nestinmrow(old));
	muo.appendChild(newrowbox());
	muo.appendChild(rb);
	d.appendChild(muo);
	n.parentNode.replaceChild(d, n);
	}
setFocus(rb);
}

function insertmatrix(rows, columns) {
	var d = designDoc.createDocumentFragment();
	var mt = designDoc.createElementNS(mmlns, "mtable");
	var mr = designDoc.createElementNS(mmlns, "mtr");
	var md = designDoc.createElementNS(mmlns, "mtd");
	md.appendChild(newrowbox());
	var i;
	for (i = 0; i < columns; i++) mr.appendChild(designDoc.importNode(md, true));
	for (i = 0; i < rows; i++) mt.appendChild(designDoc.importNode(mr, true));
	d.appendChild(mt);
	insertfragment(d);
	setFocus(mt); // will descend to first box
	}

// returns 0 for no siblings
function hassiblings(node) {
	var count = 0;
	if (node.previousSibling) count++;
	if (node.nextSibling) count++;
	return count;
	}

function getsibling(node) {
	if (!node) return null;
	var sib = node.nextSibling;
	if (!sib) sib = node.previousSibling;
	return sib;
	}

function deleteleft() {
	var s = designWin.getSelection();
	if (!s.isCollapsed) //ѡַĻΪfalse ȡtrue
	deleteselection();
	else if (!findmathparent(s.focusNode)) deletetext(s, false);
	};

function deletetext(s, right) 
{
	var n = s.focusNode;

	if (n != s.anchorNode || n.nodeType != Node.TEXT_NODE) // can't deal with inter-object selections yet
	return;
	var off = s.anchorOffset;
	var count = s.focusOffset - s.anchorOffset;

	if (s.isCollapsed) 
    {
	    count = 1;
	    if (!right) 
        { 
            // backspace
	        if (off == 0) 
                return;
	        else
                --off;
	    }
    }
    else if (count < 0) 
    {
		count = -count;
		off = s.focusOffset;
	}

	 var old = n.data;
	 if (off + count <= n.length)
     {
			n.data = old.substr(0, off) + old.substr(off + count);
			s.collapse(n, off);
	 } 
     else
     {
		    n.data = old.substr(0, off);
		    s.collapse(n, off);
	 }
}

function deleteselection() 
{
	var n = designDoc.getElementById("cursor");
	if (findmathparent(n)) 
    {
		deletemathnode(n);
	} 
    else 
    {
		deletetext(n, true);
	}
}

function deletemathnode(n) 
{
			var mr = useEnclosingmrow(n);
			var p = mr.parentNode;
			var pname = p.localName;
			var nrb = designDoc.createElementNS(mmlns, "mrow");
			var nb = newbox();
			var newF;
			setFocusColor(nb);
			nrb.appendChild(nb);

			switch (pname)
            {
			    case "math":
			        p.parentNode.removeChild(p);
			        break;
			    case "mstyle":
			        if (hassiblings(mr) == 0) 
                    {
			            p.replaceChild(nrb, mr);
			        } 
                    else 
                    {
			            newF = !!mr.previousSibling ? mr.previousSibling: mr.nextSibling;
			            p.removeChild(mr);
			            setFocusColor(newF);
			        }
		            break;
		        case "mrow":
		            if (hassiblings(mr) == 0)
                    {
			            deletemathnode(p);
			        }
                    else 
                    {
			            newF = !!mr.previousSibling ? mr.previousSibling: mr.nextSibling;
			            p.removeChild(mr);
			            setFocusColor(newF);
			        }
		            break;
		        case "mmultiscripts":
		            if (inputboxselected(n) && mr.previousSibling)
                    { 
                        // box in script, delete position
			            p.replaceChild(newnone(), mr);
			        } 
                    else 
                    {
			            p.replaceChild(nrb, mr);
			        }
		            break;
		        case "msqrt":
		        case "mfrac":
		        case "mroot":
		        case "munder":
		        case "mover":
		        case "munderover":
		        case "msub":
		        case "msup":
		        case "msubsup":
		        case "mtd":
		            p.replaceChild(nrb, mr);
		            break;
		        default:
		            //"mtr", "mtable"
                    //console.log(pname + " child is not delete ", mr); 
                    break;
        }
}

function sizesmall() {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) n.setAttribute("mathsize", "small");
}

function sizebig() {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) n.setAttribute("mathsize", "big");
}

function sizenormal() {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) n.removeAttribute("mathsize");
}

// We use MathML 1.01 style attributes, since Mozilla doesn't support mathvariant.
// For now, at least, this is simpler anyway.
function stylebold(b) {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (b) n.setAttribute("fontweight", "bold");
        else n.removeAttribute("fontweight");
    }
}

function styleitalic(i) {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (i) n.setAttribute("fontstyle", "italic");
        else n.removeAttribute("fontstyle");
    }
}

function togglebold() {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (n.getAttribute("fontweight") != "bold") n.setAttribute("fontweight", "bold");
        else n.removeAttribute("fontweight");
    }
}

function toggleitalic() {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (n.getAttribute("fontstyle") != "italic") n.setAttribute("fontstyle", "italic");
        else n.removeAttribute("fontstyle");
    }
}

function setcolor(c) {

    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (c) n.setAttribute("mathcolor", c);
        else n.removeAttribute("mathcolor");
    }
}

function setbackgroundcolor(c) {
    var s = designWin.getSelection();
    var n = getselectednode(s);
    if (findmathparent(n)) {
        if (c) n.setAttribute("mathbackground", c);
        else n.removeAttribute("mathbackground");
    }
}

// A raw attribute list.  Edit Attributes is more refined.
function viewattributes(n) {
    var node = n;
    if (node.nodeType == Node.TEXT_NODE) node = node.parentNode;
    if (findmathparent(node)) {
        var msg = "Node name: " + node.nodeName;
        msg += "\n\n";

        for (var i = 0; i < node.attributes.length; i++) {
            var attr = node.attributes.item(i);
            msg += attr.nodeName;
            msg += '=';
            msg += attr.nodeValue;
            msg += '\n';
        }
    }
}

function movespace(n) {
    var event = designDoc.createEvent("KeyEvents");
    event.initKeyEvent("keypress", true, true, null, false, false, false, false, event.DOM_VK_RIGHT, 0);
    n.dispatchEvent(event);
}

function inserttextchar(s, str) {
    var n = s.focusNode;
    var off = s.focusOffset;
    if (n.nodeType == Node.TEXT_NODE) {
        var old = n.data;
        n.data = old.substr(0, off) + str + old.substr(off);
        s.collapse(n, off + 1);
    }
}

function insertspace(s) {
    inserttextchar(s, "");
}

function tabobject() {
    var s = designWin.getSelection();
    var n = s.focusNode;
    if (!findmathparent(n)) return;
    if (!s.isCollapsed) {
        s.collapseToStart();
        return;
    }

    // find enclosing object which responds to TAB
    for (var p = n; p.localName != "math"; p = p.parentNode) {
        if (p.localName == "mtable") {
            tabtable(s, n);
            return;
        } else if (p.localName == "mroot") {
            tabroot(s, n);
            return;
        } else if (p.localName == "mfrac") {
            tabfrac(s, n);
            return;
        } else if (p.localName == "msubsup") {
            tabsubsup(s, n);
            return;
        } else if (p.localName == "munderover") {
            tabunderover(s, n);
            return;
        }
    }
}

function tabtable(s, n) {
    var mtd = findtagparent(n, "mtd");
    var sib = getnextmtd(mtd);
    if (sib) {
        caret_on_node(sib);
    } else {
        alert("lost in table");
    }
}

function getnextmtd(n) {
    if (!n || n.localName != "mtd") return null;
    var mtr = n.parentNode;
    var sib = n.nextSibling;
    if (!sib) {
        var nextrow = mtr.nextSibling;
        if (nextrow) {
            sib = nextrow.firstChild;
        }
        if (!sib) {
            var mtable = mtr.parentNode;
            mtr = mtable.firstChild;
            sib = mtr.firstChild;
        }
    }
    return sib;
}

function tabfrac(s, n) {
    var me = n;
    while (me && me.parentNode.localName != "mfrac") me = me.parentNode;
    var sib = getsibling(me);
    if (sib) {
        caret_on_node(sib);
    } else {
        alert("lost in mfrac");
    }
}

function tabroot(s, n) {
    var me = n;
    while (me && me.parentNode.localName != "mroot") me = me.parentNode;
    var sib = getsibling(me);
    if (sib) {
        caret_on_node(sib);
    } else {
        alert("lost in mroot");
    }
}

function tabsubsup(s, n) {
    var me = n;
    while (me && me.parentNode.localName != "msubsup") me = me.parentNode;
    var sib = getsibling(me);
    if (sib) {
        caret_on_node(sib);
    } else {
        alert("lost in msubsup");
    }
}

function tabunderover(s, n) {
    var me = n;
    while (me && me.parentNode.localName != "munderover") me = me.parentNode;
    var sib = getsibling(me);
    if (sib) {
        caret_on_node(sib);
    } else {
        alert("lost in munderover");
    }
}

// since NodeIterator isn't implemented in Mozilla
function findnextsibling(node, parent) {
    for (var p = node; p && p != parent; p = p.parentNode) if (p.nextSibling) return p.nextSibling;
    return null;
}

function dosplit() {
    var s = designWin.getSelection();
    var p = findtagparent(s.focusNode, "p");
    if (!p) return; // I'm lost (until we have some more editing behavior specified)
    var oldempty = false;
    var movenode = null;
    var end = s.focusNode;
    var off = s.focusOffset;
    var mathnode = findmathparent(end);
    if (mathnode) {
        movenode = findnextsibling(mathnode, p);
    } else if (end.nodeType == Node.TEXT_NODE) {
        if (off == 0) {
            movenode = end;
        } else if (off == end.length) {
            movenode = findnextsibling(end, p);
        } else {
            movenode = end.splitText(off);
        }
    } else {
        movenode = end;
    }
    // split the tree above movenode (under p)
    var t, next;
    if (movenode) {
        for (var parent = movenode.parentNode; parent && parent != p; parent = movenode.parentNode) {
            var newnode = parent.cloneNode(false); // shallow copy
            for (t = movenode; t;) {
                next = t.nextSibling;
                newnode.appendChild(t.parentNode.removeChild(t));
                t = next;
            }
            insertafter(parent, newnode);
            movenode = parent.nextSibling; // i.e. the new one
        }
    }
    var para = designDoc.createElementNS(htmlns, "p");
    if (movenode) {
        if (movenode == p.firstChild) oldempty = true;
        for (t = movenode; t;) {
            next = t.nextSibling;
            para.appendChild(t.parentNode.removeChild(t));
            t = next;
        }
    } else {
        para.appendChild(designDoc.createTextNode("new paragraph")); // localize!
    }
    insertafter(p, para);
    if (oldempty) p.appendChild(designDoc.createTextNode("blank paragraph")); // localize!
}

function dospace() {
    var s = designWin.getSelection();
    if (!s.isCollapsed) {
        s.collapseToStart();
    } else {
        if (findmathparent(s.focusNode)) movespace(s.focusNode);
        else insertspace(s);
    }
}

function insertchar(code) {
    switch (code) {
    case 33:
        // '!'
    case 37:
        // '%'
    case 38:
        // '&'
    case 39:
        // '''
    case 40:
        // '('
    case 41:
        // ')'
    case 42:
        // '*'
    case 43:
        // '+'
    case 44:
        // ','
    case 45:
        // '-'
    case 46:
        // '.'
    case 47:
        // '/'
    case 58:
        // ':'
    case 59:
        // ';'
    case 60:
        // '<'
    case 61:
        // '='
    case 62:
        // '>'
    case 91:
        // '['
    case 92:
        // '\'
    case 93:
        // ']'
    case 94:
        // '^'
    case 123:
        // '{'
    case 124:
        // '|'
    case 125:
        // '}'
    case 126:
        // '~'
        inserttag("mo", String.fromCharCode(code));
        break;
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
        inserttag("mn", String.fromCharCode(code));
        break;
    default:
        inserttag("mi", String.fromCharCode(code));
        break;
    }
}
function start() {
    var d;
    try {
        if (parent.opener != null && parent.opener.mathedit != null && parent.opener.mathedit.op == "edit") {
            try {
                var m1 = parent.opener.mathedit.getCurrentMath1();
                var myDocument;
                designDoc.body.innerHTML = "";
                var parser = new DOMParser();
                myDocument = parser.parseFromString(m1, "text/xml");
                var root = myDocument.documentElement;
                d = designDoc.createDocumentFragment();
                d.appendChild(root);
            } catch(e) {}
        } else {
            var mfontsize = "30pt";
            var mcolor = "#000000";
		d = designDoc.createDocumentFragment();
		var m = designDoc.createElementNS(mmlns, "math");
            m.setAttribute("xmlns", mmlns);
            var s = designDoc.createElementNS(mmlns, "mstyle");
            s.setAttribute("mid", "tempstyle");
            s.setAttribute("id", "tempstyle");
            s.setAttribute("mathsize", mfontsize);
            s.setAttribute("mathcolor", mcolor);
            var r = designDoc.createElementNS(mmlns, "mrow");
            var box = designDoc.createElementNS(mmlns, "mi");
            box.appendChild(designDoc.createTextNode("\u0000"));
            // box.setAttribute("tempinput","true");
            setFocusColor(box);
            r.appendChild(box);
            s.appendChild(r);
            m.appendChild(s);
            d.appendChild(m);
        }
    } catch(e) {}
    designDoc.body.appendChild(d);
    histmath[0] = designDoc.body.innerHTML;
}

function doRight() {
    curnode = designDoc.getElementById("cursor");
    rb = newbox();
    delcursor();
    setFocusColor(rb);
    curnode.parentNode.appendChild(rb);
}

function doLeft() {
    curnode = designDoc.getElementById("cursor");
    rb = newbox();
    delcursor();
    setFocusColor(rb);
    curnode.parentNode.insertBefore(rb, curnode);
}

function savehist() {
    if (histp == 29) {
        histp = 0;
    } else {
        histp = histp + 1;
    }
    histr = 0;
    histmath[histp] = designDoc.body.innerHTML;
}

function undo() {
    var mc;
    if (histr == 29) {
        alert("Can't Undo");
        return;
    }
    if (histp == 0) {
        if (histmath[29] == undefined || histmath[29] == "") {
            alert("Can't Undo");
            return;
        } else {
            mc = histmath[29];
            histp = 29;
        }
    } else {
        mc = histmath[--histp];
    }
    renew(mc);
    histr = histr + 1;
}
function redo() {
    var mc;
    if (histr == 0) {
        alert("Can't Redo");
        return;
    } else {
        if (histp == 29) {
            histp = 0;
            mc = histmath[histp];
        } else {
            mc = histmath[++histp];
        }
    }
    renew(mc);
    histr = histr - 1;
}
function renew(mc) {
    var myDocument;
    designDoc.body.innerHTML = "";
    var parser = new DOMParser();
    myDocument = parser.parseFromString(mc, "text/xml");
    var root = myDocument.documentElement;
    var d = designDoc.createDocumentFragment();
    d.appendChild(root);
    designDoc.body.appendChild(d);
}

function doReturn() {
    if (parent.opener == null) {
        alert("When MathEdit was not openned by newMath() methode,The return button can not be used");
        return;
    }
    cm1 = new Array();
    cm1[2] = designDoc.body.innerHTML;
    try {
        parent.opener.mathedit.getMath(cm1);
    } catch(e) {
        alert("When MathEdit was not openned by newMath() methode,The return button can not be used");
    }
}

function getCode() {
    mc = new Array(5);
    mc[2] = designDoc.body.innerHTML;
    return mc;
}