var bbe = {};
bbe.NS = 'bbe/';
bbe.listFiles = function __listFiles() {
	var ret = [];
	for (var i = 0, len = localStorage.length; i < len; i++) {
		var key = localStorage.key(i);
		if (key.indexOf(bbe.NS) === 0)
			ret.push(key.substring(bbe.NS.length, key.length));
	}
	return ret;
};

bbe.writeFile = function (name, content) {
	if (name.indexOf(bbe.NS) !== 0)
		name = bbe.NS + name;
	localStorage[name] = content;
};

bbe.readFile = function (name) {
	if (name.indexOf(bbe.NS) !== 0)
		name = bbe.NS + name;
	return localStorage[name];
};

bbe.deleteFile = function(name) {
	if (name.indexOf(bbe.NS) !== 0)
		name = bbe.NS + name;
	delete localStorage[name];
}

bbe.svgEditorConfig = {
		canvas_expansion: 3,
		dimensions: [800,600],
		initFill: {
			color: 'FF0000',  // solid red
			opacity: 1
		},
		initStroke: {
			width: 3,
			color: 'FFFFFF',  // solid white
			//color: '000000',  // solid black
			opacity: 1
		},
		initOpacity: 1,
		imgPath: 'images/',
		langPath: 'locale/', 
		extPath: 'extensions/',
		extensions: ['ext-markers.js','ext-connector.js', 'ext-eyedropper.js'], 
		/*extensions: ['ext-markers.js'], */
		initTool: 'select',
		wireframe: false
};

bbe.selectedChanged = function(window, elems) {
	if (bbe.toolSelected === 'tool-rubber' && elems.length > 0 && elems[0])
		bbe.svgCanvas.deleteSelectedElements();
}

//borrow from svg-edit/svg-editor.js
// This sets up alternative dialog boxes. They mostly work the same way as
// their UI counterparts, expect instead of returning the result, a callback
// needs to be included that returns the result as its first parameter.
// In the future we may want to add additional types of dialog boxes, since 
// they should be easy to handle this way.
bbe.doDialog = function() {
	var uiStrings = {ok:'确定', cancel:'取消', yes:'是', no:'否'};
	
	$('#dialog_container').draggable({cancel:'#dialog_content, #dialog_buttons *'});
	var box = $('#dialog_box'), btn_holder = $('#dialog_buttons');
	
	var dbox = function(type, msg, callback, defText) {
		$('#dialog_content').html('<p>'+msg.replace(/\n/g,'</p><p>')+'</p>')
			.toggleClass('prompt',(type=='prompt'));
		btn_holder.empty();
		
		var okText = type == 'confirm' ? uiStrings.yes : uiStrings.ok;
		var cancelText = type == 'confirm' ? uiStrings.no : uiStrings.cancel;
		
		var ok = $('<input type="button" value="' + okText + '">').appendTo(btn_holder);
	
		if(type != 'alert') {
			$('<input type="button" value="' + cancelText + '">')
				.appendTo(btn_holder)
				.click(function() { box.hide();callback(false)});
		}
		
		if(type == 'prompt') {
			var input = $('<input type="text">').prependTo(btn_holder);
			input.val(defText || '');
			//TODO: 似乎有问题，任意按键都可触发
			//input.bind('keydown', 'return', function() {ok.click();});
		}
		
		if(type == 'process') {
			ok.hide();
		}

		box.show();
		
		ok.click(function() { 
			box.hide();
			var resp = (type == 'prompt')?input.val():true;
			if(callback) callback(resp);
		}).focus();
		
		if(type == 'prompt') input.focus();
	}
	
	$.alert = function(msg, cb) { dbox('alert', msg, cb);};
	$.confirm = function(msg, cb) {	dbox('confirm', msg, cb);};
	$.process_cancel = function(msg, cb) {	dbox('process', msg, cb);};
	$.prompt = function(msg, txt, cb) { dbox('prompt', msg, cb, txt);};
};

bbe.toolSelected='';

bbe.svgCanvas = null;

bbe.updatePageNum = function() {
	$('#page-list').html(bbe.currentPageNum + 1);
	$('#page-count').html(bbe.doc.pages.length);
}

// 如果不给svgCanvas设置一个初始内容，选择控件将不会显示。TODO：查明原因
bbe.emptyContent = '<svg viewBox="0 0 800 600" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg">	'	 
	+ '<g></g></svg>'

bbe.makePage = function() {
	var page = {content: bbe.emptyContent};
	return page;
} 
	
bbe.doc = {
		fileName:null,
		pages:[null],
};

bbe.currentPageNum = 0;

bbe.loadPage = function(num) {
	var pages = bbe.doc.pages;
	if (num <0 || num >= pages.length)
		return false;
	
	if (!pages[num] || !pages[num].content)
		pages[num] = bbe.makePage();
	bbe.svgCanvas.setSvgString(pages[num].content);
	bbe.layout();
	bbe.currentPageNum = num;
	bbe.updatePageNum();
}

bbe.syncCurrentPage = function() {
	var pages = bbe.doc.pages;
	var cnum = bbe.currentPageNum;
	if (!pages[cnum])
		pages[cnum] = bbe.makePage();
	pages[cnum].content = bbe.svgCanvas.getSvgString();
}

//TODO call bbe.loadPage
bbe.goToOrAppendPage = function(num, append) {
	var cnum = bbe.currentPageNum;
	var pages = bbe.doc.pages;
	if (num < 0)
		num = 0;
	if (num === cnum || (num >= pages.length && !append))
		return;
	if (num > pages.length) {
		num = pages.length;
	}
	if (!pages[num])
		pages[num] = null;
	bbe.syncCurrentPage();
	bbe.loadPage(num);
};

bbe.saveFile = function() {
	var name = bbe.doc.fileName;
	if (!name)
		return false;
	bbe.syncCurrentPage();

	try {
		bbe.writeFile(name, JSON.stringify(bbe.doc));
		//throw {code: DOMException.QUOTA_EXCEEDED_ERR}; //for test. DOMException is not a constructor
	} catch (e) {
		if (e.code == DOMException.QUOTA_EXCEEDED_ERR) {
			$.alert('本地存储空间已满，保存失败。请删除一些旧数据，然后重试。')
		} else {
			$.alert('保存失败。错误信息：'+e);
		}
	}
}

bbe.loadFileForEdit = function(fname) {
	var fcontent = bbe.readFile(fname);
	if (!fcontent)
		return false;
	bbe.doc = JSON.parse(fcontent); //TODO: check error
	bbe.loadPage(0);
}

bbe.initDoc = function(fname) {
	bbe.doc.fileName = fname;
	bbe.doc.pages = [null];
	bbe.loadPage(0);
}

bbe.doEvents = function() {
	$('#tool-bar .tool').mousedown(function(){
			$(this).addClass('mouseDown');
	}).click(function(){
			//if (!$(this).hasClass('selected'))
			bbe.toolClicked(this);
	});
	$('#go-left').click(function(){
		bbe.goToOrAppendPage(bbe.currentPageNum - 1);
	});
	$('#go-right').click(function(){
		bbe.goToOrAppendPage(bbe.currentPageNum + 1, true);
	});
	window.onresize = bbe.layout;
	window.onbeforeunload = function () {
		return '文件可能尚未保存。';
	}
}

bbe.saveFileAction = function() {
	// TODO detect existing file
	if (!bbe.doc.fileName) {
		$.prompt('输入文件名', '新板书文件', function(fname) {
			if (typeof fname === 'string') {
				if (!fname)
					$.alert('文件名不能为空！未保存。'); //TODO prevent dialog disappearing
				else {
					bbe.doc.fileName = fname;
					bbe.saveFile();
				}
			}
		});
	} else
		bbe.saveFile();
}

bbe.openFileAction = function(fname) {
	if (!bbe.doc.fileName) {
		$.confirm('当前板书是新建的，是否先保存？', function(ok) {
			if (ok)
				bbe.saveFileAction();
			else
				bbe.loadFileForEdit(fname);
		});
	} else {
		bbe.saveFile();
		bbe.loadFileForEdit(fname);
	}
}

bbe.newFileAction = function () {
	// TODO detect existing file
	$.prompt('输入文件名', '新板书文件', function(fname) {
		if (typeof fname === 'string') {
			if (!fname)
				$.alert('文件名不能为空！'); //TODO prevent dialog disappearing
			else {
				//bbe.doc.fileName = fname;
				//TODO ask if user want to save current file;
				bbe.saveFile();
				bbe.initDoc(fname);				
			}
		}
	});
}

bbe.fileNameClicked = function() {
	bbe.openFileAction($(this).text());
}

bbe.deleteClicked = function() {
	var fname = $(this.parentNode).find('.fileName').text();
	//TODO delete file;
	$.confirm('是否删除板书文件“' + fname + '”？', function(ok) {
		if (ok) {
			bbe.deleteFile(fname);
			bbe.updateFileList();
			if (bbe.doc.fileName === fname)
				bbe.initDoc(null);
		}
	});
}

bbe.renameClicked = function() {
	var fname = $(this.parentNode).find('.fileName');
	//TODO rename file;
	$.alert("未实现");
}

bbe.updateFileList = function () {
	var list = bbe.listFiles();
	$('#file-list .item.shown').remove();
	if (list.length === 0)
		return;
	var templ = $('#file-list .item.hidden');
	var parent = templ[0].parentNode;
	for (var i = 0; i < list.length; i++) {
		var item = templ.clone().removeClass('hidden').addClass('shown');
		item.find('.fileName').text(list[i]).click(bbe.fileNameClicked);
		item.find('.delete').click(bbe.deleteClicked);
		item.find('.rename').click(bbe.renameClicked);
		item.appendTo(parent);
	}
}

bbe.toolClicked = function(elem) {
	var id = elem.id;
	var tools = $('.tool');
	tools.removeClass('mouseDown');
	var jelem = $(elem);
	if (jelem.hasClass('selectable')) {
		tools.removeClass('selected');
		jelem.addClass('selected');
	}
	bbe.toolSelected=id;
	switch(id) {
	case 'tool-pen':
		bbe.svgCanvas.setMode('fhpath');
		break;
	case 'tool-rubber':
	case 'tool-select':
		bbe.svgCanvas.setMode('select');
		break;
	case 'tool-new':
		bbe.newFileAction();
		break;
	case 'tool-left':
		bbe.goToOrAppendPage(bbe.currentPageNum - 1);
		break;
	case 'tool-right':
		bbe.goToOrAppendPage(bbe.currentPageNum + 1, false);
		break;
	case 'tool-save':
		bbe.saveFileAction();
		break;	
	case 'tool-list':
		bbe.updateFileList();
		break;
	}
	var parent = $(elem.parentNode);
	if (parent.hasClass('toolWrapper')) {
		parent.find('.popUp').toggleClass('hidden');
	}
}

/**
 * 让#workarea 占据整个窗口。
 * 
 */
bbe.layout = function () {
	var L = Math.min(3 * window.innerWidth, 4 * window.innerHeight);
    var w43 = L/3;
    var h43 = L/4;
    $('#workarea, #svgcanvas').width(w43).height(h43);
    if (bbe.svgCanvas) {
    	bbe.svgCanvas.setBBoxZoomNoSpacer('canvas', w43, h43);
    	bbe.svgCanvas.updateCanvas(w43, h43);
    }
}

$(function() {
	var svgCanvas = new $.SvgCanvas(document.getElementById("svgcanvas"), bbe.svgEditorConfig);
	bbe.svgCanvas = svgCanvas;
	svgCanvas.setSvgString(bbe.emptyContent);
	//svgCanvas.setSvgString(""); //exception
	//svgCanvas.setMode('line');
	//svgCanvas.setMode('fhpath');
	svgCanvas.setBackground('#03654c', null);
	svgCanvas.bind("selected", bbe.selectedChanged);
	bbe.layout();
	bbe.doEvents();
	bbe.doDialog();
});
	