﻿
var myApp = angular.module('myApp', []);
myApp.factory("datasource", function () {
    return {
        items: [],
        update: function () {
            var mainScope = $("#main").scope();
            mainScope.items = this.items;
            mainScope.$apply();
        }
    }
});
var _datasource = angular.injector(["myApp"]).get("datasource");

function bindRecords(data) {
    _datasource.items = data.items;
    _datasource.update();
}

myApp.filter('offset', function () {
    return function (input, start) {
        start = parseInt(start, 10);
        if (input)
            return input.slice(start);
    };
});



myApp.controller("myres.ctr", ['datasource', '$scope', function (datasource, $scope) {
    $scope.itemsPerPage = 10
    $scope.currentPage = 0
    $scope.items = datasource.items

    $scope.showIndex = function (item) {
        return $scope.items.indexOf(item) + 1;
    };

    $scope.$on('valuesUpdated', function () {
        $scope.items = DataSource.items;
    });

    $scope.downLoad = function (bookId) {
        ucbook.invokeCsFunction("DownLoadBook", bookId);
    };

    $scope.range = function () {
        if ($scope.pageCount() >= 4) {

            var rangeSize = 5;
        }
         else {
            rangeSize = $scope.pageCount() + 1;
        }
        var ret = [];
        var start;

        start = $scope.currentPage;
        end = $scope.pageCount() - 1;


        if ((start + Math.floor(rangeSize / 2)) > rangeSize) {
            start = start - Math.floor(rangeSize / 2);
            if (start + rangeSize > $scope.pageCount()) {
                start = $scope.pageCount() - rangeSize + 1;
            }
        }
        else {
            start = 0;
        }

        for (var i = start; i < start + rangeSize; i++) {
            ret.push(i);
        }
        return ret;
    };

    $scope.prevPage = function () {
        if ($scope.currentPage > 0) {
            $scope.currentPage--;
        }
    };

    $scope.prevPageDisabled = function () {
        return $scope.currentPage === 0 ? "lastnormal" : "lastselect";
    };

    $scope.pageCount = function () {
        return Math.ceil($scope.items.length / $scope.itemsPerPage) - 1;
    };


    $scope.nextPage = function () {
        if ($scope.currentPage < $scope.pageCount()) {
            $scope.currentPage++;
        }
    };

    $scope.nextPageDisabled = function () {
        return $scope.currentPage === $scope.pageCount() ? "nextnormal" : "nextselect";
    };

    $scope.setPage = function (n) {
        $scope.currentPage = n;
    };


    $scope.showResString = getResString;
} ]);


function updateRecordState(bookId, state) {
    var records = _datasource.items;
    for (var i = 0; i < records.length; i++) {
        var record = records[i];
        if (record.id == bookId) {
            record.state = state;
            break;
        }
    }
    _datasource.update();
}

function getResString(name) {
    return ucbook.constant.myres[name];
}