﻿var chapterlist,
    degree,
    pindex=1,
    topic_type,
    topiclist;




var directory_template = Handlebars.compile($('#directory-list-template').html());

function onMessage(message) {
    var msg;
    try {
        console.log(message);
        msg = JSON.parse(message);
    } catch (e) {
//        alert(e);
        console.log(e + ":" + message);
        return;
    }
    switch (msg.action) {
        case "fillChapter":
            chapterlist = msg.data;
            bindTopicType(msg.sub);
            bindChpater();
            bindTocEvents();
            break;
        case "fillTopic":
            topiclist = msg.data;
            bindTopic();
            break;
        case "error":
            $(".directory-panel").html($("#error").html());
            break;
        default:
            break;
    }
}


function reload() {
    ucbook.postWebPageMessage(JSON.stringify({ action: "ready" }));
}

function bindTopic() {
    var tmp = Handlebars.compile($("#topic-tmp").html());
    if (topiclist.result) {
        $(".questions").html(tmp(topiclist.result));
        common.page(topiclist.pageData);
        $(".xyn_line").show();
        $(".xyn_select").show();
    } else {
        $(".questions").html("<img src='img/提示.png' class='xyn_img'>");
        $(".xyn_line").hide();
        $(".xyn_select").hide();
    }
}

function bindTopicType(sub) {
    var types = topicType[sub];
    var temp = Handlebars.compile($("#type-tmp").html());
    $("#topicType").html(temp(types));
}

function bindChpater() {
    //按照"children"的值进行排列, 目前这边用不到children;
    var tocData = transData(chapterlist, 'id', 'up_id', 'children');
    //左侧的目录模版渲染的结果;
    var $data = directory_template({
        "children": tocData
    });
    $(".directory-panel").html($data);

    var directoryList = document.getElementById("directory-toc");
    if (directoryList) {
        //无语..
        this.listItem = function (li) {
            if (li.getElementsByTagName("ul").length > 0) {
                //里面有UL就把UL隐藏;
                var ul = li.getElementsByTagName("ul")[0];
                ul.style.display = "none";
                var span = document.createElement("span");
                span.className = "collapsed";
                $(span).insertBefore($(li).find('a')[0]);
            }
        }
        var items = directoryList.getElementsByTagName("li");
        for (var i = 0; i < items.length; i++) {
            listItem(items[i]);
        }
    }

}

function bindTocEvents() {
    $("#directory-toc").on('click', 'li div',
    function () {
        //这个是节
        if ($(this).closest("ul").siblings("div").length > 0) {
            //$(this).closest('li').siblings("li").find("div").css("background-color", "#FFFFFF");
            //$(this).css("background-color", "#E7F1FF");
            chapterid = this.id;
            chapterName = $(this).find("a").html();
            getChapterContent();
        } else {
            //这个就是章了;
            chapterid = this.id;
            chapterName = $(this).find("a").html();
            getChapterContent();
        };
        //包含章
        $("div", $(this).closest(".directory-toc")).css("background-color", "#FFFFFF")
        $(this).css("background-color", "#E7F1FF");
        $(this).siblings('ul').toggle();
        if ($(this).find('span').hasClass('expanded')) {
            $(this).find('span').attr('class', 'collapsed');
        } else {
            $(this).find('span').attr('class', 'expanded');
        }
        $(this).closest('li').siblings('li').find('span').attr('class', 'collapsed');
        $(this).closest('li').siblings('li').find('ul').hide();
        return false;
    })
}

function getChapterContent() {
    var cmdJSON = JSON.stringify({
        action: "getChapterContent",
        data: [chapterid, $("#degree").children("cite").attr("sval"), $("#topicType").children("cite").attr("sval"),pindex]
    });
    window.ucbook && ucbook.postWebPageMessage(cmdJSON);

};

function downloadTopic(index) {
    console.log(topiclist.result[index]);
    ucbook.postWebPageMessage(JSON.stringify({ action: "download", data: [topiclist.result[index]] }));
}

function divselect(divselectid) {
    $(divselectid).delegate("cite", "click", function () {
        var ul = $(this).siblings("ul");
        if (ul.css("display") == "none") {
            ul.slideDown("fast");
        } else {
            ul.slideUp("fast");
        }
    });
    $(divselectid).delegate(" ul li a", "click", function () {
        var txt = $(this).text();
        var value = $(this).attr("sval");
        var cite = $(this).parents("ul").siblings("cite");
        cite.html(txt);
        cite.attr("sval", value);
        $(this).parents("ul").hide();
        getChapterContent();
    });
}

//知识点列表整理排序
function transData(a, idStr, pidStr, chindrenStr) {
    var r = [],
    hash = {},
    id = idStr,
    pid = pidStr,
    children = chindrenStr,
    i = 0,
    j = 0,
    len = a.length;
    for (; i < len; i++) {
        hash[a[i][id]] = a[i];
    }
    for (; j < len; j++) {
        var aVal = a[j],
        hashVP = hash[aVal[pid]];
        if (hashVP) {
            var ary = aVal.cha_number.split(".");
            var orderNum = ary[ary.length - 1]; !hashVP[children] && (hashVP[children] = []);
            hashVP[children][orderNum - 1] = aVal;
        } else {
            r.push(aVal);
        }
    };
    //最后要对返回章进行最后一次排序;
    r.sort(function (obj0, obj1) {
        return obj0.cha_number - obj1.cha_number;
    });
    return r;
};
//迭代左侧的目录树Helper;
var audaciousFn;
Handlebars.registerHelper('recursive', function (children, options) {
    var out = '';
    if (options.fn !== undefined) {
        audaciousFn = options.fn;
    }
    children.forEach(function (child) {
        out = out + audaciousFn(child);
    });
    return out;
});
$(function () {
    if (typeof ucbook === "object") {
        ucbook.onWebPageMessage = onMessage;
        ucbook.postWebPageMessage(JSON.stringify({ action: "ready", data: [] }));
    }

    document.oncontextmenu = new Function("return false;")

    window.addEventListener("dragover",
    function (e) {
        e = e || event;
        e.preventDefault();
    },
    false);
    window.addEventListener("drop",
    function (e) {
        e = e || event;
        e.preventDefault();
    },
    false);

    divselect(".divselect");
    $("#page").delegate("a", "click", function () {
        pindex = $(this).attr("p");
        if (pindex == 0) {
            return;
        }
        getChapterContent();
    });

});