﻿ucbook.classspace = {};

(function (classspace) {
    var _curClassAction;
	var _curClassInfo;
    
    function getQATabNum()
    {
        var iframe = document.getElementById('pageContent');
        if(iframe){
            var frameDoc = iframe.contentDocument || iframe.contentWindow.document;
            var tabEle = frameDoc.getElementById("js_tabNum");
            var tabNum = tabEle.getAttribute("value");

            var classNum=_curClassInfo.attr("classnumber");	
            if(!tabNum)tabNum="0";

            return tabNum+","+classNum;
        }
    }

    function getSelectedClassName()
    {
        var className="";
        if(_curClassInfo)
            className=_curClassInfo.text();
        
        return className;
    }

    function classActionSetCss(selClassAction)
    {
        if (_curClassAction) _curClassAction.parent().removeClass("action_selected");
        if (selClassAction) selClassAction.parent().addClass("action_selected");
        _curClassAction = selClassAction;    
    }

    function classActionInvoke(selClassAction)
    {
        if(selClassAction)
        {
            var id=selClassAction.attr("id");
            var classNum=_curClassInfo.attr("classnumber");	
			var callbackMethodName="GetClassActionUrl:ucbook.classspace.goPage";

            if(classNum && id)
	            ucbook.invokeCsResultFunction(callbackMethodName,id,classNum);
        } 
    }

	function classActionInvoke_result(url)
	{
		$('#pageContent').attr("src",url);    
	}

    function classInfoSetCss(selClassInfo)
	{
		if(selClassInfo)
		{
			if(_curClassInfo)
				_curClassInfo.removeClass("class_selected");
			selClassInfo.addClass("class_selected");

            var className=selClassInfo.text();
			if(className.trim()=='')
			{
				$("#classname").text("暂无班级");			
				$("#classname").parent().removeClass("classNameArrow");			
			}
			else
			{
				$("#classname").text(className);
				$("#classname").parent().addClass("classNameArrow");
			}
			
			$('.classInfoCss').hide();
			_curClassInfo=selClassInfo;
		}
	}

    function classAction_click() {
        var selClassAction = $(this);
        if(selClassAction && _curClassInfo)
        {
            classActionInvoke(selClassAction);
            classActionSetCss(selClassAction);            
        }        
    }
    function classInfo_click(){
        var selClassInfo=$(this);
        if(selClassInfo)
        {
            classInfoSetCss(selClassInfo);
            $("#classmanage").trigger("click");
        }        
    }	
    function timage_click(){    
        //ucbook.invokeCsFunction("ShowPersonInfo");
    } 
    function newclass_click(){    
        ucbook.invokeCsFunction("NewClass");
    } 
    function joinclass_click(){    
        ucbook.invokeCsFunction("JoinClass");
    }
	function className_clicked()
	{
		$('.classInfoCss').show();
	}
    function classInfo_onmouseleave()
    {
		$('.classInfoCss').hide();        
    }

    function page_inital() {
        $('.classActionCss').delegate('a', 'click', classAction_click);
        $('.classInfoCss').delegate('li', 'click', classInfo_click);
        $('.classInfoCss').on('mouseleave', classInfo_onmouseleave); 
        $('#timage').on('click', timage_click);
        $('#newclass').on('click', newclass_click);
        $('#joinclass').on('click', joinclass_click);
		$('#classname').on('click', className_clicked);        
        
		$(document).bind("contextmenu", function(e) {
			return false;
		}); 
    }
    	
    function page_data(bin,index)
    {
         $(".navCss").scope().person =bin;
         $(".navCss").scope().$apply();         
         $(".classInfoCss li:nth-child("+(index+1)+")").trigger("click");
    }

    function getResString(name) {
        return ucbook.constant.classspace[name];
    }

    var myApp = angular.module('myApp', []);
    myApp.controller("classspace.ctr", function ($scope) {
        $scope.showResString = getResString;
    });

    classspace.inital=page_inital;
    classspace.setData=page_data;
	classspace.goPage=classActionInvoke_result;
    classspace.selClassName=getSelectedClassName;
    classspace.qaTabNum=getQATabNum;
} )(ucbook.classspace);

$(document).ready(ucbook.classspace.inital);


